/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.flink.table.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.plan.schema.FlinkTable;

public class FlinkCalciteCatalogReader
extends CalciteCatalogReader {
    public FlinkCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> defaultSchemas, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), FlinkCalciteCatalogReader.getDefaultSchemas(defaultSchemas), typeFactory, config);
    }

    protected FlinkCalciteCatalogReader(CalciteSchema rootSchema, SqlNameMatcher nameMatcher, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        super(rootSchema, nameMatcher, schemaPaths, typeFactory, config);
    }

    private static List<List<String>> getDefaultSchemas(List<List<String>> defaultSchemas) {
        ArrayList<List<String>> paths = new ArrayList<List<String>>(defaultSchemas);
        paths.add(new ArrayList());
        return Collections.unmodifiableList(paths);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        SqlValidatorTable originRelOptTable = super.getTable((List)names);
        if (originRelOptTable == null) {
            return null;
        }
        FlinkTable table = originRelOptTable.unwrap(FlinkTable.class);
        if (table != null) {
            return FlinkRelOptTable.create(originRelOptTable.getRelOptSchema(), originRelOptTable.getRowType(), originRelOptTable.getQualifiedName(), table);
        }
        return originRelOptTable;
    }
}

