/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.plan.stats.TableStats;

public class CatalogView
extends CatalogTable {
    private final String originalQuery;
    private final String expandedQuery;

    public CatalogView(String tableType, TableSchema tableSchema2, Map<String, String> properties, String originalQuery, String expandedQuery) {
        super(tableType, tableSchema2, TableStats.UNKNOWN(), properties);
        this.originalQuery = originalQuery;
        this.expandedQuery = expandedQuery;
    }

    public CatalogView(String tableType, TableSchema tableSchema2, Map<String, String> properties, RichTableSchema richTableSchema, TableStats tableStats2, String comment, LinkedHashSet<String> partitionColumnNames, boolean isPartitioned, String computedColumnsSql, String rowTimeField, long watermarkOffset, long createTime, long lastAccessTime, String originalQuery, String expandedQuery) {
        super(tableType, tableSchema2, properties, richTableSchema, tableStats2, comment, partitionColumnNames, isPartitioned, computedColumnsSql, rowTimeField, watermarkOffset, createTime, lastAccessTime);
        this.originalQuery = originalQuery;
        this.expandedQuery = expandedQuery;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public String getExpandedQuery() {
        return this.expandedQuery;
    }

    public static CatalogView createCatalogView(CatalogTable table, String originalQuery, String expandedQuery) {
        return new CatalogView(table.getTableType(), table.getTableSchema(), table.getProperties(), table.getRichTableSchema(), table.getTableStats(), table.getComment(), table.getPartitionColumnNames(), table.isPartitioned(), table.getComputedColumnsSql(), table.getRowTimeField(), table.getWatermarkOffset(), table.getCreateTime(), table.getLastAccessTime(), originalQuery, expandedQuery);
    }

    @Override
    public CatalogView deepCopy() {
        return new CatalogView(this.getTableType(), this.getTableSchema(), new HashMap<String, String>(this.getProperties()), this.getRichTableSchema(), this.getTableStats(), this.getComment(), this.getPartitionColumnNames(), this.isPartitioned(), this.getComputedColumnsSql(), this.getRowTimeField(), this.getWatermarkOffset(), this.getCreateTime(), this.getLastAccessTime(), this.getOriginalQuery(), this.getExpandedQuery());
    }

    @Override
    public String toString() {
        return "CatalogView{originalQuery='" + this.originalQuery + '\'' + ", expandedQuery='" + this.expandedQuery + '\'' + ", tableType='" + this.getTableType() + '\'' + ", tableSchema=" + this.getTableSchema() + ", tableStats=" + this.getTableStats() + ", properties=" + this.getProperties() + ", richTableSchema=" + this.getRichTableSchema() + ", comment='" + this.getComment() + '\'' + ", partitionColumnNames=" + this.getPartitionColumnNames() + ", isPartitioned=" + this.isPartitioned() + ", computedColumnsSql=" + this.getComputedColumnsSql() + ", rowTimeField='" + this.getRowTimeField() + '\'' + ", watermarkOffset=" + this.getWatermarkOffset() + ", createTime=" + this.getCreateTime() + ", lastAccessTime=" + this.getLastAccessTime() + '}';
    }
}

