/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codegen.calls;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.codegen.CodeGenException;
import org.apache.flink.table.codegen.CodeGenUtils$;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedExpression$;
import org.apache.flink.table.codegen.HashCodeGenerator$;
import org.apache.flink.table.codegen.calls.BinaryStringCallGen$;
import org.apache.flink.table.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.codegen.calls.CallGenerator$;
import org.apache.flink.table.codegen.calls.ScalarOperators$;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterBuilderFunction;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterFunction;
import org.apache.flink.table.runtime.conversion.DataStructureConverters$;
import org.apache.flink.table.runtime.util.BloomFilter;
import org.apache.flink.table.runtime.util.BloomFilterAcc;
import org.apache.flink.table.runtime.util.RuntimeFilterUtils;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.PrimitiveType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.typeutils.TypeCoercion$;
import org.apache.flink.util.SerializedValue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarOperators$ {
    public static final ScalarOperators$ MODULE$;

    static {
        new ScalarOperators$();
    }

    public GeneratedExpression generateArithmeticOperator(CodeGeneratorContext ctx, String operator, boolean nullCheck, InternalType resultType2, GeneratedExpression left, GeneratedExpression right) {
        Function1<String, String> function1;
        InternalType internalType = resultType2;
        if (internalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)internalType;
            return this.generateDecimalOperator(ctx, operator, nullCheck, decimalType, left, right);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string = operator;
        if ("%".equals(string)) {
            Function1<String, String> function12;
            InternalType internalType2 = left.resultType();
            InternalType internalType3 = right.resultType();
            if (!(internalType2 != null ? !internalType2.equals(internalType3) : internalType3 != null)) {
                function12 = this.numericCasting(left.resultType(), resultType2);
            } else {
                InternalType castedType = TypeCheckUtils$.MODULE$.isDecimal(left.resultType()) ? DataTypes.LONG : left.resultType();
                function12 = this.numericCasting(left.resultType(), castedType);
            }
            function1 = function12;
        } else {
            function1 = this.numericCasting(left.resultType(), resultType2);
        }
        Function1<String, String> leftCasting = function1;
        Function1<String, String> rightCasting = this.numericCasting(right.resultType(), resultType2);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
        return CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, resultType2, left, right, (Function2<String, String, String>)new Serializable(operator, leftCasting, rightCasting, resultTypeTerm){
            public static final long serialVersionUID = 0L;
            private final String operator$1;
            private final Function1 leftCasting$1;
            private final Function1 rightCasting$1;
            private final String resultTypeTerm$1;

            public final String apply(String leftTerm, String rightTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resultTypeTerm$1, this.leftCasting$1.apply((Object)leftTerm), this.operator$1, this.rightCasting$1.apply((Object)rightTerm)}));
            }
            {
                this.operator$1 = operator$1;
                this.leftCasting$1 = leftCasting$1;
                this.rightCasting$1 = rightCasting$1;
                this.resultTypeTerm$1 = resultTypeTerm$1;
            }
        });
    }

    private GeneratedExpression generateDecimalOperator(CodeGeneratorContext ctx, String operator, boolean nullCheck, DecimalType resultType2, GeneratedExpression left, GeneratedExpression right) {
        Function1 leftCasting = this.castToDec$1(left.resultType(), resultType2);
        Function1 rightCasting = this.castToDec$1(right.resultType(), resultType2);
        String method = Decimal.Ref.operator(operator);
        return CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, resultType2, left, right, (Function2<String, String, String>)new Serializable(resultType2, leftCasting, rightCasting, method){
            public static final long serialVersionUID = 0L;
            private final DecimalType resultType$1;
            private final Function1 leftCasting$2;
            private final Function1 rightCasting$2;
            private final String method$1;

            public final String apply(String leftTerm, String rightTerm) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$1, this.leftCasting$2.apply((Object)leftTerm), this.rightCasting$2.apply((Object)rightTerm)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.resultType$1.precision()), BoxesRunTime.boxToInteger((int)this.resultType$1.scale())}))).toString();
            }
            {
                this.resultType$1 = resultType$1;
                this.leftCasting$2 = leftCasting$2;
                this.rightCasting$2 = rightCasting$2;
                this.method$1 = method$1;
            }
        });
    }

    public GeneratedExpression generateUnaryArithmeticOperator(CodeGeneratorContext ctx, String operator, boolean nullCheck, InternalType resultType2, GeneratedExpression operand) {
        return CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, resultType2, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(operator, operand){
            public static final long serialVersionUID = 0L;
            private final String operator$2;
            private final GeneratedExpression operand$1;

            /*
             * Enabled aggressive block sorting
             */
            public final String apply(String operandTerm) {
                String string;
                if (TypeCheckUtils$.MODULE$.isDecimal(this.operand$1.resultType())) {
                    String string2 = this.operator$2;
                    String string3 = "-";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".negate()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                        return string;
                    }
                }
                if (TypeCheckUtils$.MODULE$.isDecimal(this.operand$1.resultType())) {
                    String string4 = this.operator$2;
                    String string5 = "+";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                        return string;
                    }
                }
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.operator$2, operandTerm}));
                return string;
            }
            {
                this.operator$2 = operator$2;
                this.operand$1 = operand$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneratedExpression generateIn(CodeGeneratorContext ctx, GeneratedExpression needle, Seq<GeneratedExpression> haystack, boolean nullCheck) {
        GeneratedExpression generatedExpression;
        if (haystack.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression x$1) {
                return x$1.literal();
            }
        })) {
            Tuple2 tuple2;
            InternalType internalType;
            void var9_11;
            Option<InternalType> widerType = TypeCoercion$.MODULE$.widerTypeOf(needle.resultType(), ((GeneratedExpression)haystack.head()).resultType());
            Option<InternalType> option = widerType;
            if (option instanceof Some) {
                Some some = (Some)option;
                InternalType t = (InternalType)some.x();
                Serializable serializable = new Serializable(t){
                    public static final long serialVersionUID = 0L;
                    private final InternalType t$1;

                    public final String apply(GeneratedExpression value) {
                        return (String)ScalarOperators$.MODULE$.numericCasting(value.resultType(), this.t$1).apply((Object)value.resultTerm());
                    }
                    {
                        this.t$1 = t$1;
                    }
                };
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeneratedExpression value) {
                        return value.resultTerm();
                    }
                };
            }
            void castNumeric = var9_11;
            Option<InternalType> option2 = widerType;
            if (option2 instanceof Some) {
                InternalType t;
                Some some = (Some)option2;
                internalType = t = (InternalType)some.x();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                internalType = needle.resultType();
            }
            InternalType resultType2 = internalType;
            Seq elements = (Seq)haystack.map((Function1)new Serializable((Function1)castNumeric, resultType2){
                public static final long serialVersionUID = 0L;
                private final Function1 castNumeric$1;
                private final InternalType resultType$3;

                public final GeneratedExpression apply(GeneratedExpression element) {
                    return element.copy((String)this.castNumeric$1.apply((Object)element), element.nullTerm(), element.code(), this.resultType$3, element.copy$default$5(), element.copy$default$6(), element.copy$default$7(), element.copy$default$8(), element.copy$default$9());
                }
                {
                    this.castNumeric$1 = castNumeric$1;
                    this.resultType$3 = resultType$3;
                }
            }, Seq$.MODULE$.canBuildFrom());
            String setTerm = ctx.addReusableSet((Seq<GeneratedExpression>)elements, resultType2);
            GeneratedExpression castedNeedle = needle.copy((String)castNumeric.apply((Object)needle), needle.nullTerm(), needle.code(), resultType2, needle.copy$default$5(), needle.copy$default$6(), needle.copy$default$7(), needle.copy$default$8(), needle.copy$default$9());
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError(seq);
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(DataTypes.BOOLEAN);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(DataTypes.BOOLEAN);
            String operatorCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |", " ", " = ", ";\n          |boolean ", " = true;\n          |if (!", ") {\n          |  ", " = ", ".contains(", ");\n          |  ", " = !", " && ", ".containsNull();\n          |}\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castedNeedle.code(), resultTypeTerm, resultTerm2, defaultValue, nullTerm2, castedNeedle.nullTerm(), resultTerm2, setTerm, castedNeedle.resultTerm(), nullTerm2, resultTerm2, setTerm})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |", " ", " = ", ".contains(", ");\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castedNeedle.code(), resultTypeTerm, resultTerm2, setTerm, castedNeedle.resultTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
            return generatedExpression;
        } else {
            generatedExpression = (GeneratedExpression)((TraversableOnce)haystack.map((Function1)new Serializable(ctx, needle, nullCheck){
                public static final long serialVersionUID = 0L;
                private final CodeGeneratorContext ctx$1;
                private final GeneratedExpression needle$1;
                private final boolean nullCheck$1;

                public final GeneratedExpression apply(GeneratedExpression x$3) {
                    return ScalarOperators$.MODULE$.generateEquals(this.ctx$1, this.nullCheck$1, this.needle$1, x$3);
                }
                {
                    this.ctx$1 = ctx$1;
                    this.needle$1 = needle$1;
                    this.nullCheck$1 = nullCheck$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final GeneratedExpression apply(GeneratedExpression left, GeneratedExpression right) {
                    return ScalarOperators$.MODULE$.generateOr(true, left, right);
                }
            });
        }
        return generatedExpression;
    }

    public GeneratedExpression generateEquals(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        block23: {
            GeneratedExpression generatedExpression;
            block20: {
                Object object;
                block22: {
                    block21: {
                        while (true) {
                            InternalType internalType = left.resultType();
                            StringType stringType = DataTypes.STRING;
                            if (!(internalType != null ? !internalType.equals(stringType) : stringType != null)) {
                                InternalType internalType2 = right.resultType();
                                StringType stringType2 = DataTypes.STRING;
                                if (!(internalType2 != null ? !internalType2.equals(stringType2) : stringType2 != null)) {
                                    generatedExpression = BinaryStringCallGen$.MODULE$.generateStringEquals(ctx, left, right);
                                    break block20;
                                }
                            }
                            if (TypeCheckUtils$.MODULE$.isNumeric(left.resultType()) && TypeCheckUtils$.MODULE$.isNumeric(right.resultType())) {
                                generatedExpression = this.generateComparison(ctx, "==", nullCheck, left, right);
                                break block20;
                            }
                            if (TypeCheckUtils$.MODULE$.isTemporal(left.resultType())) {
                                InternalType internalType3 = left.resultType();
                                InternalType internalType4 = right.resultType();
                                if (!(internalType3 != null ? !internalType3.equals(internalType4) : internalType4 != null)) {
                                    generatedExpression = this.generateComparison(ctx, "==", nullCheck, left, right);
                                    break block20;
                                }
                            }
                            if (TypeCheckUtils$.MODULE$.isArray(left.resultType())) {
                                InternalType internalType5 = left.resultType();
                                InternalType internalType6 = right.resultType();
                                if (!(internalType5 != null ? !internalType5.equals(internalType6) : internalType6 != null)) {
                                    generatedExpression = this.generateArrayComparison(ctx, nullCheck, left, right);
                                    break block20;
                                }
                            }
                            if (TypeCheckUtils$.MODULE$.isMap(left.resultType())) {
                                InternalType internalType7 = left.resultType();
                                InternalType internalType8 = right.resultType();
                                if (!(internalType7 != null ? !internalType7.equals(internalType8) : internalType8 != null)) {
                                    generatedExpression = this.generateMapComparison(ctx, nullCheck, left, right);
                                    break block20;
                                }
                            }
                            if (TypeCheckUtils$.MODULE$.isComparable(left.resultType())) {
                                InternalType internalType9 = left.resultType();
                                InternalType internalType10 = right.resultType();
                                if (!(internalType9 != null ? !internalType9.equals(internalType10) : internalType10 != null)) {
                                    generatedExpression = this.generateComparison(ctx, "==", nullCheck, left, right);
                                    break block20;
                                }
                            }
                            if (TypeCheckUtils$.MODULE$.isTimePoint(left.resultType())) {
                                InternalType internalType11 = right.resultType();
                                StringType stringType3 = DataTypes.STRING;
                                if (!(internalType11 != null ? !internalType11.equals(stringType3) : stringType3 != null)) {
                                    if (right.literal()) {
                                        right = this.strLiteralCastToTime(ctx, right, left.resultType());
                                        continue;
                                    }
                                    right = this.generateCast(ctx, nullCheck, right, left.resultType());
                                    continue;
                                }
                            }
                            if (!TypeCheckUtils$.MODULE$.isTimePoint(right.resultType())) break;
                            InternalType internalType12 = left.resultType();
                            StringType stringType4 = DataTypes.STRING;
                            if (internalType12 != null ? !internalType12.equals(stringType4) : stringType4 != null) break;
                            if (left.literal()) {
                                GeneratedExpression generatedExpression2 = this.strLiteralCastToTime(ctx, left, right.resultType());
                                left = generatedExpression2;
                                continue;
                            }
                            GeneratedExpression generatedExpression3 = this.generateCast(ctx, nullCheck, left, right.resultType());
                            left = generatedExpression3;
                        }
                        if (!CodeGenUtils$.MODULE$.isReference(left)) break block21;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String leftTerm, String rightTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                            }
                        };
                        break block22;
                    }
                    if (!CodeGenUtils$.MODULE$.isReference(right)) break block23;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightTerm, leftTerm}));
                        }
                    };
                }
                generatedExpression = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.BOOLEAN, left, right, (Function2<String, String, String>)object);
            }
            return generatedExpression;
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression strLiteralCastToTime(CodeGeneratorContext ctx, GeneratedExpression expr, InternalType expectType) {
        InternalType internalType;
        block5: {
            Method method;
            String defaultTerm;
            String typeTerm;
            String rightTerm;
            block3: {
                block4: {
                    block2: {
                        rightTerm = expr.resultTerm();
                        typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(expectType);
                        defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(expectType);
                        internalType = expectType;
                        DateType dateType = DataTypes.DATE;
                        InternalType internalType2 = internalType;
                        if (dateType != null ? !((Object)dateType).equals(internalType2) : internalType2 != null) break block2;
                        method = BuiltInMethod.STRING_TO_DATE.method;
                        break block3;
                    }
                    TimeType timeType = DataTypes.TIME;
                    InternalType internalType3 = internalType;
                    if (timeType != null ? !((Object)timeType).equals(internalType3) : internalType3 != null) break block4;
                    method = BuiltInMethod.STRING_TO_TIME.method;
                    break block3;
                }
                TimestampType timestampType = DataTypes.TIMESTAMP;
                InternalType internalType4 = internalType;
                if (timestampType != null ? !((Object)timestampType).equals(internalType4) : internalType4 != null) break block5;
                method = BuiltInMethod.STRING_TO_TIMESTAMP.method;
            }
            Method toTimeMethod = method;
            String term2 = CodeGenUtils$.MODULE$.newName("stringToTime");
            ctx.addReusableMember(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = ", " ? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeTerm, term2, expr.nullTerm()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", "(", ".toString());"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultTerm, CodeGenUtils$.MODULE$.qualifyMethod(toTimeMethod), rightTerm}))).toString(), ctx.addReusableMember$default$2());
            InternalType x$23 = expectType;
            String x$24 = term2;
            String x$25 = expr.copy$default$2();
            String x$26 = expr.copy$default$3();
            boolean x$27 = expr.copy$default$5();
            Object x$28 = expr.copy$default$6();
            Seq<String> x$29 = expr.copy$default$7();
            String x$30 = expr.copy$default$8();
            String x$31 = expr.copy$default$9();
            return expr.copy(x$24, x$25, x$26, x$23, x$27, x$28, x$29, x$30, x$31);
        }
        throw new MatchError((Object)internalType);
    }

    public GeneratedExpression generateNotEquals(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        block11: {
            GeneratedExpression generatedExpression;
            block3: {
                Object object;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                InternalType internalType = left.resultType();
                                                StringType stringType = DataTypes.STRING;
                                                if (internalType != null ? !internalType.equals(stringType) : stringType != null) break block2;
                                                InternalType internalType2 = right.resultType();
                                                StringType stringType2 = DataTypes.STRING;
                                                if (internalType2 != null ? !internalType2.equals(stringType2) : stringType2 != null) break block2;
                                                generatedExpression = BinaryStringCallGen$.MODULE$.generateStringNotEquals(ctx, left, right);
                                                break block3;
                                            }
                                            if (!TypeCheckUtils$.MODULE$.isNumeric(left.resultType()) || !TypeCheckUtils$.MODULE$.isNumeric(right.resultType())) break block4;
                                            generatedExpression = this.generateComparison(ctx, "!=", nullCheck, left, right);
                                            break block3;
                                        }
                                        if (!TypeCheckUtils$.MODULE$.isTemporal(left.resultType())) break block5;
                                        InternalType internalType = left.resultType();
                                        InternalType internalType3 = right.resultType();
                                        if (internalType != null ? !internalType.equals(internalType3) : internalType3 != null) break block5;
                                        generatedExpression = this.generateComparison(ctx, "!=", nullCheck, left, right);
                                        break block3;
                                    }
                                    if (!TypeCheckUtils$.MODULE$.isArray(left.resultType())) break block6;
                                    InternalType internalType = left.resultType();
                                    InternalType internalType4 = right.resultType();
                                    if (internalType != null ? !internalType.equals(internalType4) : internalType4 != null) break block6;
                                    GeneratedExpression equalsExpr = this.generateEquals(ctx, nullCheck, left, right);
                                    generatedExpression = new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{equalsExpr.resultTerm()})), equalsExpr.nullTerm(), equalsExpr.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                                    break block3;
                                }
                                if (!TypeCheckUtils$.MODULE$.isMap(left.resultType())) break block7;
                                InternalType internalType = left.resultType();
                                InternalType internalType5 = right.resultType();
                                if (internalType != null ? !internalType.equals(internalType5) : internalType5 != null) break block7;
                                GeneratedExpression equalsExpr = this.generateEquals(ctx, nullCheck, left, right);
                                generatedExpression = new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{equalsExpr.resultTerm()})), equalsExpr.nullTerm(), equalsExpr.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                                break block3;
                            }
                            if (!TypeCheckUtils$.MODULE$.isComparable(left.resultType())) break block8;
                            InternalType internalType = left.resultType();
                            InternalType internalType6 = right.resultType();
                            if (internalType != null ? !internalType.equals(internalType6) : internalType6 != null) break block8;
                            generatedExpression = this.generateComparison(ctx, "!=", nullCheck, left, right);
                            break block3;
                        }
                        if (!CodeGenUtils$.MODULE$.isReference(left)) break block9;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String leftTerm, String rightTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ".equals(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                            }
                        };
                        break block10;
                    }
                    if (!CodeGenUtils$.MODULE$.isReference(right)) break block11;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ".equals(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightTerm, leftTerm}));
                        }
                    };
                }
                generatedExpression = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.BOOLEAN, left, right, (Function2<String, String, String>)object);
            }
            return generatedExpression;
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression generateComparison(CodeGeneratorContext ctx, String operator, boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        block11: {
            Object object;
            block3: {
                block10: {
                    block6: {
                        block9: {
                            Object object2;
                            block8: {
                                String string;
                                block7: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                if (!TypeCheckUtils$.MODULE$.isDecimal(left.resultType()) && !TypeCheckUtils$.MODULE$.isDecimal(right.resultType())) break block2;
                                                object = new Serializable(operator){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String operator$3;

                                                    public final String apply(String leftTerm, String rightTerm) {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.compare(), leftTerm, rightTerm, this.operator$3}));
                                                    }
                                                    {
                                                        this.operator$3 = operator$3;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!TypeCheckUtils$.MODULE$.isNumeric(left.resultType()) || !TypeCheckUtils$.MODULE$.isNumeric(right.resultType())) break block4;
                                            object = new Serializable(operator){
                                                public static final long serialVersionUID = 0L;
                                                private final String operator$3;

                                                public final String apply(String leftTerm, String rightTerm) {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                                }
                                                {
                                                    this.operator$3 = operator$3;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!TypeCheckUtils$.MODULE$.isTemporal(left.resultType())) break block5;
                                        InternalType internalType = left.resultType();
                                        InternalType internalType2 = right.resultType();
                                        if (internalType != null ? !internalType.equals(internalType2) : internalType2 != null) break block5;
                                        object = new Serializable(operator){
                                            public static final long serialVersionUID = 0L;
                                            private final String operator$3;

                                            public final String apply(String leftTerm, String rightTerm) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                            }
                                            {
                                                this.operator$3 = operator$3;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!TypeCheckUtils$.MODULE$.isBoolean(left.resultType())) break block6;
                                    InternalType internalType = left.resultType();
                                    InternalType internalType3 = right.resultType();
                                    if (internalType != null ? !internalType.equals(internalType3) : internalType3 != null) break block6;
                                    string = operator;
                                    boolean bl = "==".equals(string) ? true : "!=".equals(string);
                                    if (!bl) break block7;
                                    object2 = new Serializable(operator){
                                        public static final long serialVersionUID = 0L;
                                        private final String operator$3;

                                        public final String apply(String leftTerm, String rightTerm) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                        }
                                        {
                                            this.operator$3 = operator$3;
                                        }
                                    };
                                    break block8;
                                }
                                boolean bl = ">".equals(string) ? true : ("<".equals(string) ? true : ("<=".equals(string) ? true : ">=".equals(string)));
                                if (!bl) break block9;
                                object2 = new Serializable(operator){
                                    public static final long serialVersionUID = 0L;
                                    private final String operator$3;

                                    public final String apply(String leftTerm, String rightTerm) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Boolean.compare(", ", ", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}));
                                    }
                                    {
                                        this.operator$3 = operator$3;
                                    }
                                };
                            }
                            object = object2;
                            break block3;
                        }
                        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported boolean comparison '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operator})));
                    }
                    if (!TypeCheckUtils$.MODULE$.isBinary(left.resultType())) break block10;
                    InternalType internalType = left.resultType();
                    InternalType internalType4 = right.resultType();
                    if (internalType != null ? !internalType.equals(internalType4) : internalType4 != null) break block10;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.util.Arrays.equals(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                        }
                    };
                    break block3;
                }
                if (!TypeCheckUtils$.MODULE$.isComparable(left.resultType())) break block11;
                InternalType internalType = left.resultType();
                InternalType internalType5 = right.resultType();
                if (internalType != null ? !internalType.equals(internalType5) : internalType5 != null) break block11;
                object = new Serializable(operator){
                    public static final long serialVersionUID = 0L;
                    private final String operator$3;

                    public final String apply(String leftTerm, String rightTerm) {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", " == null) ? ((", " == null) ? 0 : -1) : ((", " == null) ? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, rightTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 : (", ".compareTo(", ")))) ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}))).toString();
                    }
                    {
                        this.operator$3 = operator$3;
                    }
                };
            }
            return CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.BOOLEAN, left, right, (Function2<String, String, String>)object);
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression generateArrayComparison(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        return CallGenerator$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, nullCheck, DataTypes.BOOLEAN, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), CallGenerator$.MODULE$.generateCallWithStmtIfArgsNotNull$default$5(), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, nullCheck, left){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$6;
            private final boolean nullCheck$5;
            private final GeneratedExpression left$2;

            public final Tuple2<String, String> apply(Seq<String> args) {
                String leftTerm = (String)args.head();
                String rightTerm = (String)args.apply(1);
                String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
                String binaryArrayCls = BinaryArray.class.getCanonicalName();
                InternalType elementType = ((ArrayType)this.left$2.resultType()).getElementInternalType();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
                String leftElementTerm = CodeGenUtils$.MODULE$.newName("leftElement");
                String leftElementNullTerm = CodeGenUtils$.MODULE$.newName("leftElementIsNull");
                GeneratedExpression leftElementExpr = new GeneratedExpression(leftElementTerm, leftElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                String rightElementTerm = CodeGenUtils$.MODULE$.newName("rightElement");
                String rightElementNullTerm = CodeGenUtils$.MODULE$.newName("rightElementIsNull");
                GeneratedExpression rightElementExpr = new GeneratedExpression(rightElementTerm, rightElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                String indexTerm = CodeGenUtils$.MODULE$.newName("index");
                GeneratedExpression elementEqualsExpr = ScalarOperators$.MODULE$.generateEquals(this.ctx$6, this.nullCheck$5, leftElementExpr, rightElementExpr);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |boolean ", ";\n             |if (", " instanceof ", " && ", " instanceof ", ") {\n             |  ", " = ", ".equals(", ");\n             |} else {\n             |  if (", ".numElements() == ", ".numElements()) {\n             |    ", " = true;\n             |    for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n             |      ", " ", " = ", ";\n             |      boolean ", " = ", ".isNullAt(", ");\n             |      if (!", ") {\n             |        ", " =\n             |          ", ";\n             |      }\n             |\n             |      ", " ", " = ", ";\n             |      boolean ", " = ", ".isNullAt(", ");\n             |      if (!", ") {\n             |        ", " =\n             |          ", ";\n             |      }\n             |\n             |      ", "\n             |      if (!", ") {\n             |        ", " = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ", " = false;\n             |  }\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, leftTerm, binaryArrayCls, rightTerm, binaryArrayCls, resultTerm, leftTerm, rightTerm, leftTerm, rightTerm, resultTerm, indexTerm, indexTerm, leftTerm, indexTerm, elementCls, leftElementTerm, elementDefault, leftElementNullTerm, leftTerm, indexTerm, leftElementNullTerm, leftElementTerm, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.ctx$6, indexTerm, leftTerm, elementType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5()), elementCls, rightElementTerm, elementDefault, rightElementNullTerm, rightTerm, indexTerm, rightElementNullTerm, rightElementTerm, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.ctx$6, indexTerm, rightTerm, elementType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5()), elementEqualsExpr.code(), elementEqualsExpr.resultTerm(), resultTerm, resultTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$6 = ctx$6;
                this.nullCheck$5 = nullCheck$5;
                this.left$2 = left$2;
            }
        });
    }

    public GeneratedExpression generateMapComparison(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        return CallGenerator$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, nullCheck, DataTypes.BOOLEAN, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), CallGenerator$.MODULE$.generateCallWithStmtIfArgsNotNull$default$5(), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, nullCheck, left){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$7;
            private final boolean nullCheck$6;
            private final GeneratedExpression left$3;

            public final Tuple2<String, String> apply(Seq<String> args) {
                String leftTerm = (String)args.head();
                String rightTerm = (String)args.apply(1);
                String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
                String binaryMapCls = BinaryMap.class.getCanonicalName();
                MapType mapType = (MapType)this.left$3.resultType();
                String mapCls = Map.class.getCanonicalName();
                String keyCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(mapType.getKeyInternalType());
                String valueCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(mapType.getValueInternalType());
                String leftMapTerm = CodeGenUtils$.MODULE$.newName("leftMap");
                String leftKeyTerm = CodeGenUtils$.MODULE$.newName("leftKey");
                String leftValueTerm = CodeGenUtils$.MODULE$.newName("leftValue");
                String leftValueNullTerm = CodeGenUtils$.MODULE$.newName("leftValueIsNull");
                GeneratedExpression leftValueExpr = new GeneratedExpression(leftValueTerm, leftValueNullTerm, "", mapType.getValueInternalType(), GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                String rightMapTerm = CodeGenUtils$.MODULE$.newName("rightMap");
                String rightValueTerm = CodeGenUtils$.MODULE$.newName("rightValue");
                String rightValueNullTerm = CodeGenUtils$.MODULE$.newName("rightValueIsNull");
                GeneratedExpression rightValueExpr = new GeneratedExpression(rightValueTerm, rightValueNullTerm, "", mapType.getValueInternalType(), GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                String entryTerm = CodeGenUtils$.MODULE$.newName("entry");
                String entryCls = Map.Entry.class.getCanonicalName();
                GeneratedExpression valueEqualsExpr = ScalarOperators$.MODULE$.generateEquals(this.ctx$7, this.nullCheck$6, leftValueExpr, rightValueExpr);
                String internalTypeCls = InternalType.class.getCanonicalName();
                String keyTypeTerm = this.ctx$7.addReusableObject(mapType.getKeyInternalType(), "keyType", internalTypeCls);
                String valueTypeTerm = this.ctx$7.addReusableObject(mapType.getValueInternalType(), "valueType", internalTypeCls);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |boolean ", ";\n             |if (", " instanceof ", " && ", " instanceof ", ") {\n             |  ", " = ", ".equals(", ");\n             |} else {\n             |  if (", ".numElements() == ", ".numElements()) {\n             |    ", " = true;\n             |    ", " ", " = ", ".toJavaMap(", ", ", ");\n             |    ", " ", " = ", ".toJavaMap(", ", ", ");\n             |\n             |    for (", " ", " : ", ".entrySet()) {\n             |      ", " ", " = (", ") ", ".getKey();\n             |      if (", ".containsKey(", ")) {\n             |        ", " ", " = (", ") ", ".getValue();\n             |        ", " ", " = (", ") ", ".get(", ");\n             |        boolean ", " = (", " == null);\n             |        boolean ", " = (", " == null);\n             |\n             |        ", "\n             |        if (!", ") {\n             |          ", " = false;\n             |          break;\n             |        }\n             |      } else {\n             |        ", " = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ", " = false;\n             |  }\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, leftTerm, binaryMapCls, rightTerm, binaryMapCls, resultTerm, leftTerm, rightTerm, leftTerm, rightTerm, resultTerm, mapCls, leftMapTerm, leftTerm, keyTypeTerm, valueTypeTerm, mapCls, rightMapTerm, rightTerm, keyTypeTerm, valueTypeTerm, entryCls, entryTerm, leftMapTerm, keyCls, leftKeyTerm, keyCls, entryTerm, rightMapTerm, leftKeyTerm, valueCls, leftValueTerm, valueCls, entryTerm, valueCls, rightValueTerm, valueCls, rightMapTerm, leftKeyTerm, leftValueNullTerm, leftValueTerm, rightValueNullTerm, rightValueTerm, valueEqualsExpr.code(), valueEqualsExpr.resultTerm(), resultTerm, resultTerm, resultTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$7 = ctx$7;
                this.nullCheck$6 = nullCheck$6;
                this.left$3 = left$3;
            }
        });
    }

    public GeneratedExpression generateIsNull(boolean nullCheck, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (nullCheck) {
            generatedExpression = new GeneratedExpression(operand.nullTerm(), "false", operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        } else if (!nullCheck && CodeGenUtils$.MODULE$.isReference(operand)) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = ", " == null;\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.resultTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, "false", operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        } else {
            generatedExpression = new GeneratedExpression("false", "false", operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotNull(boolean nullCheck, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (nullCheck) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = !", ";\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.nullTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, "false", operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        } else if (!nullCheck && CodeGenUtils$.MODULE$.isReference(operand)) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", " != null;\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.resultTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, "false", operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        } else {
            generatedExpression = new GeneratedExpression("true", "false", operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateAnd(boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String operatorCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |\n         |boolean ", " = false;\n         |boolean ", " = false;\n         |if (!", " && !", ") {\n         |  // left expr is false, skip right expr\n         |} else {\n         |  ", "\n         |\n         |  if (!", " && !", ") {\n         |    ", " = ", " && ", ";\n         |    ", " = false;\n         |  }\n         |  else if (!", " && ", " && ", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else if (!", " && !", " && ", ") {\n         |    ", " = false;\n         |    ", " = false;\n         |  }\n         |  else if (", " && !", " && ", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else if (", " && !", " && !", ") {\n         |    ", " = false;\n         |    ", " = false;\n         |  }\n         |  else {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.code(), left.nullTerm(), right.nullTerm(), resultTerm2, left.resultTerm(), right.resultTerm(), nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, resultTerm2, nullTerm2})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = false;\n         |if (", ") {\n         |  ", "\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, left.resultTerm(), right.code(), resultTerm2, right.resultTerm()})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateOr(boolean nullCheck, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String operatorCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |\n        |boolean ", " = true;\n        |boolean ", " = false;\n        |if (!", " && ", ") {\n        |  // left expr is true, skip right expr\n        |} else {\n        |  ", "\n        |\n        |  if (!", " && !", ") {\n        |    ", " = ", " || ", ";\n        |    ", " = false;\n        |  }\n        |  else if (!", " && ", " && ", ") {\n        |    ", " = true;\n        |    ", " = false;\n        |  }\n        |  else if (!", " && !", " && ", ") {\n        |    ", " = false;\n        |    ", " = true;\n        |  }\n        |  else if (", " && !", " && ", ") {\n        |    ", " = true;\n        |    ", " = false;\n        |  }\n        |  else if (", " && !", " && !", ") {\n        |    ", " = false;\n        |    ", " = true;\n        |  }\n        |  else {\n        |    ", " = false;\n        |    ", " = true;\n        |  }\n        |}\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.code(), left.nullTerm(), right.nullTerm(), resultTerm2, left.resultTerm(), right.resultTerm(), nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, resultTerm2, nullTerm2})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = true;\n         |if (!", ") {\n         |  ", "\n         |  ", " = ", ";\n         |}\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, left.resultTerm(), right.code(), resultTerm2, right.resultTerm()})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateNot(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand) {
        return CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, DataTypes.BOOLEAN, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String operandTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
            }
        });
    }

    public GeneratedExpression generateIsTrue(GeneratedExpression operand) {
        return new GeneratedExpression(operand.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateIsNotTrue(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateIsFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", " && !", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm(), operand.nullTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateIsNotFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " || ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm(), operand.nullTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateReinterpret(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand, InternalType targetType) {
        block21: {
            block7: {
                block9: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block8: {
                                                                    block6: {
                                                                        var5_5 = new Tuple2((Object)operand.resultType(), (Object)targetType);
                                                                        if (var5_5 == null) break block6;
                                                                        fromTp = (InternalType)var5_5._1();
                                                                        toTp = (InternalType)var5_5._2();
                                                                        v0 = fromTp;
                                                                        var8_8 = toTp;
                                                                        if (v0 != null ? v0.equals(var8_8) == false : var8_8 != null) break block6;
                                                                        var9_9 = operand;
                                                                        break block7;
                                                                    }
                                                                    if (var5_5 == null) break block8;
                                                                    var10_10 = (InternalType)var5_5._1();
                                                                    var11_11 = (InternalType)var5_5._2();
                                                                    v1 = DataTypes.DATE;
                                                                    var12_12 = var10_10;
                                                                    if (v1 != null ? v1.equals(var12_12) == false : var12_12 != null) break block8;
                                                                    v2 = DataTypes.INT;
                                                                    var13_13 = var11_11;
                                                                    if (v2 != null ? v2.equals(var13_13) == false : var13_13 != null) break block8;
                                                                    var14_14 = true;
                                                                    break block9;
                                                                }
                                                                if (var5_5 == null) break block10;
                                                                var15_15 = (InternalType)var5_5._1();
                                                                var16_16 = (InternalType)var5_5._2();
                                                                v3 = DataTypes.TIME;
                                                                var17_17 = var15_15;
                                                                if (v3 != null ? v3.equals(var17_17) == false : var17_17 != null) break block10;
                                                                v4 = DataTypes.INT;
                                                                var18_18 = var16_16;
                                                                if (v4 != null ? v4.equals(var18_18) == false : var18_18 != null) break block10;
                                                                var14_14 = true;
                                                                break block9;
                                                            }
                                                            if (var5_5 == null) break block11;
                                                            var19_19 = (InternalType)var5_5._2();
                                                            if (!(var5_5._1() instanceof TimestampType)) break block11;
                                                            v5 = DataTypes.LONG;
                                                            var20_20 = var19_19;
                                                            if (v5 != null ? v5.equals(var20_20) == false : var20_20 != null) break block11;
                                                            var14_14 = true;
                                                            break block9;
                                                        }
                                                        if (var5_5 == null) break block12;
                                                        var21_21 = (InternalType)var5_5._1();
                                                        var22_22 = (InternalType)var5_5._2();
                                                        v6 = DataTypes.INT;
                                                        var23_23 = var21_21;
                                                        if (v6 != null ? v6.equals(var23_23) == false : var23_23 != null) break block12;
                                                        v7 = DataTypes.DATE;
                                                        var24_24 = var22_22;
                                                        if (v7 != null ? v7.equals(var24_24) == false : var24_24 != null) break block12;
                                                        var14_14 = true;
                                                        break block9;
                                                    }
                                                    if (var5_5 == null) break block13;
                                                    var25_25 = (InternalType)var5_5._1();
                                                    var26_26 = (InternalType)var5_5._2();
                                                    v8 = DataTypes.INT;
                                                    var27_27 = var25_25;
                                                    if (v8 != null ? v8.equals(var27_27) == false : var27_27 != null) break block13;
                                                    v9 = DataTypes.TIME;
                                                    var28_28 = var26_26;
                                                    if (v9 != null ? v9.equals(var28_28) == false : var28_28 != null) break block13;
                                                    var14_14 = true;
                                                    break block9;
                                                }
                                                if (var5_5 == null) break block14;
                                                var29_29 = (InternalType)var5_5._1();
                                                v10 = DataTypes.LONG;
                                                var30_30 = var29_29;
                                                if ((v10 != null ? v10.equals(var30_30) == false : var30_30 != null) || !(var5_5._2() instanceof TimestampType)) break block14;
                                                var14_14 = true;
                                                break block9;
                                            }
                                            if (var5_5 == null) break block15;
                                            var31_31 = (InternalType)var5_5._1();
                                            var32_32 = (InternalType)var5_5._2();
                                            v11 = DataTypes.INT;
                                            var33_33 = var31_31;
                                            if (v11 != null ? v11.equals(var33_33) == false : var33_33 != null) break block15;
                                            v12 = DataTypes.INTERVAL_MONTHS;
                                            var34_34 = var32_32;
                                            if (v12 != null ? v12.equals(var34_34) == false : var34_34 != null) break block15;
                                            var14_14 = true;
                                            break block9;
                                        }
                                        if (var5_5 == null) break block16;
                                        var35_35 = (InternalType)var5_5._1();
                                        var36_36 = (InternalType)var5_5._2();
                                        v13 = DataTypes.LONG;
                                        var37_37 = var35_35;
                                        if (v13 != null ? v13.equals(var37_37) == false : var37_37 != null) break block16;
                                        v14 = DataTypes.INTERVAL_MILLIS;
                                        var38_38 = var36_36;
                                        if (v14 != null ? v14.equals(var38_38) == false : var38_38 != null) break block16;
                                        var14_14 = true;
                                        break block9;
                                    }
                                    if (var5_5 == null) break block17;
                                    var39_39 = (InternalType)var5_5._1();
                                    var40_40 = (InternalType)var5_5._2();
                                    v15 = DataTypes.INTERVAL_MONTHS;
                                    var41_41 = var39_39;
                                    if (v15 != null ? v15.equals(var41_41) == false : var41_41 != null) break block17;
                                    v16 = DataTypes.INT;
                                    var42_42 = var40_40;
                                    if (v16 != null ? v16.equals(var42_42) == false : var42_42 != null) break block17;
                                    var14_14 = true;
                                    break block9;
                                }
                                if (var5_5 == null) break block18;
                                var43_43 = (InternalType)var5_5._1();
                                var44_44 = (InternalType)var5_5._2();
                                v17 = DataTypes.INTERVAL_MILLIS;
                                var45_45 = var43_43;
                                if (v17 != null ? v17.equals(var45_45) == false : var45_45 != null) break block18;
                                v18 = DataTypes.LONG;
                                var46_46 = var44_44;
                                if (v18 != null ? v18.equals(var46_46) == false : var46_46 != null) break block18;
                                var14_14 = true;
                                break block9;
                            }
                            if (var5_5 == null) break block19;
                            var47_47 = (InternalType)var5_5._1();
                            var48_48 = (InternalType)var5_5._2();
                            v19 = DataTypes.DATE;
                            var49_49 = var47_47;
                            if (v19 != null ? v19.equals(var49_49) == false : var49_49 != null) break block19;
                            v20 = DataTypes.LONG;
                            var50_50 = var48_48;
                            if (v20 != null ? v20.equals(var50_50) == false : var50_50 != null) break block19;
                            var14_14 = true;
                            break block9;
                        }
                        if (var5_5 == null) break block20;
                        var51_51 = (InternalType)var5_5._1();
                        var52_52 = (InternalType)var5_5._2();
                        v21 = DataTypes.TIME;
                        var53_53 = var51_51;
                        if (v21 != null ? v21.equals(var53_53) == false : var53_53 != null) break block20;
                        v22 = DataTypes.LONG;
                        var54_54 = var52_52;
                        if (v22 != null ? v22.equals(var54_54) == false : var54_54 != null) break block20;
                        var14_14 = true;
                        break block9;
                    }
                    if (var5_5 == null) ** GOTO lbl-1000
                    var55_55 = (InternalType)var5_5._1();
                    var56_56 = (InternalType)var5_5._2();
                    v23 = DataTypes.INTERVAL_MONTHS;
                    var57_57 = var55_55;
                    if (v23 != null ? v23.equals(var57_57) == false : var57_57 != null) ** GOTO lbl-1000
                    v24 = DataTypes.LONG;
                    var58_58 = var56_56;
                    if (!(v24 != null ? v24.equals(var58_58) == false : var58_58 != null)) {
                        var14_14 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        var14_14 = false;
                    }
                }
                if (!var14_14) break block21;
                var9_9 = this.internalExprCasting(operand, targetType);
            }
            return var9_9;
        }
        if (var5_5 != null) {
            from = (InternalType)var5_5._1();
            to = (InternalType)var5_5._2();
            throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported reinterpret from '", "' to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        }
        throw new MatchError((Object)var5_5);
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateCast(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand, InternalType targetType) {
        block86: {
            block33: {
                block84: {
                    block85: {
                        block83: {
                            block82: {
                                block75: {
                                    block81: {
                                        block80: {
                                            block79: {
                                                block78: {
                                                    block77: {
                                                        block76: {
                                                            block74: {
                                                                block73: {
                                                                    block72: {
                                                                        block71: {
                                                                            block70: {
                                                                                block69: {
                                                                                    block68: {
                                                                                        block67: {
                                                                                            block66: {
                                                                                                block65: {
                                                                                                    block64: {
                                                                                                        block61: {
                                                                                                            block63: {
                                                                                                                block62: {
                                                                                                                    block60: {
                                                                                                                        block59: {
                                                                                                                            block58: {
                                                                                                                                block57: {
                                                                                                                                    block56: {
                                                                                                                                        block55: {
                                                                                                                                            block54: {
                                                                                                                                                block53: {
                                                                                                                                                    block52: {
                                                                                                                                                        block51: {
                                                                                                                                                            block50: {
                                                                                                                                                                block49: {
                                                                                                                                                                    block48: {
                                                                                                                                                                        block47: {
                                                                                                                                                                            block46: {
                                                                                                                                                                                block45: {
                                                                                                                                                                                    block44: {
                                                                                                                                                                                        block43: {
                                                                                                                                                                                            block42: {
                                                                                                                                                                                                block41: {
                                                                                                                                                                                                    block40: {
                                                                                                                                                                                                        block39: {
                                                                                                                                                                                                            block38: {
                                                                                                                                                                                                                block37: {
                                                                                                                                                                                                                    block36: {
                                                                                                                                                                                                                        block35: {
                                                                                                                                                                                                                            block34: {
                                                                                                                                                                                                                                block32: {
                                                                                                                                                                                                                                    block29: {
                                                                                                                                                                                                                                        block31: {
                                                                                                                                                                                                                                            block30: {
                                                                                                                                                                                                                                                block28: {
                                                                                                                                                                                                                                                    var5_5 = new Tuple2((Object)operand.resultType(), (Object)targetType);
                                                                                                                                                                                                                                                    if (var5_5 == null) break block28;
                                                                                                                                                                                                                                                    var6_6 = (InternalType)var5_5._1();
                                                                                                                                                                                                                                                    var7_7 = (InternalType)var5_5._2();
                                                                                                                                                                                                                                                    v0 = DataTypes.PROCTIME_INDICATOR;
                                                                                                                                                                                                                                                    var8_8 = var6_6;
                                                                                                                                                                                                                                                    if (v0 != null ? v0.equals(var8_8) == false : var8_8 != null) break block28;
                                                                                                                                                                                                                                                    v1 = DataTypes.TIMESTAMP;
                                                                                                                                                                                                                                                    var9_9 = var7_7;
                                                                                                                                                                                                                                                    if (v1 != null ? v1.equals(var9_9) == false : var9_9 != null) break block28;
                                                                                                                                                                                                                                                    var10_10 = true;
                                                                                                                                                                                                                                                    break block29;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (var5_5 == null) break block30;
                                                                                                                                                                                                                                                var11_11 = (InternalType)var5_5._1();
                                                                                                                                                                                                                                                var12_12 = (InternalType)var5_5._2();
                                                                                                                                                                                                                                                v2 = DataTypes.ROWTIME_INDICATOR;
                                                                                                                                                                                                                                                var13_13 = var11_11;
                                                                                                                                                                                                                                                if (v2 != null ? v2.equals(var13_13) == false : var13_13 != null) break block30;
                                                                                                                                                                                                                                                v3 = DataTypes.TIMESTAMP;
                                                                                                                                                                                                                                                var14_14 = var12_12;
                                                                                                                                                                                                                                                if (v3 != null ? v3.equals(var14_14) == false : var14_14 != null) break block30;
                                                                                                                                                                                                                                                var10_10 = true;
                                                                                                                                                                                                                                                break block29;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (var5_5 == null) break block31;
                                                                                                                                                                                                                                            var15_15 = (InternalType)var5_5._1();
                                                                                                                                                                                                                                            var16_16 = (InternalType)var5_5._2();
                                                                                                                                                                                                                                            v4 = DataTypes.TIMESTAMP;
                                                                                                                                                                                                                                            var17_17 = var15_15;
                                                                                                                                                                                                                                            if (v4 != null ? v4.equals(var17_17) == false : var17_17 != null) break block31;
                                                                                                                                                                                                                                            v5 = DataTypes.PROCTIME_INDICATOR;
                                                                                                                                                                                                                                            var18_18 = var16_16;
                                                                                                                                                                                                                                            if (v5 != null ? v5.equals(var18_18) == false : var18_18 != null) break block31;
                                                                                                                                                                                                                                            var10_10 = true;
                                                                                                                                                                                                                                            break block29;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (var5_5 == null) ** GOTO lbl-1000
                                                                                                                                                                                                                                        var19_19 = (InternalType)var5_5._1();
                                                                                                                                                                                                                                        var20_20 = (InternalType)var5_5._2();
                                                                                                                                                                                                                                        v6 = DataTypes.TIMESTAMP;
                                                                                                                                                                                                                                        var21_21 = var19_19;
                                                                                                                                                                                                                                        if (v6 != null ? v6.equals(var21_21) == false : var21_21 != null) ** GOTO lbl-1000
                                                                                                                                                                                                                                        v7 = DataTypes.ROWTIME_INDICATOR;
                                                                                                                                                                                                                                        var22_22 = var20_20;
                                                                                                                                                                                                                                        if (!(v7 != null ? v7.equals(var22_22) == false : var22_22 != null)) {
                                                                                                                                                                                                                                            var10_10 = true;
                                                                                                                                                                                                                                        } else lbl-1000:
                                                                                                                                                                                                                                        // 3 sources

                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                            var10_10 = false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!var10_10) break block32;
                                                                                                                                                                                                                                    x$32 = DataTypes.TIMESTAMP;
                                                                                                                                                                                                                                    x$33 = operand.copy$default$1();
                                                                                                                                                                                                                                    x$34 = operand.copy$default$2();
                                                                                                                                                                                                                                    x$35 = operand.copy$default$3();
                                                                                                                                                                                                                                    x$36 = operand.copy$default$5();
                                                                                                                                                                                                                                    x$37 = operand.copy$default$6();
                                                                                                                                                                                                                                    x$38 = operand.copy$default$7();
                                                                                                                                                                                                                                    x$39 = operand.copy$default$8();
                                                                                                                                                                                                                                    x$40 = operand.copy$default$9();
                                                                                                                                                                                                                                    var32_32 = operand.copy(x$33, x$34, x$35, x$32, x$36, x$37, x$38, x$39, x$40);
                                                                                                                                                                                                                                    break block33;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (var5_5 == null) break block34;
                                                                                                                                                                                                                                fromTp = (InternalType)var5_5._1();
                                                                                                                                                                                                                                toTp = (InternalType)var5_5._2();
                                                                                                                                                                                                                                v8 = fromTp;
                                                                                                                                                                                                                                var35_35 = toTp;
                                                                                                                                                                                                                                if (v8 != null ? v8.equals(var35_35) == false : var35_35 != null) break block34;
                                                                                                                                                                                                                                var32_32 = operand;
                                                                                                                                                                                                                                break block33;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (var5_5 == null) break block35;
                                                                                                                                                                                                                            left = (InternalType)var5_5._1();
                                                                                                                                                                                                                            var37_37 = (InternalType)var5_5._2();
                                                                                                                                                                                                                            v9 = DataTypes.STRING;
                                                                                                                                                                                                                            var38_38 = var37_37;
                                                                                                                                                                                                                            if ((v9 != null ? v9.equals(var38_38) == false : var38_38 != null) || !TypeCheckUtils$.MODULE$.isTimePoint(left)) break block35;
                                                                                                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateReturnStringCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)new Serializable(ctx, left){
                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                private final InternalType left$4;

                                                                                                                                                                                                                                public final String apply(Seq<String> operandTerm) {
                                                                                                                                                                                                                                    String zoneTerm = this.ctx$2.addReusableTimeZone();
                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.internalToStringCode(this.left$4, (String)operandTerm.head(), zoneTerm)}));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                    this.left$4 = left$4;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            });
                                                                                                                                                                                                                            break block33;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (var5_5 == null) break block36;
                                                                                                                                                                                                                        var39_39 = (InternalType)var5_5._1();
                                                                                                                                                                                                                        var40_40 = (InternalType)var5_5._2();
                                                                                                                                                                                                                        v10 = DataTypes.INTERVAL_MONTHS;
                                                                                                                                                                                                                        var41_41 = var39_39;
                                                                                                                                                                                                                        if (v10 != null ? v10.equals(var41_41) == false : var41_41 != null) break block36;
                                                                                                                                                                                                                        v11 = DataTypes.STRING;
                                                                                                                                                                                                                        var42_42 = var40_40;
                                                                                                                                                                                                                        if (v11 != null ? v11.equals(var42_42) == false : var42_42 != null) break block36;
                                                                                                                                                                                                                        method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method);
                                                                                                                                                                                                                        timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.YEAR_TO_MONTH);
                                                                                                                                                                                                                        var32_32 = CallGenerator$.MODULE$.generateReturnStringCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)new Serializable(method, timeUnitRange){
                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                            private final String method$2;
                                                                                                                                                                                                                            private final String timeUnitRange$1;

                                                                                                                                                                                                                            public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$2, terms.head(), this.timeUnitRange$1}));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                this.method$2 = method$2;
                                                                                                                                                                                                                                this.timeUnitRange$1 = timeUnitRange$1;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        });
                                                                                                                                                                                                                        break block33;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (var5_5 == null) break block37;
                                                                                                                                                                                                                    var45_45 = (InternalType)var5_5._1();
                                                                                                                                                                                                                    var46_46 = (InternalType)var5_5._2();
                                                                                                                                                                                                                    v12 = DataTypes.INTERVAL_MILLIS;
                                                                                                                                                                                                                    var47_47 = var45_45;
                                                                                                                                                                                                                    if (v12 != null ? v12.equals(var47_47) == false : var47_47 != null) break block37;
                                                                                                                                                                                                                    v13 = DataTypes.STRING;
                                                                                                                                                                                                                    var48_48 = var46_46;
                                                                                                                                                                                                                    if (v13 != null ? v13.equals(var48_48) == false : var48_48 != null) break block37;
                                                                                                                                                                                                                    method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method);
                                                                                                                                                                                                                    timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.DAY_TO_SECOND);
                                                                                                                                                                                                                    var32_32 = CallGenerator$.MODULE$.generateReturnStringCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)new Serializable(method, timeUnitRange){
                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                        private final String method$3;
                                                                                                                                                                                                                        private final String timeUnitRange$2;

                                                                                                                                                                                                                        public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ", 3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$3, terms.head(), this.timeUnitRange$2}));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        {
                                                                                                                                                                                                                            this.method$3 = method$3;
                                                                                                                                                                                                                            this.timeUnitRange$2 = timeUnitRange$2;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    });
                                                                                                                                                                                                                    break block33;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (var5_5 == null) break block38;
                                                                                                                                                                                                                at = (InternalType)var5_5._1();
                                                                                                                                                                                                                var52_52 = (InternalType)var5_5._2();
                                                                                                                                                                                                                if (!(at instanceof ArrayType)) break block38;
                                                                                                                                                                                                                var53_53 = (ArrayType)at;
                                                                                                                                                                                                                v14 = DataTypes.STRING;
                                                                                                                                                                                                                var54_54 = var52_52;
                                                                                                                                                                                                                if (v14 != null ? v14.equals(var54_54) == false : var54_54 != null) break block38;
                                                                                                                                                                                                                var32_32 = this.generateCastArrayToString(ctx, nullCheck, operand, var53_53);
                                                                                                                                                                                                                break block33;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (var5_5 == null) break block39;
                                                                                                                                                                                                            var55_55 = (InternalType)var5_5._1();
                                                                                                                                                                                                            var56_56 = (InternalType)var5_5._2();
                                                                                                                                                                                                            v15 = DataTypes.BYTE_ARRAY;
                                                                                                                                                                                                            var57_57 = var55_55;
                                                                                                                                                                                                            if (v15 != null ? v15.equals(var57_57) == false : var57_57 != null) break block39;
                                                                                                                                                                                                            v16 = DataTypes.STRING;
                                                                                                                                                                                                            var58_58 = var56_56;
                                                                                                                                                                                                            if (v16 != null ? v16.equals(var58_58) == false : var58_58 != null) break block39;
                                                                                                                                                                                                            charset = StandardCharsets.class.getCanonicalName();
                                                                                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateReturnStringCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)new Serializable(ctx, operand, charset){
                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                private final GeneratedExpression operand$2;
                                                                                                                                                                                                                private final String charset$1;

                                                                                                                                                                                                                public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(new String(", ", ", ".UTF_8))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataStructureConverters$.MODULE$.genToExternal(this.ctx$2, this.operand$2.resultType(), (String)terms.head()), this.charset$1}));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                {
                                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                                    this.operand$2 = operand$2;
                                                                                                                                                                                                                    this.charset$1 = charset$1;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            });
                                                                                                                                                                                                            break block33;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (var5_5 == null) break block40;
                                                                                                                                                                                                        mt = (InternalType)var5_5._1();
                                                                                                                                                                                                        var61_61 = (InternalType)var5_5._2();
                                                                                                                                                                                                        if (!(mt instanceof MapType)) break block40;
                                                                                                                                                                                                        var62_62 = (MapType)mt;
                                                                                                                                                                                                        v17 = DataTypes.STRING;
                                                                                                                                                                                                        var63_63 = var61_61;
                                                                                                                                                                                                        if (v17 != null ? v17.equals(var63_63) == false : var63_63 != null) break block40;
                                                                                                                                                                                                        var32_32 = this.generateCastMapToString(ctx, nullCheck, operand, var62_62);
                                                                                                                                                                                                        break block33;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (var5_5 == null) break block41;
                                                                                                                                                                                                    brt = (InternalType)var5_5._1();
                                                                                                                                                                                                    var65_65 = (InternalType)var5_5._2();
                                                                                                                                                                                                    if (!(brt instanceof RowType)) break block41;
                                                                                                                                                                                                    var66_66 = (RowType)brt;
                                                                                                                                                                                                    v18 = DataTypes.STRING;
                                                                                                                                                                                                    var67_67 = var65_65;
                                                                                                                                                                                                    if (v18 != null ? v18.equals(var67_67) == false : var67_67 != null) break block41;
                                                                                                                                                                                                    var32_32 = this.generateBaseRowToString(ctx, nullCheck, operand, var66_66);
                                                                                                                                                                                                    break block33;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (var5_5 == null) break block42;
                                                                                                                                                                                                var68_68 = (InternalType)var5_5._2();
                                                                                                                                                                                                v19 = DataTypes.STRING;
                                                                                                                                                                                                var69_69 = var68_68;
                                                                                                                                                                                                if (v19 != null ? v19.equals(var69_69) == false : var69_69 != null) break block42;
                                                                                                                                                                                                var32_32 = CallGenerator$.MODULE$.generateReturnStringCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)new Serializable(){
                                                                                                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                                                                                                    public final String apply(Seq<String> terms) {
                                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" \"\" + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{terms.head()}));
                                                                                                                                                                                                    }
                                                                                                                                                                                                });
                                                                                                                                                                                                break block33;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var5_5 != null) {
                                                                                                                                                                                                var70_70 = (InternalType)var5_5._2();
                                                                                                                                                                                                v20 = DataTypes.CHAR;
                                                                                                                                                                                                var71_71 = var70_70;
                                                                                                                                                                                                if (!(v20 != null ? v20.equals(var71_71) == false : var71_71 != null)) {
                                                                                                                                                                                                    throw new CodeGenException("Character type not supported.");
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var5_5 == null) break block43;
                                                                                                                                                                                            var72_72 = (InternalType)var5_5._1();
                                                                                                                                                                                            var73_73 = (InternalType)var5_5._2();
                                                                                                                                                                                            v21 = DataTypes.STRING;
                                                                                                                                                                                            var74_74 = var72_72;
                                                                                                                                                                                            if (v21 != null ? v21.equals(var74_74) == false : var74_74 != null) break block43;
                                                                                                                                                                                            v22 = DataTypes.BOOLEAN;
                                                                                                                                                                                            var75_75 = var73_73;
                                                                                                                                                                                            if (v22 != null ? v22.equals(var75_75) == false : var75_75 != null) break block43;
                                                                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toBooleanSQL()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                                                                                }
                                                                                                                                                                                            });
                                                                                                                                                                                            break block33;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (var5_5 == null) break block44;
                                                                                                                                                                                        var76_76 = (InternalType)var5_5._1();
                                                                                                                                                                                        v23 = DataTypes.STRING;
                                                                                                                                                                                        var77_77 = var76_76;
                                                                                                                                                                                        if ((v23 != null ? v23.equals(var77_77) == false : var77_77 != null) || !TypeCheckUtils$.MODULE$.isNumeric(targetType)) break block44;
                                                                                                                                                                                        var78_78 = targetType;
                                                                                                                                                                                        if (var78_78 instanceof DecimalType) {
                                                                                                                                                                                            var79_79 = (DecimalType)var78_78;
                                                                                                                                                                                            var80_80 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(var79_79){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                private final DecimalType x2$1;

                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toDecimal(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm, BoxesRunTime.boxToInteger((int)this.x2$1.precision()), BoxesRunTime.boxToInteger((int)this.x2$1.scale())}));
                                                                                                                                                                                                }
                                                                                                                                                                                                {
                                                                                                                                                                                                    this.x2$1 = x2$1;
                                                                                                                                                                                                }
                                                                                                                                                                                            });
                                                                                                                                                                                        } else {
                                                                                                                                                                                            var81_81 = targetType;
                                                                                                                                                                                            v24 = DataTypes.BYTE;
                                                                                                                                                                                            var82_82 = var81_81;
                                                                                                                                                                                            if (!(v24 != null ? v24.equals(var82_82) == false : var82_82 != null)) {
                                                                                                                                                                                                var83_83 = "toByte";
                                                                                                                                                                                            } else {
                                                                                                                                                                                                v25 = DataTypes.SHORT;
                                                                                                                                                                                                var84_84 = var81_81;
                                                                                                                                                                                                if (!(v25 != null ? v25.equals(var84_84) == false : var84_84 != null)) {
                                                                                                                                                                                                    var83_83 = "toShort";
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    v26 = DataTypes.INT;
                                                                                                                                                                                                    var85_85 = var81_81;
                                                                                                                                                                                                    if (!(v26 != null ? v26.equals(var85_85) == false : var85_85 != null)) {
                                                                                                                                                                                                        var83_83 = "toInt";
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        v27 = DataTypes.LONG;
                                                                                                                                                                                                        var86_86 = var81_81;
                                                                                                                                                                                                        if (!(v27 != null ? v27.equals(var86_86) == false : var86_86 != null)) {
                                                                                                                                                                                                            var83_83 = "toLong";
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            v28 = DataTypes.DOUBLE;
                                                                                                                                                                                                            var87_87 = var81_81;
                                                                                                                                                                                                            if (!(v28 != null ? v28.equals(var87_87) == false : var87_87 != null)) {
                                                                                                                                                                                                                var83_83 = "toDouble";
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                v29 = DataTypes.FLOAT;
                                                                                                                                                                                                                var88_88 = var81_81;
                                                                                                                                                                                                                var83_83 = !(v29 != null ? v29.equals(var88_88) == false : var88_88 != null) ? "toFloat" : null;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            methodName = var83_83;
                                                                                                                                                                                            Predef$.MODULE$.assert(methodName != null, (Function0)new Serializable(){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                public final String apply() {
                                                                                                                                                                                                    return "Unexpected data type.";
                                                                                                                                                                                                }
                                                                                                                                                                                            });
                                                                                                                                                                                            var80_80 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, true, (Function1<String, String>)new Serializable(methodName){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                private final String methodName$1;

                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ".trim().", "())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm, this.methodName$1}));
                                                                                                                                                                                                }
                                                                                                                                                                                                {
                                                                                                                                                                                                    this.methodName$1 = methodName$1;
                                                                                                                                                                                                }
                                                                                                                                                                                            });
                                                                                                                                                                                        }
                                                                                                                                                                                        var32_32 = var80_80;
                                                                                                                                                                                        break block33;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (var5_5 == null) break block45;
                                                                                                                                                                                    var90_90 = (InternalType)var5_5._1();
                                                                                                                                                                                    var91_91 = (InternalType)var5_5._2();
                                                                                                                                                                                    v30 = DataTypes.STRING;
                                                                                                                                                                                    var92_92 = var90_90;
                                                                                                                                                                                    if (v30 != null ? v30.equals(var92_92) == false : var92_92 != null) break block45;
                                                                                                                                                                                    v31 = DataTypes.DATE;
                                                                                                                                                                                    var93_93 = var91_91;
                                                                                                                                                                                    if (v31 != null ? v31.equals(var93_93) == false : var93_93 != null) break block45;
                                                                                                                                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.STRING_TO_DATE.method), operandTerm}));
                                                                                                                                                                                        }
                                                                                                                                                                                    });
                                                                                                                                                                                    break block33;
                                                                                                                                                                                }
                                                                                                                                                                                if (var5_5 == null) break block46;
                                                                                                                                                                                var94_94 = (InternalType)var5_5._1();
                                                                                                                                                                                var95_95 = (InternalType)var5_5._2();
                                                                                                                                                                                v32 = DataTypes.STRING;
                                                                                                                                                                                var96_96 = var94_94;
                                                                                                                                                                                if (v32 != null ? v32.equals(var96_96) == false : var96_96 != null) break block46;
                                                                                                                                                                                v33 = DataTypes.TIME;
                                                                                                                                                                                var97_97 = var95_95;
                                                                                                                                                                                if (v33 != null ? v33.equals(var97_97) == false : var97_97 != null) break block46;
                                                                                                                                                                                var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.STRING_TO_TIME.method), operandTerm}));
                                                                                                                                                                                    }
                                                                                                                                                                                });
                                                                                                                                                                                break block33;
                                                                                                                                                                            }
                                                                                                                                                                            if (var5_5 == null) break block47;
                                                                                                                                                                            var98_98 = (InternalType)var5_5._1();
                                                                                                                                                                            var99_99 = (InternalType)var5_5._2();
                                                                                                                                                                            v34 = DataTypes.STRING;
                                                                                                                                                                            var100_100 = var98_98;
                                                                                                                                                                            if (v34 != null ? v34.equals(var100_100) == false : var100_100 != null) break block47;
                                                                                                                                                                            v35 = DataTypes.TIMESTAMP;
                                                                                                                                                                            var101_101 = var99_99;
                                                                                                                                                                            if (v35 != null ? v35.equals(var101_101) == false : var101_101 != null) break block47;
                                                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, true, (Function1<String, String>)new Serializable(ctx){
                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                    String zoneTerm = this.ctx$2.addReusableTimeZone();
                                                                                                                                                                                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".toString(),\n             | ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP()), operandTerm, zoneTerm})))).stripMargin();
                                                                                                                                                                                }
                                                                                                                                                                                {
                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                }
                                                                                                                                                                            });
                                                                                                                                                                            break block33;
                                                                                                                                                                        }
                                                                                                                                                                        if (var5_5 == null) break block48;
                                                                                                                                                                        var102_102 = (InternalType)var5_5._1();
                                                                                                                                                                        var103_103 = (InternalType)var5_5._2();
                                                                                                                                                                        v36 = DataTypes.STRING;
                                                                                                                                                                        var104_104 = var102_102;
                                                                                                                                                                        if (v36 != null ? v36.equals(var104_104) == false : var104_104 != null) break block48;
                                                                                                                                                                        v37 = DataTypes.BYTE_ARRAY;
                                                                                                                                                                        var105_105 = var103_103;
                                                                                                                                                                        if (v37 != null ? v37.equals(var105_105) == false : var105_105 != null) break block48;
                                                                                                                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBytes()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                                                            }
                                                                                                                                                                        });
                                                                                                                                                                        break block33;
                                                                                                                                                                    }
                                                                                                                                                                    if (var5_5 == null) break block49;
                                                                                                                                                                    var106_106 = (InternalType)var5_5._1();
                                                                                                                                                                    dt = (InternalType)var5_5._2();
                                                                                                                                                                    v38 = DataTypes.BOOLEAN;
                                                                                                                                                                    var108_108 = var106_106;
                                                                                                                                                                    if ((v38 != null ? v38.equals(var108_108) == false : var108_108 != null) || !(dt instanceof DecimalType)) break block49;
                                                                                                                                                                    var109_109 = (DecimalType)dt;
                                                                                                                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(var109_109){
                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                        private final DecimalType x134$1;

                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castFrom(), operandTerm, BoxesRunTime.boxToInteger((int)this.x134$1.precision()), BoxesRunTime.boxToInteger((int)this.x134$1.scale())}));
                                                                                                                                                                        }
                                                                                                                                                                        {
                                                                                                                                                                            this.x134$1 = x134$1;
                                                                                                                                                                        }
                                                                                                                                                                    });
                                                                                                                                                                    break block33;
                                                                                                                                                                }
                                                                                                                                                                if (var5_5 == null) break block50;
                                                                                                                                                                var110_110 = (InternalType)var5_5._1();
                                                                                                                                                                v39 = DataTypes.BOOLEAN;
                                                                                                                                                                var111_111 = var110_110;
                                                                                                                                                                if ((v39 != null ? v39.equals(var111_111) == false : var111_111 != null) || !TypeCheckUtils$.MODULE$.isNumeric(targetType)) break block50;
                                                                                                                                                                targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                    private final String targetTypeTerm$1;

                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " ? 1 : 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$1, operandTerm}));
                                                                                                                                                                    }
                                                                                                                                                                    {
                                                                                                                                                                        this.targetTypeTerm$1 = targetTypeTerm$1;
                                                                                                                                                                    }
                                                                                                                                                                });
                                                                                                                                                                break block33;
                                                                                                                                                            }
                                                                                                                                                            if (var5_5 == null) break block51;
                                                                                                                                                            var113_113 = (InternalType)var5_5._2();
                                                                                                                                                            if (!(var5_5._1() instanceof DecimalType)) break block51;
                                                                                                                                                            v40 = DataTypes.BOOLEAN;
                                                                                                                                                            var114_114 = var113_113;
                                                                                                                                                            if (v40 != null ? v40.equals(var114_114) == false : var114_114 != null) break block51;
                                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(targetType){
                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                private final InternalType targetType$1;

                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castTo(this.targetType$1), operandTerm}));
                                                                                                                                                                }
                                                                                                                                                                {
                                                                                                                                                                    this.targetType$1 = targetType$1;
                                                                                                                                                                }
                                                                                                                                                            });
                                                                                                                                                            break block33;
                                                                                                                                                        }
                                                                                                                                                        if (var5_5 == null) break block52;
                                                                                                                                                        var115_115 = (InternalType)var5_5._2();
                                                                                                                                                        if (!(var5_5._1() instanceof DecimalType)) break block52;
                                                                                                                                                        v41 = DataTypes.TIMESTAMP;
                                                                                                                                                        var116_116 = var115_115;
                                                                                                                                                        if (v41 != null ? v41.equals(var116_116) == false : var116_116 != null) break block52;
                                                                                                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(targetType){
                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                            private final InternalType targetType$1;

                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castTo(this.targetType$1), operandTerm}));
                                                                                                                                                            }
                                                                                                                                                            {
                                                                                                                                                                this.targetType$1 = targetType$1;
                                                                                                                                                            }
                                                                                                                                                        });
                                                                                                                                                        break block33;
                                                                                                                                                    }
                                                                                                                                                    if (var5_5 == null) break block53;
                                                                                                                                                    left = (InternalType)var5_5._1();
                                                                                                                                                    var118_118 = (InternalType)var5_5._2();
                                                                                                                                                    v42 = DataTypes.BOOLEAN;
                                                                                                                                                    var119_119 = var118_118;
                                                                                                                                                    if ((v42 != null ? v42.equals(var119_119) == false : var119_119 != null) || !TypeCheckUtils$.MODULE$.isNumeric(left)) break block53;
                                                                                                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " != 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                                        }
                                                                                                                                                    });
                                                                                                                                                    break block33;
                                                                                                                                                }
                                                                                                                                                if (var5_5 == null) break block54;
                                                                                                                                                left = (InternalType)var5_5._1();
                                                                                                                                                right = (InternalType)var5_5._2();
                                                                                                                                                if (!TypeCheckUtils$.MODULE$.isNumeric(left) || !TypeCheckUtils$.MODULE$.isNumeric(right)) break block54;
                                                                                                                                                operandCasting = this.numericCasting(operand.resultType(), targetType);
                                                                                                                                                var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(operandCasting){
                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                    private final Function1 operandCasting$1;

                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.operandCasting$1.apply((Object)operandTerm)}));
                                                                                                                                                    }
                                                                                                                                                    {
                                                                                                                                                        this.operandCasting$1 = operandCasting$1;
                                                                                                                                                    }
                                                                                                                                                });
                                                                                                                                                break block33;
                                                                                                                                            }
                                                                                                                                            if (var5_5 == null) break block55;
                                                                                                                                            var123_123 = (InternalType)var5_5._1();
                                                                                                                                            var124_124 = (InternalType)var5_5._2();
                                                                                                                                            v43 = DataTypes.DATE;
                                                                                                                                            var125_125 = var123_123;
                                                                                                                                            if (v43 != null ? v43.equals(var125_125) == false : var125_125 != null) break block55;
                                                                                                                                            v44 = DataTypes.TIMESTAMP;
                                                                                                                                            var126_126 = var124_124;
                                                                                                                                            if (v44 != null ? v44.equals(var126_126) == false : var126_126 != null) break block55;
                                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * ", ".MILLIS_PER_DAY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm, DateTimeUtils.class.getCanonicalName()}));
                                                                                                                                                }
                                                                                                                                            });
                                                                                                                                            break block33;
                                                                                                                                        }
                                                                                                                                        if (var5_5 == null) break block56;
                                                                                                                                        var127_127 = (InternalType)var5_5._1();
                                                                                                                                        var128_128 = (InternalType)var5_5._2();
                                                                                                                                        v45 = DataTypes.TIMESTAMP;
                                                                                                                                        var129_129 = var127_127;
                                                                                                                                        if (v45 != null ? v45.equals(var129_129) == false : var129_129 != null) break block56;
                                                                                                                                        v46 = DataTypes.DATE;
                                                                                                                                        var130_130 = var128_128;
                                                                                                                                        if (v46 != null ? v46.equals(var130_130) == false : var130_130 != null) break block56;
                                                                                                                                        targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                            private final String targetTypeTerm$2;

                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " / "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$2, operandTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MILLIS_PER_DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils.class.getCanonicalName()}))).toString();
                                                                                                                                            }
                                                                                                                                            {
                                                                                                                                                this.targetTypeTerm$2 = targetTypeTerm$2;
                                                                                                                                            }
                                                                                                                                        });
                                                                                                                                        break block33;
                                                                                                                                    }
                                                                                                                                    if (var5_5 == null) break block57;
                                                                                                                                    var132_132 = (InternalType)var5_5._1();
                                                                                                                                    var133_133 = (InternalType)var5_5._2();
                                                                                                                                    v47 = DataTypes.TIME;
                                                                                                                                    var134_134 = var132_132;
                                                                                                                                    if (v47 != null ? v47.equals(var134_134) == false : var134_134 != null) break block57;
                                                                                                                                    v48 = DataTypes.TIMESTAMP;
                                                                                                                                    var135_135 = var133_133;
                                                                                                                                    if (v48 != null ? v48.equals(var135_135) == false : var135_135 != null) break block57;
                                                                                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                        }
                                                                                                                                    });
                                                                                                                                    break block33;
                                                                                                                                }
                                                                                                                                if (var5_5 == null) break block58;
                                                                                                                                var136_136 = (InternalType)var5_5._1();
                                                                                                                                var137_137 = (InternalType)var5_5._2();
                                                                                                                                v49 = DataTypes.TIMESTAMP;
                                                                                                                                var138_138 = var136_136;
                                                                                                                                if (v49 != null ? v49.equals(var138_138) == false : var138_138 != null) break block58;
                                                                                                                                v50 = DataTypes.TIME;
                                                                                                                                var139_139 = var137_137;
                                                                                                                                if (v50 != null ? v50.equals(var139_139) == false : var139_139 != null) break block58;
                                                                                                                                targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                    private final String targetTypeTerm$3;

                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " % "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$3, operandTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MILLIS_PER_DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils.class.getCanonicalName()}))).toString();
                                                                                                                                    }
                                                                                                                                    {
                                                                                                                                        this.targetTypeTerm$3 = targetTypeTerm$3;
                                                                                                                                    }
                                                                                                                                });
                                                                                                                                break block33;
                                                                                                                            }
                                                                                                                            if (var5_5 == null) break block59;
                                                                                                                            var141_141 = (InternalType)var5_5._1();
                                                                                                                            dt = (InternalType)var5_5._2();
                                                                                                                            v51 = DataTypes.TIMESTAMP;
                                                                                                                            var143_143 = var141_141;
                                                                                                                            if ((v51 != null ? v51.equals(var143_143) == false : var143_143 != null) || !(dt instanceof DecimalType)) break block59;
                                                                                                                            var144_144 = (DecimalType)dt;
                                                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(var144_144){
                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                private final DecimalType x150$1;

                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castFrom()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(((double) (", " / 1000.0)), ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm, BoxesRunTime.boxToInteger((int)this.x150$1.precision()), BoxesRunTime.boxToInteger((int)this.x150$1.scale())}))).toString();
                                                                                                                                }
                                                                                                                                {
                                                                                                                                    this.x150$1 = x150$1;
                                                                                                                                }
                                                                                                                            });
                                                                                                                            break block33;
                                                                                                                        }
                                                                                                                        if (var5_5 == null) break block60;
                                                                                                                        var145_145 = (InternalType)var5_5._1();
                                                                                                                        var146_146 = (InternalType)var5_5._2();
                                                                                                                        v52 = DataTypes.BYTE;
                                                                                                                        var147_147 = var145_145;
                                                                                                                        if (v52 != null ? v52.equals(var147_147) == false : var147_147 != null) break block60;
                                                                                                                        v53 = DataTypes.TIMESTAMP;
                                                                                                                        var148_148 = var146_146;
                                                                                                                        if (v53 != null ? v53.equals(var148_148) == false : var148_148 != null) break block60;
                                                                                                                        var149_149 = true;
                                                                                                                        break block61;
                                                                                                                    }
                                                                                                                    if (var5_5 == null) break block62;
                                                                                                                    var150_150 = (InternalType)var5_5._1();
                                                                                                                    var151_151 = (InternalType)var5_5._2();
                                                                                                                    v54 = DataTypes.SHORT;
                                                                                                                    var152_152 = var150_150;
                                                                                                                    if (v54 != null ? v54.equals(var152_152) == false : var152_152 != null) break block62;
                                                                                                                    v55 = DataTypes.TIMESTAMP;
                                                                                                                    var153_153 = var151_151;
                                                                                                                    if (v55 != null ? v55.equals(var153_153) == false : var153_153 != null) break block62;
                                                                                                                    var149_149 = true;
                                                                                                                    break block61;
                                                                                                                }
                                                                                                                if (var5_5 == null) break block63;
                                                                                                                var154_154 = (InternalType)var5_5._1();
                                                                                                                var155_155 = (InternalType)var5_5._2();
                                                                                                                v56 = DataTypes.INT;
                                                                                                                var156_156 = var154_154;
                                                                                                                if (v56 != null ? v56.equals(var156_156) == false : var156_156 != null) break block63;
                                                                                                                v57 = DataTypes.TIMESTAMP;
                                                                                                                var157_157 = var155_155;
                                                                                                                if (v57 != null ? v57.equals(var157_157) == false : var157_157 != null) break block63;
                                                                                                                var149_149 = true;
                                                                                                                break block61;
                                                                                                            }
                                                                                                            if (var5_5 == null) ** GOTO lbl-1000
                                                                                                            var158_158 = (InternalType)var5_5._1();
                                                                                                            var159_159 = (InternalType)var5_5._2();
                                                                                                            v58 = DataTypes.LONG;
                                                                                                            var160_160 = var158_158;
                                                                                                            if (v58 != null ? v58.equals(var160_160) == false : var160_160 != null) ** GOTO lbl-1000
                                                                                                            v59 = DataTypes.TIMESTAMP;
                                                                                                            var161_161 = var159_159;
                                                                                                            if (!(v59 != null ? v59.equals(var161_161) == false : var161_161 != null)) {
                                                                                                                var149_149 = true;
                                                                                                            } else lbl-1000:
                                                                                                            // 3 sources

                                                                                                            {
                                                                                                                var149_149 = false;
                                                                                                            }
                                                                                                        }
                                                                                                        if (!var149_149) break block64;
                                                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                            public final String apply(String operandTerm) {
                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(((long) ", ") * 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                            }
                                                                                                        });
                                                                                                        break block33;
                                                                                                    }
                                                                                                    if (var5_5 == null) break block65;
                                                                                                    var162_162 = (InternalType)var5_5._1();
                                                                                                    var163_163 = (InternalType)var5_5._2();
                                                                                                    v60 = DataTypes.FLOAT;
                                                                                                    var164_164 = var162_162;
                                                                                                    if (v60 != null ? v60.equals(var164_164) == false : var164_164 != null) break block65;
                                                                                                    v61 = DataTypes.TIMESTAMP;
                                                                                                    var165_165 = var163_163;
                                                                                                    if (v61 != null ? v61.equals(var165_165) == false : var165_165 != null) break block65;
                                                                                                    var166_166 = true;
                                                                                                    break block66;
                                                                                                }
                                                                                                if (var5_5 == null) ** GOTO lbl-1000
                                                                                                var167_167 = (InternalType)var5_5._1();
                                                                                                var168_168 = (InternalType)var5_5._2();
                                                                                                v62 = DataTypes.DOUBLE;
                                                                                                var169_169 = var167_167;
                                                                                                if (v62 != null ? v62.equals(var169_169) == false : var169_169 != null) ** GOTO lbl-1000
                                                                                                v63 = DataTypes.TIMESTAMP;
                                                                                                var170_170 = var168_168;
                                                                                                if (!(v63 != null ? v63.equals(var170_170) == false : var170_170 != null)) {
                                                                                                    var166_166 = true;
                                                                                                } else lbl-1000:
                                                                                                // 3 sources

                                                                                                {
                                                                                                    var166_166 = false;
                                                                                                }
                                                                                            }
                                                                                            if (!var166_166) break block67;
                                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                                public static final long serialVersionUID = 0L;

                                                                                                public final String apply(String operandTerm) {
                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((long) (", " * 1000))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                }
                                                                                            });
                                                                                            break block33;
                                                                                        }
                                                                                        if (var5_5 == null) break block68;
                                                                                        var171_171 = (InternalType)var5_5._1();
                                                                                        var172_172 = (InternalType)var5_5._2();
                                                                                        v64 = DataTypes.TIMESTAMP;
                                                                                        var173_173 = var171_171;
                                                                                        if (v64 != null ? v64.equals(var173_173) == false : var173_173 != null) break block68;
                                                                                        v65 = DataTypes.BYTE;
                                                                                        var174_174 = var172_172;
                                                                                        if (v65 != null ? v65.equals(var174_174) == false : var174_174 != null) break block68;
                                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final String apply(String operandTerm) {
                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((byte) (", " / 1000))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                            }
                                                                                        });
                                                                                        break block33;
                                                                                    }
                                                                                    if (var5_5 == null) break block69;
                                                                                    var175_175 = (InternalType)var5_5._1();
                                                                                    var176_176 = (InternalType)var5_5._2();
                                                                                    v66 = DataTypes.TIMESTAMP;
                                                                                    var177_177 = var175_175;
                                                                                    if (v66 != null ? v66.equals(var177_177) == false : var177_177 != null) break block69;
                                                                                    v67 = DataTypes.SHORT;
                                                                                    var178_178 = var176_176;
                                                                                    if (v67 != null ? v67.equals(var178_178) == false : var178_178 != null) break block69;
                                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                        public static final long serialVersionUID = 0L;

                                                                                        public final String apply(String operandTerm) {
                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((short) (", " / 1000))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                        }
                                                                                    });
                                                                                    break block33;
                                                                                }
                                                                                if (var5_5 == null) break block70;
                                                                                var179_179 = (InternalType)var5_5._1();
                                                                                var180_180 = (InternalType)var5_5._2();
                                                                                v68 = DataTypes.TIMESTAMP;
                                                                                var181_181 = var179_179;
                                                                                if (v68 != null ? v68.equals(var181_181) == false : var181_181 != null) break block70;
                                                                                v69 = DataTypes.INT;
                                                                                var182_182 = var180_180;
                                                                                if (v69 != null ? v69.equals(var182_182) == false : var182_182 != null) break block70;
                                                                                var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                    public static final long serialVersionUID = 0L;

                                                                                    public final String apply(String operandTerm) {
                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((int) (", " / 1000))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                    }
                                                                                });
                                                                                break block33;
                                                                            }
                                                                            if (var5_5 == null) break block71;
                                                                            var183_183 = (InternalType)var5_5._1();
                                                                            var184_184 = (InternalType)var5_5._2();
                                                                            v70 = DataTypes.TIMESTAMP;
                                                                            var185_185 = var183_183;
                                                                            if (v70 != null ? v70.equals(var185_185) == false : var185_185 != null) break block71;
                                                                            v71 = DataTypes.LONG;
                                                                            var186_186 = var184_184;
                                                                            if (v71 != null ? v71.equals(var186_186) == false : var186_186 != null) break block71;
                                                                            var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final String apply(String operandTerm) {
                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((long) (", " / 1000))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                }
                                                                            });
                                                                            break block33;
                                                                        }
                                                                        if (var5_5 == null) break block72;
                                                                        var187_187 = (InternalType)var5_5._1();
                                                                        var188_188 = (InternalType)var5_5._2();
                                                                        v72 = DataTypes.TIMESTAMP;
                                                                        var189_189 = var187_187;
                                                                        if (v72 != null ? v72.equals(var189_189) == false : var189_189 != null) break block72;
                                                                        v73 = DataTypes.FLOAT;
                                                                        var190_190 = var188_188;
                                                                        if (v73 != null ? v73.equals(var190_190) == false : var190_190 != null) break block72;
                                                                        var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                            public static final long serialVersionUID = 0L;

                                                                            public final String apply(String operandTerm) {
                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((float) (", " / 1000.0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                            }
                                                                        });
                                                                        break block33;
                                                                    }
                                                                    if (var5_5 == null) break block73;
                                                                    var191_191 = (InternalType)var5_5._1();
                                                                    var192_192 = (InternalType)var5_5._2();
                                                                    v74 = DataTypes.TIMESTAMP;
                                                                    var193_193 = var191_191;
                                                                    if (v74 != null ? v74.equals(var193_193) == false : var193_193 != null) break block73;
                                                                    v75 = DataTypes.DOUBLE;
                                                                    var194_194 = var192_192;
                                                                    if (v75 != null ? v75.equals(var194_194) == false : var194_194 != null) break block73;
                                                                    var32_32 = CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, targetType, operand, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final String apply(String operandTerm) {
                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((double) (", " / 1000.0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                        }
                                                                    });
                                                                    break block33;
                                                                }
                                                                if (var5_5 == null) break block74;
                                                                var195_195 = (InternalType)var5_5._1();
                                                                var196_196 = (InternalType)var5_5._2();
                                                                v76 = DataTypes.DATE;
                                                                var197_197 = var195_195;
                                                                if (v76 != null ? v76.equals(var197_197) == false : var197_197 != null) break block74;
                                                                v77 = DataTypes.INT;
                                                                var198_198 = var196_196;
                                                                if (v77 != null ? v77.equals(var198_198) == false : var198_198 != null) break block74;
                                                                var199_199 = true;
                                                                break block75;
                                                            }
                                                            if (var5_5 == null) break block76;
                                                            var200_200 = (InternalType)var5_5._1();
                                                            var201_201 = (InternalType)var5_5._2();
                                                            v78 = DataTypes.TIME;
                                                            var202_202 = var200_200;
                                                            if (v78 != null ? v78.equals(var202_202) == false : var202_202 != null) break block76;
                                                            v79 = DataTypes.INT;
                                                            var203_203 = var201_201;
                                                            if (v79 != null ? v79.equals(var203_203) == false : var203_203 != null) break block76;
                                                            var199_199 = true;
                                                            break block75;
                                                        }
                                                        if (var5_5 == null) break block77;
                                                        var204_204 = (InternalType)var5_5._1();
                                                        var205_205 = (InternalType)var5_5._2();
                                                        v80 = DataTypes.INT;
                                                        var206_206 = var204_204;
                                                        if (v80 != null ? v80.equals(var206_206) == false : var206_206 != null) break block77;
                                                        v81 = DataTypes.DATE;
                                                        var207_207 = var205_205;
                                                        if (v81 != null ? v81.equals(var207_207) == false : var207_207 != null) break block77;
                                                        var199_199 = true;
                                                        break block75;
                                                    }
                                                    if (var5_5 == null) break block78;
                                                    var208_208 = (InternalType)var5_5._1();
                                                    var209_209 = (InternalType)var5_5._2();
                                                    v82 = DataTypes.INT;
                                                    var210_210 = var208_208;
                                                    if (v82 != null ? v82.equals(var210_210) == false : var210_210 != null) break block78;
                                                    v83 = DataTypes.TIME;
                                                    var211_211 = var209_209;
                                                    if (v83 != null ? v83.equals(var211_211) == false : var211_211 != null) break block78;
                                                    var199_199 = true;
                                                    break block75;
                                                }
                                                if (var5_5 == null) break block79;
                                                var212_212 = (InternalType)var5_5._1();
                                                var213_213 = (InternalType)var5_5._2();
                                                v84 = DataTypes.INT;
                                                var214_214 = var212_212;
                                                if (v84 != null ? v84.equals(var214_214) == false : var214_214 != null) break block79;
                                                v85 = DataTypes.INTERVAL_MONTHS;
                                                var215_215 = var213_213;
                                                if (v85 != null ? v85.equals(var215_215) == false : var215_215 != null) break block79;
                                                var199_199 = true;
                                                break block75;
                                            }
                                            if (var5_5 == null) break block80;
                                            var216_216 = (InternalType)var5_5._1();
                                            var217_217 = (InternalType)var5_5._2();
                                            v86 = DataTypes.LONG;
                                            var218_218 = var216_216;
                                            if (v86 != null ? v86.equals(var218_218) == false : var218_218 != null) break block80;
                                            v87 = DataTypes.INTERVAL_MILLIS;
                                            var219_219 = var217_217;
                                            if (v87 != null ? v87.equals(var219_219) == false : var219_219 != null) break block80;
                                            var199_199 = true;
                                            break block75;
                                        }
                                        if (var5_5 == null) break block81;
                                        var220_220 = (InternalType)var5_5._1();
                                        var221_221 = (InternalType)var5_5._2();
                                        v88 = DataTypes.INTERVAL_MONTHS;
                                        var222_222 = var220_220;
                                        if (v88 != null ? v88.equals(var222_222) == false : var222_222 != null) break block81;
                                        v89 = DataTypes.INT;
                                        var223_223 = var221_221;
                                        if (v89 != null ? v89.equals(var223_223) == false : var223_223 != null) break block81;
                                        var199_199 = true;
                                        break block75;
                                    }
                                    if (var5_5 == null) ** GOTO lbl-1000
                                    var224_224 = (InternalType)var5_5._1();
                                    var225_225 = (InternalType)var5_5._2();
                                    v90 = DataTypes.INTERVAL_MILLIS;
                                    var226_226 = var224_224;
                                    if (v90 != null ? v90.equals(var226_226) == false : var226_226 != null) ** GOTO lbl-1000
                                    v91 = DataTypes.LONG;
                                    var227_227 = var225_225;
                                    if (!(v91 != null ? v91.equals(var227_227) == false : var227_227 != null)) {
                                        var199_199 = true;
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        var199_199 = false;
                                    }
                                }
                                if (!var199_199) break block82;
                                var32_32 = this.internalExprCasting(operand, targetType);
                                break block33;
                            }
                            if (var5_5 == null) break block83;
                            var228_228 = (InternalType)var5_5._1();
                            var229_229 = (InternalType)var5_5._2();
                            v92 = DataTypes.DATE;
                            var230_230 = var228_228;
                            if (v92 != null ? v92.equals(var230_230) == false : var230_230 != null) break block83;
                            v93 = DataTypes.LONG;
                            var231_231 = var229_229;
                            if (v93 != null ? v93.equals(var231_231) == false : var231_231 != null) break block83;
                            var232_232 = true;
                            break block84;
                        }
                        if (var5_5 == null) break block85;
                        var233_233 = (InternalType)var5_5._1();
                        var234_234 = (InternalType)var5_5._2();
                        v94 = DataTypes.TIME;
                        var235_235 = var233_233;
                        if (v94 != null ? v94.equals(var235_235) == false : var235_235 != null) break block85;
                        v95 = DataTypes.LONG;
                        var236_236 = var234_234;
                        if (v95 != null ? v95.equals(var236_236) == false : var236_236 != null) break block85;
                        var232_232 = true;
                        break block84;
                    }
                    if (var5_5 == null) ** GOTO lbl-1000
                    var237_237 = (InternalType)var5_5._1();
                    var238_238 = (InternalType)var5_5._2();
                    v96 = DataTypes.INTERVAL_MONTHS;
                    var239_239 = var237_237;
                    if (v96 != null ? v96.equals(var239_239) == false : var239_239 != null) ** GOTO lbl-1000
                    v97 = DataTypes.LONG;
                    var240_240 = var238_238;
                    if (!(v97 != null ? v97.equals(var240_240) == false : var240_240 != null)) {
                        var232_232 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        var232_232 = false;
                    }
                }
                if (!var232_232) break block86;
                var32_32 = this.internalExprCasting(operand, targetType);
            }
            return var32_32;
        }
        if (var5_5 != null) {
            from = (InternalType)var5_5._1();
            to = (InternalType)var5_5._2();
            throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported cast from '", "' to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        }
        throw new MatchError((Object)var5_5);
    }

    public GeneratedExpression generateCastArrayToString(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand, ArrayType at) {
        return CallGenerator$.MODULE$.generateReturnStringCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, nullCheck, at){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$8;
            private final boolean nullCheck$7;
            private final ArrayType at$1;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String builderCls = StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$8.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})), this.ctx$8.addReusableMember$default$2());
                String arrayTerm = (String)terms.head();
                String indexTerm = CodeGenUtils$.MODULE$.newName("i");
                String numTerm = CodeGenUtils$.MODULE$.newName("num");
                InternalType elementType = this.at$1.getElementInternalType();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                String elementNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String elementCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elementCls, elementTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType), elementNullTerm, arrayTerm, indexTerm, elementNullTerm, elementTerm, elementCls, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.ctx$8, indexTerm, arrayTerm, elementType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5())})))).stripMargin();
                GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, elementNullTerm, elementCode, elementType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                GeneratedExpression castExpr = ScalarOperators$.MODULE$.generateCast(this.ctx$8, this.nullCheck$7, elementExpr, DataTypes.STRING);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", ".setLength(0);\n             |", ".append(\"[\");\n             |int ", " = ", ".numElements();\n             |for (int ", " = 0; ", " < ", "; ", "++) {\n             |  if (", " != 0) {\n             |    ", ".append(\", \");\n             |  }\n             |\n             |  ", "\n             |  if (", ") {\n             |    ", ".append(\"null\");\n             |  } else {\n             |    ", ".append(", ");\n             |  }\n             |}\n             |", ".append(\"]\");\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm, builderTerm, numTerm, arrayTerm, indexTerm, indexTerm, numTerm, indexTerm, indexTerm, builderTerm, castExpr.code(), castExpr.nullTerm(), builderTerm, builderTerm, castExpr.resultTerm(), builderTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toString()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm})));
            }
            {
                this.ctx$8 = ctx$8;
                this.nullCheck$7 = nullCheck$7;
                this.at$1 = at$1;
            }
        });
    }

    public GeneratedExpression generateCastMapToString(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand, MapType mt) {
        return CallGenerator$.MODULE$.generateReturnStringCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, nullCheck, mt){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$9;
            private final boolean nullCheck$8;
            private final MapType mt$1;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String resultTerm = CodeGenUtils$.MODULE$.newName("toStringResult");
                String builderCls = StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$9.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})), this.ctx$9.addReusableMember$default$2());
                String mapTerm = (String)terms.head();
                String genericMapCls = GenericMap.class.getCanonicalName();
                String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
                String binaryMapCls = BinaryMap.class.getCanonicalName();
                String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
                String arrayCls = BinaryArray.class.getCanonicalName();
                String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
                String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
                String indexTerm = CodeGenUtils$.MODULE$.newName("i");
                String numTerm = CodeGenUtils$.MODULE$.newName("num");
                InternalType keyType = this.mt$1.getKeyInternalType();
                String keyCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
                String keyTerm = CodeGenUtils$.MODULE$.newName("key");
                String keyNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String keyCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyCls, keyTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(keyType), keyNullTerm, keyArrayTerm, indexTerm, keyNullTerm, keyTerm, keyCls, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.ctx$9, indexTerm, keyArrayTerm, keyType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5())})))).stripMargin();
                GeneratedExpression keyExpr = new GeneratedExpression(keyTerm, keyNullTerm, keyCode, keyType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                GeneratedExpression keyCastExpr = ScalarOperators$.MODULE$.generateCast(this.ctx$9, this.nullCheck$8, keyExpr, DataTypes.STRING);
                InternalType valueType = this.mt$1.getValueInternalType();
                String valueCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
                String valueTerm = CodeGenUtils$.MODULE$.newName("value");
                String valueNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String valueCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{valueCls, valueTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType), valueNullTerm, valueArrayTerm, indexTerm, valueNullTerm, valueTerm, valueCls, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.ctx$9, indexTerm, valueArrayTerm, valueType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5())})))).stripMargin();
                GeneratedExpression valueExpr = new GeneratedExpression(valueTerm, valueNullTerm, valueCode, valueType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                GeneratedExpression valueCastExpr = ScalarOperators$.MODULE$.generateCast(this.ctx$9, this.nullCheck$8, valueExpr, DataTypes.STRING);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |String ", ";\n             |if (", " instanceof ", ") {\n             |  ", " ", " = (", ") ", ";\n             |\n             |  ", " ", " = ", ".keyArray();\n             |  ", " ", " = ", ".valueArray();\n             |\n             |  ", ".setLength(0);\n             |  ", ".append(\"{\");\n             |\n             |  int ", " = ", ".numElements();\n             |  for (int ", " = 0; ", " < ", "; ", "++) {\n             |    if (", " != 0) {\n             |      ", ".append(\", \");\n             |    }\n             |\n             |    ", "\n             |    if (", ") {\n             |      ", ".append(\"null\");\n             |    } else {\n             |      ", ".append(", ");\n             |    }\n             |    ", ".append(\"=\");\n             |\n             |    ", "\n             |    if (", ") {\n             |      ", ".append(\"null\");\n             |    } else {\n             |      ", ".append(", ");\n             |    }\n             |  }\n             |  ", ".append(\"}\");\n             |\n             |  ", " = ", ".toString();\n             |} else {\n             |  ", " ", " = (", ") ", ";\n             |  ", " = ", ".toString();\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, mapTerm, binaryMapCls, binaryMapCls, binaryMapTerm, binaryMapCls, mapTerm, arrayCls, keyArrayTerm, binaryMapTerm, arrayCls, valueArrayTerm, binaryMapTerm, builderTerm, builderTerm, numTerm, binaryMapTerm, indexTerm, indexTerm, numTerm, indexTerm, indexTerm, builderTerm, keyCastExpr.code(), keyCastExpr.nullTerm(), builderTerm, builderTerm, keyCastExpr.resultTerm(), builderTerm, valueCastExpr.code(), valueCastExpr.nullTerm(), builderTerm, builderTerm, valueCastExpr.resultTerm(), builderTerm, resultTerm, builderTerm, genericMapCls, genericMapTerm, genericMapCls, mapTerm, resultTerm, genericMapTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$9 = ctx$9;
                this.nullCheck$8 = nullCheck$8;
                this.mt$1 = mt$1;
            }
        });
    }

    public GeneratedExpression generateBaseRowToString(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression operand, RowType brt) {
        return CallGenerator$.MODULE$.generateReturnStringCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, nullCheck, brt){
            public static final long serialVersionUID = 0L;
            public final CodeGeneratorContext ctx$10;
            public final boolean nullCheck$9;
            private final RowType brt$1;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String builderCls = StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$10.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})), this.ctx$10.addReusableMember$default$2());
                String rowTerm = (String)terms.head();
                String appendCode = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.brt$1.getFieldTypes()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalType apply(DataType x$6) {
                        return x$6.toInternalType();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, builderTerm, rowTerm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateBaseRowToString.1 $outer;
                    private final String builderTerm$1;
                    private final String rowTerm$1;

                    public final String apply(Tuple2<InternalType, Object> x0$1) {
                        Tuple2<InternalType, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            InternalType elementType = (InternalType)tuple2._1();
                            int idx = tuple2._2$mcI$sp();
                            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                            String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                            GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rowTerm$1, BoxesRunTime.boxToInteger((int)idx)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = (", ") ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elementCls, elementTerm, elementCls, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(this.$outer.ctx$10, idx, this.rowTerm$1, elementType)})), elementType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                            GeneratedExpression castExpr = ScalarOperators$.MODULE$.generateCast(this.$outer.ctx$10, this.$outer.nullCheck$9, elementExpr, DataTypes.STRING);
                            String string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |", "\n               |if (", ") {\n               |  ", ".append(\"null\");\n               |} else {\n               |  ", ".append(", ");\n               |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idx != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".append(\",\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.builderTerm$1})) : "", castExpr.code(), castExpr.nullTerm(), this.builderTerm$1, this.builderTerm$1, castExpr.resultTerm()})))).stripMargin();
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builderTerm$1 = builderTerm$1;
                        this.rowTerm$1 = rowTerm$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", ".setLength(0);\n             |", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm, appendCode})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toString()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm})));
            }
            {
                this.ctx$10 = ctx$10;
                this.nullCheck$9 = nullCheck$9;
                this.brt$1 = brt$1;
            }
        });
    }

    public GeneratedExpression generateIfElse(CodeGeneratorContext ctx, boolean nullCheck, Seq<GeneratedExpression> operands, InternalType resultType2, int i) {
        Seq<String> seq;
        block4: {
            GeneratedExpression generatedExpression;
            block3: {
                Tuple2 tuple2;
                block2: {
                    if (i != operands.size() - 1) break block2;
                    generatedExpression = this.generateCast(ctx, nullCheck, (GeneratedExpression)operands.apply(i), resultType2);
                    break block3;
                }
                CodeGenUtils$.MODULE$.requireBoolean((GeneratedExpression)operands.apply(i), "CASE");
                GeneratedExpression condition = (GeneratedExpression)operands.apply(i);
                GeneratedExpression trueAction = this.generateCast(ctx, nullCheck, (GeneratedExpression)operands.apply(i + 1), resultType2);
                GeneratedExpression falseAction = this.generateIfElse(ctx, nullCheck, operands, resultType2, i + 2);
                seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block4;
                String resultTerm = (String)((SeqLike)some.get()).apply(0);
                String nullTerm = (String)((SeqLike)some.get()).apply(1);
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                String resultTerm2 = (String)tuple22._1();
                String nullTerm2 = (String)tuple22._2();
                String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
                String operatorCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |", " ", ";\n          |boolean ", ";\n          |if (", ") {\n          |  ", "\n          |  ", " = ", ";\n          |  ", " = ", ";\n          |}\n          |else {\n          |  ", "\n          |  ", " = ", ";\n          |  ", " = ", ";\n          |}\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), resultTypeTerm, resultTerm2, nullTerm2, condition.resultTerm(), trueAction.code(), resultTerm2, trueAction.resultTerm(), nullTerm2, trueAction.nullTerm(), falseAction.code(), resultTerm2, falseAction.resultTerm(), nullTerm2, falseAction.nullTerm()})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |", " ", ";\n          |if (", ") {\n          |  ", "\n          |  ", " = ", ";\n          |}\n          |else {\n          |  ", "\n          |  ", " = ", ";\n          |}\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), resultTypeTerm, resultTerm2, condition.resultTerm(), trueAction.code(), resultTerm2, trueAction.resultTerm(), falseAction.code(), resultTerm2, falseAction.resultTerm()})))).stripMargin().trim();
                generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
            }
            return generatedExpression;
        }
        throw new MatchError(seq);
    }

    public int generateIfElse$default$5() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateTemporalPlusMinus(CodeGeneratorContext ctx, boolean plus, boolean nullCheck, InternalType resultType, GeneratedExpression left, GeneratedExpression right) {
        block22: {
            block25: {
                block16: {
                    block24: {
                        block23: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block15: {
                                                    block14: {
                                                        block13: {
                                                            op = plus != false ? "+" : "-";
                                                            var8_8 = new Tuple2((Object)left.resultType(), (Object)right.resultType());
                                                            if (var8_8 == null) break block13;
                                                            var9_9 = (InternalType)var8_8._1();
                                                            var10_10 = (InternalType)var8_8._2();
                                                            v0 = DataTypes.INTERVAL_MONTHS;
                                                            var11_11 = var9_9;
                                                            if (v0 != null ? v0.equals(var11_11) == false : var11_11 != null) break block13;
                                                            v1 = DataTypes.INTERVAL_MONTHS;
                                                            var12_12 = var10_10;
                                                            if (v1 != null ? v1.equals(var12_12) == false : var12_12 != null) break block13;
                                                            var13_13 = true;
                                                            break block14;
                                                        }
                                                        if (var8_8 == null) ** GOTO lbl-1000
                                                        var14_14 = (InternalType)var8_8._1();
                                                        var15_15 = (InternalType)var8_8._2();
                                                        v2 = DataTypes.INTERVAL_MILLIS;
                                                        var16_16 = var14_14;
                                                        if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) ** GOTO lbl-1000
                                                        v3 = DataTypes.INTERVAL_MILLIS;
                                                        var17_17 = var15_15;
                                                        if (!(v3 != null ? v3.equals(var17_17) == false : var17_17 != null)) {
                                                            var13_13 = true;
                                                        } else lbl-1000:
                                                        // 3 sources

                                                        {
                                                            var13_13 = false;
                                                        }
                                                    }
                                                    if (!var13_13) break block15;
                                                    var18_18 = this.generateArithmeticOperator(ctx, op, nullCheck, left.resultType(), left, right);
                                                    break block16;
                                                }
                                                if (var8_8 == null) break block17;
                                                var19_19 = (InternalType)var8_8._1();
                                                var20_20 = (InternalType)var8_8._2();
                                                v4 = DataTypes.DATE;
                                                var21_21 = var19_19;
                                                if (v4 != null ? v4.equals(var21_21) == false : var21_21 != null) break block17;
                                                v5 = DataTypes.INTERVAL_MILLIS;
                                                var22_22 = var20_20;
                                                if (v5 != null ? v5.equals(var22_22) == false : var22_22 != null) break block17;
                                                var18_18 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.DATE, left, right, (Function2<String, String, String>)new Serializable(op){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String op$1;

                                                    public final String apply(String l, String r) {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ((int) (", " / ", "L))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, this.op$1, r, BoxesRunTime.boxToLong((long)86400000L)}));
                                                    }
                                                    {
                                                        this.op$1 = op$1;
                                                    }
                                                });
                                                break block16;
                                            }
                                            if (var8_8 == null) break block18;
                                            var23_23 = (InternalType)var8_8._1();
                                            var24_24 = (InternalType)var8_8._2();
                                            v6 = DataTypes.DATE;
                                            var25_25 = var23_23;
                                            if (v6 != null ? v6.equals(var25_25) == false : var25_25 != null) break block18;
                                            v7 = DataTypes.INTERVAL_MONTHS;
                                            var26_26 = var24_24;
                                            if (v7 != null ? v7.equals(var26_26) == false : var26_26 != null) break block18;
                                            var18_18 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.DATE, left, right, (Function2<String, String, String>)new Serializable(op){
                                                public static final long serialVersionUID = 0L;
                                                private final String op$1;

                                                public final String apply(String l, String r) {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", "(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.ADD_MONTHS.method), l, this.op$1, r}));
                                                }
                                                {
                                                    this.op$1 = op$1;
                                                }
                                            });
                                            break block16;
                                        }
                                        if (var8_8 == null) break block19;
                                        var27_27 = (InternalType)var8_8._1();
                                        var28_28 = (InternalType)var8_8._2();
                                        v8 = DataTypes.TIME;
                                        var29_29 = var27_27;
                                        if (v8 != null ? v8.equals(var29_29) == false : var29_29 != null) break block19;
                                        v9 = DataTypes.INTERVAL_MILLIS;
                                        var30_30 = var28_28;
                                        if (v9 != null ? v9.equals(var30_30) == false : var30_30 != null) break block19;
                                        var18_18 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.TIME, left, right, (Function2<String, String, String>)new Serializable(op){
                                            public static final long serialVersionUID = 0L;
                                            private final String op$1;

                                            public final String apply(String l, String r) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ((int) (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, this.op$1, r}));
                                            }
                                            {
                                                this.op$1 = op$1;
                                            }
                                        });
                                        break block16;
                                    }
                                    if (var8_8 == null) break block20;
                                    var31_31 = (InternalType)var8_8._1();
                                    var32_32 = (InternalType)var8_8._2();
                                    v10 = DataTypes.TIMESTAMP;
                                    var33_33 = var31_31;
                                    if (v10 != null ? v10.equals(var33_33) == false : var33_33 != null) break block20;
                                    v11 = DataTypes.INTERVAL_MILLIS;
                                    var34_34 = var32_32;
                                    if (v11 != null ? v11.equals(var34_34) == false : var34_34 != null) break block20;
                                    var18_18 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.TIMESTAMP, left, right, (Function2<String, String, String>)new Serializable(op){
                                        public static final long serialVersionUID = 0L;
                                        private final String op$1;

                                        public final String apply(String l, String r) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, this.op$1, r}));
                                        }
                                        {
                                            this.op$1 = op$1;
                                        }
                                    });
                                    break block16;
                                }
                                if (var8_8 == null) break block21;
                                var35_35 = (InternalType)var8_8._1();
                                var36_36 = (InternalType)var8_8._2();
                                v12 = DataTypes.TIMESTAMP;
                                var37_37 = var35_35;
                                if (v12 != null ? v12.equals(var37_37) == false : var37_37 != null) break block21;
                                v13 = DataTypes.INTERVAL_MONTHS;
                                var38_38 = var36_36;
                                if (v13 != null ? v13.equals(var38_38) == false : var38_38 != null) break block21;
                                var18_18 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, DataTypes.TIMESTAMP, left, right, (Function2<String, String, String>)new Serializable(op){
                                    public static final long serialVersionUID = 0L;
                                    private final String op$1;

                                    public final String apply(String l, String r) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", "(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.ADD_MONTHS.method), l, this.op$1, r}));
                                    }
                                    {
                                        this.op$1 = op$1;
                                    }
                                });
                                break block16;
                            }
                            if (var8_8 == null) break block22;
                            var39_39 = (InternalType)var8_8._1();
                            var40_40 = (InternalType)var8_8._2();
                            v14 = DataTypes.TIMESTAMP;
                            var41_41 = var39_39;
                            if (!(v14 != null ? v14.equals(var41_41) == false : var41_41 != null)) {
                                var42_42 = true;
                            } else {
                                v15 = DataTypes.TIME;
                                var43_43 = var39_39;
                                if (!(v15 != null ? v15.equals(var43_43) == false : var43_43 != null)) {
                                    var42_42 = true;
                                } else {
                                    v16 = DataTypes.DATE;
                                    var44_44 = var39_39;
                                    var42_42 = !(v16 != null ? v16.equals(var44_44) == false : var44_44 != null);
                                }
                            }
                            if (!var42_42) break block22;
                            v17 = DataTypes.TIMESTAMP;
                            var45_45 = var40_40;
                            if (!(v17 != null ? v17.equals(var45_45) == false : var45_45 != null)) {
                                var46_46 = true;
                            } else {
                                v18 = DataTypes.TIME;
                                var47_47 = var40_40;
                                if (!(v18 != null ? v18.equals(var47_47) == false : var47_47 != null)) {
                                    var46_46 = true;
                                } else {
                                    v19 = DataTypes.DATE;
                                    var48_48 = var40_40;
                                    var46_46 = !(v19 != null ? v19.equals(var48_48) == false : var48_48 != null);
                                }
                            }
                            if (!var46_46 || plus) break block22;
                            var49_49 = resultType;
                            v20 = DataTypes.INTERVAL_MONTHS;
                            var50_50 = var49_49;
                            if (v20 != null ? v20.equals(var50_50) == false : var50_50 != null) break block23;
                            var51_51 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, resultType, left, right, (Function2<String, String, String>)new Serializable(left, right){
                                public static final long serialVersionUID = 0L;
                                private final GeneratedExpression left$1;
                                private final GeneratedExpression right$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final String apply(String ll, String rr) {
                                    Tuple2 tuple2 = new Tuple2((Object)this.left$1.resultType(), (Object)this.right$1.resultType());
                                    if (tuple2 != null) {
                                        InternalType internalType = (InternalType)tuple2._1();
                                        InternalType internalType2 = (InternalType)tuple2._2();
                                        TimestampType timestampType = DataTypes.TIMESTAMP;
                                        InternalType internalType3 = internalType;
                                        if (!(timestampType != null ? !((Object)timestampType).equals(internalType3) : internalType3 != null)) {
                                            DateType dateType = DataTypes.DATE;
                                            InternalType internalType4 = internalType2;
                                            if (!(dateType != null ? !((Object)dateType).equals(internalType4) : internalType4 != null)) {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, rr, BoxesRunTime.boxToLong((long)86400000L)}))).toString();
                                            }
                                        }
                                    }
                                    if (tuple2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method), ll, rr}));
                                    InternalType internalType = (InternalType)tuple2._1();
                                    InternalType internalType5 = (InternalType)tuple2._2();
                                    DateType dateType = DataTypes.DATE;
                                    InternalType internalType6 = internalType;
                                    if (dateType != null ? !((Object)dateType).equals(internalType6) : internalType6 != null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method), ll, rr}));
                                    TimestampType timestampType = DataTypes.TIMESTAMP;
                                    InternalType internalType7 = internalType5;
                                    if (timestampType != null ? !((Object)timestampType).equals(internalType7) : internalType7 != null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method), ll, rr}));
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), rr}))).toString();
                                }
                                {
                                    this.left$1 = left$1;
                                    this.right$1 = right$1;
                                }
                            });
                            break block24;
                        }
                        v21 = DataTypes.INTERVAL_MILLIS;
                        var52_52 = var49_49;
                        if (v21 != null ? v21.equals(var52_52) == false : var52_52 != null) break block25;
                        var51_51 = CallGenerator$.MODULE$.generateOperatorIfNotNull(ctx, nullCheck, resultType, left, right, (Function2<String, String, String>)new Serializable(left, right, op){
                            public static final long serialVersionUID = 0L;
                            private final GeneratedExpression left$1;
                            private final GeneratedExpression right$1;
                            private final String op$1;

                            public final String apply(String ll, String rr) {
                                Tuple2 tuple2;
                                block6: {
                                    String string;
                                    block3: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    tuple2 = new Tuple2((Object)this.left$1.resultType(), (Object)this.right$1.resultType());
                                                    if (tuple2 == null) break block2;
                                                    InternalType internalType = (InternalType)tuple2._1();
                                                    InternalType internalType2 = (InternalType)tuple2._2();
                                                    TimestampType timestampType = DataTypes.TIMESTAMP;
                                                    InternalType internalType3 = internalType;
                                                    if (timestampType != null ? !((Object)timestampType).equals(internalType3) : internalType3 != null) break block2;
                                                    TimestampType timestampType2 = DataTypes.TIMESTAMP;
                                                    InternalType internalType4 = internalType2;
                                                    if (timestampType2 != null ? !((Object)timestampType2).equals(internalType4) : internalType4 != null) break block2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, this.op$1, rr}));
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block4;
                                                InternalType internalType = (InternalType)tuple2._1();
                                                InternalType internalType5 = (InternalType)tuple2._2();
                                                DateType dateType = DataTypes.DATE;
                                                InternalType internalType6 = internalType;
                                                if (dateType != null ? !((Object)dateType).equals(internalType6) : internalType6 != null) break block4;
                                                DateType dateType2 = DataTypes.DATE;
                                                InternalType internalType7 = internalType5;
                                                if (dateType2 != null ? !((Object)dateType2).equals(internalType7) : internalType7 != null) break block4;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L) ", " (", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), this.op$1, rr, BoxesRunTime.boxToLong((long)86400000L)}));
                                                break block3;
                                            }
                                            if (tuple2 == null) break block5;
                                            InternalType internalType = (InternalType)tuple2._1();
                                            InternalType internalType8 = (InternalType)tuple2._2();
                                            TimestampType timestampType = DataTypes.TIMESTAMP;
                                            InternalType internalType9 = internalType;
                                            if (timestampType != null ? !((Object)timestampType).equals(internalType9) : internalType9 != null) break block5;
                                            DateType dateType = DataTypes.DATE;
                                            InternalType internalType10 = internalType8;
                                            if (dateType != null ? !((Object)dateType).equals(internalType10) : internalType10 != null) break block5;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " (", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, this.op$1, rr, BoxesRunTime.boxToLong((long)86400000L)}));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block6;
                                        InternalType internalType = (InternalType)tuple2._1();
                                        InternalType internalType11 = (InternalType)tuple2._2();
                                        DateType dateType = DataTypes.DATE;
                                        InternalType internalType12 = internalType;
                                        if (dateType != null ? !((Object)dateType).equals(internalType12) : internalType12 != null) break block6;
                                        TimestampType timestampType = DataTypes.TIMESTAMP;
                                        InternalType internalType13 = internalType11;
                                        if (timestampType != null ? !((Object)timestampType).equals(internalType13) : internalType13 != null) break block6;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L) ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), this.op$1, rr}));
                                    }
                                    return string;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            {
                                this.left$1 = left$1;
                                this.right$1 = right$1;
                                this.op$1 = op$1;
                            }
                        });
                    }
                    var18_18 = var51_51;
                }
                return var18_18;
            }
            throw new MatchError((Object)var49_49);
        }
        throw new CodeGenException("Unsupported temporal arithmetic.");
    }

    public GeneratedExpression generateUnaryIntervalPlusMinus(CodeGeneratorContext ctx, boolean plus, boolean nullCheck, GeneratedExpression operand) {
        String operator = plus ? "+" : "-";
        return this.generateUnaryArithmeticOperator(ctx, operator, nullCheck, operand.resultType(), operand);
    }

    public GeneratedExpression makeReusableRow(CodeGeneratorContext ctx, RowType rowType, Seq<GeneratedExpression> elements, boolean nullCheck, boolean initRow) {
        String rowTerm = CodeGenUtils$.MODULE$.newName("row");
        String rowCls = BinaryRow.class.getCanonicalName();
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = BinaryRowWriter.class.getCanonicalName();
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, rowType, nullCheck, writerTerm){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$11;
            private final RowType rowType$1;
            private final boolean nullCheck$10;
            private final String writerTerm$1;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$2) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    InternalType tpe = this.rowType$1.getInternalTypeAt(idx);
                    String string = this.nullCheck$10 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |if (", ") {\n             |  ", ";\n             |} else {\n             |  ", ";\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, this.writerTerm$1, tpe), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$11, idx, element.resultTerm(), this.writerTerm$1, tpe)})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$11, idx, element.resultTerm(), this.writerTerm$1, tpe)})))).stripMargin();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$11 = ctx$11;
                this.rowType$1 = rowType$1;
                this.nullCheck$10 = nullCheck$10;
                this.writerTerm$1 = writerTerm$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", ".complete();\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, writeCode, writerTerm})))).stripMargin();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowCls, rowTerm, rowCls, BoxesRunTime.boxToInteger((int)rowType.getArity())})), initRow ? code : "");
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerCls, writerTerm, writerCls, rowTerm})), ctx.addReusableMember$default$2());
        return new GeneratedExpression(rowTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateRow(CodeGeneratorContext ctx, InternalType resultType2, Seq<GeneratedExpression> elements, boolean nullCheck) {
        Tuple2.mcZZ.sp sp2;
        block5: {
            GeneratedExpression generatedExpression;
            block3: {
                RowType rowType;
                block4: {
                    DataType[] fieldTypes2;
                    block2: {
                        boolean bl;
                        rowType = (RowType)resultType2;
                        fieldTypes2 = rowType.getFieldTypes();
                        sp2 = new Tuple2.mcZZ.sp(elements.forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(GeneratedExpression element) {
                                return element.resultType() instanceof PrimitiveType;
                            }
                        }), elements.forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(GeneratedExpression element) {
                                return element.literal();
                            }
                        }));
                        if (sp2 == null || !(bl = sp2._2$mcZ$sp())) break block2;
                        generatedExpression = new GeneratedExpression(this.getLiteralRow$1(ctx, elements, nullCheck, rowType).resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), "", rowType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                        break block3;
                    }
                    if (sp2 == null) break block4;
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl2 = sp2._2$mcZ$sp();
                    if (!bl || bl2) break block4;
                    GeneratedExpression row2 = this.getPrimitiveRow$1(ctx, elements, nullCheck, rowType, fieldTypes2);
                    String updateCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(nullCheck, fieldTypes2, row2){
                        public static final long serialVersionUID = 0L;
                        private final boolean nullCheck$2;
                        private final DataType[] fieldTypes$1;
                        private final GeneratedExpression row$1;

                        public final String apply(Tuple2<GeneratedExpression, Object> x0$4) {
                            Tuple2<GeneratedExpression, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                GeneratedExpression element = (GeneratedExpression)tuple2._1();
                                int idx = tuple2._2$mcI$sp();
                                InternalType tpe = this.fieldTypes$1[idx].toInternalType();
                                String string = element.literal() ? "" : (this.nullCheck$2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |if (", ") {\n               |  ", ";\n               |} else {\n               |  ", ";\n               |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryRowSetNull(idx, this.row$1.resultTerm(), tpe), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.row$1.resultTerm(), tpe, element.resultTerm())})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.row$1.resultTerm(), tpe, element.resultTerm())})))).stripMargin());
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.nullCheck$2 = nullCheck$2;
                            this.fieldTypes$1 = fieldTypes$1;
                            this.row$1 = row$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
                    generatedExpression = new GeneratedExpression(row2.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), updateCode, rowType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                    break block3;
                }
                if (sp2 == null) break block5;
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (bl || bl3) break block5;
                generatedExpression = this.getNonPrimitiveRow$1(ctx, elements, nullCheck, rowType);
            }
            return generatedExpression;
        }
        throw new MatchError((Object)sp2);
    }

    public GeneratedExpression makeReusableArray(CodeGeneratorContext ctx, ArrayType resultType2, Seq<GeneratedExpression> elements, boolean nullCheck, boolean initArray) {
        InternalType elementType = resultType2.getElementInternalType();
        String arrayTerm = CodeGenUtils$.MODULE$.newName("array");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String arrayCls = BinaryArray.class.getCanonicalName();
        String writerCls = BinaryArrayWriter.class.getCanonicalName();
        int elementSize = BinaryArray.calculateElementSize(elementType);
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, elementType, writerTerm){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$12;
            private final InternalType elementType$1;
            private final String writerTerm$2;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$5) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |if (", ") {\n           |  ", ";\n           |} else {\n           |  ", ";\n           |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.baseArraySetNull(idx, this.writerTerm$2, this.elementType$1), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$12, idx, element.resultTerm(), this.writerTerm$2, this.elementType$1)})))).stripMargin().trim();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$12 = ctx$12;
                this.elementType$1 = elementType$1;
                this.writerTerm$2 = writerTerm$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", ".complete();\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, writeCode, writerTerm})))).stripMargin();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arrayCls, arrayTerm, arrayCls})), initArray ? code : "");
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "(", ", ", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerCls, writerTerm, writerCls, arrayTerm, BoxesRunTime.boxToInteger((int)elements.length()), BoxesRunTime.boxToInteger((int)elementSize)})), ctx.addReusableMember$default$2());
        return new GeneratedExpression(arrayTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public GeneratedExpression generateArray(CodeGeneratorContext ctx, InternalType resultType2, Seq<GeneratedExpression> elements, boolean nullCheck) {
        Tuple2.mcZZ.sp sp2;
        block5: {
            GeneratedExpression generatedExpression;
            block3: {
                ArrayType arrayType;
                block4: {
                    InternalType elementType;
                    block2: {
                        boolean bl;
                        arrayType = (ArrayType)resultType2;
                        elementType = arrayType.getElementInternalType();
                        sp2 = new Tuple2.mcZZ.sp(elements.forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(GeneratedExpression element) {
                                return element.resultType() instanceof PrimitiveType;
                            }
                        }), elements.forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(GeneratedExpression element) {
                                return element.literal();
                            }
                        }));
                        if (sp2 == null || !(bl = sp2._2$mcZ$sp())) break block2;
                        generatedExpression = new GeneratedExpression(this.getLiteralArray$1(ctx, elements, nullCheck, arrayType).resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), "", arrayType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                        break block3;
                    }
                    if (sp2 == null) break block4;
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl2 = sp2._2$mcZ$sp();
                    if (!bl || bl2) break block4;
                    GeneratedExpression array2 = this.getPrimitiveArray$1(ctx, elements, nullCheck, arrayType, elementType);
                    String updateCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(nullCheck, elementType, array2){
                        public static final long serialVersionUID = 0L;
                        private final boolean nullCheck$3;
                        private final InternalType elementType$2;
                        private final GeneratedExpression array$2;

                        public final String apply(Tuple2<GeneratedExpression, Object> x0$6) {
                            Tuple2<GeneratedExpression, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                GeneratedExpression element = (GeneratedExpression)tuple2._1();
                                int idx = tuple2._2$mcI$sp();
                                String string = element.literal() ? "" : (this.nullCheck$3 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |if (", ") {\n               |  ", ";\n               |} else {\n               |  ", ";\n               |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.baseArraySetNull(idx, this.array$2.resultTerm(), this.elementType$2), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.array$2.resultTerm(), this.elementType$2, element.resultTerm())})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.array$2.resultTerm(), this.elementType$2, element.resultTerm())})))).stripMargin());
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.nullCheck$3 = nullCheck$3;
                            this.elementType$2 = elementType$2;
                            this.array$2 = array$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
                    generatedExpression = new GeneratedExpression(array2.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), updateCode, arrayType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                    break block3;
                }
                if (sp2 == null) break block5;
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (bl || bl3) break block5;
                generatedExpression = this.getNonPrimitiveArray$1(ctx, elements, nullCheck, arrayType);
            }
            return generatedExpression;
        }
        throw new MatchError((Object)sp2);
    }

    public GeneratedExpression generateArrayElementAt(CodeGeneratorContext ctx, GeneratedExpression array2, GeneratedExpression index, boolean nullCheck) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            InternalType componentInfo = ((ArrayType)array2.resultType()).getElementInternalType();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(componentInfo);
            String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(componentInfo);
            String idxStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.resultTerm()}));
            String arrayIsNull = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2.resultTerm(), idxStr}));
            String arrayGet = CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, idxStr, array2.resultTerm(), componentInfo, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5());
            String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |boolean ", " = ", " || ", " || ", ";\n         |", " ", " = ", " ? ", " : ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2.code(), index.code(), nullTerm2, array2.nullTerm(), index.nullTerm(), arrayIsNull, resultTypeTerm, resultTerm2, nullTerm2, defaultTerm, arrayGet})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, componentInfo, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateArrayElement(CodeGeneratorContext ctx, GeneratedExpression array2, boolean nullCheck) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            InternalType resultType2 = ((ArrayType)array2.resultType()).getElementInternalType();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType2);
            String arrayLengthCode = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".numElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2.nullTerm(), array2.resultTerm()}));
            String arrayGet = CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, 0, array2.resultTerm(), resultType2);
            String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", ";\n         |", " ", ";\n         |switch (", ") {\n         |  case 0:\n         |    ", " = true;\n         |    ", " = ", ";\n         |    break;\n         |  case 1:\n         |    ", " = ", ".isNullAt(0);\n         |    ", " = ", " ? ", " : ", ";\n         |    break;\n         |  default:\n         |    throw new RuntimeException(\"Array has more than one element.\");\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2.code(), nullTerm2, resultTypeTerm, resultTerm2, arrayLengthCode, nullTerm2, resultTerm2, defaultValue, nullTerm2, array2.resultTerm(), resultTerm2, nullTerm2, defaultValue, arrayGet})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, resultType2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateArrayCardinality(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression array2) {
        return CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, DataTypes.INT, array2, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(array2){
            public static final long serialVersionUID = 0L;
            private final GeneratedExpression array$1;

            public final String apply(String x$10) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".numElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.array$1.resultTerm()}));
            }
            {
                this.array$1 = array$1;
            }
        });
    }

    public GeneratedExpression generateMap(CodeGeneratorContext ctx, InternalType resultType2, Seq<GeneratedExpression> elements, boolean nullCheck) {
        Tuple2 tuple2;
        block7: {
            Tuple3 tuple3;
            block8: {
                Tuple2 tuple22;
                block12: {
                    Tuple3 tuple32;
                    boolean keyNeedsRefill;
                    String keyUpdate;
                    GeneratedExpression keyArr;
                    String binaryMapTerm;
                    String mapTerm;
                    block10: {
                        boolean bl;
                        InternalType valueType;
                        Seq valueElements;
                        block11: {
                            block9: {
                                boolean bl2;
                                Tuple3 tuple33;
                                Tuple3 tuple34;
                                MapType mapType;
                                block5: {
                                    boolean bl3;
                                    InternalType keyType;
                                    Seq keyElements;
                                    block6: {
                                        block4: {
                                            boolean bl4;
                                            mapType = (MapType)resultType2;
                                            mapTerm = CodeGenUtils$.MODULE$.newName("map");
                                            binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
                                            keyElements = elements.grouped(2).map((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final GeneratedExpression apply(Seq<GeneratedExpression> x0$8) {
                                                    Seq<GeneratedExpression> seq = x0$8;
                                                    Some some = Seq$.MODULE$.unapplySeq(seq);
                                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                        GeneratedExpression key;
                                                        GeneratedExpression generatedExpression = key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
                                                        return generatedExpression;
                                                    }
                                                    throw new MatchError(seq);
                                                }
                                            }).toSeq();
                                            keyType = mapType.getKeyInternalType();
                                            tuple2 = new Tuple2((Object)keyType, (Object)BoxesRunTime.boxToBoolean((boolean)keyElements.forall((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final boolean apply(GeneratedExpression x$11) {
                                                    return x$11.literal();
                                                }
                                            })));
                                            if (tuple2 == null || !(bl4 = tuple2._2$mcZ$sp())) break block4;
                                            tuple34 = new Tuple3((Object)this.getLiteralMapArray$1(keyType, keyElements, ctx, nullCheck), (Object)"", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                            break block5;
                                        }
                                        if (tuple2 == null) break block6;
                                        boolean bl5 = tuple2._2$mcZ$sp();
                                        if (!(tuple2._1() instanceof PrimitiveType) || bl5) break block6;
                                        GeneratedExpression arr = this.getPrimitiveMapArray$1(keyType, keyElements, ctx, nullCheck);
                                        String update = this.getPrimitiveMapArrayUpdateCode$1(arr.resultTerm(), keyType, keyElements, nullCheck);
                                        tuple34 = new Tuple3((Object)arr, (Object)update, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                        break block5;
                                    }
                                    if (tuple2 == null || (bl3 = tuple2._2$mcZ$sp())) break block7;
                                    GeneratedExpression arr = this.getNonPrimitiveMapArray$1(keyType, keyElements, ctx, nullCheck);
                                    String update = arr.code();
                                    tuple34 = new Tuple3((Object)arr, (Object)update, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                }
                                tuple3 = tuple34;
                                if (tuple3 == null) break block8;
                                GeneratedExpression keyArr2 = (GeneratedExpression)tuple3._1();
                                String keyUpdate2 = (String)tuple3._2();
                                boolean keyNeedsRefill2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                Tuple3 tuple35 = tuple33 = new Tuple3((Object)keyArr2, (Object)keyUpdate2, (Object)BoxesRunTime.boxToBoolean((boolean)keyNeedsRefill2));
                                keyArr = (GeneratedExpression)tuple35._1();
                                keyUpdate = (String)tuple35._2();
                                keyNeedsRefill = BoxesRunTime.unboxToBoolean((Object)tuple35._3());
                                valueElements = elements.grouped(2).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final GeneratedExpression apply(Seq<GeneratedExpression> x0$9) {
                                        Seq<GeneratedExpression> seq = x0$9;
                                        Some some = Seq$.MODULE$.unapplySeq(seq);
                                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                            GeneratedExpression value;
                                            GeneratedExpression generatedExpression = value = (GeneratedExpression)((SeqLike)some.get()).apply(1);
                                            return generatedExpression;
                                        }
                                        throw new MatchError(seq);
                                    }
                                }).toSeq();
                                valueType = mapType.getValueInternalType();
                                tuple22 = new Tuple2((Object)valueType, (Object)BoxesRunTime.boxToBoolean((boolean)valueElements.forall((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(GeneratedExpression x$13) {
                                        return x$13.literal();
                                    }
                                })));
                                if (tuple22 == null || !(bl2 = tuple22._2$mcZ$sp())) break block9;
                                tuple32 = new Tuple3((Object)this.getLiteralMapArray$1(valueType, valueElements, ctx, nullCheck), (Object)"", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                break block10;
                            }
                            if (tuple22 == null) break block11;
                            boolean bl6 = tuple22._2$mcZ$sp();
                            if (!(tuple22._1() instanceof PrimitiveType) || bl6) break block11;
                            GeneratedExpression arr = this.getPrimitiveMapArray$1(valueType, valueElements, ctx, nullCheck);
                            String update = this.getPrimitiveMapArrayUpdateCode$1(arr.resultTerm(), valueType, valueElements, nullCheck);
                            tuple32 = new Tuple3((Object)arr, (Object)update, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            break block10;
                        }
                        if (tuple22 == null || (bl = tuple22._2$mcZ$sp())) break block12;
                        GeneratedExpression arr = this.getNonPrimitiveMapArray$1(valueType, valueElements, ctx, nullCheck);
                        String update = arr.code();
                        tuple32 = new Tuple3((Object)arr, (Object)update, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    Tuple3 tuple36 = tuple32;
                    if (tuple36 != null) {
                        Tuple3 tuple37;
                        GeneratedExpression valueArr = (GeneratedExpression)tuple36._1();
                        String valueUpdate = (String)tuple36._2();
                        boolean valueNeedsRefill = BoxesRunTime.unboxToBoolean((Object)tuple36._3());
                        Tuple3 tuple38 = tuple37 = new Tuple3((Object)valueArr, (Object)valueUpdate, (Object)BoxesRunTime.boxToBoolean((boolean)valueNeedsRefill));
                        GeneratedExpression valueArr2 = (GeneratedExpression)tuple38._1();
                        String valueUpdate2 = (String)tuple38._2();
                        boolean valueNeedsRefill2 = BoxesRunTime.unboxToBoolean((Object)tuple38._3());
                        String mapCls = BaseMap.class.getCanonicalName();
                        String binaryMapCls = BinaryMap.class.getCanonicalName();
                        String initMap = keyNeedsRefill || valueNeedsRefill2 ? "" : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " ", " =\n           |  ", ".valueOf(", ", ", ");\n           |", " = ", ".keyArray();\n           |", " = ", ".valueArray();\n           |", " = ", ";\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryMapCls, binaryMapTerm, binaryMapCls, keyArr.resultTerm(), valueArr2.resultTerm(), keyArr.resultTerm(), binaryMapTerm, valueArr2.resultTerm(), binaryMapTerm, mapTerm, binaryMapTerm})))).stripMargin();
                        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapCls, mapTerm})), initMap);
                        String code = keyNeedsRefill || valueNeedsRefill2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", " = ", ".valueOf(", ", ", ");\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyUpdate, valueUpdate2, mapTerm, binaryMapCls, keyArr.resultTerm(), valueArr2.resultTerm()})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyUpdate, valueUpdate2})))).stripMargin();
                        return new GeneratedExpression(mapTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                    }
                    throw new MatchError((Object)tuple36);
                }
                throw new MatchError((Object)tuple22);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    public GeneratedExpression generateMapGet(CodeGeneratorContext ctx, GeneratedExpression map2, GeneratedExpression key, boolean nullCheck) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String tmpKey = CodeGenUtils$.MODULE$.newName("key");
            String tmpValue = CodeGenUtils$.MODULE$.newName("value");
            String length = CodeGenUtils$.MODULE$.newName("length");
            String keys = CodeGenUtils$.MODULE$.newName("keys");
            String values = CodeGenUtils$.MODULE$.newName("values");
            String index = CodeGenUtils$.MODULE$.newName("index");
            String found = CodeGenUtils$.MODULE$.newName("found");
            MapType ty = (MapType)map2.resultType();
            InternalType keyType = ty.getKeyInternalType();
            InternalType valueType = ty.getValueInternalType();
            String keyTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
            String valueTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
            String boxedValueTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
            String valueDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType);
            String mapTerm = map2.resultTerm();
            String binaryMapTypeTerm = BinaryMap.class.getCanonicalName();
            String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
            String genericMapTypeTerm = GenericMap.class.getCanonicalName();
            String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
            String arrayTypeTerm = BinaryArray.class.getCanonicalName();
            GeneratedExpression equal = this.generateEquals(ctx, nullCheck, key, new GeneratedExpression(tmpKey, "false", "", keyType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9()));
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (", " instanceof ", ") {\n         |  ", " ", " = (", ") ", ";\n         |\n         |  final int ", " = ", ".numElements();\n         |  final ", " ", " = ", ".keyArray();\n         |  final ", " ", " = ", ".valueArray();\n         |\n         |  int ", " = 0;\n         |  boolean ", " = false;\n         |  while (", " < ", " && !", ") {\n         |    final ", " ", " = ", ";\n         |    ", "\n         |    if (", ") {\n         |      ", " = true;\n         |    } else {\n         |      ", "++;\n         |    }\n         |  }\n         |\n         |  if (!", " || ", ".isNullAt(", ")) {\n         |    ", " = true;\n         |  } else {\n         |    ", " = ", ";\n         |  }\n         |} else {\n         |  ", " ", " = (", ") ", ";\n         |  ", " ", " =\n         |    (", ") ", ".get((", ") ", ");\n         |  if (", " == null) {\n         |    ", " = true;\n         |  } else {\n         |    ", " = ", ";\n         |  }\n         |}\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapTerm, binaryMapTypeTerm, binaryMapTypeTerm, binaryMapTerm, binaryMapTypeTerm, mapTerm, length, binaryMapTerm, arrayTypeTerm, keys, binaryMapTerm, arrayTypeTerm, values, binaryMapTerm, index, found, index, length, found, keyTypeTerm, tmpKey, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, index, keys, keyType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5()), equal.code(), equal.resultTerm(), found, index, found, values, index, nullTerm2, resultTerm2, CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, index, values, valueType, CodeGenUtils$.MODULE$.baseRowFieldReadAccess$default$5()), genericMapTypeTerm, genericMapTerm, genericMapTypeTerm, mapTerm, boxedValueTypeTerm, tmpValue, boxedValueTypeTerm, genericMapTerm, keyTypeTerm, key.resultTerm(), tmpValue, nullTerm2, resultTerm2, tmpValue})))).stripMargin();
            String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |boolean ", " = (", " || ", ");\n         |", " ", " = ", ";\n         |if (!", ") {\n         | ", "\n         |}\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2.code(), key.code(), nullTerm2, map2.nullTerm(), key.nullTerm(), valueTypeTerm, resultTerm2, valueDefault, nullTerm2, code})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, valueType, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateMapCardinality(CodeGeneratorContext ctx, boolean nullCheck, GeneratedExpression map2) {
        return CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull(ctx, nullCheck, DataTypes.INT, map2, CallGenerator$.MODULE$.generateUnaryOperatorIfNotNull$default$5(), (Function1<String, String>)new Serializable(map2){
            public static final long serialVersionUID = 0L;
            private final GeneratedExpression map$1;

            public final String apply(String x$16) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".numElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.map$1.resultTerm()}));
            }
            {
                this.map$1 = map$1;
            }
        });
    }

    private GeneratedExpression internalExprCasting(GeneratedExpression expr, InternalType typeInfo) {
        return new GeneratedExpression(expr.resultTerm(), expr.nullTerm(), expr.code(), typeInfo, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
    }

    public Function1<String, String> numericCasting(InternalType operandType, InternalType resultType2) {
        block8: {
            Object object;
            block3: {
                String resultTypeTerm;
                block7: {
                    String wrapperClass;
                    String resultTypeValue;
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
                                    resultTypeValue = new StringBuilder().append((Object)resultTypeTerm).append((Object)"Value()").toString();
                                    wrapperClass = CodeGenUtils$.MODULE$.boxedTypeTermForType(operandType);
                                    InternalType internalType = operandType;
                                    InternalType internalType2 = resultType2;
                                    if (internalType != null ? !internalType.equals(internalType2) : internalType2 != null) break block2;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String operandTerm) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                        }
                                    };
                                    break block3;
                                }
                                if (!TypeCheckUtils$.MODULE$.isDecimal(resultType2) || !TypeCheckUtils$.MODULE$.isDecimal(operandType)) break block4;
                                DecimalType dt = (DecimalType)resultType2;
                                object = new Serializable(dt){
                                    public static final long serialVersionUID = 0L;
                                    private final DecimalType dt$1;

                                    public final String apply(String operandTerm) {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castTo(Decimal.class), operandTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.dt$1.precision()), BoxesRunTime.boxToInteger((int)this.dt$1.scale())}))).toString();
                                    }
                                    {
                                        this.dt$1 = dt$1;
                                    }
                                };
                                break block3;
                            }
                            if (!TypeCheckUtils$.MODULE$.isDecimal(resultType2) || !TypeCheckUtils$.MODULE$.isNumeric(operandType)) break block5;
                            DecimalType dt = (DecimalType)resultType2;
                            object = new Serializable(dt){
                                public static final long serialVersionUID = 0L;
                                private final DecimalType dt$2;

                                public final String apply(String operandTerm) {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castFrom(), operandTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.dt$2.precision()), BoxesRunTime.boxToInteger((int)this.dt$2.scale())}))).toString();
                                }
                                {
                                    this.dt$2 = dt$2;
                                }
                            };
                            break block3;
                        }
                        if (!TypeCheckUtils$.MODULE$.isNumeric(resultType2) || !TypeCheckUtils$.MODULE$.isDecimal(operandType)) break block6;
                        object = new Serializable(resultType2){
                            public static final long serialVersionUID = 0L;
                            private final InternalType resultType$2;

                            public final String apply(String operandTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal.Ref.castTo(this.resultType$2), operandTerm}));
                            }
                            {
                                this.resultType$2 = resultType$2;
                            }
                        };
                        break block3;
                    }
                    if (!TypeCheckUtils$.MODULE$.isNumeric(operandType) || !TypeCheckUtils$.MODULE$.isNumeric(resultType2)) break block7;
                    object = new Serializable(resultTypeValue, wrapperClass){
                        public static final long serialVersionUID = 0L;
                        private final String resultTypeValue$1;
                        private final String wrapperClass$1;

                        public final String apply(String operandTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(new ", "(", ")).", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperClass$1, operandTerm, this.resultTypeValue$1}));
                        }
                        {
                            this.resultTypeValue$1 = resultTypeValue$1;
                            this.wrapperClass$1 = wrapperClass$1;
                        }
                    };
                    break block3;
                }
                if (!TypeCheckUtils$.MODULE$.isTimeInterval(resultType2) || !TypeCheckUtils$.MODULE$.isInteger(operandType)) break block8;
                object = new Serializable(resultTypeTerm){
                    public static final long serialVersionUID = 0L;
                    private final String resultTypeTerm$2;

                    public final String apply(String operandTerm) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ") ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resultTypeTerm$2, operandTerm}));
                    }
                    {
                        this.resultTypeTerm$2 = resultTypeTerm$2;
                    }
                };
            }
            return object;
        }
        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported casting from ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandType, resultType2})));
    }

    public GeneratedExpression generateRuntimeFilter(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, SqlRuntimeFilterFunction func) {
        String rfFuture = CodeGenUtils$.MODULE$.newName("rfFuture");
        String futureField = CompletableFuture.class.getCanonicalName();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{futureField, rfFuture})), ctx.addReusableMember$default$2());
        String rfUtils = RuntimeFilterUtils.class.getCanonicalName();
        ctx.addReusableOpenStatement(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".asyncGetBroadcastBloomFilter("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rfFuture, rfUtils}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getRuntimeContext(), ", "", "", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\"", func.getBroadcastId(), "\""}))).toString());
        String bfField = BloomFilter.class.getCanonicalName();
        String bf = CodeGenUtils$.MODULE$.newName("bf");
        String rfResult = CodeGenUtils$.MODULE$.newName("rfResult");
        boolean waitRf = ctx.getTableConfig().getConf().getBoolean(TableConfigOptions.SQL_EXEC_RUNTIME_FILTER_WAIT);
        Tuple2<String, String> tuple2 = this.runtimeFilterHash((GeneratedExpression)operands.head());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String hashCode2 = (String)tuple2._1();
            String hash = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)hashCode2, (Object)hash);
            String hashCode3 = (String)tuple23._1();
            String hash2 = (String)tuple23._2();
            String verify = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = (", ") ", ".get();\n         |if (", " != null) {\n         |  ", "\n         |  ", " = ", ".testHash(", ");\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bfField, bf, bfField, rfFuture, bf, hashCode3, rfResult, bf, hash2})))).stripMargin();
            if (!waitRf) {
                verify = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |if (", ".isDone()) {\n             |  ", "\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rfFuture, verify})))).stripMargin();
            }
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = true;\n         |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((GeneratedExpression)operands.head()).code(), rfResult, verify})))).stripMargin();
            return new GeneratedExpression(rfResult, "false", code, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(tuple2);
    }

    public GeneratedExpression generateRuntimeFilterBuilder(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, SqlRuntimeFilterBuilderFunction func) {
        String bf = CodeGenUtils$.MODULE$.newName("bfField");
        String bfField = BloomFilter.class.getCanonicalName();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bfField, bf})), ctx.addReusableMember$default$2());
        ctx.addReusableOpenStatement(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bf, bfField}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".suitableMaxNumEntries(", "),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bfField, BoxesRunTime.boxToLong((long)Predef$.MODULE$.double2Double(func.ndv()).longValue())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)func.minFpp(ctx.tableConfig()))}))).toString());
        String accTypeField = BloomFilterAcc.class.getCanonicalName();
        String quotaBid = new StringBuilder().append((Object)"\"").append((Object)func.broadcastId()).append((Object)"\"").toString();
        String accField = CodeGenUtils$.MODULE$.newName("acc");
        String serializedValue = SerializedValue.class.getCanonicalName();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accTypeField, accField, accTypeField})), ctx.addReusableMember$default$2());
        ctx.addReusableOpenStatement(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getRuntimeContext().addPreAggregatedAccumulator("})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotaBid, accField}))).toString());
        ctx.addReusableEndInputStatement(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".add(", ".fromBytes(", ".toBytes(", ")));\n         |getRuntimeContext().commitPreAggregatedAccumulator(", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accField, serializedValue, bfField, bf, quotaBid})))).stripMargin());
        Tuple2<String, String> tuple2 = this.runtimeFilterHash((GeneratedExpression)operands.head());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String hashCode2 = (String)tuple2._1();
            String hash = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)hashCode2, (Object)hash);
            String hashCode3 = (String)tuple23._1();
            String hash2 = (String)tuple23._2();
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", ".addHash(", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((GeneratedExpression)operands.head()).code(), hashCode3, bf, hash2})))).stripMargin();
            return new GeneratedExpression("true", "false", code, DataTypes.BOOLEAN, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, String> runtimeFilterHash(GeneratedExpression expr) {
        String string;
        String bf = BloomFilter.class.getCanonicalName();
        String brUtil = BinaryRowUtil.class.getCanonicalName();
        String hash = CodeGenUtils$.MODULE$.newName("rfHashCode");
        String term2 = expr.resultTerm();
        InternalType internalType = expr.resultType();
        if (TypeCheckUtils$.MODULE$.isNumeric(internalType) || TypeCheckUtils$.MODULE$.isTemporal(internalType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getLongHash(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bf, term2}));
        } else {
            StringType stringType = DataTypes.STRING;
            InternalType internalType2 = internalType;
            if (!(stringType != null ? !((Object)stringType).equals(internalType2) : internalType2 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hash64()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2}));
            } else {
                ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
                InternalType internalType3 = internalType;
                string = !(byteArrayType != null ? !((Object)byteArrayType).equals(internalType3) : internalType3 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hashByteArray64(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brUtil, term2})) : (internalType instanceof DecimalType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hashDecimal64(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brUtil, term2})) : HashCodeGenerator$.MODULE$.hashExpr(expr));
            }
        }
        String goHash = string;
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |long ", " = 0;\n       |if (!", ") {\n       |  ", " = ", ";\n       |}\n       |\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hash, expr.nullTerm(), hash, goHash})))).stripMargin(), (Object)hash);
    }

    public GeneratedExpression generateDOT(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, boolean nullCheck) {
        if (operands.size() > 2) {
            throw new CodeGenException("A DOT operator with more than 2 operands is not supported yet.");
        }
        String fieldName = ((GeneratedExpression)operands.apply(1)).literalValue().toString();
        int fieldIdx = ((RowType)((GeneratedExpression)operands.head()).resultType()).getFieldIndex(fieldName);
        GeneratedExpression access = CodeGenUtils$.MODULE$.generateFieldAccess(ctx, ((GeneratedExpression)operands.head()).resultType(), ((GeneratedExpression)operands.head()).resultTerm(), fieldIdx, nullCheck);
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(access.resultType());
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(access.resultType());
            String resultCode = nullCheck ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " ", ";\n         |boolean ", ";\n         |if (", ") {\n         |  ", " = ", ";\n         |  ", " = true;\n         |}\n         |else {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$20) {
                    return x$20.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), resultTypeTerm, resultTerm2, nullTerm2, ((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$21) {
                    return x$21.nullTerm();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" || "), resultTerm2, defaultValue, nullTerm2, access.code(), resultTerm2, access.resultTerm(), nullTerm2, access.nullTerm()})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", " ", " = ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$22) {
                    return x$22.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), access.code(), resultTypeTerm, resultTerm2, access.resultTerm()})))).stripMargin();
            return new GeneratedExpression(resultTerm2, nullTerm2, resultCode, access.resultType(), GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
        }
        throw new MatchError(seq);
    }

    private final Function1 castToDec$1(InternalType t, DecimalType resultType$1) {
        InternalType internalType = t;
        Serializable serializable = internalType instanceof DecimalType ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String operandTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
            }
        } : this.numericCasting(t, resultType$1);
        return serializable;
    }

    private final GeneratedExpression getLiteralRow$1(CodeGeneratorContext ctx$3, Seq elements$1, boolean nullCheck$2, RowType rowType$2) {
        return this.makeReusableRow(ctx$3, rowType$2, (Seq<GeneratedExpression>)elements$1, nullCheck$2, true);
    }

    private final GeneratedExpression getPrimitiveRow$1(CodeGeneratorContext ctx$3, Seq elements$1, boolean nullCheck$2, RowType rowType$2, DataType[] fieldTypes$1) {
        Seq mapped = (Seq)((TraversableLike)elements$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(fieldTypes$1){
            public static final long serialVersionUID = 0L;
            private final DataType[] fieldTypes$1;

            public final GeneratedExpression apply(Tuple2<GeneratedExpression, Object> x0$3) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    GeneratedExpression generatedExpression;
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (element.literal()) {
                        generatedExpression = element;
                    } else {
                        String resultTerm;
                        InternalType tpe = this.fieldTypes$1[idx].toInternalType();
                        String string = resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(tpe);
                        String string2 = "null";
                        String nullTerm = !(string != null ? !string.equals(string2) : string2 != null) ? "true" : "false";
                        generatedExpression = new GeneratedExpression(resultTerm, nullTerm, "", tpe, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                    }
                    GeneratedExpression generatedExpression2 = generatedExpression;
                    return generatedExpression2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.makeReusableRow(ctx$3, rowType$2, (Seq<GeneratedExpression>)mapped, nullCheck$2, true);
    }

    private final GeneratedExpression getNonPrimitiveRow$1(CodeGeneratorContext ctx$3, Seq elements$1, boolean nullCheck$2, RowType rowType$2) {
        return this.makeReusableRow(ctx$3, rowType$2, (Seq<GeneratedExpression>)elements$1, nullCheck$2, false);
    }

    private final GeneratedExpression getLiteralArray$1(CodeGeneratorContext ctx$4, Seq elements$2, boolean nullCheck$3, ArrayType arrayType$1) {
        return this.makeReusableArray(ctx$4, arrayType$1, (Seq<GeneratedExpression>)elements$2, nullCheck$3, true);
    }

    private final GeneratedExpression getPrimitiveArray$1(CodeGeneratorContext ctx$4, Seq elements$2, boolean nullCheck$3, ArrayType arrayType$1, InternalType elementType$2) {
        Seq mapped = (Seq)elements$2.map((Function1)new Serializable(elementType$2){
            public static final long serialVersionUID = 0L;
            private final InternalType elementType$2;

            public final GeneratedExpression apply(GeneratedExpression element) {
                GeneratedExpression generatedExpression;
                if (element.literal()) {
                    generatedExpression = element;
                } else {
                    String resultTerm;
                    String string = resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(this.elementType$2);
                    String string2 = "null";
                    String nullTerm = !(string != null ? !string.equals(string2) : string2 != null) ? "true" : "false";
                    generatedExpression = new GeneratedExpression(resultTerm, nullTerm, "", this.elementType$2, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                }
                return generatedExpression;
            }
            {
                this.elementType$2 = elementType$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.makeReusableArray(ctx$4, arrayType$1, (Seq<GeneratedExpression>)mapped, nullCheck$3, true);
    }

    private final GeneratedExpression getNonPrimitiveArray$1(CodeGeneratorContext ctx$4, Seq elements$2, boolean nullCheck$3, ArrayType arrayType$1) {
        return this.makeReusableArray(ctx$4, arrayType$1, (Seq<GeneratedExpression>)elements$2, nullCheck$3, false);
    }

    private final GeneratedExpression getLiteralMapArray$1(InternalType tpe, Seq elements, CodeGeneratorContext ctx$5, boolean nullCheck$4) {
        return this.makeReusableArray(ctx$5, DataTypes.createArrayType(tpe), (Seq<GeneratedExpression>)elements, nullCheck$4, true);
    }

    private final GeneratedExpression getPrimitiveMapArray$1(InternalType tpe, Seq elements, CodeGeneratorContext ctx$5, boolean nullCheck$4) {
        Seq mapped = (Seq)elements.map((Function1)new Serializable(tpe){
            public static final long serialVersionUID = 0L;
            private final InternalType tpe$1;

            public final GeneratedExpression apply(GeneratedExpression item) {
                GeneratedExpression generatedExpression;
                if (item.literal()) {
                    generatedExpression = item;
                } else {
                    String resultTerm;
                    String string = resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(this.tpe$1);
                    String string2 = "null";
                    String nullTerm = !(string != null ? !string.equals(string2) : string2 != null) ? "true" : "false";
                    generatedExpression = new GeneratedExpression(resultTerm, nullTerm, "", this.tpe$1, GeneratedExpression$.MODULE$.apply$default$5(), GeneratedExpression$.MODULE$.apply$default$6(), GeneratedExpression$.MODULE$.apply$default$7(), GeneratedExpression$.MODULE$.apply$default$8(), GeneratedExpression$.MODULE$.apply$default$9());
                }
                return generatedExpression;
            }
            {
                this.tpe$1 = tpe$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.makeReusableArray(ctx$5, DataTypes.createArrayType(tpe), (Seq<GeneratedExpression>)mapped, nullCheck$4, true);
    }

    private final GeneratedExpression getNonPrimitiveMapArray$1(InternalType tpe, Seq elements, CodeGeneratorContext ctx$5, boolean nullCheck$4) {
        return this.makeReusableArray(ctx$5, DataTypes.createArrayType(tpe), (Seq<GeneratedExpression>)elements, nullCheck$4, false);
    }

    private final String getPrimitiveMapArrayUpdateCode$1(String arrayTerm, InternalType tpe, Seq elements, boolean nullCheck$4) {
        return ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(nullCheck$4, arrayTerm, tpe){
            public static final long serialVersionUID = 0L;
            private final boolean nullCheck$4;
            private final String arrayTerm$1;
            private final InternalType tpe$2;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$7) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    GeneratedExpression key = (GeneratedExpression)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    String string = key.literal() ? "" : (this.nullCheck$4 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |if (", ") {\n             |  ", ";\n             |} else {\n             |  ", ".setNotNullAt(", ");\n             |  ", ";\n             |}\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.code(), key.nullTerm(), CodeGenUtils$.MODULE$.baseArraySetNull(i, this.arrayTerm$1, this.tpe$2), this.arrayTerm$1, BoxesRunTime.boxToInteger((int)i), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(i, this.arrayTerm$1, this.tpe$2, key.resultTerm())})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |", ";\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.code(), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(i, this.arrayTerm$1, this.tpe$2, key.resultTerm())})))).stripMargin());
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.nullCheck$4 = nullCheck$4;
                this.arrayTerm$1 = arrayTerm$1;
                this.tpe$2 = tpe$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private ScalarOperators$() {
        MODULE$ = this;
    }
}

