/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.Types;

public abstract class BaseArray
implements TypeGetterSetters {
    public abstract int numElements();

    public abstract boolean isNullAt(int var1);

    public abstract void setNullAt(int var1);

    public abstract void setNotNullAt(int var1);

    public abstract void setNullLong(int var1);

    public abstract void setNullInt(int var1);

    public abstract void setNullBoolean(int var1);

    public abstract void setNullByte(int var1);

    public abstract void setNullShort(int var1);

    public abstract void setNullFloat(int var1);

    public abstract void setNullDouble(int var1);

    public abstract void setNullChar(int var1);

    public abstract boolean[] toBooleanArray();

    public abstract byte[] toByteArray();

    public abstract short[] toShortArray();

    public abstract int[] toIntArray();

    public abstract long[] toLongArray();

    public abstract float[] toFloatArray();

    public abstract double[] toDoubleArray();

    public Object toPrimitiveArray(InternalType type) {
        if (type.equals(Types.BOOLEAN)) {
            return this.toBooleanArray();
        }
        if (type.equals(Types.BYTE)) {
            return this.toByteArray();
        }
        if (type.equals(Types.SHORT)) {
            return this.toShortArray();
        }
        if (type.equals(Types.INT)) {
            return this.toIntArray();
        }
        if (type.equals(Types.LONG)) {
            return this.toLongArray();
        }
        if (type.equals(Types.FLOAT)) {
            return this.toFloatArray();
        }
        if (type.equals(Types.DOUBLE)) {
            return this.toDoubleArray();
        }
        throw new RuntimeException("Not a primitive type");
    }

    public abstract Object[] toObjectArray(InternalType var1);

    public abstract <T> T[] toClassArray(InternalType var1, Class<T> var2);

    public void setPrimitive(int pos, Object value, InternalType type) {
        if (type.equals(Types.BOOLEAN)) {
            this.setBoolean(pos, (Boolean)value);
        } else if (type.equals(Types.BYTE)) {
            this.setByte(pos, (Byte)value);
        } else if (type.equals(Types.SHORT)) {
            this.setShort(pos, (Short)value);
        } else if (type.equals(Types.INT)) {
            this.setInt(pos, (Integer)value);
        } else if (type.equals(Types.LONG)) {
            this.setLong(pos, (Long)value);
        } else if (type.equals(Types.FLOAT)) {
            this.setFloat(pos, ((Float)value).floatValue());
        } else if (type.equals(Types.DOUBLE)) {
            this.setDouble(pos, (Double)value);
        } else {
            throw new RuntimeException("Not a primitive type");
        }
    }
}

