/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.dataformat.util.MultiSegUtil;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;

public class BinaryMap
implements BaseMap {
    private MemorySegment[] segments;
    private int baseOffset;
    private int sizeInBytes;
    private final BinaryArray keys = new BinaryArray();
    private final BinaryArray values = new BinaryArray();

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int numElements() {
        return this.keys.numElements();
    }

    @Override
    public Map toJavaMap(InternalType keyType, InternalType valueType) {
        Object[] keyArray = this.keys.toObjectArray(keyType);
        Object[] valueArray = this.values.toObjectArray(valueType);
        HashMap<Object, Object> map2 = new HashMap<Object, Object>();
        for (int i = 0; i < keyArray.length; ++i) {
            map2.put(keyArray[i], valueArray[i]);
        }
        return map2;
    }

    public void pointTo(MemorySegment segment, int baseOffset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, baseOffset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        int keyArrayBytes = MultiSegUtil.getInt(segments, baseOffset);
        assert (keyArrayBytes >= 0) : "keyArraySize (" + keyArrayBytes + ") should >= 0";
        int valueArrayBytes = sizeInBytes - keyArrayBytes - 4;
        assert (valueArrayBytes >= 0) : "valueArraySize (" + valueArrayBytes + ") should >= 0";
        this.keys.pointTo(segments, baseOffset + 4, keyArrayBytes);
        this.values.pointTo(segments, baseOffset + 4 + keyArrayBytes, valueArrayBytes);
        assert (this.keys.numElements() == this.values.numElements());
        this.segments = segments;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    public BinaryArray keyArray() {
        return this.keys;
    }

    public BinaryArray valueArray() {
        return this.values;
    }

    public BinaryMap copy() {
        return this.copy(new BinaryMap());
    }

    public BinaryMap copy(BinaryMap reuse) {
        byte[] bytes = BinaryRowUtil.copy(this.segments, this.baseOffset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public byte[] getBytes() {
        return MultiSegUtil.getBytes(this.segments, this.baseOffset, this.sizeInBytes);
    }

    public static BinaryMap valueOf(BinaryArray key, BinaryArray value) {
        Preconditions.checkArgument(key.getSegments().length == 1 && value.getSegments().length == 1);
        byte[] bytes = new byte[4 + key.getSizeInBytes() + value.getSizeInBytes()];
        MemorySegment segment = MemorySegmentFactory.wrap(bytes);
        segment.putInt(0, key.getSizeInBytes());
        key.getSegments()[0].copyTo(key.getBaseOffset(), segment, 4, key.getSizeInBytes());
        value.getSegments()[0].copyTo(value.getBaseOffset(), segment, 4 + key.getSizeInBytes(), value.getSizeInBytes());
        BinaryMap map2 = new BinaryMap();
        map2.pointTo(segment, 0, bytes.length);
        return map2;
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryMap) {
            BinaryMap other = (BinaryMap)o;
            return this.sizeInBytes == other.sizeInBytes && BinaryRowUtil.equals(this.segments, this.baseOffset, other.segments, other.baseOffset, this.sizeInBytes);
        }
        return false;
    }
}

