/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class DoubleColumnVector
extends ColumnVector {
    private static final long serialVersionUID = 6193940154117411328L;
    public double[] vector;

    public DoubleColumnVector(int len) {
        super(len);
        this.vector = new double[len];
    }

    @Override
    public Object get(int index) {
        return this.vector[index];
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((DoubleColumnVector)output2).vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, ((DoubleColumnVector)output2).vector, 0, size);
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((DoubleColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        DoubleColumnVector other = (DoubleColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

