/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.orc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.orc.ORCOptions;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.orc.OrcTableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.orc.OrcVectorizedColumnRowTableSource;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.StringUtils;
import org.apache.orc.CompressionKind;
import scala.Option;
import scala.Some;

public class OrcTableFactory
implements BatchTableSinkFactory<BaseRow>,
StreamTableSourceFactory<ColumnarRow>,
BatchTableSourceFactory<ColumnarRow> {
    private static final String DEFAULT_WRITE_MODE = "None";

    private OrcVectorizedColumnRowTableSource createSource(Map<String, String> props) {
        TableProperties properties = new TableProperties();
        properties.putProperties(props);
        RichTableSchema schema2 = properties.readSchemaFromProperties(null);
        String filePath = properties.getString(ORCOptions.FILE_PATH);
        if (StringUtils.isNullOrWhitespaceOnly(filePath)) {
            throw new RuntimeException(ORCOptions.PARAMS_HELP_MSG);
        }
        boolean enumerateNestedFiles = properties.getBoolean(ORCOptions.ENUMERATE_NESTED_FILES);
        InternalType[] dataTypes = (InternalType[])Arrays.stream(schema2.getColumnTypes()).toArray(InternalType[]::new);
        OrcVectorizedColumnRowTableSource t = new OrcVectorizedColumnRowTableSource(new Path(filePath), dataTypes, schema2.getColumnNames(), enumerateNestedFiles);
        t.setSchemaFields(schema2.getColumnNames());
        return t;
    }

    @Override
    public List<String> supportedProperties() {
        return ORCOptions.SUPPORTED_KEYS;
    }

    @Override
    public BatchTableSink<BaseRow> createBatchTableSink(Map<String, String> props) {
        TableProperties properties = new TableProperties();
        properties.putProperties(props);
        String filePath = properties.getString(ORCOptions.FILE_PATH);
        if (StringUtils.isNullOrWhitespaceOnly(filePath)) {
            throw new RuntimeException(ORCOptions.PARAMS_HELP_MSG);
        }
        Some writeModeOption = null;
        String writeMode = properties.getString(ORCOptions.WRITE_MODE);
        if (!DEFAULT_WRITE_MODE.equals(writeMode)) {
            writeModeOption = new Some((Object)FileSystem.WriteMode.valueOf(properties.getString(ORCOptions.WRITE_MODE)));
        }
        CompressionKind compressionKind = CompressionKind.valueOf((String)properties.getString(ORCOptions.COMPRESSION_CODEC_NAME));
        return new OrcTableSink(filePath, (Option<FileSystem.WriteMode>)writeModeOption, compressionKind);
    }

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", FileSystemValidator.CONNECTOR_TYPE_VALUE());
        context.put("connector.property-version", "1");
        context.put("format.type", "ORC");
        context.put("format.property-version", "1");
        return context;
    }

    @Override
    public BatchTableSource<ColumnarRow> createBatchTableSource(Map<String, String> properties) {
        return this.createSource(properties);
    }

    @Override
    public StreamTableSource<ColumnarRow> createStreamTableSource(Map<String, String> properties) {
        return this.createSource(properties);
    }
}

