/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.internal;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.validate.SqlValidator;

public class SqlIfFunction
extends SqlFunction {
    public SqlIfFunction() {
        super("IF", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.LEAST_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        this.validateQuantifier(validator, call);
        List<SqlNode> operands = call.getOperandList();
        SqlParserPos pos = call.getParserPosition();
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        whenList.add(SqlStdOperatorTable.IS_TRUE.createCall(pos, operands.get(0)));
        thenList.add(SqlNode.clone(operands.get(1)));
        return SqlCase.createSwitched(pos, null, whenList, thenList, SqlNode.clone(operands.get(2)));
    }
}

