/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.hive.functions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.hive.functions.HiveFunctionWrapper;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveSimpleUDF
extends ScalarFunction {
    private final HiveFunctionWrapper<UDF> hiveFunctionWrapper;
    private transient UDF function;
    private transient Method method;
    private transient List<TypeInfo> typeInfos;
    private transient ObjectInspector[] objectInspectors;
    private transient GenericUDFUtils.ConversionHelper conversionHelper;
    private transient boolean initialized = false;

    public HiveSimpleUDF(HiveFunctionWrapper<UDF> hiveFunctionWrapper) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
        this.initialized = false;
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        this.function = this.hiveFunctionWrapper.createFunction();
        this.initialized = false;
    }

    @Override
    public void close() {
        this.initialized = false;
    }

    private void initialize(Object ... args) throws UDFArgumentException {
        this.typeInfos = new ArrayList<TypeInfo>();
        for (Object arg : args) {
            this.typeInfos.add(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(arg.getClass()));
        }
        this.method = this.function.getResolver().getEvalMethod(this.typeInfos);
        this.objectInspectors = new ObjectInspector[this.typeInfos.size()];
        for (int i = 0; i < args.length; ++i) {
            this.objectInspectors[i] = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.typeInfos.get(i)));
        }
        this.conversionHelper = new GenericUDFUtils.ConversionHelper(this.method, this.objectInspectors);
        this.initialized = true;
    }

    public Object eval(Object ... args) throws HiveException {
        Object[] convertedArgs;
        if (!this.initialized) {
            this.initialize(args);
        }
        try {
            convertedArgs = this.conversionHelper.convertIfNecessary(args);
        }
        catch (ClassCastException e2) {
            this.initialize(args);
            convertedArgs = this.conversionHelper.convertIfNecessary(args);
        }
        return FunctionRegistry.invoke((Method)this.method, (Object)this.function, (Object[])convertedArgs);
    }

    @Override
    public boolean isDeterministic() {
        try {
            UDFType udfType = this.hiveFunctionWrapper.getUDFClass().getAnnotation(UDFType.class);
            return udfType != null && udfType.deterministic() && !udfType.stateful();
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }
}

