/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.common;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.flink.table.plan.cost.FlinkBatchCost$;
import org.apache.flink.table.plan.cost.FlinkCostFactory;
import org.apache.flink.table.plan.trait.FlinkRelDistribution;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0001\u0002\u0002\u0002E\u0011abQ8n[>tW\t_2iC:<WM\u0003\u0002\u0004\t\u000511m\\7n_:T!!\u0002\u0004\u0002\u000b9|G-Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CG\u0007\u0002))\u0011QCF\u0001\u0005G>\u0014XM\u0003\u0002\u00181\u0005\u0019!/\u001a7\u000b\u0005ea\u0011aB2bY\u000eLG/Z\u0005\u00037Q\u0011\u0001\"\u0012=dQ\u0006tw-\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u000591\r\\;ti\u0016\u0014\bCA\u0010\"\u001b\u0005\u0001#BA\u0004\u0019\u0013\t\u0011\u0003EA\u0007SK2|\u0005\u000f^\"mkN$XM\u001d\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005AAO]1jiN+G\u000f\u0005\u0002 M%\u0011q\u0005\t\u0002\f%\u0016dGK]1jiN+G\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u001d\u0011X\r\u001c(pI\u0016\u0004\"a\u000b\u0017\u000e\u0003YI!!\f\f\u0003\u000fI+GNT8eK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\bsK2$\u0015n\u001d;sS\n,H/[8o!\tY\u0013'\u0003\u00023-\ty!+\u001a7ESN$(/\u001b2vi&|g\u000eC\u00035\u0001\u0011\u0005Q'\u0001\u0004=S:LGO\u0010\u000b\u0006maJ$h\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u0006;M\u0002\rA\b\u0005\u0006IM\u0002\r!\n\u0005\u0006SM\u0002\rA\u000b\u0005\u0006_M\u0002\r\u0001\r\u0005\u0006{\u0001!\tEP\u0001\u0010G>l\u0007/\u001e;f'\u0016dgmQ8tiR\u0019qHQ$\u0011\u0005}\u0001\u0015BA!!\u0005)\u0011V\r\\(qi\u000e{7\u000f\u001e\u0005\u0006\u0007r\u0002\r\u0001R\u0001\ba2\fgN\\3s!\tyR)\u0003\u0002GA\ti!+\u001a7PaR\u0004F.\u00198oKJDQ\u0001\u0013\u001fA\u0002%\u000b!!\\9\u0011\u0005)kU\"A&\u000b\u000513\u0012\u0001C7fi\u0006$\u0017\r^1\n\u00059[%\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0011\u0015\u0001\u0006\u0001\"\u0011R\u00031)\u0007\u0010\u001d7bS:$VM]7t)\t\u0011V\u000b\u0005\u0002,'&\u0011AK\u0006\u0002\n%\u0016dwK]5uKJDQAV(A\u0002I\u000b!\u0001]<\t\u000ba\u0003A\u0011B-\u0002)\u0011L7\u000f\u001e:jEV$\u0018n\u001c8U_N#(/\u001b8h)\u0005Q\u0006CA.b\u001d\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0006")
public abstract class CommonExchange
extends Exchange {
    private final RelDistribution relDistribution;

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        block10: {
            RelOptCost relOptCost;
            block5: {
                RelDistribution.Type type;
                FlinkCostFactory costFactory;
                double inputSize;
                Double inputRows;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    inputRows = mq.getRowCount(this.input);
                                    if (inputRows == null) {
                                        return null;
                                    }
                                    inputSize = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this.input)) * Predef$.MODULE$.Double2double(inputRows);
                                    costFactory = (FlinkCostFactory)planner.getCostFactory();
                                    type = this.relDistribution.getType();
                                    if (!((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) break block4;
                                    double cpuCost = (double)(FlinkBatchCost$.MODULE$.SINGLETON_CPU_COST() + FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                                    relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                                    break block5;
                                }
                                if (!((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type)) break block6;
                                double cpuCost = (double)(FlinkBatchCost$.MODULE$.RANDOM_CPU_COST() + FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                                relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                                break block5;
                            }
                            if (!((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type)) break block7;
                            double cpuCost = (double)(FlinkBatchCost$.MODULE$.RANGE_PARTITION_CPU_COST() + FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                            double diskIoCost = inputSize;
                            double networkCost = (double)2 * inputSize;
                            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, diskIoCost, networkCost, 0.0);
                            break block5;
                        }
                        if (!((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) break block8;
                        int nParallelism = Math.max(1, (int)(inputSize / (double)FlinkBatchCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
                        double cpuCost = (double)nParallelism * Predef$.MODULE$.Double2double(inputRows) * (double)FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST();
                        double networkCost = (double)nParallelism * inputSize;
                        relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, networkCost, 0.0);
                        break block5;
                    }
                    if (!((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) break block9;
                    double cpuCost = (double)(FlinkBatchCost$.MODULE$.HASH_CPU_COST() * this.relDistribution.getKeys().size() + FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                    relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                    break block5;
                }
                if (!((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) break block10;
                relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), (double)FlinkBatchCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST() * Predef$.MODULE$.Double2double(inputRows), 0.0, inputSize, 0.0);
            }
            return relOptCost;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not support RelDistribution: ", " now!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relDistribution.getType()})));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("distribution", this.distributionToString());
    }

    private String distributionToString() {
        FlinkRelDistribution flinkRelDistribution = (FlinkRelDistribution)this.relDistribution;
        List<String> inputFieldNames = this.getInput().getRowType().getFieldNames();
        String exchangeName = this.relDistribution.getType().shortName;
        RelDistribution.Type type = this.relDistribution.getType();
        List list = ((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)flinkRelDistribution.getFieldCollations().get()).asScala()).map((Function1)new Serializable(this, inputFieldNames){
            public static final long serialVersionUID = 0L;
            private final List inputFieldNames$1;

            public final String apply(RelFieldCollation fieldCollation) {
                String name = (String)this.inputFieldNames$1.get(fieldCollation.getFieldIndex());
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, fieldCollation.getDirection().shortString}));
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava() : (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)flinkRelDistribution.getKeys()).asScala()).map((Function1)new Serializable(this, inputFieldNames){
            public static final long serialVersionUID = 0L;
            private final List inputFieldNames$1;

            public final String apply(Integer x$1) {
                return (String)this.inputFieldNames$1.get(Predef$.MODULE$.Integer2int(x$1));
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
        List fieldNames = list;
        return fieldNames.isEmpty() ? exchangeName : new StringBuilder().append((Object)exchangeName).append((Object)fieldNames).toString();
    }

    public CommonExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode relNode, RelDistribution relDistribution) {
        this.relDistribution = relDistribution;
        super(cluster, traitSet, relNode, relDistribution);
    }
}

