/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.schema.Table;
import org.apache.flink.shaded.calcite.com.google.common.base.Strings;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.plan.nodes.calcite.LogicalWatermarkAssigner;
import org.apache.flink.table.plan.rules.logical.CatalogTableRules$;
import org.apache.flink.table.plan.schema.CatalogCalciteTable;
import org.apache.flink.table.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.plan.schema.StreamTableSourceTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSourceUtil$;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001#\t\u00193)\u0019;bY><G+\u00192mKR{7\u000b\u001e:fC6$\u0016M\u00197f'>,(oY3Sk2,'BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111cF\u0007\u0002))\u0011q!\u0006\u0006\u0003-1\tqaY1mG&$X-\u0003\u0002\u0019)\tQ!+\u001a7PaR\u0014V\u000f\\3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0002\u0013aB7bi\u000eDWm\u001d\u000b\u0003C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012qAQ8pY\u0016\fg\u000eC\u0003)=\u0001\u0007\u0011&\u0001\u0003dC2d\u0007CA\n+\u0013\tYCC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000b5\u0002A\u0011\t\u0018\u0002\u000f=tW*\u0019;dQR\u0011qF\r\t\u0003EAJ!!M\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q1\u0002\r!\u000b")
public class CatalogTableToStreamTableSourceRule
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan rel = (LogicalTableScan)call.rel(0);
        CatalogCalciteTable table = rel.getTable().unwrap(CatalogCalciteTable.class);
        return table != null && !(table.table() instanceof CatalogView);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelOptTable relOptTable;
        LogicalTableScan oldRel = (LogicalTableScan)call.rel(0);
        CatalogCalciteTable catalogTable = oldRel.getTable().unwrap(CatalogCalciteTable.class);
        StreamTableSource<Object> tableSource = catalogTable.streamTableSource();
        FlinkRelOptTable table = ((FlinkRelOptTable)oldRel.getTable()).copy(new StreamTableSourceTable<Object>(tableSource, catalogTable.getStatistic()), TableSourceUtil$.MODULE$.getRelDataType(tableSource, (Option<int[]>)None$.MODULE$, true, (FlinkTypeFactory)oldRel.getCluster().getTypeFactory()));
        if (tableSource.explainSource().isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add("From");
            builder.addAll(oldRel.getTable().getQualifiedName());
            relOptTable = table.config((List)((Object)builder.build()), (Table)table.unwrap(TableSourceTable.class));
        } else {
            relOptTable = table;
        }
        table = relOptTable;
        RelNode newRel = CatalogTableRules$.MODULE$.appendParserNode(catalogTable, LogicalTableScan.create(oldRel.getCluster(), table), call.builder());
        FlinkPlannerImpl flinkPlanner = call.getPlanner().getContext().unwrap(FlinkPlannerImpl.class);
        if (!Strings.isNullOrEmpty(catalogTable.table().getComputedColumnsSql())) {
            newRel = CatalogTableRules$.MODULE$.appendComputedColumns(flinkPlanner, call.builder(), oldRel, newRel, catalogTable.table(), true);
        }
        if (catalogTable.table().getRowTimeField() != null) {
            newRel = new LogicalWatermarkAssigner(newRel.getCluster(), newRel.getTraitSet(), newRel, catalogTable.table().getRowTimeField(), catalogTable.table().getWatermarkOffset());
        }
        call.transformTo(newRel);
    }

    public CatalogTableToStreamTableSourceRule() {
        super(RelOptRule.operand(LogicalTableScan.class, RelOptRule.any()), "CatalogTableToStreamTableSource");
    }
}

