/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlRankFunction;
import org.apache.flink.table.api.TableConfig$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalOverWindow;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.plan.rules.logical.FlinkLogicalConstantRankRule;
import org.apache.flink.table.plan.rules.logical.FlinkLogicalRankRule$;
import org.apache.flink.table.plan.util.ConstantRankRange;
import org.apache.flink.table.plan.util.ConstantRankRangeWithoutEnd;
import org.apache.flink.table.plan.util.InputRefVisitor;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.plan.util.RankUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001#\t!b\t\\5oW2{w-[2bYJ\u000bgn\u001b*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAQa\b\u0001\u0005B\u0001\nq!\\1uG\",7\u000f\u0006\u0002\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t9!i\\8mK\u0006t\u0007\"\u0002\u0015\u001f\u0001\u0004I\u0013\u0001B2bY2\u0004\"a\u0005\u0016\n\u0005-\"\"A\u0004*fY>\u0003HOU;mK\u000e\u000bG\u000e\u001c\u0005\u0006[\u0001!\tEL\u0001\b_:l\u0015\r^2i)\ty#\u0007\u0005\u0002#a%\u0011\u0011g\t\u0002\u0005+:LG\u000fC\u0003)Y\u0001\u0007\u0011fB\u00035\u0005!\u0005Q'\u0001\u000bGY&t7\u000eT8hS\u000e\fGNU1oWJ+H.\u001a\t\u0003;Y2Q!\u0001\u0002\t\u0002]\u001a\"A\u000e\u001d\u0011\u0005\tJ\u0014B\u0001\u001e$\u0005\u0019\te.\u001f*fM\")!D\u000eC\u0001yQ\tQ\u0007C\u0004?m\t\u0007I\u0011A \u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012\u0001\b\u0005\u0007\u0003Z\u0002\u000b\u0011\u0002\u000f\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003bB\"7\u0005\u0004%\t\u0001R\u0001\u000e\u0007>s5\u000bV!O)~\u0013\u0016IT&\u0016\u0003\u0015\u0003\"!\b$\n\u0005\u001d\u0013!\u0001\b$mS:\\Gj\\4jG\u0006d7i\u001c8ti\u0006tGOU1oWJ+H.\u001a\u0005\u0007\u0013Z\u0002\u000b\u0011B#\u0002\u001d\r{ej\u0015+B\u001dR{&+\u0011(LA\u0001")
public class FlinkLogicalRankRule
extends RelOptRule {
    public static FlinkLogicalConstantRankRule CONSTANT_RANK() {
        return FlinkLogicalRankRule$.MODULE$.CONSTANT_RANK();
    }

    public static FlinkLogicalRankRule INSTANCE() {
        return FlinkLogicalRankRule$.MODULE$.INSTANCE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(RelOptRuleCall call) {
        Some some;
        Tuple2 tuple2;
        int rankFieldIndex;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalOverWindow window = (FlinkLogicalOverWindow)call.rel(1);
        if (window.groups.size() > 1) {
            return false;
        }
        Window.Group group = (Window.Group)window.groups.get(0);
        if (group.aggCalls.size() > 1) {
            return false;
        }
        Window.RexWinAggCall agg = (Window.RexWinAggCall)group.aggCalls.get(0);
        if (!(agg.getOperator() instanceof SqlRankFunction)) return false;
        if (!group.lowerBound.isUnbounded()) return false;
        if (!group.upperBound.isCurrentRow()) return false;
        RexLocalRef condition = calc.getProgram().getCondition();
        if (condition == null) {
            return false;
        }
        RexNode predicate = calc.getProgram().expandLocalRef(condition);
        Tuple2<Option<RankRange>, Option<RexNode>> tuple22 = RankUtil$.MODULE$.extractRankRange(predicate, rankFieldIndex = window.getRowType().getFieldCount() - 1, calc.getCluster().getRexBuilder(), TableConfig$.MODULE$.DEFAULT());
        if (tuple22 == null) throw new MatchError(tuple22);
        Option rankRange = (Option)tuple22._1();
        Option remainingPreds = (Option)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)rankRange, (Object)remainingPreds);
        Option rankRange2 = (Option)tuple23._1();
        Option remainingPreds2 = (Option)tuple23._2();
        boolean remainingPredsAccessRank = remainingPreds2.isDefined() && RankUtil$.MODULE$.accessesRankField((RexNode)remainingPreds2.get(), rankFieldIndex);
        Option option = rankRange2;
        if (option instanceof Some && (some = (Some)option).x() instanceof ConstantRankRangeWithoutEnd) {
            throw new TableException("Rank end is not specified. Currently rank only support TopN, which means the rank end must be specified.");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        if (!rankRange2.isDefined()) return false;
        if (remainingPredsAccessRank) return false;
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalOverWindow window = (FlinkLogicalOverWindow)call.rel(1);
        Window.Group group = (Window.Group)window.groups.get(0);
        SqlRankFunction rankFun = (SqlRankFunction)((RexCall)group.aggCalls.get(0)).getOperator();
        int rankFieldIndex = window.getRowType().getFieldCount() - 1;
        RexLocalRef condition = calc.getProgram().getCondition();
        RexNode predicate = calc.getProgram().expandLocalRef(condition);
        Tuple2<Option<RankRange>, Option<RexNode>> tuple2 = RankUtil$.MODULE$.extractRankRange(predicate, rankFieldIndex, calc.getCluster().getRexBuilder(), TableConfig$.MODULE$.DEFAULT());
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            ConstantRankRange constantRankRange;
            long rankEnd;
            Some some;
            RankRange rankRange;
            RelDataType relDataType;
            Tuple2 tuple22;
            Option rankRange2 = (Option)tuple2._1();
            Option remainingPreds = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rankRange2, (Object)remainingPreds);
            Option rankRange3 = (Option)tuple23._1();
            Option remainingPreds2 = (Option)tuple23._2();
            Predef$.MODULE$.require(rankRange3.isDefined());
            RelOptCluster cluster = window.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RexProgram calcProgram = calc.getProgram();
            List<RexLocalRef> projectList = calcProgram.getProjectList();
            Buffer exprList = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(projectList).map((Function1)new Serializable(this, calcProgram){
                public static final long serialVersionUID = 0L;
                private final RexProgram calcProgram$1;

                public final RexNode apply(RexLocalRef x$1) {
                    return this.calcProgram$1.expandLocalRef(x$1);
                }
                {
                    this.calcProgram$1 = calcProgram$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            InputRefVisitor visitor = new InputRefVisitor();
            exprList.foreach((Function1)new Serializable(this, visitor){
                public static final long serialVersionUID = 0L;
                private final InputRefVisitor visitor$1;

                public final void apply(RexNode x$3) {
                    x$3.accept(this.visitor$1);
                }
                {
                    this.visitor$1 = visitor$1;
                }
            });
            int[] inputFields = visitor.getFields();
            boolean outputRankFunColumn = Predef$.MODULE$.intArrayOps(inputFields).contains((Object)BoxesRunTime.boxToInteger((int)rankFieldIndex));
            if (outputRankFunColumn) {
                relDataType = window.getRowType();
            } else {
                RelDataTypeFactory.FieldInfoBuilder typeBuilder = rexBuilder.getTypeFactory().builder();
                ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(window.getRowType().getFieldList()).dropRight(1)).foreach((Function1)new Serializable(this, typeBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelDataTypeFactory.FieldInfoBuilder typeBuilder$1;

                    public final RelDataTypeFactory.FieldInfoBuilder apply(RelDataTypeField x$1) {
                        return this.typeBuilder$1.add(x$1);
                    }
                    {
                        this.typeBuilder$1 = typeBuilder$1;
                    }
                });
                relDataType = typeBuilder.build();
            }
            RelDataType rankRowType = relDataType;
            Option option = rankRange3;
            if (option instanceof Some && (rankRange = (RankRange)(some = (Some)option).x()) instanceof ConstantRankRange && (rankEnd = (constantRankRange = (ConstantRankRange)rankRange).rankEnd()) <= 0L) {
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rank end should not less than zero, but now is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rankEnd)})));
            }
            FlinkLogicalRank rank = new FlinkLogicalRank(cluster, window.getTraitSet(), window.getInput(), rankFun, group.keys, group.orderKeys, (RankRange)rankRange3.get(), outputRankFunColumn);
            if (RexUtil.isIdentity(JavaConversions$.MODULE$.bufferAsJavaList(exprList), rankRowType) && remainingPreds2.isEmpty()) {
                call.transformTo(rank);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                RexProgramBuilder programBuilder = RexProgramBuilder.create(rexBuilder, rankRowType, calcProgram.getExprList(), calcProgram.getProjectList(), (RexNode)remainingPreds2.orNull(Predef$.MODULE$.$conforms()), calc.getRowType(), true, null);
                Calc newCalc = calc.copy(calc.getTraitSet(), rank, programBuilder.getProgram());
                call.transformTo(newCalc);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new MatchError(tuple2);
    }

    public FlinkLogicalRankRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalOverWindow.class, RelOptRule.any()), new RelOptRuleOperand[0]), "FlinkLogicalRankRule");
    }
}

