/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;

public class FlinkSemiJoinJoinTransposeRule
extends RelOptRule {
    public static final FlinkSemiJoinJoinTransposeRule INSTANCE = new FlinkSemiJoinJoinTransposeRule();

    private FlinkSemiJoinJoinTransposeRule() {
        super(FlinkSemiJoinJoinTransposeRule.operand(SemiJoin.class, FlinkSemiJoinJoinTransposeRule.some(FlinkSemiJoinJoinTransposeRule.operand(Join.class, FlinkSemiJoinJoinTransposeRule.any()), new RelOptRuleOperand[0])));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinRel;
        RelNode leftJoinRel;
        List<Integer> newLeftKeys;
        RexNode newSemiJoinFilter;
        int i;
        SemiJoin semiJoin = (SemiJoin)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ImmutableIntList leftKeys = semiJoin.getLeftKeys();
        ImmutableIntList rightKeys = semiJoin.getRightKeys();
        Pair<ImmutableBitSet, ImmutableBitSet> inputRefs = this.getSemiJoinConditionInputRefs(semiJoin);
        ImmutableBitSet leftInputRefs = (ImmutableBitSet)inputRefs.left;
        ImmutableBitSet rightInputRefs = (ImmutableBitSet)inputRefs.right;
        if (leftInputRefs.isEmpty() || rightInputRefs.isEmpty()) {
            return;
        }
        int nFieldsX = join.getLeft().getRowType().getFieldList().size();
        int nFieldsY = join.getRight().getRowType().getFieldList().size();
        int nFieldsZ = semiJoin.getRight().getRowType().getFieldList().size();
        int nTotalFields = nFieldsX + nFieldsY + nFieldsZ;
        ArrayList<RelDataTypeField> fields2 = new ArrayList<RelDataTypeField>();
        List<RelDataTypeField> joinFields = semiJoin.getRowType().getFieldList();
        for (i = 0; i < nFieldsX + nFieldsY; ++i) {
            fields2.add(joinFields.get(i));
        }
        joinFields = semiJoin.getRight().getRowType().getFieldList();
        for (i = 0; i < nFieldsZ; ++i) {
            fields2.add(joinFields.get(i));
        }
        int nKeysFromX = 0;
        int nKeysFromY = 0;
        for (int leftKey : leftInputRefs) {
            if (leftKey < nFieldsX) {
                ++nKeysFromX;
                continue;
            }
            ++nKeysFromY;
        }
        if (nKeysFromX > 0 && nKeysFromY > 0) {
            return;
        }
        assert (nKeysFromX == 0 || nKeysFromX == leftInputRefs.cardinality());
        assert (nKeysFromY == 0 || nKeysFromY == leftInputRefs.cardinality());
        int[] adjustments = new int[nTotalFields];
        if (nKeysFromX > 0) {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, 0, -nFieldsY);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields2, adjustments));
            newLeftKeys = leftKeys;
        } else {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, -nFieldsX, -nFieldsX);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields2, adjustments));
            newLeftKeys = RelOptUtil.adjustKeys(leftKeys, -nFieldsX);
        }
        RelNode leftSemiJoinOp = nKeysFromX > 0 ? join.getLeft() : join.getRight();
        SemiJoin newSemiJoin = SemiJoin.create(leftSemiJoinOp, semiJoin.getRight(), newSemiJoinFilter, ImmutableIntList.copyOf(newLeftKeys), rightKeys, semiJoin.isAnti);
        if (nKeysFromX > 0) {
            leftJoinRel = newSemiJoin;
            rightJoinRel = join.getRight();
        } else {
            leftJoinRel = join.getLeft();
            rightJoinRel = newSemiJoin;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), join.getCondition(), leftJoinRel, rightJoinRel, join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoinRel);
    }

    private void setJoinAdjustments(int[] adjustments, int nFieldsX, int nFieldsY, int nFieldsZ, int adjustY, int adjustZ) {
        int i;
        for (i = 0; i < nFieldsX; ++i) {
            adjustments[i] = 0;
        }
        for (i = nFieldsX; i < nFieldsX + nFieldsY; ++i) {
            adjustments[i] = adjustY;
        }
        for (i = nFieldsX + nFieldsY; i < nFieldsX + nFieldsY + nFieldsZ; ++i) {
            adjustments[i] = adjustZ;
        }
    }

    private Pair<ImmutableBitSet, ImmutableBitSet> getSemiJoinConditionInputRefs(SemiJoin semiJoin) {
        final int leftInputFieldCount = semiJoin.getLeft().getRowType().getFieldCount();
        final ImmutableBitSet.Builder leftInputBitSet = ImmutableBitSet.builder();
        final ImmutableBitSet.Builder rightInputBitSet = ImmutableBitSet.builder();
        semiJoin.getCondition().accept(new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                int index = inputRef.getIndex();
                if (index < leftInputFieldCount) {
                    leftInputBitSet.set(index);
                } else {
                    rightInputBitSet.set(index);
                }
                return null;
            }
        });
        return new Pair<ImmutableBitSet, ImmutableBitSet>(leftInputBitSet.build(), rightInputBitSet.build());
    }
}

