/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.plan.schema.FlinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.plan.stats.FlinkStatistic$;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import org.apache.flink.table.plan.util.RexNodeExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.orc.OrcTableSource;
import org.apache.flink.table.sources.parquet.ParquetTableSource;
import org.apache.flink.table.validate.FunctionCatalog;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001E\u0011\u0011\u0005U;tQ\u001aKG\u000e^3s\u0013:$x\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAQa\b\u0001\u0005B\u0001\nq!\\1uG\",7\u000f\u0006\u0002\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t9!i\\8mK\u0006t\u0007\"\u0002\u0015\u001f\u0001\u0004I\u0013\u0001B2bY2\u0004\"a\u0005\u0016\n\u0005-\"\"A\u0004*fY>\u0003HOU;mK\u000e\u000bG\u000e\u001c\u0005\u0006[\u0001!\tEL\u0001\b_:l\u0015\r^2i)\ty#\u0007\u0005\u0002#a%\u0011\u0011g\t\u0002\u0005+:LG\u000fC\u0003)Y\u0001\u0007\u0011\u0006C\u00035\u0001\u0011%Q'\u0001\nqkNDg)\u001b7uKJLe\u000e^8TG\u0006tGCB\u00187o\u0005C\u0005\u000bC\u0003)g\u0001\u0007\u0011\u0006C\u00039g\u0001\u0007\u0011(\u0001\u0004gS2$XM\u001d\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nAaY8sK*\u0011a(F\u0001\u0004e\u0016d\u0017B\u0001!<\u0005\u00191\u0015\u000e\u001c;fe\")!i\ra\u0001\u0007\u0006!1oY1o!\t!e)D\u0001F\u0015\t\u0019Q(\u0003\u0002H\u000b\n\u0001Bj\\4jG\u0006dG+\u00192mKN\u001b\u0017M\u001c\u0005\u0006\u0013N\u0002\rAS\u0001\fe\u0016dw\n\u001d;UC\ndW\r\u0005\u0002L\u001d6\tAJ\u0003\u0002N\r\u000511o\u00195f[\u0006L!a\u0014'\u0003!\u0019c\u0017N\\6SK2|\u0005\u000f\u001e+bE2,\u0007\"B)4\u0001\u0004\u0011\u0016a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"a\u0015,\u000f\u0005\t\"\u0016BA+$\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u001b\u0003\"\u0002.\u0001\t\u0013Y\u0016AD1qa2L\bK]3eS\u000e\fG/\u001a\u000b\u0005\u0015rcW\u000eC\u0003^3\u0002\u0007a,\u0001\u0006qe\u0016$\u0017nY1uKN\u00042a\u00183g\u001b\u0005\u0001'BA1c\u0003\u0011)H/\u001b7\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002j\u0011\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tY\u0007N\u0001\u0006FqB\u0014Xm]:j_:DQ!S-A\u0002)CQA\\-A\u0002=\f!B]3m\u0005VLG\u000eZ3s!\t\u00018/D\u0001r\u0015\t\u0011X#A\u0003u_>d7/\u0003\u0002uc\nQ!+\u001a7Ck&dG-\u001a:\b\u000bY\u0014\u0001\u0012A<\u0002CA+8\u000f\u001b$jYR,'/\u00138u_R\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3\u0011\u0005uAh!B\u0001\u0003\u0011\u0003I8C\u0001={!\t\u001130\u0003\u0002}G\t1\u0011I\\=SK\u001aDQA\u0007=\u0005\u0002y$\u0012a\u001e\u0005\n\u0003\u0003A(\u0019!C\u0001\u0003\u0007\t\u0001\"\u0013(T)\u0006s5)R\u000b\u0002%!9\u0011q\u0001=!\u0002\u0013\u0011\u0012!C%O'R\u000bejQ#!\u0001")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable != null) {
            OrcTableSource orcTableSource;
            boolean bl2;
            ParquetTableSource parquetTableSource;
            TableSourceTable tableSourceTable2 = tableSourceTable;
            TableSource tableSource = tableSourceTable2.tableSource();
            if (tableSource instanceof ParquetTableSource && !(parquetTableSource = (ParquetTableSource)tableSource).isFilterPushedDown()) {
                TableConfig tableConfig = scan.getCluster().getPlanner().getContext().unwrap(TableConfig.class);
                bl2 = tableConfig.getConf().getBoolean(TableConfigOptions.SQL_PARQUET_PREDICATE_PUSHDOWN_ENABLED);
            } else if (tableSource instanceof OrcTableSource && !(orcTableSource = (OrcTableSource)tableSource).isFilterPushedDown()) {
                TableConfig tableConfig = scan.getCluster().getPlanner().getContext().unwrap(TableConfig.class);
                bl2 = tableConfig.getConf().getBoolean(TableConfigOptions.SQL_ORC_PREDICATE_PUSHDOWN_ENABLED);
            } else {
                TableSource tableSource2;
                bl2 = tableSource instanceof FilterableTableSource && !((FilterableTableSource)((Object)(tableSource2 = tableSource))).isFilterPushedDown();
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        FlinkRelOptTable table = (FlinkRelOptTable)scan.getTable();
        this.pushFilterIntoScan(call, filter, scan, table, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkRelOptTable relOptTable, String description) {
        RelBuilder relBuilder = call.builder();
        FunctionCatalog functionCatalog = FlinkRelOptUtil$.MODULE$.getFunctionCatalog(filter);
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(scan);
        Tuple2<Expression[], RexNode[]> tuple2 = RexNodeExtractor$.MODULE$.extractConjunctiveConditions(filter.getCondition(), maxCnfNodeCount, filter.getInput().getRowType().getFieldNames(), relBuilder.getRexBuilder(), functionCatalog);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Expression[] predicates = (Expression[])tuple2._1();
            RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
            Expression[] predicates2 = (Expression[])tuple23._1();
            RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
            if (Predef$.MODULE$.refArrayOps((Object[])predicates2).isEmpty()) {
                return;
            }
            LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
            Predef$.MODULE$.refArrayOps((Object[])predicates2).foreach((Function1)new Serializable(this, remainingPredicates){
                public static final long serialVersionUID = 0L;
                private final LinkedList remainingPredicates$1;

                public final boolean apply(Expression e2) {
                    return this.remainingPredicates$1.add(e2);
                }
                {
                    this.remainingPredicates$1 = remainingPredicates$1;
                }
            });
            FlinkRelOptTable newRelOptTable = this.applyPredicate(remainingPredicates, relOptTable, relBuilder);
            LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newRelOptTable);
            if (remainingPredicates.isEmpty() && Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2).isEmpty()) {
                call.transformTo(newScan);
            } else {
                relBuilder.push(scan);
                Buffer remainingConditions = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(Expression expr) {
                        return expr.toRexNode(this.relBuilder$1);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2));
                RexNode remainingCondition = (RexNode)remainingConditions.reduce((Function2)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(RexNode l, RexNode r) {
                        return this.relBuilder$1.and(l, r);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                });
                Filter newFilter = filter.copy(filter.getTraitSet(), newScan, remainingCondition);
                call.transformTo(newFilter);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    private FlinkRelOptTable applyPredicate(List<Expression> predicates, FlinkRelOptTable relOptTable, RelBuilder relBuilder) {
        FlinkStatistic flinkStatistic;
        int originPredicatesSize = predicates.size();
        TableSourceTable tableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)tableSourceTable.tableSource());
        filterableSource.setRelBuilder(relBuilder);
        TableSource newTableSource = filterableSource.applyPredicate(predicates);
        int updatedPredicatesSize = predicates.size();
        FlinkStatistic statistic2 = tableSourceTable.statistic();
        if (originPredicatesSize == updatedPredicatesSize) {
            flinkStatistic = statistic2;
        } else {
            FlinkStatistic flinkStatistic2 = statistic2;
            FlinkStatistic flinkStatistic3 = FlinkStatistic$.MODULE$.UNKNOWN();
            flinkStatistic = !(flinkStatistic2 != null ? !flinkStatistic2.equals(flinkStatistic3) : flinkStatistic3 != null) ? statistic2 : FlinkStatistic$.MODULE$.builder().statistic(statistic2).tableStats(null).build();
        }
        FlinkStatistic newStatistic = flinkStatistic;
        FlinkTable newTableSourceTable = tableSourceTable.replaceTableSource(newTableSource).copy(newStatistic);
        return relOptTable.copy(newTableSourceTable, tableSourceTable.getRowType(relBuilder.getTypeFactory()));
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(Filter.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }
}

