/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushLimitIntoTableSourceScanRule$;
import org.apache.flink.table.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.plan.schema.FlinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.plan.stats.FlinkStatistic$;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.plan.stats.TableStats$;
import org.apache.flink.table.sources.LimitableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\t\u0001\u0003+^:i\u0019&l\u0017\u000e^%oi>$\u0016M\u00197f'>,(oY3TG\u0006t'+\u001e7f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003']i\u0011\u0001\u0006\u0006\u0003\u000fUQ!A\u0006\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0001\u0004\u0006\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0011\u0015y\u0002\u0001\"\u0011!\u0003\u001di\u0017\r^2iKN$\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0001F\ba\u0001S\u0005!1-\u00197m!\t\u0019\"&\u0003\u0002,)\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"B\u0017\u0001\t\u0003r\u0013aB8o\u001b\u0006$8\r\u001b\u000b\u0003_I\u0002\"A\t\u0019\n\u0005E\u001a#\u0001B+oSRDQ\u0001\u000b\u0017A\u0002%BQ\u0001\u000e\u0001\u0005\nU\n!\"\u00199qYfd\u0015.\\5u)\u00111D(Q\"\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e2\u0011AB:dQ\u0016l\u0017-\u0003\u0002<q\t\u0001b\t\\5oWJ+Gn\u00149u)\u0006\u0014G.\u001a\u0005\u0006{M\u0002\rAP\u0001\u0006Y&l\u0017\u000e\u001e\t\u0003E}J!\u0001Q\u0012\u0003\t1{gn\u001a\u0005\u0006\u0005N\u0002\rAN\u0001\fe\u0016dw\n\u001d;UC\ndW\rC\u0003Eg\u0001\u0007Q)\u0001\u0006sK2\u0014U/\u001b7eKJ\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u000b\u0002\u000bQ|w\u000e\\:\n\u0005);%A\u0003*fY\n+\u0018\u000e\u001c3fe\u001e)AJ\u0001E\u0001\u001b\u0006\u0001\u0003+^:i\u0019&l\u0017\u000e^%oi>$\u0016M\u00197f'>,(oY3TG\u0006t'+\u001e7f!\tibJB\u0003\u0002\u0005!\u0005qj\u0005\u0002O!B\u0011!%U\u0005\u0003%\u000e\u0012a!\u00118z%\u00164\u0007\"\u0002\u000eO\t\u0003!F#A'\t\u000fYs%\u0019!C\u0001/\u0006A\u0011JT*U\u0003:\u001bU)F\u0001\u0013\u0011\u0019If\n)A\u0005%\u0005I\u0011JT*U\u0003:\u001bU\t\t")
public class PushLimitIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushLimitIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RexNode fetch = sort.fetch;
        RexNode offset = sort.offset;
        boolean onlyLimit = sort.getCollation().getFieldCollations().isEmpty() && (offset == null || RexLiteral.intValue(offset) == 0) && fetch != null;
        boolean supportPushDown = false;
        if (onlyLimit) {
            boolean bl;
            TableSourceTable tableSource = ((TableScan)call.rel(1)).getTable().unwrap(TableSourceTable.class);
            TableSourceTable tableSourceTable = tableSource;
            if (tableSourceTable != null) {
                TableSource tableSource2;
                TableSourceTable tableSourceTable2 = tableSourceTable;
                TableSource tableSource3 = tableSourceTable2.tableSource();
                boolean bl2 = tableSource3 instanceof LimitableTableSource ? !((LimitableTableSource)((Object)(tableSource2 = tableSource3))).isLimitPushedDown() : false;
                bl = bl2;
            } else {
                bl = false;
            }
            supportPushDown = bl;
        }
        return supportPushDown;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FlinkRelOptTable relOptTable = (FlinkRelOptTable)scan.getTable();
        int limit = RexLiteral.intValue(sort.fetch);
        RelBuilder relBuilder = call.builder();
        FlinkRelOptTable newRelOptTable = this.applyLimit(limit, relOptTable, relBuilder);
        FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), newRelOptTable);
        call.transformTo(newScan);
    }

    private FlinkRelOptTable applyLimit(long limit, FlinkRelOptTable relOptTable, RelBuilder relBuilder) {
        TableSourceTable tableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        LimitableTableSource limitedSource = (LimitableTableSource)((Object)tableSourceTable.tableSource());
        TableSource newTableSource = limitedSource.applyLimit(limit);
        FlinkStatistic statistic2 = relOptTable.getFlinkStatistic();
        long newRowCount = statistic2.getRowCount() == null ? limit : Math.min(limit, (long)Predef$.MODULE$.Double2double(statistic2.getRowCount()));
        TableStats newTableStats = new TableStats(Predef$.MODULE$.long2Long(newRowCount), TableStats$.MODULE$.apply$default$2(), TableStats$.MODULE$.apply$default$3());
        FlinkStatistic newStatistic = FlinkStatistic$.MODULE$.builder().statistic(statistic2).tableStats(newTableStats).build();
        FlinkTable newTableSourceTable = tableSourceTable.replaceTableSource(newTableSource).copy(newStatistic);
        return relOptTable.copy(newTableSourceTable, relOptTable.getRowType());
    }

    public PushLimitIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalSort.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushLimitIntoTableSourceScanRule");
    }
}

