/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.flink.table.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.plan.nodes.calcite.WindowAggregate;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class WindowAggregateReduceFunctionsRule
extends RelOptRule {
    public static final WindowAggregateReduceFunctionsRule INSTANCE = new WindowAggregateReduceFunctionsRule(WindowAggregateReduceFunctionsRule.operand(LogicalWindowAggregate.class, WindowAggregateReduceFunctionsRule.any()), RelFactories.LOGICAL_BUILDER);

    public WindowAggregateReduceFunctionsRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        if (!super.matches(call)) {
            return false;
        }
        WindowAggregate oldAggRel = (WindowAggregate)call.rels[0];
        List aggCalls = JavaConversions.seqAsJavaList(oldAggRel.getAggCallList());
        return this.containsAvgStddevVarCall(aggCalls);
    }

    @Override
    public void onMatch(RelOptRuleCall ruleCall) {
        WindowAggregate oldAggRel = (WindowAggregate)ruleCall.rels[0];
        this.reduceAggs(ruleCall, oldAggRel);
    }

    private boolean containsAvgStddevVarCall(List<AggregateCall> aggCallList) {
        for (AggregateCall call : aggCallList) {
            if (!this.isReducible(call.getAggregation().getKind())) continue;
            return true;
        }
        return false;
    }

    private boolean isReducible(SqlKind kind) {
        if (SqlKind.AVG_AGG_FUNCTIONS.contains((Object)kind) || SqlKind.COVAR_AVG_AGG_FUNCTIONS.contains((Object)kind)) {
            return true;
        }
        switch (kind) {
            case SUM: {
                return true;
            }
        }
        return false;
    }

    private void reduceAggs(RelOptRuleCall ruleCall, WindowAggregate oldAggRel) {
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        List oldCalls = JavaConversions.seqAsJavaList(oldAggRel.getAggCallList());
        int groupCount = oldAggRel.getGroupCount();
        ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
        HashMap<AggregateCall, RexNode> aggCallMapping = new HashMap<AggregateCall, RexNode>();
        ArrayList<RexNode> projList = new ArrayList<RexNode>();
        for (int i = 0; i < groupCount; ++i) {
            projList.add(rexBuilder.makeInputRef(this.getFieldType(oldAggRel, i), i));
        }
        RelBuilder relBuilder = ruleCall.builder();
        relBuilder.push(oldAggRel.getInput());
        ArrayList<RexNode> inputExprs = new ArrayList<RexNode>(relBuilder.fields());
        for (AggregateCall oldCall : oldCalls) {
            projList.add(this.reduceAgg(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs));
        }
        int extraArgCount = inputExprs.size() - relBuilder.peek().getRowType().getFieldCount();
        if (extraArgCount > 0) {
            relBuilder.project(inputExprs, CompositeList.of(relBuilder.peek().getRowType().getFieldNames(), Collections.nCopies(extraArgCount, null)));
        }
        this.newAggregateRel(relBuilder, oldAggRel, newCalls);
        this.newCalcRel(relBuilder, oldAggRel.getRowType(), projList);
        ruleCall.transformTo(relBuilder.build());
    }

    private RexNode reduceAgg(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        SqlKind kind = oldCall.getAggregation().getKind();
        if (this.isReducible(kind)) {
            switch (kind) {
                case SUM: {
                    return this.reduceSum(oldAggRel, oldCall, newCalls, aggCallMapping);
                }
                case AVG: {
                    return this.reduceAvg(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs);
                }
                case COVAR_POP: {
                    return this.reduceCovariance(oldAggRel, oldCall, true, newCalls, aggCallMapping, inputExprs);
                }
                case COVAR_SAMP: {
                    return this.reduceCovariance(oldAggRel, oldCall, false, newCalls, aggCallMapping, inputExprs);
                }
                case REGR_SXX: {
                    assert (oldCall.getArgList().size() == 2) : oldCall.getArgList();
                    Integer x = oldCall.getArgList().get(0);
                    Integer y = oldCall.getArgList().get(1);
                    return this.reduceRegrSzz(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs, y, y, x);
                }
                case REGR_SYY: {
                    assert (oldCall.getArgList().size() == 2) : oldCall.getArgList();
                    Integer x = oldCall.getArgList().get(0);
                    Integer y = oldCall.getArgList().get(1);
                    return this.reduceRegrSzz(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs, x, x, y);
                }
                case STDDEV_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, true, newCalls, aggCallMapping, inputExprs);
                }
                case STDDEV_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, true, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, false, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, false, newCalls, aggCallMapping, inputExprs);
                }
            }
            throw Util.unexpected(kind);
        }
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int nGroups = oldAggRel.getGroupCount();
        List<RelDataType> oldArgTypes = SqlTypeUtil.projectTypes(oldAggRel.getInput().getRowType(), oldCall.getArgList());
        return rexBuilder.addAggCall(oldCall, nGroups, false, newCalls, aggCallMapping, oldArgTypes);
    }

    private AggregateCall createAggregateCallWithBinding(RelDataTypeFactory typeFactory, SqlAggFunction aggFunction, RelDataType operandType, WindowAggregate oldAggRel, AggregateCall oldCall, int argOrdinal, int filter) {
        Aggregate.AggCallBinding binding = new Aggregate.AggCallBinding(typeFactory, aggFunction, Collections.singletonList(operandType), oldAggRel.getGroupCount(), filter >= 0);
        return AggregateCall.create(aggFunction, oldCall.isDistinct(), oldCall.isApproximate(), ImmutableIntList.of(argOrdinal), filter, aggFunction.inferReturnType(binding), null);
    }

    private RexNode reduceAvg(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        int nGroups = oldAggRel.getGroupCount();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int iAvgInput = oldCall.getArgList().get(0);
        RelDataType avgInputType = this.getFieldType(oldAggRel.getInput(), iAvgInput);
        AggregateCall sumCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), oldCall.isApproximate(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.isApproximate(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        RexNode numeratorRef = rexBuilder.addAggCall(sumCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(avgInputType));
        RexNode denominatorRef = rexBuilder.addAggCall(countCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(avgInputType));
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RelDataType avgType = typeFactory.createTypeWithNullability(oldCall.getType(), numeratorRef.getType().isNullable());
        numeratorRef = rexBuilder.ensureType(avgType, numeratorRef, true);
        RexNode divideRef = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, numeratorRef, denominatorRef);
        return rexBuilder.makeCast(oldCall.getType(), divideRef);
    }

    private RexNode reduceSum(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping) {
        int nGroups = oldAggRel.getGroupCount();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int arg = oldCall.getArgList().get(0);
        RelDataType argType = this.getFieldType(oldAggRel.getInput(), arg);
        AggregateCall sumZeroCall = AggregateCall.create(SqlStdOperatorTable.SUM0, oldCall.isDistinct(), oldCall.isApproximate(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, oldCall.name);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.isApproximate(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel, null, null);
        RexNode sumZeroRef = rexBuilder.addAggCall(sumZeroCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(argType));
        if (!oldCall.getType().isNullable()) {
            return sumZeroRef;
        }
        RexNode countRef = rexBuilder.addAggCall(countCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(argType));
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countRef, rexBuilder.makeExactLiteral(BigDecimal.ZERO)), rexBuilder.makeCast(sumZeroRef.getType(), rexBuilder.constantNull()), sumZeroRef);
    }

    private RexNode reduceStddev(WindowAggregate oldAggRel, AggregateCall oldCall, boolean biased, boolean sqrt, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        RexNode div;
        RexNode denominator;
        int nGroups = oldAggRel.getGroupCount();
        RelOptCluster cluster = oldAggRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        assert (oldCall.getArgList().size() == 1) : oldCall.getArgList();
        int argOrdinal = oldCall.getArgList().get(0);
        RelDataType argOrdinalType = this.getFieldType(oldAggRel.getInput(), argOrdinal);
        RelDataType oldCallType = typeFactory.createTypeWithNullability(oldCall.getType(), argOrdinalType.isNullable());
        RexNode argRef = rexBuilder.ensureType(oldCallType, inputExprs.get(argOrdinal), true);
        RexNode argSquared = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, argRef, argRef);
        int argSquaredOrdinal = WindowAggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argSquared);
        AggregateCall sumArgSquaredAggCall = this.createAggregateCallWithBinding(typeFactory, SqlStdOperatorTable.SUM, argSquared.getType(), oldAggRel, oldCall, argSquaredOrdinal, -1);
        RexNode sumArgSquared = rexBuilder.addAggCall(sumArgSquaredAggCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(sumArgSquaredAggCall.getType()));
        AggregateCall sumArgAggCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), oldCall.isApproximate(), ImmutableIntList.of(argOrdinal), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        RexNode sumArg = rexBuilder.addAggCall(sumArgAggCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(sumArgAggCall.getType()));
        RexNode sumArgCast = rexBuilder.ensureType(oldCallType, sumArg, true);
        RexNode sumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, sumArgCast, sumArgCast);
        AggregateCall countArgAggCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.isApproximate(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel, null, null);
        RexNode countArg = rexBuilder.addAggCall(countArgAggCall, nGroups, false, newCalls, aggCallMapping, Collections.singletonList(argOrdinalType));
        RexNode avgSumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, sumSquaredArg, countArg);
        RexNode diff = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, sumArgSquared, avgSumSquaredArg);
        if (biased) {
            denominator = countArg;
        } else {
            RexLiteral one = rexBuilder.makeExactLiteral(BigDecimal.ONE);
            RexNode nul = rexBuilder.makeCast(countArg.getType(), rexBuilder.constantNull());
            RexNode countMinusOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, countArg, one);
            RexNode countEqOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countArg, one);
            denominator = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, countEqOne, nul, countMinusOne);
        }
        RexNode result = div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, diff, denominator);
        if (sqrt) {
            RexLiteral half = rexBuilder.makeExactLiteral(new BigDecimal("0.5"));
            result = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.POWER, div, half);
        }
        return rexBuilder.makeCast(oldCall.getType(), result);
    }

    private RexNode getSumAggregatedRexNode(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, RexBuilder rexBuilder, int argOrdinal, int filterArg) {
        AggregateCall aggregateCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), oldCall.isApproximate(), ImmutableIntList.of(argOrdinal), filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        return rexBuilder.addAggCall(aggregateCall, oldAggRel.getGroupCount(), false, newCalls, aggCallMapping, Collections.singletonList(aggregateCall.getType()));
    }

    private RexNode getSumAggregatedRexNodeWithBinding(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, RelDataType operandType, int argOrdinal, int filter) {
        RelOptCluster cluster = oldAggRel.getCluster();
        AggregateCall sumArgSquaredAggCall = this.createAggregateCallWithBinding(cluster.getTypeFactory(), SqlStdOperatorTable.SUM, operandType, oldAggRel, oldCall, argOrdinal, filter);
        return cluster.getRexBuilder().addAggCall(sumArgSquaredAggCall, oldAggRel.getGroupCount(), false, newCalls, aggCallMapping, Collections.singletonList(sumArgSquaredAggCall.getType()));
    }

    private RexNode getRegrCountRexNode(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, ImmutableIntList argOrdinals, List<RelDataType> operandTypes, int filterArg) {
        AggregateCall countArgAggCall = AggregateCall.create(SqlStdOperatorTable.REGR_COUNT, oldCall.isDistinct(), oldCall.isApproximate(), argOrdinals, filterArg, oldAggRel.getGroupCount(), oldAggRel, null, null);
        return oldAggRel.getCluster().getRexBuilder().addAggCall(countArgAggCall, oldAggRel.getGroupCount(), false, newCalls, aggCallMapping, operandTypes);
    }

    private RexNode reduceRegrSzz(WindowAggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs, int xIndex, int yIndex, int nullFilterIndex) {
        RelOptCluster cluster = oldAggRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        RelDataType argXType = this.getFieldType(oldAggRel.getInput(), xIndex);
        RelDataType argYType = xIndex == yIndex ? argXType : this.getFieldType(oldAggRel.getInput(), yIndex);
        RelDataType nullFilterIndexType = nullFilterIndex == yIndex ? argYType : this.getFieldType(oldAggRel.getInput(), yIndex);
        RelDataType oldCallType = typeFactory.createTypeWithNullability(oldCall.getType(), argXType.isNullable() || argYType.isNullable() || nullFilterIndexType.isNullable());
        RexNode argX = rexBuilder.ensureType(oldCallType, inputExprs.get(xIndex), true);
        RexNode argY = rexBuilder.ensureType(oldCallType, inputExprs.get(yIndex), true);
        RexNode argNullFilter = rexBuilder.ensureType(oldCallType, inputExprs.get(nullFilterIndex), true);
        RexNode argXArgY = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, argX, argY);
        int argSquaredOrdinal = WindowAggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argXArgY);
        RexNode argXAndYNotNullFilter = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, argX), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, argY)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, argNullFilter));
        int argXAndYNotNullFilterOrdinal = WindowAggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argXAndYNotNullFilter);
        RexNode sumXY = this.getSumAggregatedRexNodeWithBinding(oldAggRel, oldCall, newCalls, aggCallMapping, argXArgY.getType(), argSquaredOrdinal, argXAndYNotNullFilterOrdinal);
        RexNode sumXYCast = rexBuilder.ensureType(oldCallType, sumXY, true);
        RexNode sumX = this.getSumAggregatedRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, rexBuilder, xIndex, argXAndYNotNullFilterOrdinal);
        RexNode sumY = xIndex == yIndex ? sumX : this.getSumAggregatedRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, rexBuilder, yIndex, argXAndYNotNullFilterOrdinal);
        RexNode sumXSumY = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, sumX, sumY);
        RexNode countArg = this.getRegrCountRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, ImmutableIntList.of(xIndex), Collections.singletonList(argXType), argXAndYNotNullFilterOrdinal);
        RexLiteral zero = rexBuilder.makeExactLiteral(BigDecimal.ZERO);
        RexLiteral nul = rexBuilder.constantNull();
        RexNode avgSumXSumY = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countArg, zero), nul, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, sumXSumY, countArg));
        RexNode avgSumXSumYCast = rexBuilder.ensureType(oldCallType, avgSumXSumY, true);
        RexNode result = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, sumXYCast, avgSumXSumYCast);
        return rexBuilder.makeCast(oldCall.getType(), result);
    }

    private RexNode reduceCovariance(WindowAggregate oldAggRel, AggregateCall oldCall, boolean biased, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        RexNode denominator;
        RelOptCluster cluster = oldAggRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        assert (oldCall.getArgList().size() == 2) : oldCall.getArgList();
        int argXOrdinal = oldCall.getArgList().get(0);
        int argYOrdinal = oldCall.getArgList().get(1);
        RelDataType argXOrdinalType = this.getFieldType(oldAggRel.getInput(), argXOrdinal);
        RelDataType argYOrdinalType = this.getFieldType(oldAggRel.getInput(), argYOrdinal);
        RelDataType oldCallType = typeFactory.createTypeWithNullability(oldCall.getType(), argXOrdinalType.isNullable() || argYOrdinalType.isNullable());
        RexNode argX = rexBuilder.ensureType(oldCallType, inputExprs.get(argXOrdinal), true);
        RexNode argY = rexBuilder.ensureType(oldCallType, inputExprs.get(argYOrdinal), true);
        RexNode argXAndYNotNullFilter = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, argX), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, argY));
        int argXAndYNotNullFilterOrdinal = WindowAggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argXAndYNotNullFilter);
        RexNode argXY = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, argX, argY);
        int argXYOrdinal = WindowAggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argXY);
        RexNode sumXY = this.getSumAggregatedRexNodeWithBinding(oldAggRel, oldCall, newCalls, aggCallMapping, argXY.getType(), argXYOrdinal, argXAndYNotNullFilterOrdinal);
        RexNode sumX = this.getSumAggregatedRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, rexBuilder, argXOrdinal, argXAndYNotNullFilterOrdinal);
        RexNode sumY = this.getSumAggregatedRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, rexBuilder, argYOrdinal, argXAndYNotNullFilterOrdinal);
        RexNode sumXSumY = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, sumX, sumY);
        RexNode countArg = this.getRegrCountRexNode(oldAggRel, oldCall, newCalls, aggCallMapping, ImmutableIntList.of(argXOrdinal, argYOrdinal), Arrays.asList(argXOrdinalType, argYOrdinalType), argXAndYNotNullFilterOrdinal);
        RexNode avgSumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, sumXSumY, countArg);
        RexNode diff = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, sumXY, avgSumSquaredArg);
        if (biased) {
            denominator = countArg;
        } else {
            RexLiteral one = rexBuilder.makeExactLiteral(BigDecimal.ONE);
            RexNode nul = rexBuilder.makeCast(countArg.getType(), rexBuilder.constantNull());
            RexNode countMinusOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, countArg, one);
            RexNode countEqOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countArg, one);
            denominator = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, countEqOne, nul, countMinusOne);
        }
        RexNode result = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, diff, denominator);
        return rexBuilder.makeCast(oldCall.getType(), result);
    }

    private static <T> int lookupOrAdd(List<T> list, T element) {
        int ordinal = list.indexOf(element);
        if (ordinal == -1) {
            ordinal = list.size();
            list.add(element);
        }
        return ordinal;
    }

    protected void newAggregateRel(RelBuilder relBuilder, WindowAggregate oldAggregate, List<AggregateCall> newCalls) {
        LogicalWindowAggregate oldWindowAgg = (LogicalWindowAggregate)oldAggregate;
        relBuilder.push(oldWindowAgg.copy(oldWindowAgg.getTraitSet(), relBuilder.peek(), (Seq<AggregateCall>)JavaConversions.asScalaBuffer(newCalls).toSeq()));
    }

    protected void newCalcRel(RelBuilder relBuilder, RelDataType rowType, List<RexNode> exprs) {
        int numExprs = exprs.size();
        List<RelDataTypeField> rowTypeSubList = rowType.getFieldList().subList(numExprs, rowType.getFieldCount());
        for (RelDataTypeField f : rowTypeSubList) {
            exprs.add(relBuilder.field(f.getName()));
        }
        relBuilder.project(exprs, rowType.getFieldNames());
    }

    private RelDataType getFieldType(RelNode relNode, int i) {
        RelDataTypeField inputField = relNode.getRowType().getFieldList().get(i);
        return inputField.getType();
    }
}

