/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.physical.common;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalIntermediateTableScan;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.nodes.physical.PhysicalTableSourceScan;
import org.apache.flink.table.plan.rules.physical.common.CommonTemporalTableJoinRule;
import org.apache.flink.table.plan.util.TemporalJoinUtil$;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.None$;
import scala.Option;
import scala.Some;

public abstract class CommonTemporalTableJoinRule$class {
    public static boolean matches(CommonTemporalTableJoinRule $this, FlinkLogicalJoin join, TableScan tableScan) {
        if (TemporalJoinUtil$.MODULE$.containsTemporalJoinCondition(join.getCondition())) {
            return false;
        }
        if ($this.findTableSource(tableScan).isEmpty()) {
            throw new TableException("Temporal table join only support join on a TableSource not on a DataStream or an intermediate query");
        }
        return $this.isLookupableTableSource(tableScan);
    }

    public static Option findTableSource(CommonTemporalTableJoinRule $this, RelNode relNode) {
        Option<TableSource> option;
        RelNode relNode2 = relNode;
        if (relNode2 instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan flinkLogicalTableSourceScan = (FlinkLogicalTableSourceScan)relNode2;
            option = new Some((Object)flinkLogicalTableSourceScan.tableSource());
        } else if (relNode2 instanceof PhysicalTableSourceScan) {
            PhysicalTableSourceScan physicalTableSourceScan = (PhysicalTableSourceScan)relNode2;
            option = new Some((Object)physicalTableSourceScan.tableSource());
        } else if (relNode2 instanceof FlinkLogicalIntermediateTableScan) {
            FlinkLogicalIntermediateTableScan flinkLogicalIntermediateTableScan = (FlinkLogicalIntermediateTableScan)relNode2;
            option = $this.findTableSource(flinkLogicalIntermediateTableScan.intermediateTable().relNode());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public static boolean isLookupableTableSource(CommonTemporalTableJoinRule $this, RelNode relNode) {
        boolean bl;
        RelNode relNode2 = relNode;
        if (relNode2 instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan flinkLogicalTableSourceScan = (FlinkLogicalTableSourceScan)relNode2;
            bl = flinkLogicalTableSourceScan.tableSource() instanceof LookupableTableSource;
        } else if (relNode2 instanceof PhysicalTableSourceScan) {
            PhysicalTableSourceScan physicalTableSourceScan = (PhysicalTableSourceScan)relNode2;
            bl = physicalTableSourceScan.tableSource() instanceof LookupableTableSource;
        } else if (relNode2 instanceof FlinkLogicalIntermediateTableScan) {
            FlinkLogicalIntermediateTableScan flinkLogicalIntermediateTableScan = (FlinkLogicalIntermediateTableScan)relNode2;
            bl = $this.isLookupableTableSource(flinkLogicalIntermediateTableScan.intermediateTable().relNode());
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(CommonTemporalTableJoinRule $this) {
    }
}

