/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.types.DataType;

@Internal
public class IndexKey
implements Comparable<IndexKey>,
Serializable {
    private static final long serialVersionUID = -7842311969684389493L;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final long[] EMPTY_LONGS = new long[0];
    private static final BitSet EMPTY = BitSet.valueOf(EMPTY_LONGS);
    private final List<Integer> definedColumns;
    private final Map<Integer, Tuple2<DataType, Object>> constantsMap = new HashMap<Integer, Tuple2<DataType, Object>>();
    private final BitSet columnSet;
    private final boolean unique;

    private IndexKey(List<Integer> columns, boolean unique) {
        BitSet columnSet = IndexKey.createBitSet(columns);
        if (columnSet.isEmpty()) {
            throw new IllegalArgumentException("Index key must contains at least one column.");
        }
        this.definedColumns = columns;
        this.columnSet = columnSet;
        this.unique = unique;
    }

    public boolean isIndex(int[] columns) {
        List<Integer> cols = Arrays.stream(columns).boxed().collect(Collectors.toList());
        BitSet other = IndexKey.createBitSet(cols);
        int i = this.columnSet.nextSetBit(0);
        while (i >= 0) {
            if (!other.get(i)) {
                return false;
            }
            i = this.columnSet.nextSetBit(i + 1);
        }
        return true;
    }

    public static IndexKey of(boolean unique, int ... columns) {
        List<Integer> cols = Arrays.stream(columns).boxed().collect(Collectors.toList());
        return new IndexKey(cols, unique);
    }

    public static IndexKey of(boolean unique, Iterable<Integer> columns) {
        List<Integer> cols = StreamSupport.stream(columns.spliterator(), false).collect(Collectors.toList());
        return new IndexKey(cols, unique);
    }

    public void addConstantKey(int columnIndex, Tuple2<DataType, Object> constantValue) {
        if (!this.definedColumns.contains(columnIndex)) {
            throw new IllegalArgumentException("Given columnIndex:" + columnIndex + " is invalid of Index(" + StringUtils.join(this.definedColumns, (String)",") + ")");
        }
        this.constantsMap.put(columnIndex, constantValue);
    }

    public Map<Integer, Tuple2<DataType, Object>> getConstantsMap() {
        return this.constantsMap;
    }

    public List<Integer> getDefinedColumns() {
        return this.definedColumns;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Internal
    public int[] toArray() {
        int[] integers = new int[this.columnSet.cardinality()];
        int j2 = 0;
        int i = this.columnSet.nextSetBit(0);
        while (i >= 0) {
            integers[j2++] = i;
            i = this.columnSet.nextSetBit(i + 1);
        }
        return integers;
    }

    public String toString() {
        return this.columnSet.toString();
    }

    private static BitSet createBitSet(Iterable<Integer> bits) {
        int max = -1;
        for (int bit : bits) {
            max = Math.max(bit, max);
        }
        if (max == -1) {
            return EMPTY;
        }
        long[] words = new long[IndexKey.wordIndex(max) + 1];
        for (int bit : bits) {
            int wordIndex;
            int n = wordIndex = IndexKey.wordIndex(bit);
            words[n] = words[n] | 1L << bit;
        }
        return BitSet.valueOf(words);
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    @Override
    public int compareTo(IndexKey o) {
        int tp;
        int n = tp = this.unique ? 0 : 1;
        int op = null == o ? 2 : (o.unique ? 0 : 1);
        return tp - op;
    }
}

