/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.plan.nodes.calcite.Expand;
import org.apache.flink.table.plan.nodes.calcite.LogicalRank;
import org.apache.flink.table.plan.nodes.calcite.Rank;
import org.apache.flink.table.plan.nodes.calcite.WindowAggregate;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecGroupAggregateBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalHashWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalSortWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecRank;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecWindowAggregateBase;
import org.apache.flink.table.plan.nodes.physical.stream.StreamExecRank;
import org.apache.flink.table.plan.util.ConstantRankRange;
import org.apache.flink.table.plan.util.FlinkRelMdUtil;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import org.apache.flink.table.plan.util.RankRange;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlinkRelMdUtil$ {
    public static final FlinkRelMdUtil$ MODULE$;

    static {
        new FlinkRelMdUtil$();
    }

    public RexNode makeSemiJoinSelectivityRexNode(RelMetadataQuery mq, SemiJoin rel) {
        JoinInfo joinInfo = rel.analyzeCondition();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        return this.makeSemiJoinSelectivityRexNode(mq, joinInfo, rel.getLeft(), rel.getRight(), rel.isAnti, rexBuilder);
    }

    private RexNode makeSemiJoinSelectivityRexNode(RelMetadataQuery mq, JoinInfo joinInfo, RelNode left, RelNode right, boolean isAnti, RexBuilder rexBuilder) {
        double antiJoinSelectivity;
        Double equiSelectivity = joinInfo.leftKeys.isEmpty() ? Predef$.MODULE$.double2Double(1.0) : Predef$.MODULE$.double2Double(RelMdUtil.computeSemiJoinSelectivity(mq, left, right, joinInfo.leftKeys, joinInfo.rightKeys));
        double nonEquiSelectivity = RelMdUtil.guessSelectivity(joinInfo.getRemaining(rexBuilder));
        double semiJoinSelectivity = Predef$.MODULE$.Double2double(equiSelectivity) * nonEquiSelectivity;
        double selectivity = isAnti ? ((antiJoinSelectivity = 1.0 - semiJoinSelectivity) == 0.0 ? 0.1 : antiJoinSelectivity) : semiJoinSelectivity;
        return rexBuilder.makeCall((SqlOperator)RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC, rexBuilder.makeApproxLiteral(new BigDecimal(selectivity)));
    }

    public RexNode makeNamePropertiesSelectivityRexNode(WindowAggregate winAgg, RexNode predicate) {
        return this.makeNamePropertiesSelectivityRexNode(winAgg, winAgg.getNamedProperties(), predicate);
    }

    public RexNode makeNamePropertiesSelectivityRexNode(BatchExecWindowAggregateBase globalWinAgg, RexNode predicate) {
        Predef$.MODULE$.require(globalWinAgg.isFinal(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "local window agg does not contain NamedProperties!";
            }
        });
        return this.makeNamePropertiesSelectivityRexNode(globalWinAgg, globalWinAgg.getNamedProperties(), predicate);
    }

    public RexNode makeNamePropertiesSelectivityRexNode(SingleRel winAgg, Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties, RexNode predicate) {
        Object object;
        if (predicate == null || predicate.isAlwaysTrue() || namedProperties.isEmpty()) {
            return predicate;
        }
        RexBuilder rexBuilder = winAgg.getCluster().getRexBuilder();
        int namePropertiesStartIdx = winAgg.getRowType().getFieldCount() - namedProperties.size();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, namePropertiesStartIdx), predicate, pushable, notPushable);
        if (JavaConversions$.MODULE$.asScalaBuffer(notPushable).nonEmpty()) {
            RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
            double selectivity = RelMdUtil.guessSelectivity(pred);
            RexNode fun = rexBuilder.makeCall((SqlOperator)RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC, rexBuilder.makeApproxLiteral(new BigDecimal(selectivity)));
            object = BoxesRunTime.boxToBoolean((boolean)pushable.add(fun));
        } else {
            object = BoxedUnit.UNIT;
        }
        return RexUtil.composeConjunction(rexBuilder, pushable, true);
    }

    public Double cardOfCalcExpr(RelMetadataQuery mq, Calc calc, RexNode expr) {
        return expr.accept(new FlinkRelMdUtil.CardOfCalcExpr(mq, calc));
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, Aggregate aggRel) {
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        ArrayBuffer aggCalls = new ArrayBuffer();
        int[] groupSet = aggRel.getGroupSet().toArray();
        Tuple2<int[], Seq<AggregateCall>> tuple2 = FlinkRelOptUtil$.MODULE$.checkAndSplitAggCalls(aggRel);
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] auxGroupSet = (int[])tuple2._1();
            Seq otherAggCalls = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)auxGroupSet, (Object)otherAggCalls);
            int[] auxGroupSet2 = (int[])tuple23._1();
            Seq otherAggCalls2 = (Seq)tuple23._2();
            int[] fullGroupSet = (int[])Predef$.MODULE$.intArrayOps(groupSet).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(auxGroupSet2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            boolean containsAllAggGroupKeys = Predef$.MODULE$.intArrayOps(fullGroupSet).indices().forall((Function1)new Serializable(groupKey){
                public static final long serialVersionUID = 0L;
                private final ImmutableBitSet groupKey$1;

                public final boolean apply(int x$1) {
                    return this.apply$mcZI$sp(x$1);
                }

                public boolean apply$mcZI$sp(int x$1) {
                    return this.groupKey$1.get(x$1);
                }
                {
                    this.groupKey$1 = groupKey$1;
                }
            });
            JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)groupKey).foreach((Function1)new Serializable(aggRel, childKeyBuilder, aggCalls, otherAggCalls2, fullGroupSet, containsAllAggGroupKeys){
                public static final long serialVersionUID = 0L;
                private final Aggregate aggRel$1;
                private final ImmutableBitSet.Builder childKeyBuilder$1;
                private final ArrayBuffer aggCalls$1;
                private final Seq otherAggCalls$1;
                private final int[] fullGroupSet$1;
                private final boolean containsAllAggGroupKeys$1;

                public final Object apply(Integer bit) {
                    Object object;
                    if (Predef$.MODULE$.Integer2int(bit) < this.fullGroupSet$1.length) {
                        object = this.childKeyBuilder$1.set(this.fullGroupSet$1[Predef$.MODULE$.Integer2int(bit)]);
                    } else if (this.containsAllAggGroupKeys$1) {
                        object = BoxedUnit.UNIT;
                    } else {
                        AggregateCall agg = (AggregateCall)JavaConversions$.MODULE$.seqAsJavaList(this.otherAggCalls$1).get(Predef$.MODULE$.Integer2int(bit) - (this.fullGroupSet$1.length + this.aggRel$1.getIndicatorCount()));
                        object = this.aggCalls$1.$plus$eq((Object)agg);
                    }
                    return object;
                }
                {
                    this.aggRel$1 = aggRel$1;
                    this.childKeyBuilder$1 = childKeyBuilder$1;
                    this.aggCalls$1 = aggCalls$1;
                    this.otherAggCalls$1 = otherAggCalls$1;
                    this.fullGroupSet$1 = fullGroupSet$1;
                    this.containsAllAggGroupKeys$1 = containsAllAggGroupKeys$1;
                }
            });
            return new Tuple2((Object)childKeyBuilder.build(), aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, WindowAggregate aggRel) {
        int namedWindowStartIndex = aggRel.getRowType().getFieldCount() - aggRel.getNamedProperties().size();
        if (JavaConversions$.MODULE$.asScalaBuffer(groupKey.toList()).exists((Function1)new Serializable(namedWindowStartIndex){
            public static final long serialVersionUID = 0L;
            private final int namedWindowStartIndex$1;

            public final boolean apply(Integer x$2) {
                return Predef$.MODULE$.Integer2int(x$2) >= this.namedWindowStartIndex$1;
            }
            {
                this.namedWindowStartIndex$1 = namedWindowStartIndex$1;
            }
        })) {
            throw new TableException("GroupKey with namedWindowProperties should not be dealt with here.");
        }
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        ArrayBuffer aggCalls = new ArrayBuffer();
        int[] groupSet = aggRel.getGroupSet().toArray();
        Seq<AggregateCall> otherAggCalls = aggRel.getAggCallList();
        boolean containsAllAggGroupKeys = Predef$.MODULE$.intArrayOps(groupSet).indices().forall((Function1)new Serializable(groupKey){
            public static final long serialVersionUID = 0L;
            private final ImmutableBitSet groupKey$2;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return this.groupKey$2.get(x$1);
            }
            {
                this.groupKey$2 = groupKey$2;
            }
        });
        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)groupKey).foreach((Function1)new Serializable(childKeyBuilder, aggCalls, groupSet, otherAggCalls, containsAllAggGroupKeys){
            public static final long serialVersionUID = 0L;
            private final ImmutableBitSet.Builder childKeyBuilder$2;
            private final ArrayBuffer aggCalls$2;
            private final int[] groupSet$1;
            private final Seq otherAggCalls$2;
            private final boolean containsAllAggGroupKeys$2;

            public final Object apply(Integer bit) {
                Object object;
                if (Predef$.MODULE$.Integer2int(bit) < this.groupSet$1.length) {
                    object = this.childKeyBuilder$2.set(this.groupSet$1[Predef$.MODULE$.Integer2int(bit)]);
                } else if (this.containsAllAggGroupKeys$2) {
                    object = BoxedUnit.UNIT;
                } else {
                    AggregateCall agg = (AggregateCall)JavaConversions$.MODULE$.seqAsJavaList(this.otherAggCalls$2).get(Predef$.MODULE$.Integer2int(bit) - this.groupSet$1.length);
                    object = this.aggCalls$2.$plus$eq((Object)agg);
                }
                return object;
            }
            {
                this.childKeyBuilder$2 = childKeyBuilder$2;
                this.aggCalls$2 = aggCalls$2;
                this.groupSet$1 = groupSet$1;
                this.otherAggCalls$2 = otherAggCalls$2;
                this.containsAllAggGroupKeys$2 = containsAllAggGroupKeys$2;
            }
        });
        return new Tuple2((Object)childKeyBuilder.build(), aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)));
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, BatchExecGroupAggregateBase aggRel) {
        Predef$.MODULE$.require(!aggRel.isFinal() || !aggRel.isMerge(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot handle global agg which has local agg!";
            }
        });
        return this.setChildKeysOfAgg(groupKey, aggRel);
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, BatchExecWindowAggregateBase aggRel) {
        Predef$.MODULE$.require(!aggRel.isFinal() || !aggRel.isMerge(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot handle global agg which has local agg!";
            }
        });
        return this.setChildKeysOfAgg(groupKey, aggRel);
    }

    private Tuple2<ImmutableBitSet, AggregateCall[]> setChildKeysOfAgg(ImmutableBitSet groupKey, SingleRel aggRel) {
        block8: {
            Tuple2 tuple2;
            block5: {
                SingleRel singleRel;
                block7: {
                    block6: {
                        block4: {
                            singleRel = aggRel;
                            if (!(singleRel instanceof BatchExecLocalSortWindowAggregate)) break block4;
                            BatchExecLocalSortWindowAggregate batchExecLocalSortWindowAggregate = (BatchExecLocalSortWindowAggregate)singleRel;
                            tuple2 = new Tuple2(batchExecLocalSortWindowAggregate.getAggCallList(), Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalSortWindowAggregate.inputTimestampIndex()}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                            break block5;
                        }
                        if (!(singleRel instanceof BatchExecLocalHashWindowAggregate)) break block6;
                        BatchExecLocalHashWindowAggregate batchExecLocalHashWindowAggregate = (BatchExecLocalHashWindowAggregate)singleRel;
                        tuple2 = new Tuple2(batchExecLocalHashWindowAggregate.getAggCallList(), Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalHashWindowAggregate.inputTimestampIndex()}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        break block5;
                    }
                    if (!(singleRel instanceof BatchExecWindowAggregateBase)) break block7;
                    BatchExecWindowAggregateBase batchExecWindowAggregateBase = (BatchExecWindowAggregateBase)singleRel;
                    tuple2 = new Tuple2(batchExecWindowAggregateBase.getAggCallList(), Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                    break block5;
                }
                if (!(singleRel instanceof BatchExecGroupAggregateBase)) break block8;
                BatchExecGroupAggregateBase batchExecGroupAggregateBase = (BatchExecGroupAggregateBase)singleRel;
                tuple2 = new Tuple2(batchExecGroupAggregateBase.getAggCallList(), Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Seq aggCalls = (Seq)tuple22._1();
                int[] fullGroupSet = (int[])tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)aggCalls, (Object)fullGroupSet);
                Seq aggCalls2 = (Seq)tuple24._1();
                int[] fullGroupSet2 = (int[])tuple24._2();
                boolean containsAllAggGroupKeys = Predef$.MODULE$.intArrayOps(fullGroupSet2).indices().forall((Function1)new Serializable(groupKey){
                    public static final long serialVersionUID = 0L;
                    private final ImmutableBitSet groupKey$3;

                    public final boolean apply(int x$1) {
                        return this.apply$mcZI$sp(x$1);
                    }

                    public boolean apply$mcZI$sp(int x$1) {
                        return this.groupKey$3.get(x$1);
                    }
                    {
                        this.groupKey$3 = groupKey$3;
                    }
                });
                ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
                ArrayBuffer aggs = new ArrayBuffer();
                JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)groupKey).foreach((Function1)new Serializable(aggCalls2, fullGroupSet2, containsAllAggGroupKeys, childKeyBuilder, aggs){
                    public static final long serialVersionUID = 0L;
                    private final Seq aggCalls$3;
                    private final int[] fullGroupSet$2;
                    private final boolean containsAllAggGroupKeys$3;
                    private final ImmutableBitSet.Builder childKeyBuilder$3;
                    private final ArrayBuffer aggs$1;

                    public final Object apply(Integer bit) {
                        Object object;
                        if (Predef$.MODULE$.Integer2int(bit) < this.fullGroupSet$2.length) {
                            object = this.childKeyBuilder$3.set(this.fullGroupSet$2[Predef$.MODULE$.Integer2int(bit)]);
                        } else if (this.containsAllAggGroupKeys$3) {
                            object = BoxedUnit.UNIT;
                        } else {
                            AggregateCall agg = (AggregateCall)JavaConversions$.MODULE$.seqAsJavaList(this.aggCalls$3).get(Predef$.MODULE$.Integer2int(bit) - this.fullGroupSet$2.length);
                            object = this.aggs$1.$plus$eq((Object)agg);
                        }
                        return object;
                    }
                    {
                        this.aggCalls$3 = aggCalls$3;
                        this.fullGroupSet$2 = fullGroupSet$2;
                        this.containsAllAggGroupKeys$3 = containsAllAggGroupKeys$3;
                        this.childKeyBuilder$3 = childKeyBuilder$3;
                        this.aggs$1 = aggs$1;
                    }
                });
                return new Tuple2((Object)childKeyBuilder.build(), aggs.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)));
            }
            throw new MatchError((Object)tuple22);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown relnode type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggRel.getRelTypeName()})));
    }

    public ImmutableBitSet setChildKeysOfWinAgg(ImmutableBitSet groupKey, BatchExecWindowAggregateBase globalWinAgg) {
        Predef$.MODULE$.require(globalWinAgg.isMerge(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot handle global agg which does not have local agg!";
            }
        });
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        Predef$.MODULE$.intArrayOps(groupKey.toArray()).foreach((Function1)new Serializable(globalWinAgg, childKeyBuilder){
            public static final long serialVersionUID = 0L;
            private final BatchExecWindowAggregateBase globalWinAgg$1;
            private final ImmutableBitSet.Builder childKeyBuilder$4;

            public final ImmutableBitSet.Builder apply(int key) {
                return key < this.globalWinAgg$1.getGrouping().length ? this.childKeyBuilder$4.set(key) : this.childKeyBuilder$4.set(key + 1);
            }
            {
                this.globalWinAgg$1 = globalWinAgg$1;
                this.childKeyBuilder$4 = childKeyBuilder$4;
            }
        });
        return childKeyBuilder.build();
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> splitGroupKeysOnAggregate(SingleRel agg, ImmutableBitSet groupKey) {
        block9: {
            Tuple2<ImmutableBitSet, AggregateCall[]> tuple2;
            block10: {
                Tuple2 tuple22;
                block5: {
                    Tuple2 tuple23;
                    SingleRel singleRel;
                    block7: {
                        Tuple2<ImmutableBitSet, AggregateCall[]> tuple24;
                        block8: {
                            Tuple2 tuple25;
                            block6: {
                                block2: {
                                    Tuple2<int[], Seq<AggregateCall>> tuple26;
                                    block3: {
                                        Tuple2<ImmutableBitSet, AggregateCall[]> tuple27;
                                        block4: {
                                            Tuple2 tuple28;
                                            int[] auxGroupSet;
                                            int[] nArray;
                                            singleRel = agg;
                                            if (!(singleRel instanceof Aggregate)) break block2;
                                            Aggregate aggregate = (Aggregate)singleRel;
                                            tuple26 = FlinkRelOptUtil$.MODULE$.checkAndSplitAggCalls(aggregate);
                                            if (tuple26 == null) break block3;
                                            int[] auxGroupSet2 = nArray = (auxGroupSet = (int[])tuple26._1());
                                            tuple27 = this.setAggChildKeys(groupKey, aggregate);
                                            if (tuple27 == null) break block4;
                                            ImmutableBitSet childKeys = (ImmutableBitSet)tuple27._1();
                                            AggregateCall[] aggCalls = (AggregateCall[])tuple27._2();
                                            Tuple2 tuple29 = tuple28 = new Tuple2((Object)childKeys, (Object)aggCalls);
                                            ImmutableBitSet childKeys2 = (ImmutableBitSet)tuple29._1();
                                            AggregateCall[] aggCalls2 = (AggregateCall[])tuple29._2();
                                            ImmutableBitSet childKeyExcludeAuxKey = this.removeAuxKey$1(childKeys2, aggregate.getGroupSet().toArray(), auxGroupSet2);
                                            tuple22 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls2);
                                            break block5;
                                        }
                                        throw new MatchError(tuple27);
                                    }
                                    throw new MatchError(tuple26);
                                }
                                if (!(singleRel instanceof WindowAggregate)) break block6;
                                WindowAggregate windowAggregate = (WindowAggregate)singleRel;
                                tuple22 = this.setAggChildKeys(groupKey, windowAggregate);
                                break block5;
                            }
                            if (!(singleRel instanceof BatchExecGroupAggregateBase)) break block7;
                            BatchExecGroupAggregateBase batchExecGroupAggregateBase = (BatchExecGroupAggregateBase)singleRel;
                            tuple24 = this.setAggChildKeys(groupKey, batchExecGroupAggregateBase);
                            if (tuple24 == null) break block8;
                            ImmutableBitSet childKeys = (ImmutableBitSet)tuple24._1();
                            AggregateCall[] aggCalls = (AggregateCall[])tuple24._2();
                            Tuple2 tuple210 = tuple25 = new Tuple2((Object)childKeys, (Object)aggCalls);
                            ImmutableBitSet childKeys3 = (ImmutableBitSet)tuple210._1();
                            AggregateCall[] aggCalls3 = (AggregateCall[])tuple210._2();
                            ImmutableBitSet childKeyExcludeAuxKey = this.removeAuxKey$1(childKeys3, batchExecGroupAggregateBase.getGrouping(), batchExecGroupAggregateBase.getAuxGrouping());
                            tuple22 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls3);
                            break block5;
                        }
                        throw new MatchError(tuple24);
                    }
                    if (!(singleRel instanceof BatchExecWindowAggregateBase)) break block9;
                    BatchExecWindowAggregateBase batchExecWindowAggregateBase = (BatchExecWindowAggregateBase)singleRel;
                    tuple2 = this.setAggChildKeys(groupKey, batchExecWindowAggregateBase);
                    if (tuple2 == null) break block10;
                    ImmutableBitSet childKeys = (ImmutableBitSet)tuple2._1();
                    AggregateCall[] aggCalls = (AggregateCall[])tuple2._2();
                    Tuple2 tuple211 = tuple23 = new Tuple2((Object)childKeys, (Object)aggCalls);
                    ImmutableBitSet childKeys4 = (ImmutableBitSet)tuple211._1();
                    AggregateCall[] aggCalls4 = (AggregateCall[])tuple211._2();
                    ImmutableBitSet childKeyExcludeAuxKey = this.removeAuxKey$1(childKeys4, batchExecWindowAggregateBase.getGrouping(), batchExecWindowAggregateBase.getAuxGrouping());
                    tuple22 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls4);
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown aggregate type: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{agg.getRelTypeName()})));
    }

    public RexNode setChildPredicateOfWinAgg(RexNode predicate, BatchExecWindowAggregateBase globalWinAgg) {
        Predef$.MODULE$.require(globalWinAgg.isMerge(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot handle global agg which does not have local agg!";
            }
        });
        if (predicate == null) {
            return null;
        }
        int[] fullGrouping = (int[])Predef$.MODULE$.intArrayOps(globalWinAgg.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(globalWinAgg.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return RexUtil.shift(predicate, fullGrouping.length, 1);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(Aggregate agg, RexNode predicate) {
        int[] fullGroupSet = FlinkRelOptUtil$.MODULE$.checkAndGetFullGroupSet(agg);
        return this.splitPredicateOnAgg(fullGroupSet, agg, predicate);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(WindowAggregate agg, RexNode predicate) {
        return this.splitPredicateOnAgg(agg.getGroupSet().toArray(), agg, predicate);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(BatchExecGroupAggregateBase agg, RexNode predicate) {
        return this.splitPredicateOnAgg((int[])Predef$.MODULE$.intArrayOps(agg.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(agg.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), agg, predicate);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(BatchExecWindowAggregateBase agg, RexNode predicate) {
        return this.splitPredicateOnAgg((int[])Predef$.MODULE$.intArrayOps(agg.getGrouping()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(agg.getAuxGrouping()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), agg, predicate);
    }

    private Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAgg(int[] grouping, SingleRel agg, RexNode predicate) {
        None$ none$;
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        int numOfGroupKey = grouping.length;
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, numOfGroupKey), predicate, pushable, notPushable);
        RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
        if (pushable.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            List<RelDataTypeField> aggOutputFields = agg.getRowType().getFieldList();
            List<RelDataTypeField> aggInputFields = agg.getInput().getRowType().getFieldList();
            int[] adjustments = new int[aggOutputFields.size()];
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(grouping).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(adjustments){
                public static final long serialVersionUID = 0L;
                private final int[] adjustments$1;

                public final void apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int bit = tuple2._1$mcI$sp();
                        int index = tuple2._2$mcI$sp();
                        this.adjustments$1[index] = bit - index;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.adjustments$1 = adjustments$1;
                }
            });
            Buffer pushableConditions = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(pushable).map((Function1)new Serializable(rexBuilder, aggOutputFields, aggInputFields, adjustments){
                public static final long serialVersionUID = 0L;
                private final RexBuilder rexBuilder$1;
                private final List aggOutputFields$1;
                private final List aggInputFields$1;
                private final int[] adjustments$1;

                public final RexNode apply(RexNode pushCondition) {
                    return pushCondition.accept(new RelOptUtil.RexInputConverter(this.rexBuilder$1, this.aggOutputFields$1, this.aggInputFields$1, this.adjustments$1));
                }
                {
                    this.rexBuilder$1 = rexBuilder$1;
                    this.aggOutputFields$1 = aggOutputFields$1;
                    this.aggInputFields$1 = aggInputFields$1;
                    this.adjustments$1 = adjustments$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            none$ = Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.bufferAsJavaList(pushableConditions), true));
        }
        None$ childPred = none$;
        None$ restPred = notPushable.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, notPushable, true));
        return new Tuple2((Object)childPred, (Object)restPred);
    }

    public int getRankFunColumnIndex(Rank rank) {
        Rank rank2;
        block6: {
            int n;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            rank2 = rank;
                            if (!(rank2 instanceof LogicalRank)) break block2;
                            n = this.getRankFunColumnIndex(rank, true);
                            break block3;
                        }
                        if (!(rank2 instanceof FlinkLogicalRank)) break block4;
                        FlinkLogicalRank flinkLogicalRank = (FlinkLogicalRank)rank2;
                        n = this.getRankFunColumnIndex(rank, flinkLogicalRank.outputRankFunColumn());
                        break block3;
                    }
                    if (!(rank2 instanceof BatchExecRank)) break block5;
                    BatchExecRank batchExecRank = (BatchExecRank)rank2;
                    n = this.getRankFunColumnIndex(rank, batchExecRank.outputRankFunColumn());
                    break block3;
                }
                if (!(rank2 instanceof StreamExecRank)) break block6;
                StreamExecRank streamExecRank = (StreamExecRank)rank2;
                n = this.getRankFunColumnIndex(rank, streamExecRank.outputRankFunColumn());
            }
            return n;
        }
        throw new MatchError((Object)rank2);
    }

    private int getRankFunColumnIndex(Rank rank, boolean outputRankFunColumn) {
        int n;
        if (outputRankFunColumn) {
            Predef$.MODULE$.require(rank.getRowType().getFieldCount() == rank.getInput().getRowType().getFieldCount() + 1);
            n = rank.getRowType().getFieldCount() - 1;
        } else {
            Predef$.MODULE$.require(rank.getRowType().getFieldCount() == rank.getInput().getRowType().getFieldCount());
            n = -1;
        }
        return n;
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnRank(Rank rank, RexNode predicate) {
        int rankFunColumnIndex = this.getRankFunColumnIndex(rank);
        if (predicate == null || predicate.isAlwaysTrue() || rankFunColumnIndex < 0) {
            return new Tuple2((Object)new Some((Object)predicate), (Object)None$.MODULE$);
        }
        ArrayList<RexNode> rankNodes = new ArrayList<RexNode>();
        ArrayList<RexNode> nonRankNodes = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, rankFunColumnIndex), predicate, nonRankNodes, rankNodes);
        RexBuilder rexBuilder = rank.getCluster().getRexBuilder();
        None$ nonRankPred = nonRankNodes.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, nonRankNodes, true));
        None$ rankPred = rankNodes.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, rankNodes, true));
        return new Tuple2((Object)nonRankPred, (Object)rankPred);
    }

    public Double getRankRangeNdv(RankRange rankRange) {
        Double d;
        RankRange rankRange2 = rankRange;
        if (rankRange2 instanceof ConstantRankRange) {
            ConstantRankRange constantRankRange = (ConstantRankRange)rankRange2;
            d = Predef$.MODULE$.double2Double((double)(constantRankRange.rankEnd() - constantRankRange.rankStart() + 1L));
        } else {
            d = Predef$.MODULE$.double2Double(100.0);
        }
        return d;
    }

    public Tuple2<ImmutableBitSet, ImmutableBitSet> splitColumnsIntoLeftAndRight(int leftCount, ImmutableBitSet columns) {
        ImmutableBitSet.Builder leftBuilder = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightBuilder = ImmutableBitSet.builder();
        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)columns).foreach((Function1)new Serializable(leftCount, leftBuilder, rightBuilder){
            public static final long serialVersionUID = 0L;
            private final int leftCount$1;
            private final ImmutableBitSet.Builder leftBuilder$1;
            private final ImmutableBitSet.Builder rightBuilder$1;

            public final ImmutableBitSet.Builder apply(Integer bit) {
                return Predef$.MODULE$.Integer2int(bit) < this.leftCount$1 ? this.leftBuilder$1.set(Predef$.MODULE$.Integer2int(bit)) : this.rightBuilder$1.set(Predef$.MODULE$.Integer2int(bit) - this.leftCount$1);
            }
            {
                this.leftCount$1 = leftCount$1;
                this.leftBuilder$1 = leftBuilder$1;
                this.rightBuilder$1 = rightBuilder$1;
            }
        });
        return new Tuple2((Object)leftBuilder.build(), (Object)rightBuilder.build());
    }

    public Double getAggregationRatioIfNdvUnavailable(int groupingLength) {
        return Predef$.MODULE$.double2Double(1.0 - package$.MODULE$.exp(-0.1 * (double)groupingLength));
    }

    public Double getRowCountOfLocalAgg(int parallelism, Double inputRowCount, Double globalAggRowCount) {
        return Predef$.MODULE$.double2Double(Math.min((1.0 - package$.MODULE$.pow(1.0 - 1.0 / (double)parallelism, Predef$.MODULE$.Double2double(inputRowCount) / Predef$.MODULE$.Double2double(globalAggRowCount))) * Predef$.MODULE$.Double2double(globalAggRowCount) * (double)parallelism, Predef$.MODULE$.Double2double(inputRowCount)));
    }

    public Double adaptNdvBasedOnSelectivity(Double rowCount, Double distinctRowCount, Double selectivity) {
        double ndv = Math.min(Predef$.MODULE$.Double2double(distinctRowCount), Predef$.MODULE$.Double2double(rowCount));
        return Predef$.MODULE$.double2Double((1.0 - Math.pow(1.0 - Predef$.MODULE$.Double2double(selectivity), Predef$.MODULE$.Double2double(rowCount) / ndv)) * ndv);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Object> getInputRefIndices(int index, Expand expand) {
        void var3_3;
        HashSet inputRefs = new HashSet();
        JavaConversions$.MODULE$.asScalaBuffer(expand.projects()).foreach((Function1)new Serializable(index, inputRefs){
            public static final long serialVersionUID = 0L;
            private final int index$1;
            private final HashSet inputRefs$1;

            public final boolean apply(List<RexNode> project) {
                boolean bl;
                RexNode rexNode = project.get(this.index$1);
                if (rexNode instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)rexNode;
                    bl = this.inputRefs$1.add(BoxesRunTime.boxToInteger((int)rexInputRef.getIndex()));
                } else {
                    bl = this.inputRefs$1.add(BoxesRunTime.boxToInteger((int)-1));
                }
                return bl;
            }
            {
                this.index$1 = index$1;
                this.inputRefs$1 = inputRefs$1;
            }
        });
        return var3_3;
    }

    private final ImmutableBitSet removeAuxKey$1(ImmutableBitSet groupKey, int[] groupSet, int[] auxGroupSet) {
        return groupKey.contains(ImmutableBitSet.of(groupSet)) ? groupKey.except(ImmutableBitSet.of(auxGroupSet)) : groupKey;
    }

    private FlinkRelMdUtil$() {
        MODULE$ = this;
    }
}

