/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSink;
import org.apache.flink.table.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.resource.batch.RunningUnitGenerator;
import org.apache.flink.util.Preconditions;

public class BatchRunningUnitBuildProcessor
implements DAGProcessor {
    @Override
    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> sinkNodes, DAGProcessContext context) {
        if (!context.getTableEnvironment().getConfig().getConf().getBoolean(TableConfigOptions.SQL_EXEC_SORT_RANGE_ENABLED)) {
            LinkedList<BatchExecNode> batchExecNodes = new LinkedList<BatchExecNode>();
            for (ExecNode<?, ?> sinkNode : sinkNodes) {
                Preconditions.checkArgument(sinkNode instanceof BatchExecNode);
                if (sinkNode instanceof BatchExecSink) {
                    batchExecNodes.add((BatchExecNode)((Object)((BatchExecSink)sinkNode).getInput()));
                    continue;
                }
                batchExecNodes.add((BatchExecNode)sinkNode);
            }
            RunningUnitGenerator visitor = this.getRunningUnitGenerator(context.getTableEnvironment().getConfig().getConf());
            batchExecNodes.forEach(b -> b.accept(visitor));
            ((BatchTableEnvironment)context.getTableEnvironment()).getRUKeeper().setRunningUnits(visitor.getRunningUnits());
        }
        return sinkNodes;
    }

    protected RunningUnitGenerator getRunningUnitGenerator(Configuration tableConf) {
        return new RunningUnitGenerator(tableConf);
    }
}

