/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.managedmem;

import java.util.List;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.batch.BatchExecNodeVisitorImpl;
import org.apache.flink.table.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.resource.batch.managedmem.BatchManagedMemCalculatorOnConfig;
import org.apache.flink.table.resource.batch.managedmem.BatchManagedMemCalculatorOnStatistics;
import org.apache.flink.table.util.NodeResourceUtil;
import org.apache.flink.util.Preconditions;

public class BatchManagedMemoryProcessor
implements DAGProcessor {
    private TableEnvironment tEnv;

    @Override
    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> sinkNodes, DAGProcessContext context) {
        sinkNodes.forEach(s -> Preconditions.checkArgument(s instanceof BatchExecNode));
        this.tEnv = context.getTableEnvironment();
        NodeResourceUtil.InferMode inferMode = NodeResourceUtil.getInferMode(this.tEnv.getConfig().getConf());
        BatchExecNodeVisitorImpl managedVisitor = inferMode.equals((Object)NodeResourceUtil.InferMode.ALL) ? new BatchManagedMemCalculatorOnStatistics(this.tEnv.getConfig().getConf()) : new BatchManagedMemCalculatorOnConfig(this.tEnv.getConfig().getConf());
        sinkNodes.forEach(s -> ((BatchExecNode)s).accept(managedVisitor));
        return sinkNodes;
    }
}

