/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.parallelism;

import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecScan;
import org.apache.flink.table.resource.batch.parallelism.BatchShuffleStageParallelismCalculator;
import org.apache.flink.table.resource.batch.parallelism.ShuffleStage;
import org.apache.flink.table.util.NodeResourceUtil;

public class BatchParallelismCalculatorOnConfig
extends BatchShuffleStageParallelismCalculator {
    public BatchParallelismCalculatorOnConfig(Configuration tableConf, int envParallelism) {
        super(tableConf, envParallelism);
    }

    @Override
    protected void calculate(ShuffleStage shuffleStage) {
        if (shuffleStage.isFinalParallelism()) {
            return;
        }
        Set<ExecNode<?, ?>> nodeSet = shuffleStage.getExecNodeSet();
        int maxSourceParallelism = -1;
        for (ExecNode<?, ?> node : nodeSet) {
            int result;
            if (!(node instanceof BatchExecScan) || (result = this.calculateSource((BatchExecScan)node)) <= maxSourceParallelism) continue;
            maxSourceParallelism = result;
        }
        if (maxSourceParallelism > 0) {
            shuffleStage.setParallelism(maxSourceParallelism, false);
        } else {
            shuffleStage.setParallelism(NodeResourceUtil.getOperatorDefaultParallelism(this.getTableConf(), this.envParallelism), false);
        }
    }
}

