/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.parallelism;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.flink.table.plan.nodes.exec.ExecNode;

public class ShuffleStage {
    private final Set<ExecNode<?, ?>> execNodeSet = new LinkedHashSet();
    private int parallelism = -1;
    private boolean isFinalParallelism = false;

    public void addNode(ExecNode<?, ?> node) {
        this.execNodeSet.add(node);
    }

    public void addNodeSet(Set<ExecNode<?, ?>> nodeSet) {
        this.execNodeSet.addAll(nodeSet);
    }

    public void removeNode(ExecNode<?, ?> node) {
        this.execNodeSet.remove(node);
    }

    public Set<ExecNode<?, ?>> getExecNodeSet() {
        return this.execNodeSet;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism, boolean finalParallelism) {
        if (this.isFinalParallelism) {
            if (finalParallelism && this.parallelism != parallelism) {
                throw new IllegalArgumentException("both fixed parallelism are not equal, old: " + this.parallelism + ", new: " + parallelism);
            }
        } else if (finalParallelism) {
            this.parallelism = parallelism;
            this.isFinalParallelism = true;
        } else {
            this.parallelism = Math.max(this.parallelism, parallelism);
        }
    }

    public boolean isFinalParallelism() {
        return this.isFinalParallelism;
    }
}

