/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime;

import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

public abstract class AbstractProcessStreamOperator<OUT>
extends AbstractStreamOperator<OUT> {
    protected long currentWatermark = Long.MIN_VALUE;
    protected transient ContextImpl ctx;
    protected boolean closed = false;

    public AbstractProcessStreamOperator() {
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() throws Exception {
        super.open();
        this.ctx = new ContextImpl(this.getProcessingTimeService());
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void close() throws Exception {
        super.close();
        this.closed = true;
    }

    public void dispose() throws Exception {
        if (!this.closed) {
            this.close();
        }
        super.dispose();
    }

    protected class ContextImpl
    implements TimerService {
        protected final ProcessingTimeService timerService;
        public StreamRecord<?> element;

        ContextImpl(ProcessingTimeService timerService) {
            this.timerService = Preconditions.checkNotNull(timerService);
        }

        public Long timestamp() {
            Preconditions.checkState(this.element != null);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        public long currentProcessingTime() {
            return this.timerService.getCurrentProcessingTime();
        }

        public long currentWatermark() {
            return AbstractProcessStreamOperator.this.currentWatermark;
        }

        public void registerProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a keyed streams.");
        }

        public void registerEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a keyed streams.");
        }

        public void deleteProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Deleting timers is only supported on a keyed streams.");
        }

        public void deleteEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Deleting timers is only supported on a keyed streams.");
        }

        public TimerService timerService() {
            return this;
        }
    }
}

