/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.functions.ThreadLocalCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DateTimeFunctions$ {
    public static final DateTimeFunctions$ MODULE$;
    private final Logger LOG;
    private final int EPOCH_JULIAN;
    private final int MILLIS_PER_HOUR;
    private final int MILLIS_PER_DAY;
    private final String[] FORMATS;
    private final ThreadLocalCache<String, TimeZone> TIMEZONE_CACHE;
    private final ThreadLocalCache<Tuple2<String, TimeZone>, SimpleDateFormat> FORMATTER_TIMEZONE_CACHE;

    static {
        new DateTimeFunctions$();
    }

    private Logger LOG() {
        return this.LOG;
    }

    public int EPOCH_JULIAN() {
        return this.EPOCH_JULIAN;
    }

    public int MILLIS_PER_HOUR() {
        return this.MILLIS_PER_HOUR;
    }

    public int MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    public String[] FORMATS() {
        return this.FORMATS;
    }

    private ThreadLocalCache<String, TimeZone> TIMEZONE_CACHE() {
        return this.TIMEZONE_CACHE;
    }

    private ThreadLocalCache<Tuple2<String, TimeZone>, SimpleDateFormat> FORMATTER_TIMEZONE_CACHE() {
        return this.FORMATTER_TIMEZONE_CACHE;
    }

    public String dateFormat(long ts, String formatString, TimeZone tz) {
        String string;
        try {
            SimpleDateFormat toFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)formatString, (Object)tz));
            java.util.Date datetime = new java.util.Date(ts);
            string = toFormatter.format(datetime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when parse format string: ").append((Object)formatString).toString(), (Throwable)illegalArgumentException);
            string = null;
        }
        catch (ParseException parseException) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when formatting: ").append((Object)BoxesRunTime.boxToLong((long)ts)).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String dateFormat(String dateText, String fromFormat, String toFormat, TimeZone tz) {
        String string;
        try {
            SimpleDateFormat fromFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)fromFormat, (Object)tz));
            SimpleDateFormat toFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)toFormat, (Object)tz));
            string = toFormatter.format(fromFormatter.parse(dateText));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when parse format string: ").append((Object)dateText).append((Object)", from: ").append((Object)fromFormat).append((Object)", to: ").append((Object)toFormat).toString(), (Throwable)illegalArgumentException);
            string = null;
        }
        catch (ParseException parseException) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when formatting: ").append((Object)dateText).append((Object)", from: ").append((Object)fromFormat).append((Object)", to: ").append((Object)toFormat).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String dateFormat(String dateText, String toFormat, TimeZone tz) {
        return this.dateFormat(dateText, "yyyy-MM-dd HH:mm:ss", toFormat, tz);
    }

    public int toDate(int v) {
        return v;
    }

    public long toTimestamp(long v) {
        return v;
    }

    public Long toTimestamp(double v) {
        return BoxesRunTime.boxToDouble((double)v) == null ? null : Predef$.MODULE$.long2Long(Predef$.MODULE$.double2Double(v).longValue());
    }

    public Long toTimestamp(Decimal v) {
        return v == null ? null : Predef$.MODULE$.long2Long(Decimal.castToLong(v));
    }

    public int toDate(String dateStr, String fromFormat) {
        long ts = this.parseToTimeMillis(dateStr, fromFormat, TimeZone.getTimeZone("UTC"));
        ZoneId zoneId = ZoneId.of("UTC");
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return this.ymdToUnixDate(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth());
    }

    public Long toTimestamp(String dateText, TimeZone tz) {
        Long l;
        Long option = this.toTimestamp(dateText, "yyyy-MM-dd HH:mm:ss", tz);
        Long l2 = option;
        if (l2 == null) {
            l = null;
        } else {
            Long l3;
            try {
                l3 = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(option) + (long)this.getMillis(dateText));
            }
            catch (Exception exception) {
                this.LOG().error(new StringBuilder().append((Object)"Exception when parse timestamp string : ").append((Object)dateText).toString());
                l3 = null;
            }
            l = l3;
        }
        return l;
    }

    public Long toTimestamp(String dateText, String fromFormat, TimeZone tz) {
        Long l;
        SimpleDateFormat fromFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)fromFormat, (Object)tz));
        try {
            l = Predef$.MODULE$.long2Long(fromFormatter.parse(dateText).getTime());
        }
        catch (ParseException parseException) {
            l = null;
        }
        return l;
    }

    public long toTimestampTz(String dateText, String fromFormat, String tzString) {
        TimeZone tz = this.TIMEZONE_CACHE().get(tzString);
        SimpleDateFormat fromFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)fromFormat, (Object)tz));
        return fromFormatter.parse(dateText).getTime();
    }

    public long toTimestampTz(String dateText, String tzString) {
        TimeZone tz = this.TIMEZONE_CACHE().get(tzString);
        SimpleDateFormat fromFormatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)"yyyy-MM-dd HH:mm:ss", (Object)tz));
        return fromFormatter.parse(dateText).getTime();
    }

    public String dateFormatTz(long ts, String formatString, String tzString) {
        TimeZone tz = this.TIMEZONE_CACHE().get(tzString);
        return this.dateFormat(ts, formatString, tz);
    }

    public String dateFormatTz(long ts, String tzString) {
        TimeZone tz = this.TIMEZONE_CACHE().get(tzString);
        return this.dateFormat(ts, "yyyy-MM-dd HH:mm:ss", tz);
    }

    public String convertTz(String dateText, String format2, String tzFrom, String tzTo) {
        return this.dateFormatTz(this.toTimestampTz(dateText, format2, tzFrom), tzTo);
    }

    public String convertTz(String dateText, String tzFrom, String tzTo) {
        return this.dateFormatTz(this.toTimestampTz(dateText, "yyyy-MM-dd HH:mm:ss", tzFrom), tzTo);
    }

    public long fromTimestamp(long ts) {
        return ts;
    }

    public int extractYearMonth(TimeUnitRange range2, int v) {
        block5: {
            int n;
            block3: {
                TimeUnitRange timeUnitRange;
                block4: {
                    block2: {
                        timeUnitRange = range2;
                        if (!((Object)((Object)TimeUnitRange.YEAR)).equals((Object)timeUnitRange)) break block2;
                        n = v / 12;
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnitRange.MONTH)).equals((Object)timeUnitRange)) break block4;
                    n = v % 12;
                    break block3;
                }
                if (!((Object)((Object)TimeUnitRange.QUARTER)).equals((Object)timeUnitRange)) break block5;
                n = (v % 12 + 2) / 3;
            }
            return n;
        }
        throw new AssertionError((Object)range2);
    }

    public long extractFromDate(TimeUnitRange range2, long ts) {
        return this.convertExtract(range2, ts, SqlTypeName.DATE, TimeZone.getTimeZone("UTC"));
    }

    public long unixTimeExtract(TimeUnitRange range2, int ts) {
        return DateTimeUtils.unixTimeExtract(range2, ts);
    }

    public long extractFromTimestamp(TimeUnitRange range2, long ts, TimeZone tz) {
        return this.convertExtract(range2, ts, SqlTypeName.TIMESTAMP, tz);
    }

    public long utcTsToTzTs(long ts, TimeZone tz) {
        String utcString = this.dateFormatTz(ts, "yyyy-MM-dd HH:mm:ss.SSS", "UTC");
        return Predef$.MODULE$.Long2long(this.toTimestamp(utcString, "yyyy-MM-dd HH:mm:ss.SSS", tz));
    }

    private long convertExtract(TimeUnitRange range2, long ts, SqlTypeName sqlTypeName, TimeZone tz) {
        TimeUnit unit = range2.startUnit;
        int offset = tz.getOffset(ts);
        long utcTz = ts + (long)offset;
        TimeUnit timeUnit = unit;
        boolean bl = ((Object)((Object)TimeUnit.MILLENNIUM)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.CENTURY)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.QUARTER)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.MONTH)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DAY)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DOW)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DOY)).equals((Object)timeUnit) ? true : ((Object)((Object)TimeUnit.WEEK)).equals((Object)timeUnit))))))));
        if (bl) {
            SqlTypeName sqlTypeName2 = sqlTypeName;
            if (((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName2)) {
                long d = this.divide(utcTz, TimeUnit.DAY.multiplier);
                return DateTimeUtils.unixDateExtract(range2, d);
            }
            if (((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName2)) {
                return this.divide(utcTz, TimeUnit.DAY.multiplier);
            }
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is unsupported now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName})));
        }
        if (((Object)((Object)TimeUnit.DECADE)).equals((Object)timeUnit)) {
            throw new TableException("DECADE is unsupported now.");
        }
        if (((Object)((Object)TimeUnit.EPOCH)).equals((Object)timeUnit)) {
            throw new TableException("EPOCH is unsupported now.");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        long res = this.mod(utcTz, this.getFactor(unit));
        if (unit == TimeUnit.QUARTER) {
            --res;
        }
        res = this.divide(res, unit.multiplier);
        if (unit == TimeUnit.QUARTER) {
            ++res;
        }
        return res;
    }

    private long divide(long res, BigDecimal value) {
        long l;
        if (BoxesRunTime.equalsNumNum((Number)value, (Number)BigDecimal.ONE)) {
            l = res;
        } else if (value.compareTo(BigDecimal.ONE) < 0 && value.signum() == 1) {
            BigDecimal reciprocal = BigDecimal.ONE.divide(value, RoundingMode.UNNECESSARY);
            l = reciprocal.multiply(BigDecimal.valueOf(res)).longValue();
        } else {
            l = res / value.longValue();
        }
        return l;
    }

    private long mod(long res, BigDecimal value) {
        return BoxesRunTime.equalsNumNum((Number)value, (Number)BigDecimal.ONE) ? res : res % value.longValue();
    }

    private BigDecimal getFactor(TimeUnit unit) {
        block10: {
            BigDecimal bigDecimal;
            block3: {
                TimeUnit timeUnit;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            timeUnit = unit;
                                            if (!((Object)((Object)TimeUnit.DAY)).equals((Object)timeUnit)) break block2;
                                            bigDecimal = BigDecimal.ONE;
                                            break block3;
                                        }
                                        if (!((Object)((Object)TimeUnit.HOUR)).equals((Object)timeUnit)) break block4;
                                        bigDecimal = TimeUnit.DAY.multiplier;
                                        break block3;
                                    }
                                    if (!((Object)((Object)TimeUnit.MINUTE)).equals((Object)timeUnit)) break block5;
                                    bigDecimal = TimeUnit.HOUR.multiplier;
                                    break block3;
                                }
                                if (!((Object)((Object)TimeUnit.SECOND)).equals((Object)timeUnit)) break block6;
                                bigDecimal = TimeUnit.MINUTE.multiplier;
                                break block3;
                            }
                            if (!((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit)) break block7;
                            bigDecimal = BigDecimal.ONE;
                            break block3;
                        }
                        if (!((Object)((Object)TimeUnit.MONTH)).equals((Object)timeUnit)) break block8;
                        bigDecimal = TimeUnit.YEAR.multiplier;
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnit.QUARTER)).equals((Object)timeUnit)) break block9;
                    bigDecimal = TimeUnit.YEAR.multiplier;
                    break block3;
                }
                boolean bl = ((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DECADE)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.CENTURY)).equals((Object)timeUnit) ? true : ((Object)((Object)TimeUnit.MILLENNIUM)).equals((Object)timeUnit)));
                if (!bl) break block10;
                bigDecimal = BigDecimal.ONE;
            }
            return bigDecimal;
        }
        throw new IllegalArgumentException("Invalid start unit.");
    }

    public long parseToTimeMillis(String dt, TimeZone tz) {
        long l;
        String fmt = dt.length() <= 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
        try {
            l = this.parseToTimeMillis(dt, fmt, tz) + (long)this.getMillis(dt);
        }
        catch (Exception exception) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when parse timestamp string : ").append((Object)dt).toString());
            l = Long.MIN_VALUE;
        }
        return l;
    }

    public long parseToTimeMillis(String dt, String fmt, TimeZone tz) {
        long l;
        try {
            SimpleDateFormat sdp = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)fmt, (Object)tz));
            java.util.Date d = sdp.parse(dt);
            l = d.getTime();
        }
        catch (Exception exception) {
            this.LOG().error(new StringBuilder().append((Object)"Exception when parse date string in unixTimestamp:").append((Object)dt).append((Object)",").append((Object)fmt).toString());
            l = Long.MIN_VALUE;
        }
        long millis = l;
        return millis;
    }

    /*
     * WARNING - void declaration
     */
    private int getMillis(String dt) {
        void var3_3;
        int n;
        int n2 = dt.length();
        switch (n2) {
            default: {
                if (n2 >= 23 && n2 <= 26) {
                    n = new StringOps(Predef$.MODULE$.augmentString(dt.substring(20, 23))).toInt();
                    break;
                }
                n = 0;
                break;
            }
            case 22: {
                n = new StringOps(Predef$.MODULE$.augmentString(dt.substring(20))).toInt() * 10;
                break;
            }
            case 21: {
                n = new StringOps(Predef$.MODULE$.augmentString(dt.substring(20))).toInt() * 100;
                break;
            }
            case 19: {
                n = 0;
            }
        }
        int millis = n;
        return (int)var3_3;
    }

    public String timestampToStringPrecision(long ts, int precision, TimeZone tz) {
        String fmt = precision <= 3 && precision >= 0 ? this.FORMATS()[precision] : this.FORMATS()[3];
        return this.dateFormat(ts, fmt, tz);
    }

    public long timestampFloor(TimeUnitRange unit, long ts, TimeZone tz) {
        block5: {
            long l;
            block3: {
                TimeUnitRange timeUnitRange;
                long utcTs;
                int offset;
                block4: {
                    block2: {
                        offset = tz.getOffset(ts);
                        utcTs = ts + (long)offset;
                        timeUnitRange = unit;
                        if (!((Object)((Object)TimeUnitRange.HOUR)).equals((Object)timeUnitRange)) break block2;
                        l = this.floor(utcTs, this.MILLIS_PER_HOUR()) - (long)offset;
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnitRange.DAY)).equals((Object)timeUnitRange)) break block4;
                    l = this.floor(utcTs, this.MILLIS_PER_DAY()) - (long)offset;
                    break block3;
                }
                boolean bl = ((Object)((Object)TimeUnitRange.MONTH)).equals((Object)timeUnitRange) ? true : (((Object)((Object)TimeUnitRange.YEAR)).equals((Object)timeUnitRange) ? true : ((Object)((Object)TimeUnitRange.QUARTER)).equals((Object)timeUnitRange));
                if (!bl) break block5;
                int days = (int)(utcTs / (long)this.MILLIS_PER_DAY() + (long)this.EPOCH_JULIAN());
                l = this.julianDateFloor(unit, days, true) * (long)this.MILLIS_PER_DAY() - (long)offset;
            }
            return l;
        }
        throw new AssertionError((Object)unit);
    }

    public long timestampCeil(TimeUnitRange unit, long ts, TimeZone tz) {
        block5: {
            long l;
            block3: {
                TimeUnitRange timeUnitRange;
                long utcTs;
                int offset;
                block4: {
                    block2: {
                        offset = tz.getOffset(ts);
                        utcTs = ts + (long)offset;
                        timeUnitRange = unit;
                        if (!((Object)((Object)TimeUnitRange.HOUR)).equals((Object)timeUnitRange)) break block2;
                        l = this.ceil(utcTs, this.MILLIS_PER_HOUR()) - (long)offset;
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnitRange.DAY)).equals((Object)timeUnitRange)) break block4;
                    l = this.ceil(utcTs, this.MILLIS_PER_DAY()) - (long)offset;
                    break block3;
                }
                boolean bl = ((Object)((Object)TimeUnitRange.MONTH)).equals((Object)timeUnitRange) ? true : (((Object)((Object)TimeUnitRange.YEAR)).equals((Object)timeUnitRange) ? true : ((Object)((Object)TimeUnitRange.QUARTER)).equals((Object)timeUnitRange));
                if (!bl) break block5;
                int days = (int)(utcTs / (long)this.MILLIS_PER_DAY() + (long)this.EPOCH_JULIAN());
                l = this.julianDateFloor(unit, days, false) * (long)this.MILLIS_PER_DAY() - (long)offset;
            }
            return l;
        }
        throw new AssertionError((Object)unit);
    }

    private long floor(long a, long b) {
        long r = a % b;
        return r < 0L ? a - r - b : a - r;
    }

    private long ceil(long a, long b) {
        long r = a % b;
        return r > 0L ? a - r + b : a - r;
    }

    private long julianDateFloor(TimeUnitRange range2, int julian, boolean floor) {
        block11: {
            long l;
            block9: {
                TimeUnitRange timeUnitRange;
                int year;
                int quarter;
                int month;
                int day;
                block10: {
                    block8: {
                        int b = 0;
                        int c = 0;
                        if (julian > 2299160) {
                            int a = julian + 32044;
                            b = (4 * a + 3) / 146097;
                            c = a - b * 146097 / 4;
                        } else {
                            b = 0;
                            c = julian + 32082;
                        }
                        int d = (4 * c + 3) / 1461;
                        int e2 = c - 1461 * d / 4;
                        int m = (5 * e2 + 2) / 153;
                        day = e2 - (153 * m + 2) / 5 + 1;
                        month = m + 3 - 12 * (m / 10);
                        quarter = (month + 2) / 3;
                        year = b * 100 + d - 4800 + m / 10;
                        timeUnitRange = range2;
                        if (!((Object)((Object)TimeUnitRange.YEAR)).equals((Object)timeUnitRange)) break block8;
                        if (!(floor || month <= 1 && day <= 1)) {
                            ++year;
                        }
                        l = this.ymdToUnixDate(year, 1, 1);
                        break block9;
                    }
                    if (!((Object)((Object)TimeUnitRange.MONTH)).equals((Object)timeUnitRange)) break block10;
                    if (!floor && day > 1) {
                        ++month;
                    }
                    l = this.ymdToUnixDate(year, month, 1);
                    break block9;
                }
                if (!((Object)((Object)TimeUnitRange.QUARTER)).equals((Object)timeUnitRange)) break block11;
                if (!(floor || month <= 1 && day <= 1)) {
                    ++quarter;
                }
                l = this.ymdToUnixDate(year, quarter * 3 - 2, 1);
            }
            return l;
        }
        throw new AssertionError((Object)range2);
    }

    public long now() {
        java.util.Date date = new java.util.Date();
        return date.getTime() / 1000L;
    }

    public long now(long offset) {
        java.util.Date date = new java.util.Date();
        return date.getTime() / 1000L + offset;
    }

    public long unixTimestamp() {
        return new java.util.Date().getTime() / 1000L;
    }

    public long unixTimestamp(String dateString, String dateFormat2, TimeZone tz) {
        long ts = this.parseToTimeMillis(dateString, dateFormat2, tz);
        return ts == Long.MIN_VALUE ? Long.MIN_VALUE : ts / 1000L;
    }

    public long unixTimestamp(String dateString, TimeZone tz) {
        return this.unixTimestamp(dateString, "yyyy-MM-dd HH:mm:ss", tz);
    }

    public long unixTimestamp(long t) {
        return new Timestamp(t).getTime() / 1000L;
    }

    public String fromUnixtime(long unixtime, String format2, TimeZone tz) {
        String string;
        if (BoxesRunTime.boxToLong((long)unixtime) == null || format2 == null) {
            return null;
        }
        try {
            SimpleDateFormat formatter = this.FORMATTER_TIMEZONE_CACHE().get((Tuple2<String, TimeZone>)new Tuple2((Object)format2, (Object)tz));
            java.util.Date date = new java.util.Date(unixtime * 1000L);
            string = formatter.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.LOG().error(new StringBuilder().append((Object)"exception when parse format string: ").append((Object)format2).toString(), (Throwable)illegalArgumentException);
            string = null;
        }
        catch (ParseException parseException) {
            this.LOG().error(new StringBuilder().append((Object)"exception when formatting string: ").append((Object)BoxesRunTime.boxToLong((long)unixtime)).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String fromUnixtime(long unixtime, TimeZone tz) {
        return this.fromUnixtime(unixtime, "yyyy-MM-dd HH:mm:ss", tz);
    }

    public String fromUnixtime(double unixtime, TimeZone tz) {
        if (BoxesRunTime.boxToDouble((double)unixtime) == null) {
            return null;
        }
        return this.fromUnixtime(Predef$.MODULE$.double2Double(unixtime).longValue(), "yyyy-MM-dd HH:mm:ss", tz);
    }

    public String fromUnixtime(Decimal unixtime, TimeZone tz) {
        if (unixtime == null) {
            return null;
        }
        return this.fromUnixtime(Decimal.castToLong(unixtime), "yyyy-MM-dd HH:mm:ss", tz);
    }

    public int dateDiff(long t1, long t2, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        LocalDate ld1 = Instant.ofEpochMilli(t1).atZone(zoneId).toLocalDate();
        LocalDate ld2 = Instant.ofEpochMilli(t2).atZone(zoneId).toLocalDate();
        return (int)ChronoUnit.DAYS.between(ld2, ld1);
    }

    public int dateDiff(String t1, long t2, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        long lt1 = this.parseToTimeMillis(t1, tz);
        LocalDate ld1 = Instant.ofEpochMilli(lt1).atZone(zoneId).toLocalDate();
        LocalDate ld2 = Instant.ofEpochMilli(t2).atZone(zoneId).toLocalDate();
        return (int)ChronoUnit.DAYS.between(ld2, ld1);
    }

    public int dateDiff(long t1, String t2, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        long lt2 = this.parseToTimeMillis(t2, tz);
        LocalDate ld1 = Instant.ofEpochMilli(t1).atZone(zoneId).toLocalDate();
        LocalDate ld2 = Instant.ofEpochMilli(lt2).atZone(zoneId).toLocalDate();
        return (int)ChronoUnit.DAYS.between(ld2, ld1);
    }

    public int dateDiff(String t1, String t2, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        long lt1 = this.parseToTimeMillis(t1, tz);
        long lt2 = this.parseToTimeMillis(t2, tz);
        LocalDate ld1 = Instant.ofEpochMilli(lt1).atZone(zoneId).toLocalDate();
        LocalDate ld2 = Instant.ofEpochMilli(lt2).atZone(zoneId).toLocalDate();
        return (int)ChronoUnit.DAYS.between(ld2, ld1);
    }

    public String dateSub(String dateStr, int days, TimeZone tz) {
        if (dateStr == null) {
            return null;
        }
        long ts = this.parseToTimeMillis(dateStr, tz);
        if (ts == Long.MIN_VALUE) {
            return null;
        }
        if (ts == Long.MIN_VALUE) {
            return null;
        }
        ZoneId zoneId = tz.toZoneId();
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return this.dateFormat(zdt.minusDays(days).toInstant().toEpochMilli(), "yyyy-MM-dd", tz);
    }

    public String dateSub(long ts, int days, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return this.dateFormat(zdt.minusDays(days).toInstant().toEpochMilli(), "yyyy-MM-dd", tz);
    }

    public String dateAdd(String dateStr, int days, TimeZone tz) {
        if (dateStr == null) {
            return null;
        }
        long ts = this.parseToTimeMillis(dateStr, tz);
        if (ts == Long.MIN_VALUE) {
            return null;
        }
        ZoneId zoneId = tz.toZoneId();
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return this.dateFormat(zdt.plusDays(days).toInstant().toEpochMilli(), "yyyy-MM-dd", tz);
    }

    public String dateAdd(long ts, int days, TimeZone tz) {
        ZoneId zoneId = tz.toZoneId();
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return this.dateFormat(zdt.plusDays(days).toInstant().toEpochMilli(), "yyyy-MM-dd", tz);
    }

    public Date internalToDate(int v, TimeZone tz) {
        long t = (long)v * 86400000L;
        int offset = tz.getOffset(t);
        return new Date(t - (long)offset);
    }

    public Time internalToTime(int v, TimeZone tz) {
        int offset = tz.getOffset(v);
        return new Time(v - offset);
    }

    public int timeToInternal(Time v, TimeZone tz) {
        int offset = tz.getOffset(v.getTime());
        long ts = v.getTime() + (long)offset;
        return (int)(ts % 86400000L);
    }

    public int dateToInternal(java.util.Date v, TimeZone tz) {
        int offset = tz.getOffset(v.getTime());
        long ts = v.getTime() + (long)offset;
        return (int)(ts / 86400000L);
    }

    private int ymdToUnixDate(int year, int month, int day) {
        int julian = this.ymdToJulian(year, month, day);
        return julian - this.EPOCH_JULIAN();
    }

    private int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int m = month + 12 * a - 3;
        int y = year + 4800 - a;
        int j2 = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
        if (j2 < 2299161) {
            j2 = day + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
        }
        return j2;
    }

    private DateTimeFunctions$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.EPOCH_JULIAN = 2440588;
        this.MILLIS_PER_HOUR = 3600000;
        this.MILLIS_PER_DAY = 86400000;
        this.FORMATS = (String[])((Object[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.SS", "yyyy-MM-dd HH:mm:ss.SSS"});
        this.TIMEZONE_CACHE = new ThreadLocalCache<String, TimeZone>(){

            public TimeZone getNewInstance(String tz) {
                return TimeZone.getTimeZone(tz);
            }
        };
        this.FORMATTER_TIMEZONE_CACHE = new ThreadLocalCache<Tuple2<String, TimeZone>, SimpleDateFormat>(){

            /*
             * WARNING - void declaration
             */
            public SimpleDateFormat getNewInstance(Tuple2<String, TimeZone> t) {
                void var2_2;
                SimpleDateFormat sdf = new SimpleDateFormat((String)t._1());
                sdf.setTimeZone((TimeZone)t._2());
                return var2_2;
            }
        };
    }
}

