/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.ConcatAggFunction$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.typeutils.ListViewTypeInfo;
import org.apache.flink.table.typeutils.ListViewTypeInfo$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001#\t\t2i\u001c8dCR\fum\u001a$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001D1hO\u001a,hn\u0019;j_:\u001c(BA\u0003\u0007\u0003%1WO\\2uS>t7O\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001BaE\u000b\u0018;5\tAC\u0003\u0002\u0006\u0011%\u0011a\u0003\u0006\u0002\u0012\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\t\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u00039e\u0011ABQ5oCJL8\u000b\u001e:j]\u001e\u0004\"\u0001\u0007\u0010\n\u0005}I\"AC$f]\u0016\u0014\u0018n\u0019*po\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011A\u0001\u0005\u0006M\u0001!\taJ\u0001\u000bC\u000e\u001cW/\\;mCR,Gc\u0001\u0015/aA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u0015yS\u00051\u0001\u001e\u0003\r\t7m\u0019\u0005\u0006c\u0015\u0002\raF\u0001\u0006m\u0006dW/\u001a\u0005\u0006g\u0001!\t\u0001N\u0001\be\u0016$(/Y2u)\rASG\u000e\u0005\u0006_I\u0002\r!\b\u0005\u0006cI\u0002\ra\u0006\u0005\u0006q\u0001!\t%O\u0001\tO\u0016$h+\u00197vKR\u0011qC\u000f\u0005\u0006_]\u0002\r!\b\u0005\u0006y\u0001!\t!P\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004Qyz\u0004\"B\u0018<\u0001\u0004i\u0002\"\u0002!<\u0001\u0004\t\u0015aA5ugB\u0019!iR\u000f\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA5I\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0015Q\u0005\u0001\"\u0011L\u0003E\u0019'/Z1uK\u0006\u001b7-^7vY\u0006$xN\u001d\u000b\u0002;!)Q\n\u0001C\u0001\u001d\u0006\u0001\"/Z:fi\u0006\u001b7-^7vY\u0006$xN\u001d\u000b\u0003Q=CQa\f'A\u0002uAQ!\u0015\u0001\u0005BI\u000b!cZ3u\u0003\u000e\u001cW/\\;mCR|'\u000fV=qKR\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W\u0011\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\t\t\u0006$\u0018\rV=qK\u001e)!L\u0001E\u00017\u0006\t2i\u001c8dCR\fum\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005\u0011bf!B\u0001\u0003\u0011\u0003i6c\u0001/_CB\u0011\u0011fX\u0005\u0003A*\u0012a!\u00118z%\u00164\u0007CA\u0015c\u0013\t\u0019'F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\"9\u0012\u0005Q\rF\u0001\\\u0011\u001d9GL1A\u0005\u0002!\fQ\u0002\\5oK\u0012+G.[7ji\u0016\u0014X#A\f\t\r)d\u0006\u0015!\u0003\u0018\u00039a\u0017N\\3EK2LW.\u001b;fe\u0002Bq\u0001\u001c/\u0002\u0002\u0013%Q.A\u0006sK\u0006$'+Z:pYZ,G#\u00018\u0011\u0005\t{\u0017B\u00019D\u0005\u0019y%M[3di\u0002")
public class ConcatAggFunction
extends AggregateFunction<BinaryString, GenericRow> {
    public static BinaryString lineDelimiter() {
        return ConcatAggFunction$.MODULE$.lineDelimiter();
    }

    public void accumulate(GenericRow acc, BinaryString value) {
        if (value != null) {
            ListView list = (ListView)acc.getField(0);
            list.add(value);
        }
    }

    public void retract(GenericRow acc, BinaryString value) {
        ListView list;
        if (value != null && !(list = (ListView)acc.getField(0)).remove(value)) {
            ListView retractList = (ListView)acc.getField(1);
            retractList.add(value);
        }
    }

    @Override
    public BinaryString getValue(GenericRow acc) {
        ListView list = (ListView)acc.getField(0);
        Iterable accList = list.get();
        return accList != null && accList.iterator().hasNext() ? BinaryString.concatWs(ConcatAggFunction$.MODULE$.lineDelimiter(), list.get()) : null;
    }

    public void merge(GenericRow acc, Iterable<GenericRow> its) {
        for (GenericRow otherAcc : its) {
            ListView thisList = (ListView)acc.getField(0);
            ListView otherList = (ListView)otherAcc.getField(0);
            Iterable accList = otherList.get();
            if (accList != null) {
                Iterator listIter = accList.iterator();
                while (listIter.hasNext()) {
                    thisList.add(listIter.next());
                }
            }
            ListView otherRetractList = (ListView)otherAcc.getField(1);
            ListView thisRetractList = (ListView)acc.getField(1);
            Iterable retractList = otherRetractList.get();
            if (retractList == null) continue;
            Iterator retractListIter = retractList.iterator();
            List buffer = null;
            if (retractListIter.hasNext()) {
                buffer = (List)thisList.get();
            }
            boolean listChanged = false;
            while (retractListIter.hasNext()) {
                BinaryString element = (BinaryString)retractListIter.next();
                if (buffer != null && buffer.remove(element)) {
                    listChanged = true;
                    continue;
                }
                thisRetractList.add(element);
            }
            if (!listChanged) continue;
            thisList.clear();
            thisList.addAll(buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GenericRow createAccumulator() {
        void var1_1;
        GenericRow acc = new GenericRow(2);
        acc.update(0, new ListView(package$.MODULE$.typeInfo2DataType(BinaryStringTypeInfo.INSTANCE)));
        acc.update(1, new ListView(package$.MODULE$.typeInfo2DataType(BinaryStringTypeInfo.INSTANCE)));
        return var1_1;
    }

    public void resetAccumulator(GenericRow acc) {
        ListView list = (ListView)acc.getField(0);
        ListView retractList = (ListView)acc.getField(1);
        list.clear();
        retractList.clear();
    }

    @Override
    public DataType getAccumulatorType() {
        DataType[] fieldTypes2 = (DataType[])((Object[])new DataType[]{DataTypes.createGenericType(new ListViewTypeInfo<BinaryString>(BinaryStringTypeInfo.INSTANCE, ListViewTypeInfo$.MODULE$.$lessinit$greater$default$2())), DataTypes.createGenericType(new ListViewTypeInfo<BinaryString>(BinaryStringTypeInfo.INSTANCE, ListViewTypeInfo$.MODULE$.$lessinit$greater$default$2()))});
        String[] fieldNames = (String[])((Object[])new String[]{"list", "retractList"});
        return new RowType(fieldTypes2, fieldNames);
    }
}

