/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.dataview.Order;
import org.apache.flink.table.api.dataview.SortedMapView;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.MapViewTypeInfo;
import org.apache.flink.table.typeutils.MapViewTypeInfo$;
import org.apache.flink.table.typeutils.SortedMapViewTypeInfo;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0003\u0003\t\"a\b'bgR4\u0016\r\\;f/&$\bNU3ue\u0006\u001cG/Q4h\rVt7\r^5p]*\u00111\u0001B\u0001\rC\u001e<g-\u001e8di&|gn\u001d\u0006\u0003\u000b\u0019\t\u0011BZ;oGRLwN\\:\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001+\t\u0011\"d\u0005\u0002\u0001'A!AC\u0006\r'\u001b\u0005)\"BA\u0003\t\u0013\t9RCA\tBO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u0004\"!\u0007\u000e\r\u0001\u0011)1\u0004\u0001b\u00019\t\tA+\u0005\u0002\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t9aj\u001c;iS:<\u0007C\u0001\u0010%\u0013\t)sDA\u0002B]f\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0005\u0002\u0015\u0011\fG/\u00194pe6\fG/\u0003\u0002,Q\tQq)\u001a8fe&\u001c'k\\<\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0005y\u0003c\u0001\u0019\u000115\t!\u0001C\u00033\u0001\u0011\u00051'\u0001\u0006bG\u000e,X.\u001e7bi\u0016$2\u0001N\u001c:!\tqR'\u0003\u00027?\t!QK\\5u\u0011\u0015A\u0014\u00071\u0001'\u0003\r\t7m\u0019\u0005\u0006uE\u0002\raI\u0001\u0006m\u0006dW/\u001a\u0005\u0006e\u0001!\t\u0001\u0010\u000b\u0005iurt\bC\u00039w\u0001\u0007a\u0005C\u0003;w\u0001\u00071\u0005C\u0003Aw\u0001\u0007\u0011)A\u0003pe\u0012,'\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\t1{gn\u001a\u0005\u0006\u0015\u0002!\taS\u0001\be\u0016$(/Y2u)\r!D*\u0014\u0005\u0006q%\u0003\rA\n\u0005\u0006u%\u0003\ra\t\u0005\u0006\u0015\u0002!\ta\u0014\u000b\u0005iA\u000b&\u000bC\u00039\u001d\u0002\u0007a\u0005C\u0003;\u001d\u0002\u00071\u0005C\u0003A\u001d\u0002\u0007\u0011\tC\u0003U\u0001\u0011\u0005S+\u0001\u0005hKR4\u0016\r\\;f)\tAb\u000bC\u00039'\u0002\u0007a\u0005C\u0003Y\u0001\u0011%\u0011,A\u0006va\u0012\fG/\u001a,bYV,Gc\u0001\u001b[7\")\u0001h\u0016a\u0001M!)Al\u0016a\u0001;\u0006\t2o\u001c:uK\u0012$\u0015\r^1NCB4\u0016.Z<\u0011\ty\u001b\u0017)Z\u0007\u0002?*\u0011\u0001-Y\u0001\tI\u0006$\u0018M^5fo*\u0011!\rC\u0001\u0004CBL\u0017B\u00013`\u00055\u0019vN\u001d;fI6\u000b\u0007OV5foB\u0019a-\u001b\r\u000e\u0003\u001dT!\u0001[#\u0002\tU$\u0018\u000e\\\u0005\u0003U\u001e\u0014A\u0001T5ti\")A\u000e\u0001C\u0001[\u0006\u0001\"/Z:fi\u0006\u001b7-^7vY\u0006$xN\u001d\u000b\u0003i9DQ\u0001O6A\u0002\u0019BQ\u0001\u001d\u0001\u0007\u0002E\fAcZ3u\u0013:$XM\u001d8bYZ\u000bG.^3UsB,W#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005UD\u0011!\u0002;za\u0016\u001c\u0018BA<u\u00051Ie\u000e^3s]\u0006dG+\u001f9f\u0011\u0015I\b\u0001\"\u0001{\u000319W\r\u001e,bYV,G+\u001f9f+\u0005Y\bCA:}\u0013\tiHO\u0001\u0005ECR\fG+\u001f9f\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005iq-\u001a;SKN,H\u000e\u001e+za\u0016$\u0012a\u001f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003-Ig.\u001b;ECR\fW*\u00199\u0016\u0005\u0005%\u0001C\u00020\u0002\fa\ty!C\u0002\u0002\u000e}\u0013q!T1q-&,w\u000fE\u0002gS\u0006Cq!a\u0005\u0001\t\u0003\n)\"\u0001\rhKR,6/\u001a:EK\u001aLg.\u001a3J]B,H\u000fV=qKN$B!a\u0006\u0002\u001eA!a$!\u0007|\u0013\r\tYb\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u0005I1/[4oCR,(/\u001a\t\u0006=\u0005e\u00111\u0005\u0019\u0005\u0003K\t)\u0004\u0005\u0004\u0002(\u00055\u00121\u0007\b\u0004=\u0005%\u0012bAA\u0016?\u00051\u0001K]3eK\u001aLA!a\f\u00022\t)1\t\\1tg*\u0019\u00111F\u0010\u0011\u0007e\t)\u0004B\u0006\u00028\u0005u\u0011\u0011!A\u0001\u0006\u0003a\"aA0%c!9\u00111\b\u0001\u0005B\u0005u\u0012!E2sK\u0006$X-Q2dk6,H.\u0019;peR\ta\u0005C\u0004\u0002B\u0001!\t%!\u0001\u0002%\u001d,G/Q2dk6,H.\u0019;peRK\b/\u001a")
public abstract class LastValueWithRetractAggFunction<T>
extends AggregateFunction<T, GenericRow> {
    public void accumulate(GenericRow acc, Object value) {
        if (value != null) {
            long order = System.currentTimeMillis();
            Object v = value;
            MapView dataMapView = (MapView)acc.getField(2);
            ArrayList<Long> dataMapList = (ArrayList<Long>)dataMapView.get(v);
            if (dataMapList == null) {
                dataMapList = new ArrayList<Long>();
            }
            dataMapList.add(Predef$.MODULE$.long2Long(order));
            dataMapView.put(v, dataMapList);
            this.accumulate(acc, v, Predef$.MODULE$.long2Long(order));
        }
    }

    public void accumulate(GenericRow acc, Object value, Long order) {
        if (value != null && order != null) {
            SortedMapView sortedDataMapView;
            ArrayList<Object> sortedDataMapList;
            Object v = value;
            Long prevOrder = (Long)acc.getField(1);
            if (prevOrder == null || Predef$.MODULE$.Long2long(prevOrder) <= Predef$.MODULE$.Long2long(order)) {
                acc.update(0, v);
                acc.update(1, order);
            }
            if ((sortedDataMapList = (ArrayList<Object>)(sortedDataMapView = (SortedMapView)acc.getField(3)).get(order)) == null) {
                sortedDataMapList = new ArrayList<Object>();
            }
            sortedDataMapList.add(v);
            sortedDataMapView.put(order, sortedDataMapList);
        }
    }

    public void retract(GenericRow acc, Object value) {
        if (value != null) {
            Object v = value;
            MapView dataMapView = (MapView)acc.getField(2);
            List dataMapList = (List)dataMapView.get(v);
            if (dataMapList != null && dataMapList.size() > 0) {
                Long order = (Long)dataMapList.get(0);
                dataMapList.remove(0);
                if (dataMapList.isEmpty()) {
                    dataMapView.remove(v);
                } else {
                    dataMapView.put(v, dataMapList);
                }
                this.retract(acc, v, order);
            }
        }
    }

    public void retract(GenericRow acc, Object value, Long order) {
        if (value != null && order != null) {
            Object v = value;
            SortedMapView sortedDataMapView = (SortedMapView)acc.getField(3);
            List sortedDataMapList = (List)sortedDataMapView.get(order);
            if (sortedDataMapList == null) {
                return;
            }
            int index = sortedDataMapList.indexOf(v);
            if (index >= 0) {
                sortedDataMapList.remove(index);
                if (sortedDataMapList.isEmpty()) {
                    sortedDataMapView.remove(order);
                } else {
                    sortedDataMapView.put(order, sortedDataMapList);
                }
            }
            if (BoxesRunTime.equals((Object)v, (Object)acc.getField(0))) {
                this.updateValue(acc, sortedDataMapView);
            }
        }
    }

    @Override
    public T getValue(GenericRow acc) {
        return (T)acc.getField(0);
    }

    private void updateValue(GenericRow acc, SortedMapView<Long, List<T>> sortedDataMapView) {
        Object v0;
        Long startKey = (Long)acc.getField(1);
        Iterator<Map.Entry<Long, List<T>>> itor = sortedDataMapView.tailEntries(startKey).iterator();
        if (itor.hasNext()) {
            Map.Entry<Long, List<T>> entry = itor.next();
            acc.update(1, entry.getKey());
            v0 = entry.getValue().get(entry.getValue().size() - 1);
        } else {
            acc.update(1, null);
            v0 = null;
        }
        Object lastValue = v0;
        acc.update(0, lastValue);
    }

    public void resetAccumulator(GenericRow acc) {
        acc.update(0, null);
        acc.update(1, null);
        MapView dataMapView = (MapView)acc.getField(2);
        dataMapView.clear();
        SortedMapView sortedDataMapView = (SortedMapView)acc.getField(3);
        sortedDataMapView.clear();
    }

    public abstract InternalType getInternalValueType();

    public DataType getValueType() {
        return this.getInternalValueType();
    }

    @Override
    public DataType getResultType() {
        return this.getValueType();
    }

    public MapView<T, List<Long>> initDataMap() {
        return new MapView(this.getValueType(), package$.MODULE$.typeInfo2DataType(new ListTypeInfo<Long>(Types$.MODULE$.LONG())));
    }

    @Override
    public DataType[] getUserDefinedInputTypes(Class<?>[] signature) {
        block4: {
            DataType[] dataTypeArray;
            block3: {
                block2: {
                    if (signature.length != 1) break block2;
                    dataTypeArray = (DataType[])((Object[])new DataType[]{this.getValueType()});
                    break block3;
                }
                if (signature.length != 2) break block4;
                dataTypeArray = (DataType[])((Object[])new DataType[]{this.getValueType(), DataTypes.LONG});
            }
            return dataTypeArray;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GenericRow createAccumulator() {
        void var1_1;
        GenericRow acc = new GenericRow(4);
        acc.update(2, this.initDataMap());
        acc.update(3, new SortedMapView(Order.DESCENDING, DataTypes.LONG, package$.MODULE$.typeInfo2DataType(new ListTypeInfo(TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(this.getValueType())))));
        return var1_1;
    }

    @Override
    public DataType getAccumulatorType() {
        DataType[] fieldTypes2 = (DataType[])((Object[])new DataType[]{this.getInternalValueType(), DataTypes.LONG, DataTypes.createGenericType(new MapViewTypeInfo(package$.MODULE$.dataType2ExternalTypeInfo(this.getValueType()), new ListTypeInfo<Long>(Types$.MODULE$.LONG()), MapViewTypeInfo$.MODULE$.$lessinit$greater$default$3(), MapViewTypeInfo$.MODULE$.$lessinit$greater$default$4())), DataTypes.createGenericType(new SortedMapViewTypeInfo(new SortedMapViewTypeInfo.ComparableComparator(false), package$.MODULE$.dataType2ExternalTypeInfo(DataTypes.LONG), new ListTypeInfo(TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(this.getValueType()))))});
        String[] fieldNames = (String[])((Object[])new String[]{"lastValue", "lastOrder", "dataMap", "sortedDataMap"});
        return new RowType(fieldTypes2, fieldNames);
    }
}

