/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.util.Arrays;

public class BaseConversionUtils {
    private static long unsignedLongDiv(long x, int m) {
        if (x >= 0L) {
            return x / (long)m;
        }
        return x / (long)m + 2L * (Long.MAX_VALUE / (long)m) + (long)(2 / m) + (x % (long)m + 2L * (Long.MAX_VALUE % (long)m) + (long)(2 % m)) / (long)m;
    }

    private static void decode(byte[] value, long val, int radix) {
        Arrays.fill(value, (byte)0);
        int i = value.length - 1;
        while (val != 0L) {
            long q = BaseConversionUtils.unsignedLongDiv(val, radix);
            value[i] = (byte)(val - q * (long)radix);
            val = q;
            --i;
        }
    }

    private static long encode(byte[] value, int radix, int fromPos) {
        long val = 0L;
        long bound = BaseConversionUtils.unsignedLongDiv(-1 - radix, radix);
        for (int i = fromPos; i < value.length && value[i] >= 0; ++i) {
            if (val >= bound && BaseConversionUtils.unsignedLongDiv(-1 - value[i], radix) < val) {
                return -1L;
            }
            val = val * (long)radix + (long)value[i];
        }
        return val;
    }

    private static void byte2char(byte[] value, int radix, int fromPos) {
        for (int i = fromPos; i < value.length; ++i) {
            value[i] = (byte)Character.toUpperCase(Character.forDigit(value[i], radix));
        }
    }

    private static boolean char2byte(byte[] value, int radix, int fromPos) {
        for (int i = fromPos; i < value.length; ++i) {
            value[i] = (byte)Character.digit(value[i], radix);
            if (value[i] != -1) continue;
            return false;
        }
        return true;
    }

    public static String conv(byte[] n, int fromBase, int toBase) {
        byte[] value = new byte[64];
        if (n == null || n.length < 1) {
            return null;
        }
        if (fromBase < 2 || fromBase > 36 || Math.abs(toBase) < 2 || Math.abs(toBase) > 36) {
            return null;
        }
        boolean negative = n[0] == 45;
        int first = 0;
        if (negative) {
            first = 1;
        }
        for (int i = 1; i <= n.length - first; ++i) {
            value[value.length - i] = n[n.length - i];
        }
        if (!BaseConversionUtils.char2byte(value, fromBase, value.length - n.length + first)) {
            return null;
        }
        long val = BaseConversionUtils.encode(value, fromBase, value.length - n.length + first);
        if (negative && toBase > 0) {
            val = val < 0L ? -1L : -val;
        }
        if (toBase < 0 && val < 0L) {
            val = -val;
            negative = true;
        }
        BaseConversionUtils.decode(value, val, Math.abs(toBase));
        for (first = 0; first < value.length - 1 && value[first] == 0; ++first) {
        }
        BaseConversionUtils.byte2char(value, Math.abs(toBase), first);
        if (negative && toBase < 0) {
            value[--first] = 45;
        }
        return new String(value, first, value.length - first);
    }
}

