/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalUtils {
    public static boolean isDecimal(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof Float || obj instanceof Double || obj instanceof BigDecimal || obj instanceof BigInteger) {
            return true;
        }
        if (obj instanceof String || obj instanceof Character) {
            String s = obj.toString();
            if (s == null || "".equals(s)) {
                return false;
            }
            return DecimalUtils.isInteger(s) || DecimalUtils.isLong(s) || DecimalUtils.isDouble(s);
        }
        return false;
    }

    private static boolean isInteger(String s) {
        boolean flag = true;
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e2) {
            flag = false;
        }
        return flag;
    }

    private static boolean isLong(String s) {
        boolean flag = true;
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e2) {
            flag = false;
        }
        return flag;
    }

    private static boolean isDouble(String s) {
        boolean flag = true;
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e2) {
            flag = false;
        }
        return flag;
    }
}

