/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.util.Preconditions;

public class NullAwareJoinHelper {
    public static int[] getNullFilterKeys(boolean[] filterNulls) {
        Preconditions.checkArgument(filterNulls.length > 0);
        ArrayList<Integer> nullFilterKeyList = new ArrayList<Integer>();
        for (int i = 0; i < filterNulls.length; ++i) {
            if (!filterNulls[i]) continue;
            nullFilterKeyList.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])nullFilterKeyList.toArray(new Integer[0]));
    }

    public static boolean shouldFilter(boolean nullSafe, boolean filterAllNulls, int[] nullFilterKeys, BinaryRow key) {
        return !nullSafe && (filterAllNulls ? key.anyNull() : key.anyNull(nullFilterKeys));
    }
}

