/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.join.batch.NullAwareJoinHelper;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;

public class SortMergeFullOuterJoinIterator
implements Closeable {
    private final Projection<BinaryRow, BinaryRow> projection1;
    private final Projection<BinaryRow, BinaryRow> projection2;
    private final RecordComparator keyComparator;
    private final MutableObjectIterator<BinaryRow> iterator1;
    private final MutableObjectIterator<BinaryRow> iterator2;
    private BinaryRow row1;
    private BinaryRow key1;
    private BinaryRow row2;
    private BinaryRow key2;
    private BinaryRow matchKey;
    private ResettableExternalBuffer buffer1;
    private ResettableExternalBuffer buffer2;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;

    public SortMergeFullOuterJoinIterator(BinaryRowSerializer serializer1, BinaryRowSerializer serializer2, Projection projection1, Projection projection2, RecordComparator keyComparator, MutableObjectIterator<BinaryRow> iterator1, MutableObjectIterator<BinaryRow> iterator2, ResettableExternalBuffer buffer1, ResettableExternalBuffer buffer2, boolean[] filterNulls) throws IOException {
        this.projection1 = projection1;
        this.projection2 = projection2;
        this.keyComparator = keyComparator;
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.row1 = serializer1.createInstance();
        this.row2 = serializer2.createInstance();
        this.buffer1 = buffer1;
        this.buffer2 = buffer2;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls.length;
        this.nextRow1();
        this.nextRow2();
    }

    private boolean shouldFilter(BinaryRow key) {
        return NullAwareJoinHelper.shouldFilter(this.nullSafe, this.filterAllNulls, this.nullFilterKeys, key);
    }

    public boolean nextOuterJoin() throws IOException {
        if (this.key1 != null && (this.shouldFilter(this.key1) || this.key2 == null)) {
            this.matchKey = null;
            this.bufferRows1();
            this.buffer2.reset();
            return true;
        }
        if (this.key2 != null && (this.shouldFilter(this.key2) || this.key1 == null)) {
            this.matchKey = null;
            this.buffer1.reset();
            this.bufferRows2();
            return true;
        }
        if (this.key1 != null && this.key2 != null) {
            int cmp = this.keyComparator.compare(this.key1, this.key2);
            if (cmp == 0) {
                this.matchKey = this.key1;
                this.bufferRows1();
                this.bufferRows2();
            } else if (cmp > 0) {
                this.matchKey = null;
                this.buffer1.reset();
                this.bufferRows2();
            } else {
                this.matchKey = null;
                this.buffer2.reset();
                this.bufferRows1();
            }
            return true;
        }
        return false;
    }

    private void bufferRows1() throws IOException {
        BinaryRow copy2 = this.key1.copy();
        this.buffer1.reset();
        do {
            this.buffer1.add(this.row1);
        } while (this.nextRow1() && this.keyComparator.compare(this.key1, copy2) == 0);
    }

    private void bufferRows2() throws IOException {
        BinaryRow copy2 = this.key2.copy();
        this.buffer2.reset();
        do {
            this.buffer2.add(this.row2);
        } while (this.nextRow2() && this.keyComparator.compare(this.key2, copy2) == 0);
    }

    private boolean nextRow1() throws IOException {
        this.row1 = this.iterator1.next(this.row1);
        if (this.row1 != null) {
            this.key1 = this.projection1.apply(this.row1);
            return true;
        }
        this.row1 = null;
        this.key1 = null;
        return false;
    }

    private boolean nextRow2() throws IOException {
        this.row2 = this.iterator2.next(this.row2);
        if (this.row2 != null) {
            this.key2 = this.projection2.apply(this.row2);
            return true;
        }
        this.row2 = null;
        this.key2 = null;
        return false;
    }

    public BinaryRow getMatchKey() {
        return this.matchKey;
    }

    public ResettableExternalBuffer getBuffer1() {
        return this.buffer1;
    }

    public ResettableExternalBuffer getBuffer2() {
        return this.buffer2;
    }

    @Override
    public void close() {
        this.buffer1.close();
        this.buffer2.close();
    }
}

