/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch.hashtable;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.operators.util.BitSet;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.join.batch.hashtable.BinaryHashBucketArea;
import org.apache.flink.table.runtime.join.batch.hashtable.BinaryHashPartition;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.Preconditions;

public class BuildSideIterator
implements RowIterator<BinaryRow> {
    private final BinaryRowSerializer accessor;
    private final ArrayList<BinaryHashPartition> partitionsBeingBuilt;
    private final BitSet probedSet;
    private final boolean matchedOrUnmatched;
    private int areaIndex;
    private BinaryRow reuse;
    private BucketIterator bucketIterator;

    BuildSideIterator(BinaryRowSerializer accessor, BinaryRow reuse, ArrayList<BinaryHashPartition> partitionsBeingBuilt, BitSet probedSet, boolean matchedOrUnmatched) {
        this.accessor = accessor;
        this.partitionsBeingBuilt = partitionsBeingBuilt;
        this.probedSet = probedSet;
        this.reuse = reuse;
        this.matchedOrUnmatched = matchedOrUnmatched;
        this.areaIndex = -1;
    }

    @Override
    public boolean advanceNext() {
        if (this.bucketIterator != null && this.bucketIterator.advanceNext()) {
            return true;
        }
        ++this.areaIndex;
        while (this.areaIndex < this.partitionsBeingBuilt.size()) {
            BucketIterator iterator;
            BinaryHashPartition partition2 = this.partitionsBeingBuilt.get(this.areaIndex);
            if (partition2.isInMemory() && (iterator = new BucketIterator(partition2.bucketArea, this.accessor, this.reuse, this.probedSet, this.matchedOrUnmatched)).advanceNext()) {
                this.bucketIterator = iterator;
                return true;
            }
            ++this.areaIndex;
        }
        return false;
    }

    @Override
    public BinaryRow getRow() {
        return this.bucketIterator.getRow();
    }

    public static class BucketIterator
    implements RowIterator<BinaryRow> {
        private BinaryHashBucketArea area;
        private final BinaryRowSerializer accessor;
        private final BitSet probedSet;
        private final boolean matchedOrUnmatched;
        private MemorySegment bucketSegment;
        private MemorySegment[] overflowSegments;
        private int scanCount;
        private int bucketInSegmentOffset;
        private int pointerOffset;
        private int countInBucket;
        private int numInBucket;
        private BinaryRow reuse;
        private BinaryRow instance;

        BucketIterator(BinaryHashBucketArea area, BinaryRowSerializer accessor, BinaryRow reuse, BitSet probedSet, boolean matchedOrUnmatched) {
            this.area = area;
            this.accessor = accessor;
            this.probedSet = probedSet;
            this.reuse = reuse;
            this.matchedOrUnmatched = matchedOrUnmatched;
            this.scanCount = -1;
            this.moveToNextBucket();
        }

        @Override
        public boolean advanceNext() {
            block1: {
                do {
                    this.instance = this.nextInBucket(this.reuse);
                    if (this.instance != null) break block1;
                } while (this.moveToNextBucket());
                return false;
            }
            return true;
        }

        @Override
        public BinaryRow getRow() {
            return this.instance;
        }

        private boolean moveToNextBucket() {
            ++this.scanCount;
            if (this.scanCount >= this.area.numBuckets) {
                return false;
            }
            int bucketArrayPos = this.scanCount >> this.area.table.bucketsPerSegmentBits;
            int currentBucketInSegmentOffset = (this.scanCount & this.area.table.bucketsPerSegmentMask) << 7;
            MemorySegment currentBucket = this.area.buckets[bucketArrayPos];
            this.setBucket(currentBucket, this.area.overflowSegments, currentBucketInSegmentOffset);
            return true;
        }

        private void setBucket(MemorySegment bucket, MemorySegment[] overflowSegments, int bucketInSegmentOffset) {
            this.bucketSegment = bucket;
            this.overflowSegments = overflowSegments;
            this.bucketInSegmentOffset = bucketInSegmentOffset;
            this.pointerOffset = bucketInSegmentOffset + 68;
            this.countInBucket = bucket.getShort(bucketInSegmentOffset + 0);
            this.numInBucket = 0;
            this.probedSet.setMemorySegment(this.bucketSegment, this.bucketInSegmentOffset + 2);
        }

        private BinaryRow nextInBucket(BinaryRow reuse) {
            while (this.countInBucket != 0) {
                Preconditions.checkNotNull(this.bucketSegment);
                while (this.numInBucket < this.countInBucket) {
                    boolean probed = this.probedSet.get(this.numInBucket);
                    ++this.numInBucket;
                    if (this.matchedOrUnmatched == probed) {
                        try {
                            this.area.partition.setReadPosition(this.bucketSegment.getInt(this.pointerOffset));
                            reuse = this.accessor.mapFromPages(reuse, (AbstractPagedInputView)this.area.partition);
                            this.pointerOffset += 4;
                            return reuse;
                        }
                        catch (IOException ioex) {
                            throw new RuntimeException("Error deserializing key or value from the hashtable: " + ioex.getMessage(), ioex);
                        }
                    }
                    this.pointerOffset += 4;
                }
                int forwardPointer = this.bucketSegment.getInt(this.bucketInSegmentOffset + 4);
                if (forwardPointer == -1) {
                    return null;
                }
                int overflowSegIndex = forwardPointer >>> this.area.table.segmentSizeBits;
                this.bucketSegment = this.overflowSegments[overflowSegIndex];
                this.bucketInSegmentOffset = forwardPointer & this.area.table.segmentSizeMask;
                this.pointerOffset = this.bucketInSegmentOffset + 68;
                this.countInBucket = this.bucketSegment.getShort(this.bucketInSegmentOffset + 0);
                this.numInBucket = 0;
                this.probedSet.setMemorySegment(this.bucketSegment, this.bucketInSegmentOffset + 2);
            }
            return null;
        }
    }
}

