/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.JoinStateHandler;
import org.apache.flink.util.Preconditions;

@Internal
public class JoinKeyNotContainPrimaryKeyStateHandler
implements JoinStateHandler {
    private final KeyedMapState<BaseRow, BaseRow, Tuple2<BaseRow, Long>> keyedMapState;
    private final KeySelector<BaseRow, BaseRow> keySelector;
    private final Projection<BaseRow, BaseRow> pkProjection;
    private transient BaseRow joinKey;
    private transient BaseRow pk;

    public JoinKeyNotContainPrimaryKeyStateHandler(KeyedMapState<BaseRow, BaseRow, Tuple2<BaseRow, Long>> keyedMapState, KeySelector<BaseRow, BaseRow> keySelector, Projection<BaseRow, BaseRow> pkProjection) {
        this.keyedMapState = keyedMapState;
        this.keySelector = keySelector;
        this.pkProjection = pkProjection;
    }

    @Override
    public void extractCurrentJoinKey(BaseRow row2) throws Exception {
        this.joinKey = this.keySelector.getKey(row2);
    }

    @Override
    public BaseRow getCurrentJoinKey() {
        return this.joinKey;
    }

    @Override
    public void extractCurrentPrimaryKey(BaseRow row2) {
        this.pk = this.pkProjection.apply(row2);
    }

    @Override
    public BaseRow getCurrentPrimaryKey() {
        return this.pk;
    }

    @Override
    public long add(BaseRow row2, long expireTime) {
        this.keyedMapState.add((Object)this.joinKey, (Object)this.pk, new Tuple2<BaseRow, Long>(row2, expireTime));
        return 1L;
    }

    @Override
    public long retract(BaseRow row2) {
        this.keyedMapState.remove((Object)this.joinKey, (Object)this.pk);
        return 0L;
    }

    @Override
    public void batchGet(Collection<? extends BaseRow> keys) {
        throw new RuntimeException("batchGet is not supported for JoinKeyNotContainPrimaryKeyStateHandler");
    }

    @Override
    public void setCurrentJoinKey(BaseRow row2) {
        this.joinKey = row2;
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecords(BaseRow key) {
        return new Tuple3Iterator(this.keyedMapState.iterator((Object)key));
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecordsFromCache(BaseRow key) {
        return this.getRecords(key);
    }

    @Override
    public boolean contains(BaseRow key, BaseRow row2) {
        return this.keyedMapState.contains((Object)key, (Object)this.pkProjection.apply(row2));
    }

    @Override
    public void update(BaseRow key, BaseRow row2, long count, long expireTime) {
        this.keyedMapState.add((Object)key, (Object)this.pkProjection.apply(row2), new Tuple2<BaseRow, Long>(row2, expireTime));
    }

    @Override
    public long[] batchUpdate(BaseRow key, List<Tuple2<BaseRow, Long>> rows, long expireTime) {
        HashMap addMap = new HashMap();
        HashMap<BaseRow, Integer> deleteMap = new HashMap<BaseRow, Integer>();
        long[] updateStatus = new long[rows.size()];
        int idx = 0;
        for (Tuple2<BaseRow, Long> tuple2 : rows) {
            if ((Long)tuple2.f1 < 0L) {
                updateStatus[idx] = -1L;
                deleteMap.put(this.pkProjection.apply((BaseRow)tuple2.f0), idx);
            } else {
                updateStatus[idx] = 1L;
                addMap.put(this.pkProjection.apply((BaseRow)tuple2.f0), new Tuple2(tuple2.f0, expireTime));
            }
            ++idx;
        }
        for (Map.Entry entry : addMap.entrySet()) {
            Integer index = (Integer)deleteMap.get(entry.getKey());
            if (index == null) continue;
            deleteMap.remove(entry.getKey());
            updateStatus[index.intValue()] = 0L;
        }
        this.keyedMapState.removeAll((Object)key, deleteMap.keySet());
        this.keyedMapState.addAll((Object)key, addMap);
        return updateStatus;
    }

    @Override
    public void putAll(Map<BaseRow, BaseRow> putMap) {
        throw new RuntimeException("MapState don't support putAll!");
    }

    @Override
    public void removeAll(Set<BaseRow> keys) {
        throw new RuntimeException("MapState don't support removeAll!");
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedMapState.remove((Object)joinKey);
    }

    private class Tuple3Iterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final Iterator<Map.Entry<BaseRow, Tuple2<BaseRow, Long>>> internalIterator;
        private final Tuple3<BaseRow, Long, Long> reuse;

        Tuple3Iterator(Iterator<Map.Entry<BaseRow, Tuple2<BaseRow, Long>>> internalIterator) {
            Preconditions.checkNotNull(internalIterator);
            this.internalIterator = internalIterator;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            Tuple2<BaseRow, Long> tuple2 = this.internalIterator.next().getValue();
            this.reuse.f0 = tuple2.f0;
            this.reuse.f1 = 1L;
            this.reuse.f2 = tuple2.f1;
            return this.reuse;
        }

        @Override
        public void remove() {
            this.internalIterator.remove();
        }
    }
}

