/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state.match;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.match.JoinMatchStateHandler;

public class JoinKeyContainPrimaryKeyMatchStateHandler
implements JoinMatchStateHandler {
    private final KeyedValueState<BaseRow, Long> keyedValueState;
    private transient BaseRow currentJoinKey;
    private transient long currentRowMatchJoinCount;

    public JoinKeyContainPrimaryKeyMatchStateHandler(KeyedValueState<BaseRow, Long> keyedValueState) {
        this.keyedValueState = keyedValueState;
    }

    @Override
    public void extractCurrentRowMatchJoinCount(BaseRow joinKey, BaseRow row2, long possibleJoinCnt) {
        this.currentJoinKey = joinKey;
        Long count = (Long)this.keyedValueState.get((Object)joinKey);
        this.currentRowMatchJoinCount = null == count ? 0L : count;
    }

    @Override
    public long getCurrentRowMatchJoinCnt() {
        return this.currentRowMatchJoinCount;
    }

    @Override
    public void resetCurrentRowMatchJoinCnt(long joinCnt) {
        this.keyedValueState.put((Object)this.currentJoinKey, (Object)joinCnt);
        this.currentRowMatchJoinCount = joinCnt;
    }

    @Override
    public void updateRowMatchJoinCnt(BaseRow joinKey, BaseRow baseRow, long joinCnt) {
        this.keyedValueState.put((Object)joinKey, (Object)joinCnt);
    }

    @Override
    public void addRowMatchJoinCnt(BaseRow joinKey, BaseRow baseRow, long joinCnt) {
        this.keyedValueState.put((Object)joinKey, (Object)joinCnt);
    }

    @Override
    public void remove(BaseRow joinKey, BaseRow baseRow) {
        this.keyedValueState.remove((Object)joinKey);
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedValueState.remove((Object)joinKey);
    }

    @Override
    public void removeAll(BaseRow joinKey, Set<BaseRow> keys) {
        if (!keys.isEmpty()) {
            HashSet<BaseRow> set = new HashSet<BaseRow>();
            set.add(joinKey);
            this.keyedValueState.removeAll(set);
        }
    }

    @Override
    public void addAll(BaseRow joinKey, Map<BaseRow, Long> kvs) {
        if (!kvs.isEmpty()) {
            HashMap<BaseRow, Long> putMap = new HashMap<BaseRow, Long>();
            for (Map.Entry<BaseRow, Long> entry : kvs.entrySet()) {
                putMap.put(joinKey, entry.getValue());
            }
            this.keyedValueState.putAll(putMap);
        }
    }
}

