/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.overagg;

import org.apache.flink.table.codegen.GeneratedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.AggsHandleFunction;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.overagg.OverWindowFrame;
import org.apache.flink.table.runtime.overagg.OverWindowFrame$;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001f\t)rJ\u001a4tKR|e/\u001a:XS:$wn\u001e$sC6,'BA\u0002\u0005\u0003\u001dyg/\u001a:bO\u001eT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\bPm\u0016\u0014x+\u001b8e_^4%/Y7f\u0011!)\u0002A!A!\u0002\u00131\u0012AE1hOND\u0015M\u001c3mK\u001a+hn\u0019;j_:\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u000f\r|G-Z4f]&\u00111\u0004\u0007\u0002\u001c\u000f\u0016tWM]1uK\u0012\fumZ:IC:$G.\u001a$v]\u000e$\u0018n\u001c8\t\u0011u\u0001!\u0011!Q\u0001\ny\taa\u001c4gg\u0016$\bCA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001\u0002'p]\u001eD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000fG\u0006d7m\u00144gg\u0016$h)\u001e8d!\u0011yr%\u000b\u0010\n\u0005!\u0002#!\u0003$v]\u000e$\u0018n\u001c82!\tQS&D\u0001,\u0015\tac!\u0001\u0006eCR\fgm\u001c:nCRL!AL\u0016\u0003\u000f\t\u000b7/\u001a*po\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"BAM\u001a5kA\u0011\u0011\u0003\u0001\u0005\u0006+=\u0002\rA\u0006\u0005\u0006;=\u0002\rA\b\u0005\u0006K=\u0002\rA\n\u0005\no\u0001\u0001\r\u0011!Q!\na\n\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\"\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\ti$H\u0001\nBO\u001e\u001c\b*\u00198eY\u00164UO\\2uS>t\u0007\"C \u0001\u0001\u0004\u0005\t\u0015)\u0003A\u00035Ig\u000e];u\u0013R,'/\u0019;peB\u0011\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\tA!\u001e;jY&\u0011ai\u0011\u0002\u0019%\u0016\u001cX\r\u001e;bE2,W\t\u001f;fe:\fGNQ;gM\u0016\u0014\u0018B\u0001%F\u00059\u0011UO\u001a4fe&#XM]1u_JDaA\u0013\u0001!B\u0013q\u0012AC5oaV$\u0018J\u001c3fq\"IA\n\u0001a\u0001\u0002\u0003\u0006K!Q\u0001\u000fKb$XM\u001d8bY\n+hMZ3s\u0011\u0019q\u0005\u0001)Q\u0005=\u0005\u00192-\u001e:sK:$()\u001e4gKJdUM\\4uQ\")\u0001\u000b\u0001C!#\u0006!q\u000e]3o)\t\u0011V\u000b\u0005\u0002 '&\u0011A\u000b\t\u0002\u0005+:LG\u000fC\u0003W\u001f\u0002\u0007q+A\u0002dib\u0004\"!\u000f-\n\u0005eS$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003-\u0011Xm]3u\u0005V4g-\u001a:\u0015\u0005Ik\u0006\"\u00020[\u0001\u0004\t\u0015\u0001\u0002:poNDQ\u0001\u0019\u0001\u0005B\u0005\fQa\u001e:ji\u0016$2!\u000b2h\u0011\u0015\u0019w\f1\u0001e\u0003\u0015Ig\u000eZ3y!\tyR-\u0003\u0002gA\t\u0019\u0011J\u001c;\t\u000b!|\u0006\u0019A\u0015\u0002\u000f\r,(O]3oi\u0002")
public class OffsetOverWindowFrame
extends OverWindowFrame {
    private final GeneratedAggsHandleFunction aggsHandleFunction;
    private final long offset;
    private final Function1<BaseRow, Object> calcOffsetFunc;
    private AggsHandleFunction processor;
    private ResettableExternalBuffer.BufferIterator inputIterator;
    private long inputIndex;
    private ResettableExternalBuffer externalBuffer;
    private long currentBufferLength;

    @Override
    public void open(ExecutionContext ctx) {
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(Thread.currentThread().getContextClassLoader());
        this.processor.open(ctx);
    }

    @Override
    public void resetBuffer(ResettableExternalBuffer rows) {
        this.processor.setAccumulators(this.processor.createAccumulators());
        this.currentBufferLength = rows.size();
        this.inputIndex = this.offset;
        if (this.calcOffsetFunc == null) {
            if (this.inputIterator != null) {
                this.inputIterator.close();
            }
            this.inputIterator = this.offset >= 0L ? rows.newIterator((int)this.offset) : rows.newIterator();
        } else {
            this.externalBuffer = rows;
        }
    }

    @Override
    public BaseRow write(int index, BaseRow current) {
        if (this.calcOffsetFunc == null) {
            if (this.inputIndex >= 0L && this.inputIndex < this.currentBufferLength) {
                this.processor.accumulate(OverWindowFrame$.MODULE$.getNextOrNull(this.inputIterator));
            } else {
                this.processor.retract(current);
            }
            ++this.inputIndex;
        } else {
            long realIndex = BoxesRunTime.unboxToLong((Object)this.calcOffsetFunc.apply((Object)current)) + (long)index;
            if (realIndex >= 0L && realIndex < this.currentBufferLength) {
                ResettableExternalBuffer.BufferIterator tempIterator = this.externalBuffer.newIterator((int)realIndex);
                this.processor.accumulate(OverWindowFrame$.MODULE$.getNextOrNull(tempIterator));
                tempIterator.close();
            } else {
                this.processor.retract(current);
            }
        }
        return this.processor.getValue();
    }

    public OffsetOverWindowFrame(GeneratedAggsHandleFunction aggsHandleFunction, long offset, Function1<BaseRow, Object> calcOffsetFunc) {
        this.aggsHandleFunction = aggsHandleFunction;
        this.offset = offset;
        this.calcOffsetFunc = calcOffsetFunc;
        super(aggsHandleFunction);
        this.inputIndex = 0L;
        this.currentBufferLength = 0L;
    }
}

