/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.typeutils.runtime.NullAwareComparator;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.InternalType;

public class KeyExtractor
implements Serializable {
    private final int[] keyPositions;
    private final InternalType[] types;
    private final NullAwareComparator[] nullAwareComparators;

    public KeyExtractor(int[] keyPositions, boolean[] orders, InternalType[] types, TypeComparator[] comparators) {
        this.keyPositions = keyPositions;
        this.types = types;
        this.nullAwareComparators = new NullAwareComparator[comparators.length];
        for (int i = 0; i < this.nullAwareComparators.length; ++i) {
            this.nullAwareComparators[i] = new NullAwareComparator(comparators[i], orders[i]);
        }
    }

    public TypeComparator[] getFlatComparators() {
        LinkedList flatComparators = new LinkedList();
        for (NullAwareComparator c : this.nullAwareComparators) {
            Collections.addAll(flatComparators, ((TypeComparator)c).getFlatComparators());
        }
        return flatComparators.toArray(new TypeComparator[0]);
    }

    public int extractKeys(BaseRow record, Object[] target, int index) {
        int len = this.nullAwareComparators.length;
        int localIndex = index;
        for (int i = 0; i < len; ++i) {
            int pos = this.keyPositions[i];
            Object element = record.isNullAt(pos) ? null : TypeGetterSetters.get(record, pos, this.types[pos]);
            localIndex += this.nullAwareComparators[i].extractKeys(element, target, localIndex);
        }
        return localIndex - index;
    }
}

