/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import java.io.Serializable;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.XORShiftRandom;

@Internal
public class ReservoirSamplerWithoutReplacement
implements Serializable {
    private final int numSamples;
    private final Random random;
    private IntermediateSampleData<BaseRow> smallest = null;
    private final PriorityQueue<IntermediateSampleData<BaseRow>> queue;
    private int index = 0;
    private Projection<BaseRow, BaseRow> projection;

    ReservoirSamplerWithoutReplacement(int numSamples, long seed) {
        Preconditions.checkArgument(numSamples >= 0, "numSamples should be non-negative.");
        this.numSamples = numSamples;
        this.random = new XORShiftRandom(seed);
        this.queue = new PriorityQueue(numSamples);
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    void collectPartitionData(BaseRow baseRow) {
        double weight = this.random.nextDouble();
        if (this.index < this.numSamples) {
            this.addQueue(weight, this.projection.apply(baseRow));
            this.smallest = this.queue.peek();
        } else if (weight > this.smallest.getWeight()) {
            this.queue.remove();
            this.addQueue(weight, this.projection.apply(baseRow));
            this.smallest = this.queue.peek();
        }
        ++this.index;
    }

    void collectSampleData(IntermediateSampleData<BaseRow> sampleData) {
        if (this.index < this.numSamples) {
            this.addQueue(sampleData.getWeight(), this.projection.apply((BaseRow)sampleData.getElement()));
            this.smallest = this.queue.peek();
        } else if (sampleData.getWeight() > this.smallest.getWeight()) {
            this.queue.remove();
            this.addQueue(sampleData.getWeight(), this.projection.apply((BaseRow)sampleData.getElement()));
            this.smallest = this.queue.peek();
        }
        ++this.index;
    }

    private void addQueue(double weight, BaseRow row2) {
        this.queue.add((IntermediateSampleData<BaseRow>)new IntermediateSampleData(weight, (Object)row2));
    }

    Iterator<IntermediateSampleData<BaseRow>> sample() {
        return this.queue.iterator();
    }
}

