/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.Arrays;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.table.runtime.util.BloomFilter;
import org.apache.flink.util.SerializedValue;

public class BloomFilterAcc
implements Accumulator<SerializedValue, SerializedValue> {
    private byte[] bytes;

    @Override
    public void add(SerializedValue value) {
        if (this.bytes == null) {
            this.bytes = value.getByteArray();
        } else {
            BloomFilter.mergeBloomFilterBytes(this.bytes, value.getByteArray());
        }
    }

    @Override
    public SerializedValue getLocalValue() {
        if (this.bytes == null) {
            return null;
        }
        return SerializedValue.fromBytes(this.bytes);
    }

    @Override
    public void resetLocal() {
        this.bytes = null;
    }

    @Override
    public void merge(Accumulator<SerializedValue, SerializedValue> other) {
        BloomFilter.mergeBloomFilterBytes(this.bytes, ((BloomFilterAcc)other).bytes);
    }

    @Override
    public Accumulator<SerializedValue, SerializedValue> clone() {
        BloomFilterAcc clone = new BloomFilterAcc();
        clone.bytes = Arrays.copyOf(this.bytes, this.bytes.length);
        return clone;
    }

    public static BloomFilterAcc fromBytes(byte[] bytes) {
        BloomFilterAcc acc = new BloomFilterAcc();
        acc.add(SerializedValue.fromBytes(bytes));
        return acc;
    }
}

