/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.ListMemorySegmentSource;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public class InMemoryBuffer
implements Closeable {
    private final int segmentSize;
    private final ArrayList<MemorySegment> freeMemory;
    private final AbstractRowSerializer serializer;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private final SimpleCollectingOutputView recordCollector;
    private long currentDataBufferOffset;
    private int numBytesInLastBuffer;
    private int recordCount;
    private LinkedList<BufferIterator> iterators;

    public InMemoryBuffer(List<MemorySegment> memory, AbstractRowSerializer serializer) {
        this.segmentSize = memory.get(0).size();
        this.freeMemory = new ArrayList<MemorySegment>(memory);
        this.serializer = (AbstractRowSerializer)serializer.duplicate();
        this.recordBufferSegments = new ArrayList(memory.size());
        this.recordCollector = new SimpleCollectingOutputView(this.recordBufferSegments, (MemorySegmentSource)new ListMemorySegmentSource(this.freeMemory), this.segmentSize);
        this.recordCount = 0;
        this.iterators = new LinkedList();
    }

    public void reset() {
        this.currentDataBufferOffset = 0L;
        this.recordCount = 0;
        this.freeMemory.addAll(this.recordBufferSegments);
        this.recordBufferSegments.clear();
        this.recordCollector.reset();
        this.iterators.clear();
    }

    @Override
    public void close() {
        this.freeMemory.clear();
        this.recordBufferSegments.clear();
        this.iterators.clear();
    }

    public boolean write(BaseRow row2) throws IOException {
        try {
            this.serializer.serializeToPages(row2, (AbstractPagedOutputView)this.recordCollector);
            this.currentDataBufferOffset = this.recordCollector.getCurrentOffset();
            this.numBytesInLastBuffer = this.recordCollector.getCurrentPositionInSegment();
            ++this.recordCount;
            for (BufferIterator iterator : this.iterators) {
                iterator.recordBuffer.updateLimitInLastSegment(this.numBytesInLastBuffer);
            }
            return true;
        }
        catch (EOFException e2) {
            return false;
        }
    }

    public ArrayList<MemorySegment> getRecordBufferSegments() {
        return this.recordBufferSegments;
    }

    public long getCurrentDataBufferOffset() {
        return this.currentDataBufferOffset;
    }

    public int getNumRecordBuffers() {
        int result = (int)(this.currentDataBufferOffset / (long)this.segmentSize);
        long mod = this.currentDataBufferOffset % (long)this.segmentSize;
        if (mod != 0L) {
            ++result;
        }
        return result;
    }

    public int getNumBytesInLastBuffer() {
        return this.numBytesInLastBuffer;
    }

    public final BufferIterator newIterator() {
        return this.newIterator(0, 0L);
    }

    public final BufferIterator newIterator(int beginRow, long offset) {
        Preconditions.checkArgument(offset >= 0L, "`offset` can't be negative!");
        RandomAccessInputView recordBuffer = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize, this.numBytesInLastBuffer);
        BufferIterator iterator = new BufferIterator(beginRow, offset, recordBuffer);
        this.iterators.add(iterator);
        return iterator;
    }

    public class BufferIterator
    implements MutableObjectIterator<BinaryRow>,
    Closeable {
        private int beginRow;
        private int nextRow;
        private RandomAccessInputView recordBuffer;

        private BufferIterator(int beginRow, long offset, RandomAccessInputView recordBuffer) {
            this.beginRow = beginRow;
            this.recordBuffer = recordBuffer;
            this.reset(offset);
        }

        public void reset(long offset) {
            this.nextRow = this.beginRow;
            this.recordBuffer.setReadPosition(offset);
        }

        @Override
        public BinaryRow next(BinaryRow reuse) throws IOException {
            try {
                if (this.nextRow >= InMemoryBuffer.this.recordCount) {
                    return null;
                }
                ++this.nextRow;
                return InMemoryBuffer.this.serializer.mapFromPages(reuse, (AbstractPagedInputView)this.recordBuffer);
            }
            catch (EOFException e2) {
                return null;
            }
        }

        @Override
        public BinaryRow next() throws IOException {
            throw new RuntimeException("Not support!");
        }

        @Override
        public void close() {
            InMemoryBuffer.this.iterators.remove(this);
        }
    }
}

