/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.table.runtime.util.BloomFilter;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeFilterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeFilterUtils.class);

    public static CompletableFuture<BloomFilter> asyncGetBroadcastBloomFilter(StreamingRuntimeContext context, String broadcastId) {
        CompletableFuture future = context.queryPreAggregatedAccumulator(broadcastId);
        return future.handleAsync((accumulator, e2) -> {
            if (e2 == null && accumulator != null) {
                LOG.info("get runtime filter success, broadcastId: " + broadcastId);
                return BloomFilter.fromBytes(((SerializedValue)accumulator.getLocalValue()).getByteArray());
            }
            if (e2 != null) {
                LOG.error(e2.getMessage(), e2);
            }
            return null;
        });
    }
}

