/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.TimeZone;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.window.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;

public class TumblingWindowAssigner
extends WindowAssigner<TimeWindow>
implements InternalTimeWindowAssigner {
    private static final long serialVersionUID = -1671849072115929859L;
    private final long size;
    private final long offset;
    private final TimeZone timeZone;
    private final boolean isEventTime;

    protected TumblingWindowAssigner(long size, long offset, TimeZone timeZone, boolean isEventTime) {
        if (size <= 0L) {
            throw new IllegalArgumentException("TumblingWindowAssigner parameters must satisfy size > 0");
        }
        this.size = size;
        this.timeZone = timeZone;
        this.offset = offset;
        this.isEventTime = isEventTime;
    }

    protected TumblingWindowAssigner(long size, long offset, boolean isEventTime) {
        this(size, offset, TimeZone.getTimeZone("UTC"), isEventTime);
    }

    protected TumblingWindowAssigner(long size, TimeZone timeZone, boolean isEventTime) {
        this(size, -timeZone.getOffset(15L), timeZone, isEventTime);
    }

    @Override
    public Collection<TimeWindow> assignWindows(BaseRow element, long timestamp) {
        long tzOffset = this.offset;
        if (this.timeZone.useDaylightTime()) {
            tzOffset = -this.timeZone.getOffset(timestamp);
        }
        long start = TimeWindow.getWindowStartWithOffset(timestamp, tzOffset, this.size);
        return Collections.singletonList(new TimeWindow(start, start + this.size));
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return this.isEventTime;
    }

    @Override
    public String toString() {
        return "TumblingWindow(" + this.size + ")";
    }

    public static TumblingWindowAssigner of(Duration size) {
        return new TumblingWindowAssigner(size.toMillis(), 0L, true);
    }

    public TumblingWindowAssigner withOffset(Duration offset) {
        return new TumblingWindowAssigner(this.size, offset.toMillis(), this.isEventTime);
    }

    public TumblingWindowAssigner withTimeZone(TimeZone timeZone) {
        return new TumblingWindowAssigner(this.size, timeZone, this.isEventTime);
    }

    @Override
    public TumblingWindowAssigner withEventTime() {
        return new TumblingWindowAssigner(this.size, this.offset, this.timeZone, true);
    }

    @Override
    public TumblingWindowAssigner withProcessingTime() {
        return new TumblingWindowAssigner(this.size, this.offset, this.timeZone, false);
    }
}

