/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.SubKeyedAggsHandleFunction;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.window.internal.InternalWindowProcessFunction;

public class GeneralWindowProcessFunction<K, W extends Window>
extends InternalWindowProcessFunction<K, W> {
    private static final long serialVersionUID = 5992545519395844485L;
    private List<W> reuseAffectedWindows;

    public GeneralWindowProcessFunction(WindowAssigner<W> windowAssigner, SubKeyedAggsHandleFunction<W> windowAggregator, long allowedLateness) {
        super(windowAssigner, windowAggregator, allowedLateness);
    }

    @Override
    public Collection<W> assignStateNamespace(BaseRow inputRow, long timestamp) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows(inputRow, timestamp);
        this.reuseAffectedWindows = new ArrayList<W>(elementWindows.size());
        for (Window window : elementWindows) {
            if (this.isWindowLate(window)) continue;
            this.reuseAffectedWindows.add(window);
        }
        return this.reuseAffectedWindows;
    }

    @Override
    public Collection<W> assignActualWindows(BaseRow inputRow, long timestamp) throws Exception {
        return this.reuseAffectedWindows;
    }

    @Override
    public BaseRow getWindowAggregationResult(W window) throws Exception {
        BaseRow acc = this.ctx.getWindowAccumulators(window);
        if (acc == null) {
            acc = this.windowAggregator.createAccumulators();
        }
        this.windowAggregator.setAccumulators(window, acc);
        return this.windowAggregator.getValue(window);
    }

    @Override
    public void cleanWindowIfNeeded(W window, long time) throws Exception {
        if (this.isCleanupTime(window, time)) {
            this.ctx.clearWindowState(window);
            this.ctx.clearPreviousState(window);
            this.ctx.clearTrigger(window);
        }
    }
}

