/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.csv;

import org.apache.flink.api.java.io.AbstractCsvOutputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.conversion.DataStructureConverters;
import org.apache.flink.table.types.InternalType;

public class BaseRowCsvOutputFormat
extends AbstractCsvOutputFormat<BaseRow> {
    private static final long serialVersionUID = 1L;
    private final InternalType[] fieldTypes;
    private DataStructureConverters.DataStructureConverter[] converters;

    public BaseRowCsvOutputFormat(Path outputPath, InternalType[] fieldTypes2) {
        super(outputPath);
        this.fieldTypes = fieldTypes2;
        this.converters = new DataStructureConverters.DataStructureConverter[fieldTypes2.length];
    }

    protected Object getSpecificField(BaseRow record, int n) {
        if (this.converters[n] == null) {
            this.converters[n] = DataStructureConverters.getConverterForType(this.fieldTypes[n]);
        }
        return this.converters[n].toExternal(record, n);
    }

    protected int getFieldsNum(BaseRow record) {
        return record.getArity();
    }
}

