/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.CleanupWhenUnsuccessful;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LocatedFileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.sinks.filesystem.FileSystemOutputFormat$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.sinks.filesystem.OutputJobDescription;
import org.apache.flink.table.types.RowType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011md!B\u0001\u0003\u0003\u0003y!A\u0006$jY\u0016\u001c\u0016p\u001d;f[>+H\u000f];u\r>\u0014X.\u0019;\u000b\u0005\r!\u0011A\u00034jY\u0016\u001c\u0018p\u001d;f[*\u0011QAB\u0001\u0006g&t7n\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003\u0007\u0015/cA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000fE\u0002\u001aA\tj\u0011A\u0007\u0006\u00037q\t!![8\u000b\u0005uq\u0012AB2p[6|gN\u0003\u0002 \u0011\u0005\u0019\u0011\r]5\n\u0005\u0005R\"\u0001D(viB,HOR8s[\u0006$\bCA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0003O\u0011\u0012qAQ1tKJ{w\u000f\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002\u001a_%\u0011\u0001G\u0007\u0002\u0011\r&t\u0017\r\\5{K>sW*Y:uKJ\u0004\"!\u0007\u001a\n\u0005MR\"AE%oSRL\u0017\r\\5{K>sW*Y:uKJD\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0005a\u0006$\b.F\u00018!\tA4H\u0004\u0002*s%\u0011!HK\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;U!Aq\b\u0001B\u0001B\u0003%q'A\u0003qCRD\u0007\u0005\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0003-!Wm]2sSB$\u0018n\u001c8\u0016\u0003\r\u0003\"\u0001R#\u000e\u0003\tI!A\u0012\u0002\u0003)=+H\u000f];u\u0015>\u0014G)Z:de&\u0004H/[8o\u0011!A\u0005A!A!\u0002\u0013\u0019\u0015\u0001\u00043fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"\u0002&\u0001\t\u0003Y\u0015A\u0002\u001fj]&$h\bF\u0002M\u001b:\u0003\"\u0001\u0012\u0001\t\u000bUJ\u0005\u0019A\u001c\t\u000b\u0005K\u0005\u0019A\"\t\u000fA\u0003!\u0019!C\u0005#\u0006Yqo\u001c:l\t&\u0014h*Y7f+\u0005\u0011\u0006CA\tT\u0013\ta$\u0003\u0003\u0004V\u0001\u0001\u0006IAU\u0001\ro>\u00148\u000eR5s\u001d\u0006lW\r\t\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0003\u001d9xN]6ESJ,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000b!AZ:\u000b\u0005yC\u0011\u0001B2pe\u0016L!\u0001Y.\u0003\tA\u000bG\u000f\u001b\u0005\u0007E\u0002\u0001\u000b\u0011B-\u0002\u0011]|'o\u001b#je\u0002B\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011\u00023\u0016\u0003\u0015\u0004\"A\u00174\n\u0005\u001d\\&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA[\u0001\u0007MN|F%Z9\u0015\u0005-t\u0007CA\u0015m\u0013\ti'F\u0001\u0003V]&$\bbB8i\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0004BB9\u0001A\u0003&Q-A\u0002gg\u0002B#\u0001]:\u0011\u0005%\"\u0018BA;+\u0005%!(/\u00198tS\u0016tG\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\u0006!1m\u001c8g+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011ap\u001f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111A\u0001\tG>tgm\u0018\u0013fcR\u00191.!\u0002\t\u000f=|\u0018\u0011!a\u0001s\"9\u0011\u0011\u0002\u0001!B\u0013I\u0018!B2p]\u001a\u0004\u0003bCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001f\taB];oi&lWmQ8oi\u0016DH/\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018q\t\u0011BZ;oGRLwN\\:\n\t\u0005m\u0011Q\u0003\u0002\u000f%VtG/[7f\u0007>tG/\u001a=u\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\u0002%I,h\u000e^5nK\u000e{g\u000e^3yi~#S-\u001d\u000b\u0004W\u0006\r\u0002\"C8\u0002\u001e\u0005\u0005\t\u0019AA\t\u0011!\t9\u0003\u0001Q!\n\u0005E\u0011a\u0004:v]RLW.Z\"p]R,\u0007\u0010\u001e\u0011\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011QF\u0001\tKb,7mQ8oMV\u0011\u0011q\u0006\t\u0005\u0003c\t\u0019$D\u0001\u001d\u0013\r\t)\u0004\b\u0002\u0010\u000bb,7-\u001e;j_:\u001cuN\u001c4jO\"Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u00031)\u00070Z2D_:4w\fJ3r)\rY\u0017Q\b\u0005\n_\u0006]\u0012\u0011!a\u0001\u0003_A\u0001\"!\u0011\u0001A\u0003&\u0011qF\u0001\nKb,7mQ8oM\u0002B1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\u0005I\u0011N\u001c9viRK\b/Z\u000b\u0003\u0003\u0013\u0002D!a\u0013\u0002\\A1\u0011QJA*\u0003/j!!a\u0014\u000b\u0007\u0005EC$\u0001\u0005usB,\u0017N\u001c4p\u0013\u0011\t)&a\u0014\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004B!!\u0017\u0002\\1\u0001A\u0001DA/\u0003?\n\t\u0011!A\u0003\u0002\u0005-$aA0%c!A\u0011\u0011\r\u0001!B\u0013\t\u0019'\u0001\u0006j]B,H\u000fV=qK\u0002\u0002D!!\u001a\u0002jA1\u0011QJA*\u0003O\u0002B!!\u0017\u0002j\u0011a\u0011QLA0\u0003\u0003\u0005\tQ!\u0001\u0002lE!\u0011QNA:!\rI\u0013qN\u0005\u0004\u0003cR#a\u0002(pi\"Lgn\u001a\t\u0004S\u0005U\u0014bAA<U\t\u0019\u0011I\\=\t\u0017\u0005m\u0004\u00011AA\u0002\u0013%\u0011QP\u0001\u000eS:\u0004X\u000f\u001e+za\u0016|F%Z9\u0015\u0007-\fy\bC\u0005p\u0003s\n\t\u00111\u0001\u0002\u0002B\"\u00111QAD!\u0019\ti%a\u0015\u0002\u0006B!\u0011\u0011LAD\t1\ti&a\u0018\u0002\u0002\u0003\u0005)\u0011AA6\u0011%\tY\t\u0001b\u0001\n\u0013\ti)A\u0006qCRD\u0017j\u001d,bY&$WCAAH!\rI\u0013\u0011S\u0005\u0004\u0003'S#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\u0010\u0006a\u0001/\u0019;i\u0013N4\u0016\r\\5eA!I\u00111\u0014\u0001A\u0002\u0013%\u0011QT\u0001\u000fi\u0016l\u0007o\u0016:ji\u00164\u0015\u000e\\3t+\t\ty\nE\u0003\u0002\"\u0006-v'\u0004\u0002\u0002$*!\u0011QUAT\u0003\u001diW\u000f^1cY\u0016T1!!++\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\u000b\u0019KA\u0002TKRD\u0011\"!-\u0001\u0001\u0004%I!a-\u0002%Q,W\u000e],sSR,g)\u001b7fg~#S-\u001d\u000b\u0004W\u0006U\u0006\"C8\u00020\u0006\u0005\t\u0019AAP\u0011!\tI\f\u0001Q!\n\u0005}\u0015a\u0004;f[B<&/\u001b;f\r&dWm\u001d\u0011)\u0007\u0005]6\u000fC\u0006\u0002@\u0002\u0001\r\u00111A\u0005\u0012\u0005u\u0015aD1eI\u0016$\u0007+\u0019:uSRLwN\\:\t\u0017\u0005\r\u0007\u00011AA\u0002\u0013E\u0011QY\u0001\u0014C\u0012$W\r\u001a)beRLG/[8og~#S-\u001d\u000b\u0004W\u0006\u001d\u0007\"C8\u0002B\u0006\u0005\t\u0019AAP\u0011!\tY\r\u0001Q!\n\u0005}\u0015\u0001E1eI\u0016$\u0007+\u0019:uSRLwN\\:!Q\r\tIm\u001d\u0005\f\u0003#\u0004\u0001\u0019!a\u0001\n\u0003\t\u0019.A\u0007dkJ\u0014XM\u001c;G_Jl\u0017\r^\u000b\u00021!Y\u0011q\u001b\u0001A\u0002\u0003\u0007I\u0011AAm\u0003E\u0019WO\u001d:f]R4uN]7bi~#S-\u001d\u000b\u0004W\u0006m\u0007\u0002C8\u0002V\u0006\u0005\t\u0019\u0001\r\t\u000f\u0005}\u0007\u0001)Q\u00051\u0005q1-\u001e:sK:$hi\u001c:nCR\u0004\u0003\"CAr\u0001\t\u0007I\u0011CAs\u00031i\u0015\tW0G\u00132+uLT+N+\t\t9\u000fE\u0002*\u0003SL1!a;+\u0005\rIe\u000e\u001e\u0005\t\u0003_\u0004\u0001\u0015!\u0003\u0002h\u0006iQ*\u0011-`\r&cUi\u0018(V\u001b\u0002Bq!a=\u0001\t#\t)0A\toK^$\u0016m]6PkR\u0004X\u000f\u001e$jY\u0016$raNA|\u0003w\u0014)\u0001\u0003\u0005\u0002z\u0006E\b\u0019AAt\u0003\u0019!\u0018m]6JI\"A\u0011Q`Ay\u0001\u0004\ty0A\u0002eSJ\u0004B!\u000bB\u0001o%\u0019!1\u0001\u0016\u0003\r=\u0003H/[8o\u0011\u001d\u00119!!=A\u0002]\n1!\u001a=u\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\t1bZ3u\r&dWMT1nKR)qGa\u0004\u0003\u0012!A\u0011\u0011 B\u0005\u0001\u0004\t9\u000fC\u0004\u0003\b\t%\u0001\u0019A\u001c\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018\u0005\u00012/\u001a;D_:4\u0017nZ;sCRLwN\u001c\u000b\u0004W\ne\u0001B\u0002?\u0003\u0014\u0001\u0007\u0011\u0010C\u0004\u0003\u001e\u0001!\tAa\b\u0002#M,GOU;oi&lWmQ8oi\u0016DH\u000fF\u0002l\u0005CA\u0001\"!\u0004\u0003\u001c\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0003I\u0019X\r^#yK\u000e,H/[8o\u0007>tg-[4\u0015\u0007-\u0014I\u0003\u0003\u0005\u0003,\t\r\u0002\u0019AA\u0018\u0003=)\u00070Z2vi&|gnQ8oM&<\u0007b\u0002B\u0018\u0001\u0011\u0005!\u0011G\u0001\rg\u0016$\u0018J\u001c9viRK\b/\u001a\u000b\u0004W\nM\u0002\u0002CA#\u0005[\u0001\rA!\u000e1\t\t]\"1\b\t\u0007\u0003\u001b\n\u0019F!\u000f\u0011\t\u0005e#1\b\u0003\r\u0005{\u0011\u0019$!A\u0001\u0002\u000b\u0005\u00111\u000e\u0002\u0004?\u0012\u0012\u0004b\u0002B!\u0001\u0011\u0005#1I\u0001\u0005_B,g\u000eF\u0003l\u0005\u000b\u0012I\u0005\u0003\u0005\u0003H\t}\u0002\u0019AAt\u0003)!\u0018m]6Ok6\u0014WM\u001d\u0005\t\u0005\u0017\u0012y\u00041\u0001\u0002h\u0006Aa.^7UCN\\7\u000f\u000b\u0004\u0003@\t=#q\f\t\u0006S\tE#QK\u0005\u0004\u0005'R#A\u0002;ie><8\u000f\u0005\u0003\u0003X\tmSB\u0001B-\u0015\tYB#\u0003\u0003\u0003^\te#aC%P\u000bb\u001cW\r\u001d;j_:\fdAH\u001c\u0003b\t-\u0015'C\u0012\u0003d\t%$\u0011\u0011B6+\r1$Q\r\u0003\b\u0005Or!\u0019\u0001B9\u0005\u0005!\u0016\u0002\u0002B6\u0005[\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$b\u0001B8U\u00051A\u000f\u001b:poN\fB!!\u001c\u0003tA!!Q\u000fB>\u001d\rI#qO\u0005\u0004\u0005sR\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005{\u0012yHA\u0005UQJ|w/\u00192mK*\u0019!\u0011\u0010\u00162\u0013\r\u0012\u0019I!\"\u0003\b\n=dbA\u0015\u0003\u0006&\u0019!q\u000e\u00162\u000b\tJ#F!#\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\u0012)\u0006C\u0004\u0003\u0010\u0002!\tE!%\u0002!%t\u0017\u000e^5bY&TXm\u00127pE\u0006dGcA6\u0003\u0014\"A!Q\u0013BG\u0001\u0004\t9/A\u0006qCJ\fG\u000e\\3mSNl\u0007b\u0002BM\u0001\u0011\u0005#1T\u0001\u000fM&t\u0017\r\\5{K\u001ecwNY1m)\rY'Q\u0014\u0005\t\u0005+\u00139\n1\u0001\u0002h\"9!\u0011\u0015\u0001\u0005\n\t\r\u0016\u0001C7pm\u0016\u0004\u0016\r\u001e5\u0015\u0007-\u0014)\u000bC\u0004\u0003(\n}\u0005\u0019A-\u0002\u0003ADqAa+\u0001\t\u0013\u0011i+\u0001\fqCRD'+Z7pm\u0016$w+\u001b;i/>\u00148\u000eR5s)\rI&q\u0016\u0005\u0007k\t%\u0006\u0019A-\t\u000f\tM\u0006\u0001\"\u0005\u00036\u0006\u00112\r\\8tK\u000e+(O]3oi\u001a{'/\\1u)\u0005Y\u0007b\u0002B]\u0001\u0011\u0005!QW\u0001\u0006C\n|'\u000f\u001e\u0005\b\u0005{\u0003A\u0011AAs\u0003%9W\r\u001e+bg.LE\tC\u0004\u0003B\u0002!\t!a5\u0002!\u001d,GoQ;se\u0016tGOR8s[\u0006$\bb\u0002Bc\u0001\u0011E!QW\u0001\u0014G>tg-[4DkJ\u0014XM\u001c;G_Jl\u0017\r\u001e\u0005\b\u0005\u0013\u0004A\u0011\u0003B[\u0003Q\u0011X\r\\3bg\u0016\u001cUO\u001d:f]R4uN]7bi\"A!Q\u001a\u0001!\n\u0013\u0011y-A\nsK2,\u0017m]3PkR\u0004X\u000f\u001e$pe6\fG\u000fF\u0002l\u0005#D\u0001Ba5\u0003L\u0002\u0007!Q[\u0001\u0007M>\u0014X.\u0019;1\t\t]'1\u001c\t\u00053\u0001\u0012I\u000e\u0005\u0003\u0002Z\tmG\u0001\u0004Bo\u0005#\f\t\u0011!A\u0003\u0002\u0005-$aA0%g!9!\u0011\u001d\u0001\u0005\u0012\t\r\u0018\u0001\u0006:fMJ,7\u000f[\"veJ,g\u000e\u001e$pe6\fG\u000fF\u0002l\u0005KD\u0001Ba:\u0003`\u0002\u0007!\u0011^\u0001\ra\u0006\u0014H/\u001b;j_:\\U-\u001f\t\u0005S\t\u0005!\u0005C\u0004\u0003n\u0002!\tEa<\u0002\u0013\r|gNZ5hkJ,GcA6\u0003r\"9!1\u001fBv\u0001\u0004I\u0018A\u00039be\u0006lW\r^3sg\"9!q\u001f\u0001\u0005B\tU\u0016!B2m_N,wa\u0002B~\u0005!\u0005!Q`\u0001\u0017\r&dWmU=ti\u0016lw*\u001e;qkR4uN]7biB\u0019AIa@\u0007\r\u0005\u0011\u0001\u0012AB\u0001'\u001d\u0011ypa\u0001\u0004\n!\u00022!KB\u0003\u0013\r\u00199A\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\t\r-1\u0011C\u0007\u0003\u0007\u001bQ1aa\u0004\u0007\u0003\u0011)H/\u001b7\n\t\rM1Q\u0002\u0002\b\u0019><w-\u001b8h\u0011\u001dQ%q C\u0001\u0007/!\"A!@\u0007\u000f\rm!q !\u0004\u001e\tQq*\u001e;qkR\u001c\u0006/Z2\u0014\u000f\re11AB\u0010QA\u0019\u0011f!\t\n\u0007\r\r\"FA\u0004Qe>$Wo\u0019;\t\u0015\r\u001d2\u0011\u0004BK\u0002\u0013\u0005a'\u0001\u0006pkR\u0004X\u000f\u001e)bi\"D!ba\u000b\u0004\u001a\tE\t\u0015!\u00038\u0003-yW\u000f\u001e9viB\u000bG\u000f\u001b\u0011\t\u0017\r=2\u0011\u0004BK\u0002\u0013\u00051\u0011G\u0001\u0019GV\u001cHo\\7QCJ$\u0018\u000e^5p]2{7-\u0019;j_:\u001cXCAB\u001a!\u0019A4QGB\u001do%\u00191qG\u001f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004<\r}bb\u0001#\u0004>%\u0019!\u0011\u0010\u0002\n\t\r\u000531\t\u0002\u0015\u0007V\u001cHo\\7UC\ndW\rU1si&$\u0018n\u001c8\u000b\u0007\te$\u0001C\u0006\u0004H\re!\u0011#Q\u0001\n\rM\u0012!G2vgR|W\u000eU1si&$\u0018n\u001c8M_\u000e\fG/[8og\u0002B1ba\u0013\u0004\u001a\tU\r\u0011\"\u0001\u0004N\u0005iq.\u001e;qkR\u001cu\u000e\\;n]N,\"aa\u0014\u0011\t\rE3qK\u0007\u0003\u0007'R1a!\u0016\u0007\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0019Ifa\u0015\u0003\u000fI{w\u000fV=qK\"Y1QLB\r\u0005#\u0005\u000b\u0011BB(\u00039yW\u000f\u001e9vi\u000e{G.^7og\u0002BqASB\r\t\u0003\u0019\t\u0007\u0006\u0005\u0004d\r\u001d4\u0011NB6!\u0011\u0019)g!\u0007\u000e\u0005\t}\bbBB\u0014\u0007?\u0002\ra\u000e\u0005\t\u0007_\u0019y\u00061\u0001\u00044!A11JB0\u0001\u0004\u0019y\u0005\u0003\u0006\u0004p\re\u0011\u0011!C\u0001\u0007c\nAaY8qsRA11MB:\u0007k\u001a9\bC\u0005\u0004(\r5\u0004\u0013!a\u0001o!Q1qFB7!\u0003\u0005\raa\r\t\u0015\r-3Q\u000eI\u0001\u0002\u0004\u0019y\u0005\u0003\u0006\u0004|\re\u0011\u0013!C\u0001\u0007{\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0000)\u001aqg!!,\u0005\r\r\u0005\u0003BBC\u0007\u001fk!aa\"\u000b\t\r%51R\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!$+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007#\u001b9IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!b!&\u0004\u001aE\u0005I\u0011ABL\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"a!'+\t\rM2\u0011\u0011\u0005\u000b\u0007;\u001bI\"%A\u0005\u0002\r}\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007CSCaa\u0014\u0004\u0002\"I1QUB\r\u0003\u0003%\t%U\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0015\r%6\u0011DA\u0001\n\u0003\t)/\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0004.\u000ee\u0011\u0011!C\u0001\u0007_\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002t\rE\u0006\"C8\u0004,\u0006\u0005\t\u0019AAt\u0011)\u0019)l!\u0007\u0002\u0002\u0013\u00053qW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111\u0011\u0018\t\u0007\u0007w\u001bi,a\u001d\u000e\u0005\u0005\u001d\u0016\u0002BB`\u0003O\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0007\u0007\u001cI\"!A\u0005\u0002\r\u0015\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=5q\u0019\u0005\n_\u000e\u0005\u0017\u0011!a\u0001\u0003gB!ba3\u0004\u001a\u0005\u0005I\u0011IBg\u0003!A\u0017m\u001d5D_\u0012,GCAAt\u0011)\u0019\tn!\u0007\u0002\u0002\u0013\u000531[\u0001\ti>\u001cFO]5oOR\t!\u000b\u0003\u0006\u0004X\u000ee\u0011\u0011!C!\u00073\fa!Z9vC2\u001cH\u0003BAH\u00077D\u0011b\\Bk\u0003\u0003\u0005\r!a\u001d\b\u0015\r}'q`A\u0001\u0012\u0003\u0019\t/\u0001\u0006PkR\u0004X\u000f^*qK\u000e\u0004Ba!\u001a\u0004d\u001aQ11\u0004B\u0000\u0003\u0003E\ta!:\u0014\u000b\r\r8q\u001d\u0015\u0011\u0017\r%8q^\u001c\u00044\r=31M\u0007\u0003\u0007WT1a!<+\u0003\u001d\u0011XO\u001c;j[\u0016LAa!=\u0004l\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f)\u001b\u0019\u000f\"\u0001\u0004vR\u00111\u0011\u001d\u0005\u000b\u0007#\u001c\u0019/!A\u0005F\rM\u0007BCB~\u0007G\f\t\u0011\"!\u0004~\u0006)\u0011\r\u001d9msRA11MB\u0000\t\u0003!\u0019\u0001C\u0004\u0004(\re\b\u0019A\u001c\t\u0011\r=2\u0011 a\u0001\u0007gA\u0001ba\u0013\u0004z\u0002\u00071q\n\u0005\u000b\t\u000f\u0019\u0019/!A\u0005\u0002\u0012%\u0011aB;oCB\u0004H.\u001f\u000b\u0005\t\u0017!\u0019\u0002E\u0003*\u0005\u0003!i\u0001\u0005\u0005*\t\u001f941GB(\u0013\r!\tB\u000b\u0002\u0007)V\u0004H.Z\u001a\t\u0015\u0011UAQAA\u0001\u0002\u0004\u0019\u0019'A\u0002yIAB!\u0002\"\u0007\u0004d\u0006\u0005I\u0011\u0002C\u000e\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003AA\u0001\u0002b\b\u0003\u0000\u0012\u0005A\u0011E\u0001\u0018O\u0016$x*\u001e;qkRTuN\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$\u0012b\u0011C\u0012\t[!\t\u0004b\u000e\t\u0011\u0011\u0015BQ\u0004a\u0001\tO\t1c\\;uaV$hi\u001c:nCR4\u0015m\u0019;pef\u00042\u0001\u0012C\u0015\u0013\r!YC\u0001\u0002\u0014\u001fV$\b/\u001e;G_Jl\u0017\r\u001e$bGR|'/\u001f\u0005\t\t_!i\u00021\u0001\u0004d\u0005Qq.\u001e;qkR\u001c\u0006/Z2\t\u0011\u0011MBQ\u0004a\u0001\tk\t\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\u0011\u000b%\u0012\taa\u0014\t\u0011\u0011eBQ\u0004a\u0001\tw\tqa\u001c9uS>t7\u000f\u0005\u0004\u0005>\u0011\u0005sgN\u0007\u0003\t\u007fQ1aa\u0004\u0015\u0013\u0011\u00199\u0004b\u0010\t\u0011\u0011\u0015#q C\u0001\t\u000f\n1cZ3u\r&dWMR8s[\u0006$x*\u001e;qkR$r\u0001\u0014C%\t\u0017\"y\u0005\u0003\u0004B\t\u0007\u0002\ra\u0011\u0005\b\t\u001b\"\u0019\u00051\u00018\u0003\u0015QwNY%E\u0011\u0019)D1\ta\u0001o!AA1\u000bB\u0000\t\u0003!)&\u0001\u000bj]&$\u0018.\u00197ju\u00164\u0015\u000e\\3TsN$X-\u001c\u000b\u0006K\u0012]C\u0011\f\u0005\u0007k\u0011E\u0003\u0019A-\t\u000f\u0011mC\u0011\u000ba\u0001s\u0006iQ\r\u001f;sCV\u001bXM]\"p]\u001aDC\u0001\"\u0017\u0005`A!A\u0011\rC5\u001b\t!\u0019G\u0003\u0003\u0004\u000e\u0012\u0015$B\u0001C4\u0003\u0015Q\u0017M^1y\u0013\u0011!Y\u0007b\u0019\u0003\u00119+H\u000e\\1cY\u0016Dc\u0001\"\u0015\u0003P\u0011=\u0014G\u0002\u00108\tc\"9(M\u0005$\u0005G\u0012I\u0007b\u001d\u0003lEJ1Ea!\u0003\u0006\u0012U$qN\u0019\u0006E%R#\u0011R\u0019\u0004M\tU\u0003B\u0003C\r\u0005\u007f\f\t\u0011\"\u0003\u0005\u001c\u0001")
public abstract class FileSystemOutputFormat
implements OutputFormat<BaseRow>,
Serializable,
FinalizeOnMaster,
InitializeOnMaster {
    private final String path;
    private final OutputJobDescription description;
    private final String org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName;
    private final Path workDir;
    private transient FileSystem org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs;
    private Configuration conf;
    private RuntimeContext runtimeContext;
    private ExecutionConfig execConf;
    private TypeInformation<?> inputType;
    private final boolean pathIsValid;
    private transient Set<String> tempWriteFiles;
    private transient Set<String> addedPartitions;
    private OutputFormat<BaseRow> currentFormat;
    private final int MAX_FILE_NUM;

    public static Logger LOG() {
        return FileSystemOutputFormat$.MODULE$.LOG();
    }

    public static FileSystem initializeFileSystem(Path path, @Nullable Configuration configuration) throws IOException {
        return FileSystemOutputFormat$.MODULE$.initializeFileSystem(path, configuration);
    }

    public static FileSystemOutputFormat getFileFormatOutput(OutputJobDescription outputJobDescription, String string, String string2) {
        return FileSystemOutputFormat$.MODULE$.getFileFormatOutput(outputJobDescription, string, string2);
    }

    public static OutputJobDescription getOutputJobDescription(OutputFormatFactory outputFormatFactory, OutputSpec outputSpec, Option<RowType> option, Map<String, String> map2) {
        return FileSystemOutputFormat$.MODULE$.getOutputJobDescription(outputFormatFactory, outputSpec, option, map2);
    }

    public String path() {
        return this.path;
    }

    public OutputJobDescription description() {
        return this.description;
    }

    public String org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName() {
        return this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName;
    }

    private Path workDir() {
        return this.workDir;
    }

    public FileSystem org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs() {
        return this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs;
    }

    private void org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs_$eq(FileSystem x$1) {
        this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs = x$1;
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    private RuntimeContext runtimeContext() {
        return this.runtimeContext;
    }

    private void runtimeContext_$eq(RuntimeContext x$1) {
        this.runtimeContext = x$1;
    }

    private ExecutionConfig execConf() {
        return this.execConf;
    }

    private void execConf_$eq(ExecutionConfig x$1) {
        this.execConf = x$1;
    }

    private TypeInformation<?> inputType() {
        return this.inputType;
    }

    private void inputType_$eq(TypeInformation<?> x$1) {
        this.inputType = x$1;
    }

    private boolean pathIsValid() {
        return this.pathIsValid;
    }

    private Set<String> tempWriteFiles() {
        return this.tempWriteFiles;
    }

    private void tempWriteFiles_$eq(Set<String> x$1) {
        this.tempWriteFiles = x$1;
    }

    public Set<String> addedPartitions() {
        return this.addedPartitions;
    }

    public void addedPartitions_$eq(Set<String> x$1) {
        this.addedPartitions = x$1;
    }

    public OutputFormat<BaseRow> currentFormat() {
        return this.currentFormat;
    }

    public void currentFormat_$eq(OutputFormat<BaseRow> x$1) {
        this.currentFormat = x$1;
    }

    public int MAX_FILE_NUM() {
        return this.MAX_FILE_NUM;
    }

    public String newTaskOutputFile(int taskId, Option<String> dir, String ext) {
        String fileName = this.getFileName(taskId, ext);
        String path = dir.isDefined() ? new Path(new Path(this.workDir(), (String)dir.get()), fileName).toString() : new Path(this.workDir(), fileName).toString();
        this.tempWriteFiles().$plus$eq((Object)path);
        return path;
    }

    private String getFileName(int taskId, String ext) {
        int arg$macro$3 = taskId;
        String arg$macro$4 = this.description().uuid();
        String arg$macro$5 = ext;
        return new StringOps("part-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$3), arg$macro$4, arg$macro$5}));
    }

    public void setConfiguration(Configuration configuration) {
        this.conf_$eq(configuration);
    }

    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext_$eq(runtimeContext);
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.execConf_$eq(executionConfig);
    }

    public void setInputType(TypeInformation<?> inputType) {
        this.inputType_$eq(inputType);
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        this.addedPartitions_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tempWriteFiles_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public void initializeGlobal(int parallelism) {
        this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs_$eq(FileSystemOutputFormat$.MODULE$.initializeFileSystem(this.workDir(), null));
        if (this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().exists(this.workDir())) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Working dir ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workDir().toUri().toString()})));
        }
        this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().mkdirs(this.workDir());
    }

    @Override
    public void finalizeGlobal(int parallelism) {
        if (this.pathIsValid()) {
            this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs_$eq(FileSystemOutputFormat$.MODULE$.initializeFileSystem(this.workDir(), null));
            this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$movePath(this.workDir());
            this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().delete(this.workDir(), true);
        }
    }

    public void org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$movePath(Path p) {
        LocatedFileStatus[] locatedFiles = this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().listLocatedStatus(p);
        Predef$.MODULE$.refArrayOps((Object[])locatedFiles).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemOutputFormat $outer;

            public final Object apply(LocatedFileStatus lfs) {
                Object object;
                if (lfs.isDir()) {
                    this.$outer.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$movePath(lfs.getPath());
                    object = BoxedUnit.UNIT;
                } else {
                    Path ori = lfs.getPath();
                    Path dest = this.$outer.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$pathRemovedWithWorkDir(ori);
                    object = BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().rename(ori, dest));
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Path org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$pathRemovedWithWorkDir(Path path) {
        String[] paths = path.toString().split("/");
        ArrayBuffer pathBuf = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(this, pathBuf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemOutputFormat $outer;
            private final ArrayBuffer pathBuf$1;

            public final Object apply(String p) {
                String string = p;
                String string2 = this.$outer.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName();
                return !(string != null ? !string.equals(string2) : string2 != null) ? BoxedUnit.UNIT : this.pathBuf$1.$plus$eq((Object)p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pathBuf$1 = pathBuf$1;
            }
        });
        return new Path(pathBuf.mkString("/"));
    }

    public void closeCurrentFormat() {
        if (this.currentFormat() != null) {
            this.currentFormat().close();
            boolean bl = this.currentFormat() == null;
        }
    }

    public void abort() {
        try {
            this.closeCurrentFormat();
        }
        catch (Throwable throwable) {
            this.tempWriteFiles().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemOutputFormat $outer;

                public final boolean apply(String p) {
                    return this.$outer.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$fs().delete(new Path(p), false);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        this.tempWriteFiles().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public int getTaskID() {
        return this.runtimeContext().getIndexOfThisSubtask();
    }

    public OutputFormat<BaseRow> getCurrentFormat() {
        return this.currentFormat();
    }

    public void configCurrentFormat() {
        OutputFormat<BaseRow> outputFormat;
        block4: {
            block3: {
                block2: {
                    Predef$.MODULE$.assert(this.currentFormat() != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Can't config current format cause it's null!";
                        }
                    });
                    this.currentFormat().configure(this.conf());
                    this.currentFormat().open(this.runtimeContext().getIndexOfThisSubtask(), this.runtimeContext().getNumberOfParallelSubtasks());
                    outputFormat = this.currentFormat();
                    if (!(outputFormat instanceof RichOutputFormat)) break block2;
                    RichOutputFormat richOutputFormat = (RichOutputFormat)outputFormat;
                    richOutputFormat.setRuntimeContext(this.runtimeContext());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(outputFormat instanceof InputTypeConfigurable)) break block4;
                OutputFormat<BaseRow> outputFormat2 = outputFormat;
                ((InputTypeConfigurable)((Object)outputFormat2)).setInputType(this.inputType(), this.execConf());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(outputFormat);
    }

    public void releaseCurrentFormat() {
        if (this.currentFormat() != null) {
            this.releaseOutputFormat(this.currentFormat());
            this.currentFormat_$eq(null);
        }
    }

    private void releaseOutputFormat(OutputFormat<?> format2) {
        boolean cleanupCalled = false;
        try {
            format2.close();
        }
        catch (Exception exception) {
            OutputFormat<?> outputFormat = format2;
            if (outputFormat instanceof CleanupWhenUnsuccessful) {
                CleanupWhenUnsuccessful cleanupWhenUnsuccessful = (CleanupWhenUnsuccessful)((Object)outputFormat);
                if (!cleanupCalled) {
                    cleanupWhenUnsuccessful.tryCleanupOnError();
                    cleanupCalled = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void refreshCurrentFormat(Option<BaseRow> partitionKey) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void configure(Configuration parameters) {
    }

    @Override
    public void close() {
        this.closeCurrentFormat();
    }

    public FileSystemOutputFormat(String path, OutputJobDescription description) {
        this.path = path;
        this.description = description;
        this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName = new StringBuilder().append((Object)".flink-workdir-").append((Object)description.uuid()).toString();
        this.workDir = new Path(path, this.org$apache$flink$table$sinks$filesystem$FileSystemOutputFormat$$workDirName());
        this.pathIsValid = Try$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemOutputFormat $outer;

            public final Path apply() {
                return new Path(this.$outer.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).isSuccess();
        this.tempWriteFiles = null;
        this.MAX_FILE_NUM = 1000000;
    }

    public static class OutputSpec
    implements Product,
    Serializable {
        private final String outputPath;
        private final scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> customPartitionLocations;
        private final RowType outputColumns;

        public String outputPath() {
            return this.outputPath;
        }

        public scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> customPartitionLocations() {
            return this.customPartitionLocations;
        }

        public RowType outputColumns() {
            return this.outputColumns;
        }

        public OutputSpec copy(String outputPath, scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> customPartitionLocations, RowType outputColumns) {
            return new OutputSpec(outputPath, customPartitionLocations, outputColumns);
        }

        public String copy$default$1() {
            return this.outputPath();
        }

        public scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> copy$default$2() {
            return this.customPartitionLocations();
        }

        public RowType copy$default$3() {
            return this.outputColumns();
        }

        public String productPrefix() {
            return "OutputSpec";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = this.outputColumns();
                    break;
                }
                case 1: {
                    object = this.customPartitionLocations();
                    break;
                }
                case 0: {
                    object = this.outputPath();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OutputSpec;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OutputSpec)) return false;
            boolean bl = true;
            if (!bl) return false;
            OutputSpec outputSpec = (OutputSpec)x$1;
            String string = this.outputPath();
            String string2 = outputSpec.outputPath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> map2 = this.customPartitionLocations();
            scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> map3 = outputSpec.customPartitionLocations();
            if (map2 == null) {
                if (map3 != null) {
                    return false;
                }
            } else if (!map2.equals(map3)) return false;
            RowType rowType = this.outputColumns();
            RowType rowType2 = outputSpec.outputColumns();
            if (rowType == null) {
                if (rowType2 != null) {
                    return false;
                }
            } else if (!((Object)rowType).equals(rowType2)) return false;
            if (!outputSpec.canEqual(this)) return false;
            return true;
        }

        public OutputSpec(String outputPath, scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String> customPartitionLocations, RowType outputColumns) {
            this.outputPath = outputPath;
            this.customPartitionLocations = customPartitionLocations;
            this.outputColumns = outputColumns;
            Product.class.$init$((Product)this);
        }
    }
}

