/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem.csv;

import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.csv.CsvOptions;
import org.apache.flink.table.sinks.csv.BaseRowCsvOutputFormat;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.types.AtomicType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.FlinkException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001E\u0011\u0001cQ*W\r>\u0014X.\u0019;GC\u000e$xN]=\u000b\u0005\r!\u0011aA2tm*\u0011QAB\u0001\u000bM&dWm]=ti\u0016l'BA\u0004\t\u0003\u0015\u0019\u0018N\\6t\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!aE(viB,HOR8s[\u0006$h)Y2u_JL\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011%a\u0002\u00011A\u0001B\u0003&Q$A\u0004paRLwN\\:\u0011\ty\u0019S%J\u0007\u0002?)\u0011\u0001%I\u0001\u0005kRLGNC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"aA'baB\u0011a\u0005\f\b\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,Q!)\u0001\u0007\u0001C!c\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0003eU\u0002\"aJ\u001a\n\u0005QB#\u0001B+oSRDQ\u0001H\u0018A\u0002uAQa\u000e\u0001\u0005Ba\n\u0001cZ3u\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\u0015J\u0004\"\u0002\u001e7\u0001\u0004Y\u0014A\u0002;bg.LE\r\u0005\u0002(y%\u0011Q\b\u000b\u0002\u0004\u0013:$\b\"B \u0001\t\u0003\u0002\u0015a\u00048fo>+H\u000f];u\r>\u0014X.\u0019;\u0015\t\u0005\u000b6k\u0017\t\u0004\u0005&[U\"A\"\u000b\u0005\u0011+\u0015AA5p\u0015\t1u)\u0001\u0004d_6lwN\u001c\u0006\u0003\u0011*\t1!\u00199j\u0013\tQ5I\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0011\u0005QA-\u0019;bM>\u0014X.\u0019;\n\u0005Ak%a\u0002\"bg\u0016\u0014vn\u001e\u0005\u0006%z\u0002\r!J\u0001\u0005a\u0006$\b\u000eC\u0003U}\u0001\u0007Q+\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"AV-\u000e\u0003]S!\u0001\u0017\u0005\u0002\u000bQL\b/Z:\n\u0005i;&a\u0002*poRK\b/\u001a\u0005\u0006uy\u0002\ra\u000f\u0005\u0007;\u0002\u0001K\u0011\u00020\u0002\u0019\u001d,Go\u0016:ji\u0016lu\u000eZ3\u0015\u0005};\bC\u00011u\u001d\t\t\u0017O\u0004\u0002c]:\u00111\r\u001c\b\u0003I.t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!\u0004\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011QNC\u0001\u0005G>\u0014X-\u0003\u0002pa\u0006\u0011am\u001d\u0006\u0003[*I!A]:\u0002\u0015\u0019KG.Z*zgR,WN\u0003\u0002pa&\u0011QO\u001e\u0002\n/JLG/Z'pI\u0016T!A]:\t\u000bad\u0006\u0019A=\u0002\u000bA\u0014x\u000e]:\u0011\u0005idX\"A>\u000b\u0005\u0001B\u0011BA?|\u0005=!\u0016M\u00197f!J|\u0007/\u001a:uS\u0016\u001c\bBB@\u0001\t\u0003\n\t!A\ttkB\u0004xN\u001d;ECR\f7k\u00195f[\u0006$B!a\u0001\u0002\nA\u0019q%!\u0002\n\u0007\u0005\u001d\u0001FA\u0004C_>dW-\u00198\t\u000f\u0005-a\u00101\u0001\u0002\u000e\u0005AA-\u0019;b)f\u0004X\rE\u0002W\u0003\u001fI1!!\u0005X\u0005!!\u0015\r^1UsB,\u0007bBA\u000b\u0001\u0011\u0005\u0013qC\u0001\ti>\u001cFO]5oOR\tQ\u0005C\u0004\u0002\u001c\u0001!\t%!\b\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u000f\u0005\b\u0003C\u0001A\u0011IA\u0012\u0003\u0019)\u0017/^1mgR!\u00111AA\u0013\u0011!\t9#a\bA\u0002\u0005%\u0012!B8uQ\u0016\u0014\bcA\u0014\u0002,%\u0019\u0011Q\u0006\u0015\u0003\u0007\u0005s\u0017\u0010")
public class CSVFormatFactory
extends OutputFormatFactory {
    private Map<String, String> options;

    @Override
    public void configure(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public String getFileExtension(int taskId) {
        return ".csv";
    }

    @Override
    public OutputFormat<BaseRow> newOutputFormat(String path, RowType dataSchema, int taskId) {
        TableProperties csvOptions = new TableProperties().putProperties(this.options).toKeyLowerCase();
        BaseRowCsvOutputFormat outputFormat = new BaseRowCsvOutputFormat(new Path(path), dataSchema.getFieldInternalTypes());
        outputFormat.setAllowNullValues(csvOptions.getBoolean(CsvOptions.EMPTY_COLUMN_AS_NULL));
        outputFormat.setRecordDelimiter(csvOptions.getString(CsvOptions.OPTIONAL_LINE_DELIM));
        outputFormat.setFieldDelimiter(csvOptions.getString(CsvOptions.OPTIONAL_FIELD_DELIM));
        outputFormat.setQuoteCharacter(csvOptions.getString(CsvOptions.OPTIONAL_QUOTE_CHARACTER));
        outputFormat.setTimezone(TimeZone.getTimeZone(csvOptions.getString(CsvOptions.OPTIONAL_TIME_ZONE, FileSystemOptions$.MODULE$.TIME_ZONE().defaultValue())));
        outputFormat.setWriteMode(this.getWriteMode(csvOptions));
        boolean outputFieldNames = csvOptions.getBoolean(CsvOptions.OPTIONAL_FIRST_LINE_AS_HEADER);
        if (outputFieldNames) {
            outputFormat.setOutputFieldName(true);
            outputFormat.setFieldNames(dataSchema.getFieldNames());
        }
        outputFormat.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.NEVER);
        return outputFormat;
    }

    private FileSystem.WriteMode getWriteMode(TableProperties props) {
        block4: {
            FileSystem.WriteMode writeMode;
            block3: {
                String string;
                block2: {
                    String writeMode2 = props.getString(CsvOptions.OPTIONAL_WRITE_MODE);
                    string = writeMode2.toLowerCase();
                    if (!"no_overwrite".equals(string)) break block2;
                    writeMode = FileSystem.WriteMode.NO_OVERWRITE;
                    break block3;
                }
                if (!"overwrite".equals(string)) break block4;
                writeMode = FileSystem.WriteMode.OVERWRITE;
            }
            return writeMode;
        }
        throw new FlinkException("Unknown overwrite mode for Csv sink, optional: no_overwrite/overwrite");
    }

    @Override
    public boolean supportDataSchema(DataType dataType2) {
        boolean bl;
        DataType dataType3 = dataType2;
        if (dataType3 instanceof AtomicType) {
            bl = true;
        } else if (dataType3 instanceof TypeInfoWrappedDataType) {
            TypeInfoWrappedDataType typeInfoWrappedDataType = (TypeInfoWrappedDataType)dataType3;
            bl = this.supportDataSchema(typeInfoWrappedDataType.toInternalType());
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFormatFactory;
    }
}

