/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.csv;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import org.apache.flink.api.common.typeinfo.BigDecimalTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.AbstractRowCsvInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.functions.BuildInScalarFunctions;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.types.parser.BigDecParser;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.SqlDateParser;
import org.apache.flink.types.parser.SqlTimeParser;
import org.apache.flink.types.parser.SqlTimestampParser;
import org.apache.flink.types.parser.StringParser;

public class BaseRowCsvInputFormat
extends AbstractRowCsvInputFormat<BaseRow> {
    private static final long serialVersionUID = 1L;
    private transient GenericRow reuseRow;

    public BaseRowCsvInputFormat(Path filePath, InternalType[] fieldTypes2, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull) {
        this(filePath, fieldTypes2, lineDelimiter, fieldDelimiter, selectedFields, emptyColumnAsNull, Long.MAX_VALUE);
    }

    public BaseRowCsvInputFormat(Path filePath, InternalType[] fieldTypes2, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull, long limit) {
        super(filePath, (TypeInformation[])TypeConverters.createExternalTypeInfoFromDataTypes(fieldTypes2), lineDelimiter, fieldDelimiter, selectedFields, emptyColumnAsNull, limit);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        for (int i = 0; i < fieldParsers.length; ++i) {
            if (fieldParsers[i] instanceof StringParser) {
                StringParser parser = (StringParser)fieldParsers[i];
                BinaryStringParser newParser = new BinaryStringParser();
                if (parser.isQuotedStringParsing()) {
                    newParser.enableQuotedStringParsing(parser.getQuoteCharacter());
                }
                fieldParsers[i] = newParser;
            } else if (fieldParsers[i] instanceof SqlDateParser) {
                fieldParsers[i] = new DateParser();
            } else if (fieldParsers[i] instanceof SqlTimeParser) {
                fieldParsers[i] = new TimeParser();
            } else if (fieldParsers[i] instanceof SqlTimestampParser) {
                fieldParsers[i] = new TimestampParser(this.getTimezone());
            } else if (fieldParsers[i] instanceof BigDecParser) {
                fieldParsers[i] = new DecimalParser((BigDecimalTypeInfo)this.fieldTypeInfos[i]);
            }
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
    }

    protected BaseRow fillRecord(BaseRow ignore, Object[] parsedValues) {
        if (this.reuseRow == null) {
            this.reuseRow = new GenericRow(this.arity);
        }
        for (int i = 0; i < parsedValues.length; ++i) {
            this.reuseRow.update(i, parsedValues[i]);
        }
        return this.reuseRow;
    }

    public TypeInformation<BaseRow> getProducedType() {
        return new BaseRowTypeInfo(this.fieldTypeInfos);
    }

    public static class DecimalParser
    extends FieldParser<Decimal> {
        final BigDecParser parser = new BigDecParser();
        final BigDecimalTypeInfo dt;

        public DecimalParser(BigDecimalTypeInfo dt) {
            this.dt = dt;
        }

        @Override
        protected int parseField(byte[] bytes, int startPos, int limit, byte[] delim, Decimal reuse) {
            return this.parser.parseField(bytes, startPos, limit, delim, null);
        }

        @Override
        public Decimal getLastResult() {
            return Decimal.fromBigDecimal(this.parser.getLastResult(), this.dt.precision(), this.dt.scale());
        }

        @Override
        public Decimal createValue() {
            return Decimal.zero(this.dt.precision(), this.dt.scale());
        }
    }

    public static class TimestampParser
    extends FieldParser<Long> {
        final SqlTimestampParser parser = new SqlTimestampParser();

        public TimestampParser(TimeZone timezone) {
            this.parser.setTimeZone(timezone);
        }

        @Override
        public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Long reusable) {
            return this.parser.parseField(bytes, startPos, limit, delimiter, null);
        }

        @Override
        public Long createValue() {
            return 0L;
        }

        @Override
        public Long getLastResult() {
            return BuildInScalarFunctions.toLong(this.parser.getLastResult());
        }
    }

    public static class TimeParser
    extends FieldParser<Integer> {
        final SqlTimeParser parser = new SqlTimeParser();

        @Override
        public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Integer reusable) {
            return this.parser.parseField(bytes, startPos, limit, delimiter, null);
        }

        @Override
        public Integer createValue() {
            return 0;
        }

        @Override
        public Integer getLastResult() {
            return BuildInScalarFunctions.toInt(this.parser.getLastResult());
        }
    }

    public static class DateParser
    extends FieldParser<Integer> {
        final SqlDateParser parser = new SqlDateParser();

        @Override
        public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Integer reusable) {
            return this.parser.parseField(bytes, startPos, limit, delimiter, null);
        }

        @Override
        public Integer createValue() {
            return 0;
        }

        @Override
        public Integer getLastResult() {
            return BuildInScalarFunctions.toInt(this.parser.getLastResult());
        }
    }

    public static class BinaryStringParser
    extends FieldParser<BinaryString> {
        private boolean quotedStringParsing = false;
        private byte quoteCharacter;
        private String singleQuoteStr;
        private String doubleQuoteStr;
        private static final byte BACKSLASH = 92;
        private BinaryString result;

        public void enableQuotedStringParsing(byte quoteCharacter) {
            this.quotedStringParsing = true;
            this.quoteCharacter = quoteCharacter;
            byte[] doubleQuoteChars = new byte[]{quoteCharacter, quoteCharacter};
            this.doubleQuoteStr = new String(doubleQuoteChars);
            byte[] singleQuoteChar = new byte[]{quoteCharacter};
            this.singleQuoteStr = new String(singleQuoteChar);
        }

        @Override
        public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, BinaryString reusable) {
            int i;
            int delimLimit = limit - delimiter.length + 1;
            if (this.quotedStringParsing && bytes[i] == this.quoteCharacter) {
                ++i;
                boolean replace = false;
                while (i < limit && (bytes[i] != this.quoteCharacter || bytes[i - 1] == 92 || i + 1 < limit && bytes[i + 1] == this.quoteCharacter)) {
                    if (bytes[i - 1] != 92 && bytes[i] == this.quoteCharacter && i + 1 < limit && bytes[i + 1] == this.quoteCharacter) {
                        replace = true;
                        ++i;
                    }
                    ++i;
                }
                if (i == limit) {
                    this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
                    return -1;
                }
                ++i;
                try {
                    if (i == limit) {
                        if (replace || this.getCharset().equals(StandardCharsets.UTF_8)) {
                            String res = new String(bytes, startPos + 1, i - startPos - 2, this.getCharset());
                            this.result = BinaryString.fromBytes(res.replace(this.doubleQuoteStr, this.singleQuoteStr).getBytes("utf-8"));
                        } else {
                            this.result = BinaryString.fromBytes(bytes, startPos + 1, i - startPos - 2);
                        }
                        return limit;
                    }
                    if (i < delimLimit && BinaryStringParser.delimiterNext(bytes, i, delimiter)) {
                        if (replace && this.getCharset().equals(StandardCharsets.UTF_8)) {
                            String res = new String(bytes, startPos + 1, i - startPos - 2, this.getCharset());
                            this.result = BinaryString.fromBytes(res.replace(this.doubleQuoteStr, this.singleQuoteStr).getBytes("utf-8"));
                        } else {
                            this.result = BinaryString.fromBytes(bytes, startPos + 1, i - startPos - 2);
                        }
                        return i + delimiter.length;
                    }
                    this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
                    return -1;
                }
                catch (UnsupportedEncodingException e2) {
                    this.setErrorState(FieldParser.ParseErrorState.CHARSET_INVALID);
                    return -1;
                }
            }
            for (i = startPos; i < delimLimit && !BinaryStringParser.delimiterNext(bytes, i, delimiter); ++i) {
            }
            if (i >= delimLimit) {
                if (limit == startPos) {
                    this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
                }
                this.result = BinaryString.fromBytes(bytes, startPos, limit - startPos);
                return limit;
            }
            if (i == startPos) {
                this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
            }
            this.result = BinaryString.fromBytes(bytes, startPos, i - startPos);
            return i + delimiter.length;
        }

        @Override
        public BinaryString createValue() {
            return BinaryString.EMPTY_UTF8;
        }

        @Override
        public BinaryString getLastResult() {
            return this.result;
        }
    }
}

