/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.plan.stats.TableStats$;
import org.apache.flink.table.sources.orc.OrcInputFormat;
import org.apache.flink.table.sources.orc.OrcTableStatsCollector$;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.LongRef;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;

public final class OrcTableStatsCollector$
implements Logging {
    public static final OrcTableStatsCollector$ MODULE$;
    private final int defaultTimeout;
    private final TimeUnit timeoutTimeUnit;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;
    private static Class[] reflParams$Cache1;
    private static volatile SoftReference reflPoly$Cache1;

    static {
        reflParams$Cache1 = new Class[]{Path.class, List.class};
        reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        new OrcTableStatsCollector$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("listFileStatus", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    private Logger LOG$lzycompute() {
        OrcTableStatsCollector$ orcTableStatsCollector$ = this;
        synchronized (orcTableStatsCollector$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public int defaultTimeout() {
        return this.defaultTimeout;
    }

    public TimeUnit timeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public TableStats collectTableStats(Path filePath, boolean nestedFileEnumeration, String[] fieldNames, InternalType[] fieldTypes2, Option<Configuration> hadoopConf, Option<Object> maxThreads) {
        long startTime = System.currentTimeMillis();
        List<FileStatus> fileStatus = this.listFileStatus(filePath, nestedFileEnumeration, fieldNames, fieldTypes2);
        if (fileStatus.isEmpty()) {
            return new TableStats(Predef$.MODULE$.long2Long(0L), TableStats$.MODULE$.apply$default$2(), TableStats$.MODULE$.apply$default$3());
        }
        Configuration config = (Configuration)hadoopConf.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
        Tuple2<Object, java.util.Map<String, ColumnStatistics>> tuple2 = this.collectStatistics(fileStatus, fieldNames, config, maxThreads);
        if (tuple2 != null) {
            Tuple2 tuple22;
            long totalRowCount = tuple2._1$mcJ$sp();
            java.util.Map finalStatsMap = (java.util.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)totalRowCount), (Object)finalStatsMap);
            long totalRowCount2 = tuple23._1$mcJ$sp();
            java.util.Map finalStatsMap2 = (java.util.Map)tuple23._2();
            scala.collection.immutable.Map finalColumnStats = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(finalStatsMap2).map((Function1)new Serializable(fieldNames, fieldTypes2, totalRowCount2){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final InternalType[] fieldTypes$1;
                private final long totalRowCount$1;

                public final Tuple2<String, ColumnStats> apply(Tuple2<String, ColumnStatistics> x0$1) {
                    Tuple2<String, ColumnStatistics> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        ColumnStatistics stats = (ColumnStatistics)tuple2._2();
                        int index = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)name);
                        InternalType t = this.fieldTypes$1[index];
                        ColumnStats columnStats = new ColumnStats(null, stats.hasNull() ? Predef$.MODULE$.long2Long(this.totalRowCount$1 - stats.getNumberOfValues()) : null, null, null, OrcTableStatsCollector$.MODULE$.org$apache$flink$table$sources$orc$OrcTableStatsCollector$$getMaxMinValueByType(t, stats, true), OrcTableStatsCollector$.MODULE$.org$apache$flink$table$sources$orc$OrcTableStatsCollector$$getMaxMinValueByType(t, stats, false));
                        Tuple2 tuple22 = new Tuple2((Object)name, (Object)columnStats);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                    this.totalRowCount$1 = totalRowCount$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            long endTime = System.currentTimeMillis();
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"collect TableStats from path: ", ", cost: ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath, BoxesRunTime.boxToLong((long)(endTime - startTime))})));
            }
            return new TableStats(Predef$.MODULE$.long2Long(totalRowCount2), JavaConversions$.MODULE$.mapAsJavaMap((Map)finalColumnStats), TableStats$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError(tuple2);
    }

    public Option<Configuration> collectTableStats$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> collectTableStats$default$6() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, java.util.Map<String, ColumnStatistics>> collectStatistics(List<FileStatus> fileStatus, String[] fieldNames, Configuration hadoopConf, Option<Object> maxThreads) {
        numOfCpuCores = Hardware.getNumberCPUCores();
        defaultThreads = package$.MODULE$.min(package$.MODULE$.max(numOfCpuCores / 2, 1), fileStatus.size());
        var7_7 = false;
        var8_8 = null;
        var9_9 = maxThreads;
        if (!(var9_9 instanceof Some)) ** GOTO lbl-1000
        var7_7 = true;
        var8_8 = (Some)var9_9;
        t = BoxesRunTime.unboxToInt((Object)var8_8.x());
        if (t > 0) {
            threads = package$.MODULE$.min(package$.MODULE$.min(numOfCpuCores, t), fileStatus.size());
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max threads: ", ", uses threads: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t), BoxesRunTime.boxToInteger((int)threads)})));
            }
            var12_12 = threads;
        } else if (var7_7) {
            t = BoxesRunTime.unboxToInt((Object)var8_8.x());
            this.LOG().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal max threads: ", ", uses default value: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t), BoxesRunTime.boxToInteger((int)defaultThreads)})));
            var12_12 = defaultThreads;
        } else {
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uses default threads: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultThreads)})));
            }
            var12_12 = defaultThreads;
        }
        numOfThreads = var12_12;
        threadFactory = new ThreadFactoryBuilder().setNameFormat("Collect Orc statistics Thread %d").build();
        executor = Executors.newFixedThreadPool(numOfThreads, threadFactory);
        totalRowCount = LongRef.create((long)0L);
        finalStatsMap = new HashMap<K, V>();
        try {
            results = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(fileStatus).map((Function1)new Serializable(fieldNames, hadoopConf, executor){
                public static final long serialVersionUID = 0L;
                public final String[] fieldNames$3;
                public final Configuration hadoopConf$1;
                private final ExecutorService executor$1;

                public final Future<Tuple2<Object, java.util.Map<String, ColumnStatistics>>> apply(FileStatus file) {
                    return this.executor$1.submit(new Callable<Tuple2<Object, java.util.Map<String, ColumnStatistics>>>(this, file){
                        private final /* synthetic */ anonfun.3 $outer;
                        private final FileStatus file$1;

                        public Tuple2<Object, java.util.Map<String, ColumnStatistics>> call() {
                            return OrcTableStatsCollector$.MODULE$.org$apache$flink$table$sources$orc$OrcTableStatsCollector$$getStatisticsOfFile(this.file$1, this.$outer.fieldNames$3, this.$outer.hadoopConf$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                }
                {
                    this.fieldNames$3 = fieldNames$3;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.executor$1 = executor$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            results.foreach((Function1)new Serializable(totalRowCount, finalStatsMap){
                public static final long serialVersionUID = 0L;
                private final LongRef totalRowCount$2;
                public final HashMap finalStatsMap$1;

                public final void apply(Future<Tuple2<Object, java.util.Map<String, ColumnStatistics>>> f) {
                    Tuple2<Object, java.util.Map<String, ColumnStatistics>> tuple2 = f.get(OrcTableStatsCollector$.MODULE$.defaultTimeout(), OrcTableStatsCollector$.MODULE$.timeoutTimeUnit());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        long rowCount = tuple2._1$mcJ$sp();
                        java.util.Map fileStatsMap = (java.util.Map)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)fileStatsMap);
                        long rowCount2 = tuple23._1$mcJ$sp();
                        java.util.Map fileStatsMap2 = (java.util.Map)tuple23._2();
                        this.totalRowCount$2.elem += rowCount2;
                        JavaConversions$.MODULE$.mapAsScalaMap(fileStatsMap2).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.collectStatistics.1 $outer;

                            public final void apply(Tuple2<String, ColumnStatistics> x0$2) {
                                Tuple2<String, ColumnStatistics> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String fieldName = (String)tuple2._1();
                                    ColumnStatistics colStats = (ColumnStatistics)tuple2._2();
                                    OrcTableStatsCollector$.MODULE$.org$apache$flink$table$sources$orc$OrcTableStatsCollector$$updateStatistics(colStats, fieldName, this.$outer.finalStatsMap$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.totalRowCount$2 = totalRowCount$2;
                    this.finalStatsMap$1 = finalStatsMap$1;
                }
            });
            executor.shutdownNow();
        }
        catch (Throwable var20_20) {
            var16_16.shutdownNow();
            throw var20_20;
        }
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)totalRowCount.elem), finalStatsMap);
    }

    public Object org$apache$flink$table$sources$orc$OrcTableStatsCollector$$getMaxMinValueByType(InternalType t, ColumnStatistics stat, boolean isMax) {
        InternalType internalType;
        block30: {
            Long l;
            block24: {
                Timestamp timestamp;
                block29: {
                    Date date;
                    block28: {
                        BigDecimal bigDecimal;
                        block27: {
                            String string;
                            block26: {
                                Double d;
                                boolean bl;
                                block25: {
                                    Long l2;
                                    boolean bl2;
                                    block23: {
                                        internalType = t;
                                        BooleanType booleanType = DataTypes.BOOLEAN;
                                        InternalType internalType2 = internalType;
                                        if (booleanType != null ? !((Object)booleanType).equals(internalType2) : internalType2 != null) break block23;
                                        l = null;
                                        break block24;
                                    }
                                    ByteType byteType = DataTypes.BYTE;
                                    InternalType internalType3 = internalType;
                                    if (!(byteType != null ? !((Object)byteType).equals(internalType3) : internalType3 != null)) {
                                        bl2 = true;
                                    } else {
                                        ShortType shortType = DataTypes.SHORT;
                                        InternalType internalType4 = internalType;
                                        if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                                            bl2 = true;
                                        } else {
                                            IntType intType = DataTypes.INT;
                                            InternalType internalType5 = internalType;
                                            if (!(intType != null ? !((Object)intType).equals(internalType5) : internalType5 != null)) {
                                                bl2 = true;
                                            } else {
                                                LongType longType = DataTypes.LONG;
                                                InternalType internalType6 = internalType;
                                                bl2 = !(longType != null ? !((Object)longType).equals(internalType6) : internalType6 != null);
                                            }
                                        }
                                    }
                                    if (!bl2) break block25;
                                    ColumnStatistics columnStatistics = stat;
                                    if (columnStatistics instanceof IntegerColumnStatistics) {
                                        IntegerColumnStatistics integerColumnStatistics = (IntegerColumnStatistics)columnStatistics;
                                        l2 = isMax ? BoxesRunTime.boxToLong((long)integerColumnStatistics.getMaximum()) : BoxesRunTime.boxToLong((long)integerColumnStatistics.getMinimum());
                                    } else {
                                        l2 = null;
                                    }
                                    l = l2;
                                    break block24;
                                }
                                FloatType floatType = DataTypes.FLOAT;
                                InternalType internalType7 = internalType;
                                if (!(floatType != null ? !((Object)floatType).equals(internalType7) : internalType7 != null)) {
                                    bl = true;
                                } else {
                                    DoubleType doubleType = DataTypes.DOUBLE;
                                    InternalType internalType8 = internalType;
                                    bl = !(doubleType != null ? !((Object)doubleType).equals(internalType8) : internalType8 != null);
                                }
                                if (!bl) break block26;
                                ColumnStatistics columnStatistics = stat;
                                if (columnStatistics instanceof DoubleColumnStatistics) {
                                    DoubleColumnStatistics doubleColumnStatistics = (DoubleColumnStatistics)columnStatistics;
                                    d = isMax ? BoxesRunTime.boxToDouble((double)doubleColumnStatistics.getMaximum()) : BoxesRunTime.boxToDouble((double)doubleColumnStatistics.getMinimum());
                                } else {
                                    d = null;
                                }
                                l = d;
                                break block24;
                            }
                            StringType stringType = DataTypes.STRING;
                            InternalType internalType9 = internalType;
                            if (stringType != null ? !((Object)stringType).equals(internalType9) : internalType9 != null) break block27;
                            ColumnStatistics columnStatistics = stat;
                            if (columnStatistics instanceof StringColumnStatistics) {
                                StringColumnStatistics stringColumnStatistics = (StringColumnStatistics)columnStatistics;
                                string = isMax ? stringColumnStatistics.getMaximum() : stringColumnStatistics.getMinimum();
                            } else {
                                string = null;
                            }
                            l = string;
                            break block24;
                        }
                        if (!(internalType instanceof DecimalType)) break block28;
                        ColumnStatistics columnStatistics = stat;
                        if (columnStatistics instanceof DecimalColumnStatistics) {
                            DecimalColumnStatistics decimalColumnStatistics = (DecimalColumnStatistics)columnStatistics;
                            HiveDecimal v = isMax ? decimalColumnStatistics.getMaximum() : decimalColumnStatistics.getMinimum();
                            bigDecimal = v.bigDecimalValue();
                        } else {
                            bigDecimal = null;
                        }
                        l = bigDecimal;
                        break block24;
                    }
                    DateType dateType = DataTypes.DATE;
                    InternalType internalType10 = internalType;
                    if (dateType != null ? !((Object)dateType).equals(internalType10) : internalType10 != null) break block29;
                    ColumnStatistics columnStatistics = stat;
                    if (columnStatistics instanceof DateColumnStatistics) {
                        DateColumnStatistics dateColumnStatistics = (DateColumnStatistics)columnStatistics;
                        date = isMax ? dateColumnStatistics.getMaximum() : dateColumnStatistics.getMinimum();
                    } else {
                        date = null;
                    }
                    l = date;
                    break block24;
                }
                TimestampType timestampType = DataTypes.TIMESTAMP;
                InternalType internalType11 = internalType;
                if (timestampType != null ? !((Object)timestampType).equals(internalType11) : internalType11 != null) break block30;
                ColumnStatistics columnStatistics = stat;
                if (columnStatistics instanceof TimestampColumnStatistics) {
                    TimestampColumnStatistics timestampColumnStatistics = (TimestampColumnStatistics)columnStatistics;
                    timestamp = isMax ? timestampColumnStatistics.getMaximum() : timestampColumnStatistics.getMinimum();
                } else {
                    timestamp = null;
                }
                l = timestamp;
            }
            return l;
        }
        throw new MatchError((Object)internalType);
    }

    public Tuple2<Object, java.util.Map<String, ColumnStatistics>> org$apache$flink$table$sources$orc$OrcTableStatsCollector$$getStatisticsOfFile(FileStatus fileStatus, String[] fieldNames, Configuration hadoopConf) {
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(fileStatus.getPath().toUri());
        Reader reader = OrcFile.createReader((org.apache.hadoop.fs.Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(hadoopConf)));
        long rowCount = reader.getNumberOfRows();
        ColumnStatistics[] fileStats = reader.getStatistics();
        TypeDescription schema2 = reader.getSchema();
        List columnNames = schema2.getFieldNames();
        List columnTypes = schema2.getChildren();
        int[] fieldIndices = (int[])Predef$.MODULE$.refArrayOps((Object[])fieldNames).map((Function1)new Serializable(columnNames){
            public static final long serialVersionUID = 0L;
            private final List columnNames$1;

            public final int apply(String x$3) {
                return this.columnNames$1.indexOf(x$3);
            }
            {
                this.columnNames$1 = columnNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        HashMap statsMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fieldNames).zip((GenIterable)Predef$.MODULE$.wrapIntArray(fieldIndices), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(fileStats, columnTypes, statsMap){
            public static final long serialVersionUID = 0L;
            private final ColumnStatistics[] fileStats$1;
            private final List columnTypes$1;
            private final HashMap statsMap$1;

            public final Object apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String fieldName = (String)tuple2._1();
                    int fieldIdx = tuple2._2$mcI$sp();
                    if (fieldIdx >= 0) {
                        int colId = ((TypeDescription)this.columnTypes$1.get(fieldIdx)).getId();
                        boxedUnit = this.statsMap$1.put(fieldName, this.fileStats$1[colId]);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fileStats$1 = fileStats$1;
                this.columnTypes$1 = columnTypes$1;
                this.statsMap$1 = statsMap$1;
            }
        });
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), statsMap);
    }

    public void org$apache$flink$table$sources$orc$OrcTableStatsCollector$$updateStatistics(ColumnStatistics newStats, String fieldName, java.util.Map<String, ColumnStatistics> statsMap) {
        ColumnStatistics columnStatistics;
        block4: {
            block3: {
                ColumnStatistics oldStats;
                block2: {
                    oldStats = statsMap.get(fieldName);
                    if (oldStats != null) break block2;
                    statsMap.put(fieldName, newStats);
                    break block3;
                }
                columnStatistics = newStats;
                if (!(columnStatistics instanceof ColumnStatisticsImpl)) break block4;
                ColumnStatisticsImpl columnStatisticsImpl = (ColumnStatisticsImpl)columnStatistics;
                ((ColumnStatisticsImpl)oldStats).merge(columnStatisticsImpl);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)columnStatistics);
    }

    private List<FileStatus> listFileStatus(Path filePath, boolean nestedFileEnumeration, String[] fieldNames, InternalType[] fieldTypes2) {
        OrcInputFormat<Object, Object> inputFormat = new OrcInputFormat<Object, Object>(filePath, nestedFileEnumeration, fieldNames, fieldTypes2){
            public final boolean nestedFileEnumeration$1;

            public Object convert(Object current) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void listFileStatus(Path path, List<FileStatus> files) {
                FileSystem fs = path.getFileSystem();
                Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).foreach((Function1)new Serializable(this, files){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final List files$1;

                    public final Object apply(FileStatus s) {
                        Object object;
                        if (s.isDir()) {
                            if (this.$outer.acceptFile(s) && this.$outer.nestedFileEnumeration$1) {
                                this.$outer.listFileStatus(s.getPath(), this.files$1);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            object = this.$outer.acceptFile(s) ? BoxesRunTime.boxToBoolean((boolean)this.files$1.add(s)) : BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.files$1 = files$1;
                    }
                });
            }
            {
                this.nestedFileEnumeration$1 = nestedFileEnumeration$1;
                super(filePath$1, fieldTypes$2, fieldNames$2);
            }
        };
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        OrcInputFormat<Object, Object> qual1 = inputFormat;
        try {
            OrcTableStatsCollector$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, filePath, files);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return files;
    }

    private OrcTableStatsCollector$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.defaultTimeout = 60000;
        this.timeoutTimeUnit = TimeUnit.MILLISECONDS;
    }
}

