/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.orc.Reader;

public class OrcUtils {
    public static int[] requestedColumnIds(boolean isCaseSensitive, String[] requiredFieldNames, String[] schemaFieldNames, Reader reader) {
        String[] orcFieldNames = reader.getSchema().getFieldNames().toArray(new String[0]);
        if (orcFieldNames.length == 0) {
            return null;
        }
        boolean isHiveOrcFile = Arrays.stream(orcFieldNames).allMatch(field -> field.startsWith("_col"));
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (isHiveOrcFile) {
            for (String field2 : requiredFieldNames) {
                int index = OrcUtils.fieldIndex(field2, schemaFieldNames, isCaseSensitive);
                ret.add(index);
            }
        } else {
            for (String field3 : requiredFieldNames) {
                int index = OrcUtils.fieldIndex(field3, orcFieldNames, isCaseSensitive);
                ret.add(index);
            }
        }
        return ret.stream().mapToInt(i -> i).toArray();
    }

    private static int fieldIndex(String field, String[] fieldNames, boolean isCaseSensitive) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if ((!isCaseSensitive || !field.equals(fieldNames[i])) && (isCaseSensitive || !field.equalsIgnoreCase(fieldNames[i]))) continue;
            return i;
        }
        return -1;
    }
}

