/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class PojoParquetInputFormat<OUT>
extends ParquetInputFormat<OUT, Row> {
    private static final long serialVersionUID = -7396017155381358924L;
    private final Class<OUT> pojoTypeClass;
    private final TypeSerializer<OUT> pojoSerializer;
    private transient Field[] pojoFields;
    private transient OUT reuse;

    public PojoParquetInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo) {
        this(filePath, pojoTypeInfo, pojoTypeInfo.getFieldNames());
    }

    public PojoParquetInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames) {
        this(filePath, pojoTypeInfo, fieldNames, new ExecutionConfig());
    }

    public PojoParquetInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, ExecutionConfig config) {
        super(filePath, PojoParquetInputFormat.extractTypeInfo(pojoTypeInfo, fieldNames), fieldNames);
        this.pojoSerializer = pojoTypeInfo.createSerializer(config);
        this.pojoTypeClass = pojoTypeInfo.getTypeClass();
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.pojoFields = new Field[this.fieldNames.length];
        HashMap<String, Field> allFields = new HashMap<String, Field>();
        this.findAllFields(this.pojoTypeClass, allFields);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            this.pojoFields[i] = (Field)allFields.get(fieldName);
            if (this.pojoFields[i] == null) {
                throw new RuntimeException("There is no field called \"" + fieldName + "\" in " + this.pojoTypeClass.getName());
            }
            this.pojoFields[i].setAccessible(true);
        }
    }

    @Override
    public OUT convert(Row current) {
        if (this.reuse == null) {
            this.reuse = this.pojoSerializer.createInstance();
        }
        for (int i = 0; i < current.getArity(); ++i) {
            try {
                this.pojoFields[i].set(this.reuse, current.getField(i));
                continue;
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException("Parsed value could not be set in POJO field \"" + this.fieldNames[i] + "\"", e2);
            }
        }
        return this.reuse;
    }

    private void findAllFields(Class<?> clazz, Map<String, Field> allFields) {
        for (Field field : clazz.getDeclaredFields()) {
            allFields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            this.findAllFields(clazz.getSuperclass(), allFields);
        }
    }

    private static <OUT> InternalType[] extractTypeInfo(PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames) {
        Preconditions.checkNotNull(pojoTypeInfo);
        Preconditions.checkNotNull(fieldNames);
        Preconditions.checkArgument(pojoTypeInfo.getArity() >= fieldNames.length);
        RowType rowType = (RowType)TypeConverters.createInternalTypeFromTypeInfo(pojoTypeInfo);
        InternalType[] fieldTypes2 = new InternalType[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Preconditions.checkNotNull(fieldName, "The field name cannot be null.");
            int fieldPos = pojoTypeInfo.getFieldIndex(fieldName);
            Preconditions.checkArgument(fieldPos >= 0, "Field \"" + fieldName + "\" is not a member of POJO class " + pojoTypeInfo.getTypeClass().getName());
            fieldTypes2[i] = rowType.getInternalTypeAt(fieldPos).toInternalType();
        }
        return fieldTypes2;
    }
}

