/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.mapreduce.RecordReader;

public class RecordReaderIterator<T>
implements Iterator<T>,
Closeable {
    private RecordReader<Void, T> reader;
    private boolean alreadyHasNext = false;
    private boolean finished = false;

    public RecordReaderIterator(RecordReader<Void, T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.finished && !this.alreadyHasNext) {
                boolean bl = this.finished = !this.reader.nextKeyValue();
                if (this.finished) {
                    this.close();
                }
                this.alreadyHasNext = !this.finished;
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return !this.finished;
    }

    @Override
    public T next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of stream");
            }
            this.alreadyHasNext = false;
            return (T)this.reader.getCurrentValue();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            finally {
                this.reader = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

